/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

import java.awt.geom.AffineTransform;

public final class UnitConv {
    public static final float IN2MM = 25.4f;
    public static final float IN2CM = 2.54f;
    public static final int IN2PT = 72;
    public static final String PICA = "pc";
    public static final String POINT = "pt";
    public static final String MM = "mm";
    public static final String CM = "cm";
    public static final String INCH = "in";
    public static final String MPT = "mpt";
    public static final String PX = "px";

    private UnitConv() {
    }

    public static double mm2pt(double d) {
        return d * 72.0 / (double)25.4f;
    }

    public static double mm2mpt(double d) {
        return d * 1000.0 * 72.0 / (double)25.4f;
    }

    public static double pt2mm(double d) {
        return d * (double)25.4f / 72.0;
    }

    public static double mm2in(double d) {
        return d / (double)25.4f;
    }

    public static double in2mm(double d) {
        return d * (double)25.4f;
    }

    public static double in2mpt(double d) {
        return d * 72.0 * 1000.0;
    }

    public static double in2pt(double d) {
        return d * 72.0;
    }

    public static double mpt2in(double d) {
        return d / 72.0 / 1000.0;
    }

    public static double mm2px(double d, int n) {
        return UnitConv.mm2in(d) * (double)n;
    }

    public static double mpt2px(double d, int n) {
        return UnitConv.mpt2in(d) * (double)n;
    }

    public static AffineTransform mptToPt(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        dArray[4] = dArray[4] / 1000.0;
        dArray[5] = dArray[5] / 1000.0;
        return new AffineTransform(dArray);
    }

    public static AffineTransform ptToMpt(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        dArray[4] = dArray[4] * 1000.0;
        dArray[5] = dArray[5] * 1000.0;
        return new AffineTransform(dArray);
    }

    public static int convert(String string) {
        double d = 0.0;
        if (string != null) {
            if (string.toLowerCase().indexOf(PX) > 0) {
                d = Double.parseDouble(string.substring(0, string.length() - 2));
                d *= 1000.0;
            } else if (string.toLowerCase().indexOf(INCH) > 0) {
                d = Double.parseDouble(string.substring(0, string.length() - 2));
                d *= 72000.0;
            } else if (string.toLowerCase().indexOf(CM) > 0) {
                d = Double.parseDouble(string.substring(0, string.length() - 2));
                d *= 28346.4567;
            } else if (string.toLowerCase().indexOf(MM) > 0) {
                d = Double.parseDouble(string.substring(0, string.length() - 2));
                d *= 2834.64567;
            } else if (string.toLowerCase().indexOf(MPT) > 0) {
                d = Double.parseDouble(string.substring(0, string.length() - 3));
            } else if (string.toLowerCase().indexOf(POINT) > 0) {
                d = Double.parseDouble(string.substring(0, string.length() - 2));
                d *= 1000.0;
            } else if (string.toLowerCase().indexOf(PICA) > 0) {
                d = Double.parseDouble(string.substring(0, string.length() - 2));
                d *= 12000.0;
            }
        }
        return (int)d;
    }
}

