/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.EditorApplicationComponentActivator;
import com.mathworks.mde.editor.EditorGroup;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.MWCaret;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.JumpList;

public final class EditorSyntaxTextPane
extends SyntaxTextPane {
    private final DropTarget fThisDropTarget = new DropTarget((Component)((Object)this), new EditorDropTargetListener());

    public EditorSyntaxTextPane() {
        this.setDropTarget(this.fThisDropTarget);
        this.setName("EditorTextPane");
        this.getAccessibleContext().setAccessibleName(EditorUtils.lookup("editor.acc.pane"));
        JumpList.addJumpNavigationSupport((JTextComponent)((Object)this));
        this.putClientProperty("ComponentActivator", new EditorApplicationComponentActivator());
    }

    public synchronized void setDropTarget(DropTarget dropTarget) {
        super.setDropTarget(this.fThisDropTarget);
    }

    private class EditorDropTargetListener
    implements DropTargetListener {
        private EditorDropTargetListener() {
        }

        private DropTargetListener getCaretDropTargetListener() {
            DropTargetListener dropTargetListener = null;
            if (EditorSyntaxTextPane.this.getCaret() instanceof MWCaret) {
                dropTargetListener = ((MWCaret)EditorSyntaxTextPane.this.getCaret()).getDropTargetListener();
            }
            return dropTargetListener;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (MJDataFlavor.isDecodableFileFlavor((DropTargetDragEvent)dropTargetDragEvent)) {
                dropTargetDragEvent.acceptDrag(1);
            } else if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) && this.getCaretDropTargetListener() != null) {
                this.getCaretDropTargetListener().dragEnter(dropTargetDragEvent);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DropTarget dropTarget;
            boolean bl = false;
            if (MJDataFlavor.isDecodableFileFlavor((DropTargetDropEvent)dropTargetDropEvent) && (dropTarget = EditorStartup.getParentDesktop().getGroupDropTarget(EditorGroup.getTitle())) != null) {
                dropTarget.drop(dropTargetDropEvent);
                bl = true;
            }
            if (!bl && !EditorUtils.processFileDrop(dropTargetDropEvent)) {
                if (this.getCaretDropTargetListener() != null) {
                    this.getCaretDropTargetListener().drop(dropTargetDropEvent);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this.getCaretDropTargetListener() != null) {
                this.getCaretDropTargetListener().dragExit(dropTargetEvent);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this.getCaretDropTargetListener() != null && !dropTargetDragEvent.isDataFlavorSupported(MJDataFlavor.javaFileListFlavor)) {
                this.getCaretDropTargetListener().dragOver(dropTargetDragEvent);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (this.getCaretDropTargetListener() != null && !dropTargetDragEvent.isDataFlavorSupported(MJDataFlavor.javaFileListFlavor)) {
                this.getCaretDropTargetListener().dropActionChanged(dropTargetDragEvent);
            }
        }
    }
}

