/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.ActionManager;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorViewUtils;
import com.mathworks.mde.editor.PopupAction;
import com.mathworks.mde.editor.codepad.Codepad;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.apache.commons.lang.Validate;

public class GoToMenu {
    private static final String SHOW_FUNCTIONS_PREF = "Editor.GoToMenu.ShowFunctions";
    private static final int MAX_GOTO_ITEMS = 20;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(GoToMenu.class.getPackage().getName() + ".resources.RES_Editor_Toolstrip");
    private static final int RIGHT_HEADER_GAP = 10;
    private static final int LEFT_HEADER_GAP = 10;
    private static final int VERTICAL_HEADER_GAP = 7;
    private final Editor fEditor;
    private final TSToolSet fToolSet;
    private final ActionManager fActionManager;
    private boolean fShowingFunctions;
    private HeaderLabel fHeaderLabel;
    private CustomLabel fToggleLabel;
    private PopupList fFunctionsSectionsPopupList;
    private ListModel fFunctionsModel;
    private ListModel fSectionsModel;
    private MJPanel fPanel;
    private MJScrollPane fScrollPane;
    private JComponent fFocusComponent;
    private MJAbstractAction fToggleBookmarkAction;
    private MJAbstractAction fNextBookmarkAction;
    private MJAbstractAction fPreviousBookmarkAction;
    private MJAbstractAction fGoToAction;

    public GoToMenu(Editor editor, TSToolSet tSToolSet, ActionManager actionManager) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        Validate.notNull((Object)tSToolSet, (String)"'toolSet' cannot be null");
        Validate.notNull((Object)actionManager, (String)"'actionManager' cannot be null");
        this.fEditor = editor;
        this.fToolSet = tSToolSet;
        this.fActionManager = actionManager;
    }

    public void populate() {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        mJAbstractAction.putValue("PopupListener", (Object)this.createPopupListener());
        this.fToolSet.configureAndAdd("goto", (Action)mJAbstractAction);
        this.fGoToAction = this.getAction(EditorAction.GOTO);
        this.fToolSet.configureAndAdd("goto_line", (Action)this.fGoToAction);
        this.fToggleBookmarkAction = this.getAction(EditorAction.TOGGLE_BOOKMARK);
        this.fToolSet.configureAndAdd("toggle_bookmark", (Action)this.fToggleBookmarkAction);
        this.fPreviousBookmarkAction = this.getAction(EditorAction.PREVIOUS_BOOKMARK);
        this.fToolSet.configureAndAdd("previous_bookmark", (Action)this.fPreviousBookmarkAction);
        this.fNextBookmarkAction = this.getAction(EditorAction.NEXT_BOOKMARK);
        this.fToolSet.configureAndAdd("next_bookmark", (Action)this.fNextBookmarkAction);
    }

    private ChildAction getAction(EditorAction editorAction) {
        return new ChildAction((Action)this.fActionManager.getAction(editorAction));
    }

    private PopupListener createPopupListener() {
        return new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                popupCallback.show((JComponent)GoToMenu.this.createPopupContent());
            }
        };
    }

    public MJPanel createPopupContent() {
        this.fPanel = new MJPanel(new BorderLayout(0, 0)){

            public void requestFocus() {
                if (GoToMenu.this.fFocusComponent != null) {
                    GoToMenu.this.fFocusComponent.requestFocus();
                }
                super.requestFocus();
            }

            public boolean requestFocusInWindow() {
                if (GoToMenu.this.fFocusComponent != null) {
                    return GoToMenu.this.fFocusComponent.requestFocusInWindow();
                }
                return super.requestFocusInWindow();
            }
        };
        if (this.fEditor.isMCode()) {
            this.initializeModels();
            if (this.eitherModelNotEmpty()) {
                this.fPanel.add((Component)this.createFunctionsAndSectionsHeader(), (Object)"North");
                this.fPanel.add((Component)this.createFunctionsAndSectionsPopupList(), (Object)"Center");
                this.fFocusComponent = this.fFunctionsSectionsPopupList;
            }
        }
        PopupList popupList = this.createGoToAndBookmarksPopup();
        if (this.fFocusComponent == null) {
            this.fFocusComponent = popupList;
        }
        this.fPanel.add((Component)popupList, (Object)"South");
        return this.fPanel;
    }

    private PopupList createGoToAndBookmarksPopup() {
        PopupList popupList = new PopupList(this.createGoToLineAndBookmarksModel());
        popupList.setName("editor_toolset:gotoPopupList");
        popupList.addListActionListener(GoToMenu.createListActionListener());
        return popupList;
    }

    private JComponent createFunctionsAndSectionsHeader() {
        HeaderPanel headerPanel = new HeaderPanel(new BorderLayout(0, 0));
        this.fHeaderLabel = new HeaderLabel();
        ((Container)((Object)headerPanel)).add((Component)((Object)this.fHeaderLabel), "West");
        if (this.getUnshownModel().getSize() > 0) {
            this.fToggleLabel = new CustomLabel();
            this.fToggleLabel.setName("gotoToggleButton");
            this.fToggleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    GoToMenu.this.toggleList();
                }
            });
            ((Container)((Object)headerPanel)).add((Component)((Object)this.fToggleLabel), "East");
        }
        return headerPanel;
    }

    private JComponent createFunctionsAndSectionsPopupList() {
        this.fFunctionsSectionsPopupList = new PopupList();
        this.fFunctionsSectionsPopupList.setName("editor_toolset:functionSectionList");
        this.fFunctionsSectionsPopupList.addListActionListener(GoToMenu.createListActionListener());
        this.fScrollPane = new MJScrollPane((Component)this.fFunctionsSectionsPopupList, 20, 31);
        this.fScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.updateList();
        return this.fScrollPane;
    }

    private static ListActionListener createListActionListener() {
        return new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                Action action = (Action)listActionEvent.getListItem().getAttributes().getAttribute(TSFactory.ACTION_ATTRIBUTE);
                action.actionPerformed((ActionEvent)listActionEvent);
            }
        };
    }

    private ListModel createGoToLineAndBookmarksModel() {
        DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
        defaultListModel.addElement(ListItem.newHeader((String)BUNDLE.getString("Tool.goto_line_group.Label")));
        this.addToModel(defaultListModel, "goto_line", this.fGoToAction);
        defaultListModel.addElement(ListItem.newHeader((String)BUNDLE.getString("Tool.bookmarks_group.Label")));
        this.addToModel(defaultListModel, "toggle_bookmark", this.fToggleBookmarkAction);
        this.addToModel(defaultListModel, "previous_bookmark", this.fPreviousBookmarkAction);
        this.addToModel(defaultListModel, "next_bookmark", this.fNextBookmarkAction);
        return defaultListModel;
    }

    private void addToModel(DefaultListModel defaultListModel, String string, MJAbstractAction mJAbstractAction) {
        ListItem listItem = TSFactory.createListItemFromAction((Action)mJAbstractAction, (ListStyle)ListStyle.SINGLE_LINE_DESCRIPTION);
        listItem.getAttributes().setAttribute((Attribute)ListItem.DESCRIPTION, (Object)BUNDLE.getString("Tool." + string + ".Description"));
        defaultListModel.addElement(listItem);
    }

    private void toggleList() {
        this.fShowingFunctions = !this.fShowingFunctions;
        Prefs.setBooleanPref((String)SHOW_FUNCTIONS_PREF, (boolean)this.fShowingFunctions);
        this.updateList();
    }

    private void updateList() {
        this.fHeaderLabel.setText(BUNDLE.getString(this.fShowingFunctions ? "Tool.functions_group.Label" : "Tool.sections_group.Label"));
        if (this.fToggleLabel != null) {
            this.fToggleLabel.setText(BUNDLE.getString(this.fShowingFunctions ? "showSections" : "showFunctions"));
        }
        this.fFunctionsSectionsPopupList.setModel(this.fShowingFunctions ? this.fFunctionsModel : this.fSectionsModel);
        this.fFunctionsSectionsPopupList.setVisibleRowCount(Math.min(this.fFunctionsSectionsPopupList.getModel().getSize(), 20));
        this.resizeScrollPane();
        OverlayManager overlayManager = OverlayManagers.get((Component)this.fPanel);
        if (overlayManager != null) {
            overlayManager.packOverlay((Component)this.fPanel);
        }
    }

    private void resizeScrollPane() {
        Dimension dimension = this.fFunctionsSectionsPopupList.getPreferredScrollableViewportSize();
        this.fScrollPane.setPreferredSize(new Dimension(dimension.width, dimension.height + 2));
    }

    private ListModel getUnshownModel() {
        return this.fShowingFunctions ? this.fSectionsModel : this.fFunctionsModel;
    }

    private boolean eitherModelNotEmpty() {
        return this.fFunctionsModel.getSize() > 0 || this.fSectionsModel.getSize() > 0;
    }

    private void initializeModels() {
        this.fFunctionsModel = this.createFunctionsModel();
        this.fSectionsModel = this.createSectionsModel();
        this.fShowingFunctions = this.fFunctionsModel.getSize() > 0 && this.fSectionsModel.getSize() == 0 ? true : (this.fFunctionsModel.getSize() == 0 && this.fSectionsModel.getSize() > 0 ? false : Prefs.getBooleanPref((String)SHOW_FUNCTIONS_PREF, (boolean)true));
    }

    private ListModel createFunctionsModel() {
        PopupAction[] popupActionArray;
        DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
        for (PopupAction popupAction : popupActionArray = EditorViewUtils.createFunctionPopupActions(this.fEditor, false)) {
            defaultListModel.addElement(TSFactory.createListItemFromAction((Action)((Object)popupAction), (ListStyle)ListStyle.TEXT_ONLY));
        }
        return defaultListModel;
    }

    private ListModel createSectionsModel() {
        DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
        Codepad codepad = (Codepad)this.fEditor.getProperty((Object)"Codepad");
        if (codepad != null) {
            List<Action> list = codepad.getGoToCellActions();
            for (Action action : list) {
                defaultListModel.addElement(TSFactory.createListItemFromAction((Action)action, (ListStyle)ListStyle.TEXT_ONLY));
            }
        }
        return defaultListModel;
    }

    private static class CustomLabel
    extends MJLabel {
        private static final Color NORMAL_TEXT_COLOR = new Color(ToolstripTheme.getInstance().getPopupHeaderColor().getRed(), ToolstripTheme.getInstance().getPopupHeaderColor().getGreen(), ToolstripTheme.getInstance().getPopupHeaderColor().getBlue(), 212);
        private static final Color MOUSEOVER_TEXT_COLOR = ToolstripTheme.getInstance().getPopupHeaderColor().brighter();

        private CustomLabel() {
            this.setForeground(NORMAL_TEXT_COLOR);
            Font font = ToolstripTheme.getInstance().getPopupHeaderFont();
            this.setFont(font.deriveFont((float)font.getSize() - 3.0f));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    CustomLabel.this.setForeground(MOUSEOVER_TEXT_COLOR);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    CustomLabel.this.setForeground(NORMAL_TEXT_COLOR);
                }
            });
        }

        public void setText(String string) {
            super.setText(string.toUpperCase(Locale.getDefault()));
        }
    }

    private static class HeaderLabel
    extends MJLabel {
        private HeaderLabel() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 7, 10));
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(ToolstripTheme.getInstance().getPopupHeaderFont());
            graphics2D.setColor(ToolstripTheme.getInstance().getPopupHeaderColor());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(this.getText().toUpperCase(Locale.getDefault()), 10, (this.getHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        }
    }

    private static class HeaderPanel
    extends MJPanel {
        private HeaderPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, ToolstripTheme.getInstance().getPopupHeaderFromColor(), 0.0f, this.getHeight(), ToolstripTheme.getInstance().getPopupHeaderToColor()));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setColor(ToolstripTheme.getInstance().getPopupHeaderBorderColor());
            graphics2D.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            super.paintChildren(graphics);
        }
    }
}

