/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointParseUtils;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.text.mcode.MLexer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class BreakpointDialogs {
    public static final String CONDITIONAL_BREAKPOINT_DIALOG = "conditionalBreakpointDialog";
    public static final String CONDITIONAL_BREAKPOINT_TEXTFIELD = "conditionalBreakpointTextField";
    public static final String CONDITIONAL_BREAKPOINT_OK = "conditionalBreakpointOkButton";
    public static final String CONDITIONAL_BREAKPOINT_CANCEL = "conditionalBreakpointCancelButton";

    private BreakpointDialogs() {
    }

    public static String promptUserForExpression(MatlabBreakpoint matlabBreakpoint, int n) {
        ConditionalBreakpointDialog conditionalBreakpointDialog = new ConditionalBreakpointDialog(matlabBreakpoint, n);
        conditionalBreakpointDialog.show();
        return conditionalBreakpointDialog.getCondition();
    }

    public static MatlabBreakpoint showSetBreakpointDialog(int n, Collection<MatlabBreakpoint> collection, int n2, File file) {
        boolean bl = true;
        for (MatlabBreakpoint object2 : collection) {
            if (!MatlabBreakpoint.isLineBreakpoint(object2)) continue;
            bl = false;
            break;
        }
        Collection<Integer> collection2 = MatlabBreakpointUtils.getAnonymousFunctionIndciesWithoutBreakpoints(n2, collection);
        Frame frame = EditorUiUtils.getFrameToCenterDialogOn(file);
        String string = MatlabBreakpointUtils.lookup("dialog.anonymousSetBkpt");
        int n3 = BreakpointDialogs.showGetAnonymousIndex(frame, string, bl, collection2, n2);
        return BreakpointDialogs.createBreakpointForAnonymousIndex(n, n3, file);
    }

    private static int showGetAnonymousIndex(Component component, String string, boolean bl, Collection<Integer> collection, int n) {
        if (bl || !collection.isEmpty()) {
            int n2;
            final MJRadioButton mJRadioButton = new MJRadioButton(MatlabBreakpointUtils.lookup("dialog.beginningLine"), true);
            MJRadioButton mJRadioButton2 = new MJRadioButton(MatlabBreakpointUtils.lookup("dialog.anonymousFunction"), false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)mJRadioButton);
            buttonGroup.add((AbstractButton)mJRadioButton2);
            final MJComboBox mJComboBox = new MJComboBox(collection.toArray()){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    return new Dimension(dimension.width + 5, dimension.height);
                }
            };
            if (bl) {
                mJComboBox.setEnabled(false);
            }
            if (!collection.isEmpty()) {
                mJComboBox.setSelectedIndex(0);
            }
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    mJComboBox.setEnabled(!mJRadioButton.isSelected());
                }
            };
            mJRadioButton.addActionListener(actionListener);
            mJRadioButton2.addActionListener(actionListener);
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            int n3 = 6;
            gridBagConstraints.insets = new Insets(0, n3, n3, 0);
            mJPanel.add((Component)new MJLabel(string), (Object)gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 1;
            if (bl && !collection.isEmpty()) {
                gridBagConstraints.insets = new Insets(n3, n3 * 2, n3, 0);
                mJPanel.add((Component)mJRadioButton, (Object)gridBagConstraints);
            } else if (collection.isEmpty()) {
                gridBagConstraints.insets = new Insets(n3, n3, n3, 0);
                mJPanel.add((Component)new MJLabel(mJRadioButton.getText()), (Object)gridBagConstraints);
            }
            gridBagConstraints.gridy = 2;
            if (bl && !collection.isEmpty()) {
                gridBagConstraints.insets = new Insets(0, n3 * 2, n3, 0);
                mJPanel.add((Component)mJRadioButton2, (Object)gridBagConstraints);
            } else if (!collection.isEmpty()) {
                gridBagConstraints.insets = new Insets(n3, n3, n3, 0);
                mJPanel.add((Component)new MJLabel(mJRadioButton2.getText()), (Object)gridBagConstraints);
            }
            if (!collection.isEmpty() && n > 1) {
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = new Insets(gridBagConstraints.insets.top, 4, gridBagConstraints.insets.bottom, gridBagConstraints.insets.right);
                mJPanel.add((Component)mJComboBox, (Object)gridBagConstraints);
            }
            if ((n2 = MJOptionPane.showConfirmDialog((Component)component, (Object)mJPanel, (String)EditorUtils.EDITOR_TITLE, (int)2)) != 0) {
                return -1;
            }
            if (mJRadioButton.isSelected() && bl) {
                return 0;
            }
            return (Integer)mJComboBox.getSelectedItem();
        }
        DialogFactory.showErrorMessage(component, MatlabBreakpointUtils.lookup("dialog.anonymousError"));
        return -1;
    }

    private static void showErrorDialogLater(final File file, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame frame = EditorUiUtils.getFrameToCenterDialogOn(file);
                String string2 = MatlabBreakpointUtils.lookup("errorMessage.cannotSetBreakpoint") + string;
                DialogFactory.showWarningMessage(frame, string2);
            }
        });
    }

    public static void tryAndGotoLineInErrorMessageAndShowErrorDialogLater(File file, String string) {
        Editor editor = MLEditorServices.getEditorApplication().findEditor((StorageLocation)new FileStorageLocation(file));
        if (MatlabBreakpointParseUtils.doesErrorMessageContainLineNumber(string) && editor != null) {
            int n = MatlabBreakpointParseUtils.getLineNumberFromErrorMessage(string);
            editor.goToLine(n, true);
        }
        BreakpointDialogs.showErrorDialogLater(file, string);
    }

    public static void showClassNotOnPathErrorDialogLater(File file, String string) {
        String string2 = MessageFormat.format(MatlabBreakpointUtils.lookup("errorMessage.classNotOnPath"), MatlabPath.getValidPathEntryParent((File)file));
        BreakpointDialogs.showErrorDialogLater(file, string2 + string);
    }

    private static MatlabBreakpoint createBreakpointForAnonymousIndex(int n, int n2, File file) {
        MatlabBreakpoint matlabBreakpoint = n2 == -1 ? null : (MatlabBreakpoint.isLineBreakpoint(n2) ? MatlabBreakpoint.create(n, file) : MatlabBreakpoint.createAnonymous(n, n2, file));
        return matlabBreakpoint;
    }

    private static class ConditionalBreakpointDialog
    extends MJDialog {
        private MJTextField fConditionalTextField = new MJTextField(30);
        private MJButton fOkButton;
        private String fCondition;

        private ConditionalBreakpointDialog(MatlabBreakpoint matlabBreakpoint, int n) {
            super(EditorUiUtils.getFrameToCenterDialogOn(matlabBreakpoint.getFile()), EditorUtils.EDITOR_TITLE, true);
            this.setName(BreakpointDialogs.CONDITIONAL_BREAKPOINT_DIALOG);
            String string = MatlabBreakpointUtils.convertFileToStringPath(matlabBreakpoint.getFile());
            String string2 = MatlabBreakpointUtils.lookup("errorMessage.file") + " " + MFilePathUtil.getTruncatedFilename(string);
            PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p, 9dlu, p", "p, 10dlu, p, 3dlu, p, 10dlu, p, 10dlu, p"));
            panelBuilder.setDefaultDialogBorder();
            this.setContentPane(panelBuilder.getPanel());
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)new MJLabel((Icon)DialogIcon.QUESTION_32x32.getIcon()), cellConstraints.xywh(1, 1, 1, 8, CellConstraints.CENTER, CellConstraints.CENTER));
            panelBuilder.add((Component)new MJLabel(string2), cellConstraints.xy(3, 1));
            String string3 = MatlabBreakpoint.isLineBreakpoint(matlabBreakpoint.getAnonymousIndex()) ? MessageFormat.format(MatlabBreakpointUtils.lookup("dialog.conditionLine"), matlabBreakpoint.getOneBasedLineNumber()) : (n > 1 ? MessageFormat.format(MatlabBreakpointUtils.lookup("dialog.conditionLineAnonymous"), matlabBreakpoint.getOneBasedLineNumber(), matlabBreakpoint.getAnonymousIndex()) : MessageFormat.format(MatlabBreakpointUtils.lookup("dialog.conditionLineSingleAnonymous"), matlabBreakpoint.getOneBasedLineNumber()));
            panelBuilder.add((Component)new MJLabel(string3), cellConstraints.xy(3, 3));
            this.fConditionalTextField.setName(BreakpointDialogs.CONDITIONAL_BREAKPOINT_TEXTFIELD);
            this.fConditionalTextField.setText(matlabBreakpoint.getExpression());
            this.fConditionalTextField.getAccessibleContext().setAccessibleName(MatlabBreakpointUtils.lookup("dialog.condition.acc"));
            panelBuilder.add((Component)this.fConditionalTextField, cellConstraints.xy(3, 5));
            panelBuilder.add((Component)new MJLabel(MatlabBreakpointUtils.lookup("dialog.conditionBeforeLine")), cellConstraints.xy(3, 7));
            this.fOkButton = new MJButton(MJUtilities.intlString((String)"labelOK"));
            this.fOkButton.setName(BreakpointDialogs.CONDITIONAL_BREAKPOINT_OK);
            this.fOkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = MatlabBreakpointUtils.cleanupExpression(ConditionalBreakpointDialog.this.fConditionalTextField.getText());
                    if (string != null && !string.isEmpty()) {
                        boolean bl = MLexer.isExpression((String)string);
                        if (!bl) {
                            MJOptionPane.showMessageDialog((Component)((Object)ConditionalBreakpointDialog.this), (Object)MatlabBreakpointUtils.lookup("dialog.conditionError"), (String)EditorUtils.EDITOR_TITLE, (int)0);
                            ConditionalBreakpointDialog.this.fConditionalTextField.selectAll();
                            return;
                        }
                        ConditionalBreakpointDialog.this.fCondition = string;
                    } else {
                        ConditionalBreakpointDialog.this.fCondition = "";
                    }
                    ConditionalBreakpointDialog.this.closeWindow();
                }
            });
            MJButton mJButton = new MJButton(MJUtilities.intlString((String)"labelCancel"));
            mJButton.setName(BreakpointDialogs.CONDITIONAL_BREAKPOINT_CANCEL);
            mJButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConditionalBreakpointDialog.this.closeWindow();
                }
            });
            MJButton mJButton2 = new MJButton(MJUtilities.intlString((String)"labelHelp"));
            mJButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MLHelpServices.cshDisplayTopic((Object)((Object)ConditionalBreakpointDialog.this), (String)MLHelpServices.getMapfileName((String)"matlab", (String)"helptargets"), (String)"matlab_env_conditional_breakpoints");
                }
            });
            panelBuilder.add((Component)ButtonBarFactory.buildOKCancelHelpBar((JButton)this.fOkButton, (JButton)mJButton, (JButton)mJButton2), cellConstraints.xywh(1, 9, 3, 1));
            this.fConditionalTextField.selectAll();
            this.addWindowListener(new WindowEventHandler());
            this.pack();
            this.setLocationRelativeTo(EditorUiUtils.getFrameToCenterDialogOn(matlabBreakpoint.getFile()));
        }

        private void closeWindow() {
            this.dispose();
        }

        public String getCondition() {
            return this.fCondition;
        }

        private class WindowEventHandler
        extends WindowAdapter {
            private WindowEventHandler() {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                ConditionalBreakpointDialog.this.fConditionalTextField.requestFocus();
                ConditionalBreakpointDialog.this.getRootPane().setDefaultButton((JButton)ConditionalBreakpointDialog.this.fOkButton);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ConditionalBreakpointDialog.this.closeWindow();
            }
        }
    }
}

