/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.mlint;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorMenuGroupID;
import com.mathworks.matlab.api.editor.EditorMenuID;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuContext;
import com.mathworks.matlab.api.menus.MenuContributor;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.matlab.api.menus.MenuID;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mde.editor.plugins.mlint.CodeAnalyzerReportUtils;
import com.mathworks.mlservices.MLLicenseChecker;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.editor.SelfRemovingEditorEventListener;
import com.mathworks.widgets.menus.DefaultMenuBuilder;
import com.mathworks.widgets.menus.DefaultMenuGroupID;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MLintMenuContributor
implements MenuContributor<Editor> {
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle(MLintMenuContributor.class.getPackage().getName() + ".resources.RES_mlint");
    public static final String MLINT_MENU_NAME = "CodeAnaylzerReportMenu";
    private static final EditorAction SHOW_MLINT_REPORT = new EditorAction("show-mlint-report");
    private static final EditorAction SHOW_MLINT_DEPLOYMENT = new EditorAction("show-mlint-deployment-messages");
    private static final MenuGroupID TOOLS_MLINT_MENU_GROUP = new DefaultMenuGroupID("ToolsMenuGroup");
    private static final MenuGroupID MLINT_CONFIGURATION_GROUP = new DefaultMenuGroupID("MLintConfigurationGroup");
    private static final MenuGroupID MLINT_OPTIONS_GROUP = new DefaultMenuGroupID("MLintOptionsGroup");
    private static final MenuGroupID MLINT_REPORT_GROUP = new DefaultMenuGroupID("MLintReportGroup");
    private static Boolean sTestShowDeploymentMenuItem;

    public static Action createShowCodeAnalyzerReportAction(final Editor editor) {
        return new MJAbstractAction(MLintMenuContributor.getShowCodeAnalyzerReportLabel(editor)){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeAnalyzerReportUtils.showCodeAnalyzerReport(editor);
            }
        };
    }

    public Class<Editor> getContributionTarget() {
        return Editor.class;
    }

    public void contribute(Editor editor, MenuContext menuContext) {
        if (MatlabPluginUtils.isMatlabCodeFileOrBuffer(editor)) {
            new Contribution(editor, menuContext).contribute();
        }
    }

    public void contributeToContextMenu(Editor editor, MenuBuilder menuBuilder) {
    }

    public static void setShowCompilerMenuItem(Boolean bl) {
        sTestShowDeploymentMenuItem = bl;
    }

    private static String getShowCodeAnalyzerReportLabel(Editor editor) {
        return editor.isDirty() ? BUNDLE.getString("menuitem.SaveAndShowMLintReport") : BUNDLE.getString("menuitem.ShowMLintReport");
    }

    private static class Contribution {
        private final ChangeListener fMLintConfigListener;
        private final EditorAction.ObservableAction fMLintReportAction;
        private final EditorAction.ObservableAction fShowDeploymentMessagesAction;
        private MenuBuilder fMLintMenuBuilder;
        private Editor fEditor;
        private MenuContext fContext;

        private Contribution(Editor editor, MenuContext menuContext) {
            this.fEditor = editor;
            this.fContext = menuContext;
            this.fMLintReportAction = SHOW_MLINT_REPORT.getAction();
            this.fShowDeploymentMessagesAction = SHOW_MLINT_DEPLOYMENT.getAction();
            this.fMLintConfigListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Contribution.this.updateShowDeploymentMessagesAction();
                            Contribution.this.populateMLintMenu();
                            Contribution.this.fContext.refresh();
                        }
                    });
                }
            };
        }

        private void contribute() {
            this.setActionObservers();
            this.fMLintMenuBuilder = new DefaultMenuBuilder(BUNDLE.getString("menu.MLint"), MLintMenuContributor.MLINT_MENU_NAME, new MenuGroupID[]{MLINT_CONFIGURATION_GROUP, MLINT_OPTIONS_GROUP, MLINT_REPORT_GROUP});
            this.populateMLintMenu();
            MenuBuilder menuBuilder = this.fContext.getBuilder((MenuID)EditorMenuID.TOOLS);
            menuBuilder.insertGroupBefore((MenuGroupID)EditorMenuGroupID.TOOLS_REPORT_GROUP, TOOLS_MLINT_MENU_GROUP);
            menuBuilder.add(TOOLS_MLINT_MENU_GROUP, (Component)this.fMLintMenuBuilder.getMenu());
            MLintPrefsUtils.addConfigurationListener((ChangeListener)this.fMLintConfigListener);
            new SelfRemovingEditorEventListener(this.fEditor){

                public void handleEventOccurred(EditorEvent editorEvent) {
                    if (editorEvent == EditorEvent.DIRTY_STATE_CHANGED) {
                        Contribution.this.fMLintReportAction.setName(MLintMenuContributor.getShowCodeAnalyzerReportLabel(Contribution.this.fEditor));
                    }
                }

                public void cleanup() {
                    int n = MLintPrefsUtils.getConfigurationListenerCount();
                    MLintPrefsUtils.removeConfigurationListener((ChangeListener)Contribution.this.fMLintConfigListener);
                    assert (MLintPrefsUtils.getConfigurationListenerCount() == n - 1);
                }
            };
            this.updateEnablement();
        }

        private void updateEnablement() {
            boolean bl = this.fEditor.isBuffer() || this.fEditor.getStorageLocation() instanceof FileStorageLocation && MLFileUtils.isMFile((String)((FileStorageLocation)this.fEditor.getStorageLocation()).getFile().getName());
            this.fMLintMenuBuilder.getMenu().setEnabled(bl);
        }

        private void setActionObservers() {
            this.fShowDeploymentMessagesAction.setObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    try {
                        CodeAnalyzerUtils.setCategoryEnabled((String)"MCC", (boolean)Contribution.this.fShowDeploymentMessagesAction.isSelected());
                    }
                    catch (Exception exception) {
                        Contribution.this.showMLintDialog(exception);
                    }
                }
            });
            this.updateShowDeploymentMessagesAction();
            this.fMLintReportAction.setObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    CodeAnalyzerReportUtils.showCodeAnalyzerReport(Contribution.this.fEditor);
                }
            });
        }

        private void populateMLintMenu() {
            MJUtilities.assertIsEventThread();
            this.fMLintMenuBuilder.clearContents();
            List list = CodeAnalyzerUtils.createConfigurationMenuItems();
            if (list.size() > 1) {
                for (JMenuItem jMenuItem : list) {
                    this.fMLintMenuBuilder.add(MLINT_CONFIGURATION_GROUP, (Component)jMenuItem);
                }
            }
            if (sTestShowDeploymentMenuItem != null) {
                if (sTestShowDeploymentMenuItem.booleanValue()) {
                    this.insertCompilerMenuItem();
                }
            } else if (Matlab.isMatlabAvailable()) {
                new MatlabWorker(){

                    public Object runOnMatlabThread() throws Exception {
                        return MLLicenseChecker.hasLicense((String)"Compiler");
                    }

                    public void runOnAWTEventDispatchThread(Object object) {
                        if (Boolean.TRUE.equals(object) && Contribution.this.fEditor != null) {
                            Contribution.this.insertCompilerMenuItem();
                        }
                    }
                }.start();
            }
            this.fMLintMenuBuilder.add(MLINT_REPORT_GROUP, (Action)((Object)this.fMLintReportAction));
        }

        private void insertCompilerMenuItem() {
            MJUtilities.assertIsEventThread();
            this.fMLintMenuBuilder.add(MLINT_OPTIONS_GROUP, (Component)new MJCheckBoxMenuItem((Action)((Object)this.fShowDeploymentMessagesAction)));
            this.fContext.refresh();
        }

        private void updateShowDeploymentMessagesAction() {
            MLintConfiguration mLintConfiguration = MLintPrefsUtils.getActiveConfiguration();
            String string = mLintConfiguration.getFile().equals(MLintPrefsUtils.DEFAULT_SETTINGS_FILE) ? MLintPrefsUtils.DEFAULT_SETTINGS : mLintConfiguration.getFile().getName();
            this.fShowDeploymentMessagesAction.setSelected(mLintConfiguration.isCategoryEnabled("MCC", false));
            this.fShowDeploymentMessagesAction.setName(MessageFormat.format(BUNDLE.getString("menuitem.ShowDeployment"), string));
            this.fShowDeploymentMessagesAction.setEnabled(!mLintConfiguration.isReadOnly());
        }

        private void showMLintDialog(Exception exception) {
            String string = MessageFormat.format(BUNDLE.getString("message.ProblemUpdating"), exception.getMessage());
            MJOptionPane.showMessageDialog((Component)this.fEditor.getComponent(), (Object)string);
        }
    }
}

