/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.embeddedoutputs;

import com.mathworks.mde.embeddedoutputs.RegionEvaluator;
import com.mathworks.mde.embeddedoutputs.RegionOutputsMessage;
import com.mathworks.mde.embeddedoutputs.RegionStateHandler;
import com.mathworks.mde.embeddedoutputs.RegionsData;
import com.mathworks.mde.embeddedoutputs.evaluation.InterruptManager;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.util.ThreadUtils;
import java.util.concurrent.ExecutorService;

public final class EmbeddedOutputsMessageService {
    private static final String EVAL_REGION = "/embeddedOutputs/evalRegions/";
    private static final String INTERRUPT_EVAL = "/embeddedOutputs/interruptRegion/";
    private static final String REGION_EVAL_START = "/liveEval/regionEvaluating/";
    private static final String REGION_EVAL_END = "/liveEval/regionEvaled/";
    private static final String REGIONS_EVAL_END = "/liveEval/regionsEvaled/";
    private final String fEvalRegionNamespace;
    private final String fEvalStartedNamespace;
    private final String fEvalCompletedNamespace;
    private final String fEvalsCompletedNamespace;
    private final ExecutorService fExecutorService;
    private final Subscriber fEvalRegionsSubscriber;

    public EmbeddedOutputsMessageService(String string, RegionEvaluator regionEvaluator) {
        this.fEvalRegionNamespace = EVAL_REGION + string;
        this.fEvalStartedNamespace = REGION_EVAL_START + string;
        this.fEvalCompletedNamespace = REGION_EVAL_END + string;
        this.fEvalsCompletedNamespace = REGIONS_EVAL_END + string;
        this.fEvalRegionsSubscriber = this.createEvalRegionsSubscriber(regionEvaluator);
        Subscriber subscriber = EmbeddedOutputsMessageService.createInterruptEvalSubscriber(string);
        this.fExecutorService = ThreadUtils.newSingleDaemonThreadExecutor((String)"evalRegions");
        MessageService messageService = MessageServiceFactory.getMessageService();
        messageService.subscribe(this.fEvalRegionNamespace, this.fEvalRegionsSubscriber);
        messageService.subscribe(INTERRUPT_EVAL + string, subscriber);
    }

    public void dispose() {
        MessageService messageService = MessageServiceFactory.getMessageService();
        messageService.unsubscribe(this.fEvalRegionNamespace, this.fEvalRegionsSubscriber);
        this.fExecutorService.shutdown();
    }

    private RegionStateHandler createRegionStateHandler() {
        final MessageService messageService = MessageServiceFactory.getMessageService();
        return new RegionStateHandler(){

            @Override
            public void regionEvalStarted(int n) {
                messageService.publish(EmbeddedOutputsMessageService.this.fEvalStartedNamespace, (Object)n);
            }

            @Override
            public void regionEvalCompleted(RegionOutputsMessage regionOutputsMessage) {
                messageService.publish(EmbeddedOutputsMessageService.this.fEvalCompletedNamespace, (Object)regionOutputsMessage);
            }

            @Override
            public void regionsCompleted(String string) {
                messageService.publish(EmbeddedOutputsMessageService.this.fEvalsCompletedNamespace, (Object)string);
            }
        };
    }

    private Subscriber createEvalRegionsSubscriber(final RegionEvaluator regionEvaluator) {
        return new Subscriber(){

            public void handle(Message message) {
                EmbeddedOutputsMessageService.this.fExecutorService.submit(EmbeddedOutputsMessageService.this.createRegionsEvalRunnable(message, regionEvaluator));
            }
        };
    }

    private static Subscriber createInterruptEvalSubscriber(final String string) {
        return new Subscriber(){

            public void handle(Message message) {
                String string2 = (String)message.getData();
                InterruptManager.interrupt(string, string2);
            }
        };
    }

    private Runnable createRegionsEvalRunnable(final Message message, final RegionEvaluator regionEvaluator) {
        final RegionStateHandler regionStateHandler = this.createRegionStateHandler();
        return new Runnable(){

            @Override
            public void run() {
                RegionsData regionsData = new RegionsData(message.getData());
                regionEvaluator.evalRegions(regionsData, regionStateHandler);
            }
        };
    }
}

