/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.examples;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.examples.ExampleGalleryUtils;
import com.mathworks.mde.examples.ExampleGalleryViewer;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.examples.ExampleGalleryConfig;
import com.mathworks.mlwidgets.examples.ExamplePrefs;
import com.mathworks.mlwidgets.html.HtmlComponentCreationException;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class ExampleGallery
extends DTClientBase {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mde.examples.resources.RES_ExampleGallery");
    private static final String TITLE = BUNDLE.getString("ExampleGallery.Title");
    public static final String galleryName = "Example Gallery";
    private static ExampleGallery sInstance;
    private final PrefListener fPrefenceListener;
    private final ExampleGalleryViewer fExampleGalleryViewer = new ExampleGalleryViewer();
    private final DTClientAdapter fExampleGalleryDTClientListener;

    private ExampleGallery() throws HtmlComponentCreationException {
        this.fPrefenceListener = new ExampleGalleryPrefListener();
        ExamplePrefs.addPrefsListeners((PrefListener)this.fPrefenceListener, (String[])new String[]{"ExamplesDomain", "ExamplesShowInstalled"});
        this.fExampleGalleryDTClientListener = new ExampleGalleryDTClientListener();
        this.addDesktopClientListeners();
        this.setLayout(new BorderLayout());
        this.add(this.fExampleGalleryViewer, "Center");
        this.setName(galleryName);
        if (PlatformInfo.isWindows()) {
            this.setIcon(new ImageIcon(ExampleGalleryUtils.getImageURL("resources/icons/example_gallery_32.png")));
        } else {
            this.setIcon(new ImageIcon(ExampleGalleryUtils.getImageURL("resources/icons/example_gallery_48.png")));
        }
        this.setSmallIcon(new ImageIcon(ExampleGalleryUtils.getImageURL("resources/icons/example_gallery_16.png")));
    }

    public void showViewer(ExampleGalleryConfig exampleGalleryConfig) {
        SwingUtilities.invokeLater(new ExampleGalleryRunnable(this, exampleGalleryConfig));
    }

    public static synchronized ExampleGallery getInstance() throws HtmlComponentCreationException {
        if (sInstance == null) {
            sInstance = new ExampleGallery();
        }
        return sInstance;
    }

    private void addDesktopClientListeners() {
        MLDesktop.getInstance().addClientListener((Component)((Object)this), (DTClientListener)this.fExampleGalleryDTClientListener);
    }

    private void dispose() {
        MLDesktop.getInstance().removeClient(TITLE);
        ExamplePrefs.removePrefsListeners((PrefListener)this.fPrefenceListener, (String[])new String[]{"ExamplesDomain", "ExamplesShowInstalled"});
        MLDesktop.getInstance().removeClientListener((Component)((Object)this), (DTClientListener)this.fExampleGalleryDTClientListener);
        sInstance = null;
    }

    private ExampleGalleryViewer getExampleGalleryViewer() {
        return this.fExampleGalleryViewer;
    }

    private class ExampleGalleryDTClientListener
    extends DTClientAdapter {
        private ExampleGalleryDTClientListener() {
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExampleGallery.this.fExampleGalleryViewer.requestFocus();
                }
            });
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
            ExampleGallery.this.fExampleGalleryViewer.dispose();
            ExampleGallery.this.dispose();
        }
    }

    private static class ExampleGalleryPrefListener
    implements PrefListener {
        private ExampleGalleryPrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            MLHelpServices.showExampleGallery();
        }
    }

    private static class ExampleGalleryRunnable
    implements Runnable {
        private final ExampleGalleryConfig fIExampleGalleryConfig;
        private final ExampleGallery fExampleGallery;

        ExampleGalleryRunnable(ExampleGallery exampleGallery, ExampleGalleryConfig exampleGalleryConfig) {
            this.fExampleGallery = exampleGallery;
            this.fIExampleGalleryConfig = exampleGalleryConfig;
        }

        @Override
        public void run() {
            MLDesktop.getInstance().addClient((Component)((Object)this.fExampleGallery), TITLE, true, DTLocation.createExternal(), true);
            this.fExampleGallery.getExampleGalleryViewer().loadUrlWhenReady(this.fIExampleGalleryConfig.getUrl());
        }
    }
}

