/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.examples;

import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.Url;
import com.mathworks.mde.examples.ActionManager;
import com.mathworks.mde.examples.ConnectorFactory;
import com.mathworks.mde.examples.ExampleGalleryPage;
import com.mathworks.mde.examples.ExampleGalleryUtils;
import com.mathworks.mde.examples.addons.AddonUtils;
import com.mathworks.mlwidgets.html.HTMLBrowserPanel;
import com.mathworks.mlwidgets.html.HtmlActionsToolBar;
import com.mathworks.mlwidgets.html.HtmlComponentCreationException;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mwswing.MJUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ExampleGalleryViewer
extends JComponent {
    public static final String EXAMPLE_GALLERY_VIEWER_NAME = "Example Gallery Viewer";
    private final HtmlComponent fHtmlComponent;
    private final JLabel fLoadingLabel;
    private final HTMLBrowserPanel fBrowserPanel;
    private final HtmlActionsToolBar fToolbar;
    private String fUniqueKey = String.valueOf(this.hashCode());
    private ExampleGalleryPage fExampleGalleryPage = new ExampleGalleryPage(this.fUniqueKey);
    private final ActionManager fActionManager = new ActionManager(this.fExampleGalleryPage);

    public ExampleGalleryViewer() throws HtmlComponentCreationException {
        this.fHtmlComponent = ExampleGalleryViewer.buildHtmlComponent();
        this.fBrowserPanel = new HTMLBrowserPanel(this.fHtmlComponent, null);
        this.fToolbar = new HtmlActionsToolBar(this.fBrowserPanel.getHtmlComponent().getActions());
        this.fHtmlComponent.addPageChangedListener(new PageChangedListener(){

            public void pageChanged(PageChangedEvent pageChangedEvent) {
                ExampleGalleryViewer.this.instantiateConnection(0, AddonUtils.getInstalledAddonsJsonArray());
            }
        });
        this.setName(EXAMPLE_GALLERY_VIEWER_NAME);
        this.setLayout(new GridBagLayout());
        this.fLoadingLabel = new JLabel(ExampleGalleryUtils.getString("ExampleGallery.LoadingLabel"));
        this.fLoadingLabel.setIcon(new ImageIcon(ExampleGalleryUtils.getImageURL("resources/icons/loading.gif")));
        this.add(this.fLoadingLabel);
    }

    void loadUrlWhenReady(final Url url) {
        ConnectorFactory.runWhenReady(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExampleGalleryViewer.this.fBrowserPanel.setCurrentLocation(url);
                        ExampleGalleryViewer.this.remove(ExampleGalleryViewer.this.fLoadingLabel);
                        ExampleGalleryViewer.this.setLayout(new BorderLayout());
                        ExampleGalleryViewer.this.add((Component)ExampleGalleryViewer.this.fToolbar, "North");
                        ExampleGalleryViewer.this.add((Component)ExampleGalleryViewer.this.fBrowserPanel, "Center");
                        ExampleGalleryViewer.this.revalidate();
                        ExampleGalleryViewer.this.requestFocus();
                    }
                });
            }
        });
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.fBrowserPanel.placeFocusInBrowser();
    }

    private static HtmlComponent buildHtmlComponent() throws HtmlComponentCreationException {
        return HtmlComponentFactory.buildHtmlComponentWithoutFallback((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.CHROMIUM});
    }

    public void dispose() {
        this.fActionManager.dispose();
        this.fExampleGalleryPage.dispose();
        this.fBrowserPanel.dispose();
    }

    public void instantiateConnection(int n, final String string) {
        if (n < 10) {
            final int n2 = n + 1;
            this.fBrowserPanel.executeScript(String.format("instantiateConnection('%s','%s');", this.fExampleGalleryPage.getLocalPageUrl(), string), (HtmlDataListener)new HtmlDataListener<String>(){

                public void dataRetrieved(String string2) {
                    if (string2 == null) {
                        MJUtilities.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ExampleGalleryViewer.this.instantiateConnection(n2, string);
                            }
                        }, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                }
            });
        }
    }

    public ExampleGalleryPage getExampleGalleryPage() {
        return this.fExampleGalleryPage;
    }
}

