/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.ActionInputSource;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.AutoMounter;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreMenuSectionID;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.explorer.DiffActionProvider;
import com.mathworks.mde.explorer.ExplorerToolbar;
import com.mathworks.mde.explorer.MatlabCdOperationObserver;
import com.mathworks.mde.explorer.NullSCPlugin;
import com.mathworks.mde.explorer.ToolbarUtils;
import com.mathworks.mde.find.FindFiles;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.explorer.DetailViewer;
import com.mathworks.mlwidgets.explorer.ExplorerSplitPane;
import com.mathworks.mlwidgets.explorer.ExplorerSplitPanePrefs;
import com.mathworks.mlwidgets.explorer.SplitPaneTop;
import com.mathworks.mlwidgets.explorer.extensions.basic.FileTransferHandler;
import com.mathworks.mlwidgets.explorer.extensions.matlab.VariableTransferHandler;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.PathModel;
import com.mathworks.mlwidgets.explorer.model.actions.ActionManager;
import com.mathworks.mlwidgets.explorer.model.editorfs.EditorFileSystem;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationHistory;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.model.overlayfs.OverlayFileSystem;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.table.DateColumn;
import com.mathworks.mlwidgets.explorer.model.table.DescriptionAttribute;
import com.mathworks.mlwidgets.explorer.model.table.ExplorerTableConfigurationSerializer;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mlwidgets.explorer.model.table.IconColumn;
import com.mathworks.mlwidgets.explorer.model.table.LocationAffordance;
import com.mathworks.mlwidgets.explorer.model.table.LocationColumn;
import com.mathworks.mlwidgets.explorer.model.table.NameColumn;
import com.mathworks.mlwidgets.explorer.model.table.PathAffordance;
import com.mathworks.mlwidgets.explorer.model.table.SizeColumn;
import com.mathworks.mlwidgets.explorer.model.table.TypeColumn;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.ComponentInjector;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MenuUtils;
import com.mathworks.mlwidgets.explorer.util.PrefUtils;
import com.mathworks.mlwidgets.explorer.util.SourceControlManagerPlugin;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBar;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarMode;
import com.mathworks.mlwidgets.explorer.widgets.address.TitleChangeListener;
import com.mathworks.mlwidgets.explorer.widgets.buttons.ExplorerActionButton;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.services.Prefs;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.FocusTraversalPolicyBuilder;
import com.mathworks.widgets.WorkMonitor;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.grouptable.Affordance;
import com.mathworks.widgets.grouptable.ColumnActions;
import com.mathworks.widgets.grouptable.ExpansionProvider;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTablePair;
import com.mathworks.widgets.grouptable.GroupingTableSelectionListener;
import com.mathworks.widgets.grouptable.TableConfigurationSerializer;
import com.mathworks.widgets.grouptable.transfer.ReceiveHandler;
import com.mathworks.widgets.grouptable.transfer.SendHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;

public class Explorer
extends DTClientBase {
    private final VirtualFileSystem fSystem;
    private ExplorerActionButton fExplorerActionButton;
    private final FileTable fTable;
    private final ExplorerSplitPane fSplitPane;
    private final DetailViewer fDetailViewer;
    private final AddressBar fAddressBar;
    private final WorkMonitor fWorkMonitor;
    private final NavigationContext fContext;
    private final ActionManager fActionManager;
    private final ExplorerToolbar fToolbar;
    private MoveToolbarAction fMoveToolbarAction;
    private FileLocation fSuppressCdReaction;
    private GroupingTableConfiguration<FileSystemEntry> fNonSearchConfiguration;
    private GroupingTableConfiguration<FileSystemEntry> fSearchConfiguration;
    private GroupingTableConfiguration<FileSystemEntry> fCurrentConfiguration;
    private static SourceControlManagerPlugin sSourceControlManager = Explorer.getSourceControlManager();
    private static Explorer sInstance;
    private static boolean sIsHighContrast;
    public static final String NAME = "Current Directory";
    public static final String I18N_NAME;
    private static final String CUSTOMIZATION_PANEL_KEY = "documents.cwd";

    private Explorer() {
        AutoMounter autoMounter2;
        sInstance = this;
        this.setName(NAME);
        Prefs.mapPrefsToSettings((String)(ExplorerPrefs.History.getFactoryDir() + "//matlab//settings//explorer.csv"));
        ExtensionRegistry extensionRegistry = ExplorerExtensionRegistry.getInstance();
        this.fSystem = new VirtualFileSystem((FileSystem)new OverlayFileSystem(RealFileSystem.getInstance(), (FileSystem)EditorFileSystem.getInstance(), EditorFileSystem.getInstance().getDirtyPredicate()));
        for (AutoMounter autoMounter2 : extensionRegistry.getAutoMounters()) {
            this.fSystem.addAutoMounter(autoMounter2);
        }
        this.fContext = Explorer.createNavigationContext(extensionRegistry, this.fSystem);
        this.switchTableConfigurationOnSearchOrEnd();
        this.fWorkMonitor = Explorer.buildWorkMonitor((Component)((Object)this));
        this.fAddressBar = this.buildAddressBar(this.fContext, this.fWorkMonitor);
        this.fNonSearchConfiguration = Explorer.buildTableConfiguration(this.fContext, false);
        this.fSearchConfiguration = Explorer.buildTableConfiguration(this.fContext, true);
        this.fCurrentConfiguration = this.fNonSearchConfiguration;
        this.fTable = Explorer.buildTable(this.fContext, this.fWorkMonitor, this.fNonSearchConfiguration);
        this.fWorkMonitor.registerComponentForWaitCursor((Component)this.fTable);
        this.fWorkMonitor.registerComponentForWaitCursor((Component)this.fTable.getTableHeader());
        new PathAffordanceAdapter();
        sSourceControlManager.setManager(sSourceControlManager);
        this.fActionManager = Explorer.buildActionManager(this.fTable);
        MJScrollPane mJScrollPane = Explorer.buildTableScroller(this.fTable);
        mJScrollPane.setName("CFBScrollableFileList");
        autoMounter2 = new SplitPaneTop(mJScrollPane);
        sSourceControlManager.setConfiguration(this.fNonSearchConfiguration, this.fTable, (ComponentInjector)autoMounter2);
        sSourceControlManager.checkForSourceControl(this.fContext.getLocation().toFile());
        ExplorerSplitPanePrefs explorerSplitPanePrefs = new ExplorerSplitPanePrefs("Documents");
        this.fSplitPane = new ExplorerSplitPane(explorerSplitPanePrefs);
        this.fDetailViewer = Explorer.buildDetailViewer(this.fSplitPane.getComponent(), this.fTable, explorerSplitPanePrefs);
        this.fSplitPane.setTop((JComponent)autoMounter2);
        this.fSplitPane.setDetailViewer(this.fDetailViewer);
        PrefUtils.manageFonts((Container)this.fDetailViewer.getComponent(), (String)I18N_NAME);
        PrefUtils.manageFonts((Container)this.getTable(), (String)I18N_NAME);
        PrefUtils.manageTextColor((Container)this.fDetailViewer.getComponent());
        PrefUtils.manageTextColor((Container)this.getTable());
        PrefUtils.manageBackgroundColor((Container)this.fDetailViewer.getComponent());
        PrefUtils.manageBackgroundColor((Container)this.getTable());
        this.navigateDocumentContextOnCd();
        this.cdOnDocumentContextNavigation();
        this.clearSearchBoxOnSearchEnd();
        Explorer.stopFileSystemMonitoringOnShutdown();
        this.setLayout(new BorderLayout());
        this.fToolbar = new ExplorerToolbar(this.fActionManager, CUSTOMIZATION_PANEL_KEY);
        this.add(this.fToolbar.getComponent(), "North");
        this.add((Component)this.fSplitPane.getComponent(), "Center");
        ColumnActions columnActions = new ColumnActions(this.fTable.getGroupingModel());
        MJAbstractAction mJAbstractAction = this.fActionManager.getAction(CoreActionID.COPY);
        MJAbstractAction mJAbstractAction2 = this.fActionManager.getAction(CoreActionID.PASTE);
        MJAbstractAction mJAbstractAction3 = this.fActionManager.getAction(CoreActionID.DELETE);
        ContextTargetingManager.setToolName((Action)mJAbstractAction, (String)DTMenuMergeTag.COPY.toString());
        ContextTargetingManager.setToolName((Action)mJAbstractAction2, (String)DTMenuMergeTag.PASTE.toString());
        ContextTargetingManager.setToolName((Action)mJAbstractAction3, (String)DTMenuMergeTag.DELETE.toString());
        this.setContextActions(new Action[]{mJAbstractAction, mJAbstractAction2, mJAbstractAction3});
        this.fAddressBar.addUpdateTitleListener(new TitleChangeListener(){

            public void updateTitle(String string) {
                Explorer.this.setTitle(string);
            }
        });
        this.setupFocus();
        String string = ExplorerResources.getString((String)"title");
        this.setShortTitle(string);
        this.setTitle(string);
        this.setClientName(NAME);
        sIsHighContrast = MJUtilities.isHighContrast();
        this.fAddressBar.setSearchEnabled(false);
        MLDesktop.getInstance().addClientListener(NAME, (DTClientListener)new DTClientAdapter(){

            public void clientOpened(DTClientEvent dTClientEvent) {
                Explorer.this.fAddressBar.setSearchEnabled(true);
            }

            public void clientClosed(DTClientEvent dTClientEvent) {
                Explorer.this.fAddressBar.setSearchEnabled(false);
            }
        });
    }

    public static NavigationContext createNavigationContext(ExtensionRegistry extensionRegistry, VirtualFileSystem virtualFileSystem) {
        NavigationContext navigationContext;
        try {
            navigationContext = new NavigationContext((FileSystem)virtualFileSystem, extensionRegistry, new FileLocation(NativeJava.getCurrentDirectory()));
        }
        catch (InvalidLocationException invalidLocationException) {
            throw new IllegalStateException("User home directory is not a valid directory", invalidLocationException);
        }
        return navigationContext;
    }

    public void setTitle(String string) {
        super.setTitle(string);
    }

    private static DetailViewer buildDetailViewer(MJSplitPane mJSplitPane, FileTable fileTable, ExplorerSplitPanePrefs explorerSplitPanePrefs) {
        final DetailViewer detailViewer = new DetailViewer(mJSplitPane, fileTable, explorerSplitPanePrefs);
        detailViewer.getComponent().setName("DetailViewer");
        detailViewer.getComponent().getAccessibleContext().setAccessibleName(ExplorerResources.getString((String)"title"));
        fileTable.getContext().addNavigationListener(new NavigationListener(){

            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                detailViewer.setFile(null);
            }

            public void searchStarted(SearchCriteria searchCriteria) {
                detailViewer.setFile(null);
            }

            public void searchEnded() {
                detailViewer.setFile(null);
            }
        });
        fileTable.addSelectionListener((GroupingTableSelectionListener)new GroupingTableSelectionListener<FileSystemEntry>(){

            public void valueChanged(List<FileSystemEntry> list) {
                if (!list.isEmpty()) {
                    detailViewer.setFile(list.get(0));
                } else {
                    detailViewer.setFile(null);
                }
            }
        });
        return detailViewer;
    }

    public static SourceControlManagerPlugin getSourceControlManager() {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(SourceControlManagerPlugin.class);
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            return (SourceControlManagerPlugin)iterator.next();
        }
        return new NullSCPlugin();
    }

    private static GroupingTableConfiguration<FileSystemEntry> buildTableConfiguration(NavigationContext navigationContext, boolean bl) {
        ExplorerTableConfigurationSerializer explorerTableConfigurationSerializer;
        List<GroupingTableColumn> list;
        Vector<GroupingTablePair> vector = new Vector<GroupingTablePair>();
        FileSystemExpansionProvider fileSystemExpansionProvider = new FileSystemExpansionProvider(navigationContext);
        GroupingTableColumn groupingTableColumn = new IconColumn(fileSystemExpansionProvider).getColumn();
        GroupingTableColumn groupingTableColumn2 = new NameColumn(fileSystemExpansionProvider).getColumn();
        GroupingTableColumn groupingTableColumn3 = sSourceControlManager.getStatusColumn();
        if (bl) {
            list = Arrays.asList(groupingTableColumn, groupingTableColumn2, new SizeColumn(fileSystemExpansionProvider).getColumn(), new DateColumn(fileSystemExpansionProvider).getColumn(), groupingTableColumn3, new LocationColumn().getColumn(), new TypeColumn(fileSystemExpansionProvider).getColumn());
            explorerTableConfigurationSerializer = new ExplorerTableConfigurationSerializer(ExplorerPrefs.LastSearchGroupColumn, ExplorerPrefs.LastSearchGroupMode, ExplorerPrefs.LastSearchSortColumn, ExplorerPrefs.LastSearchSortDescending, ExplorerPrefs.LastSearchVisibleColumns, ExplorerPrefs.LastSearchColumnOrder, ExplorerPrefs.LastSearchColumnSizes, ExplorerPrefs.LastSearchOpenGroups, ExplorerPrefs.LastSearchClosedGroups);
        } else {
            list = Arrays.asList(groupingTableColumn, groupingTableColumn2, new SizeColumn(fileSystemExpansionProvider).getColumn(), new DateColumn(fileSystemExpansionProvider).getColumn(), groupingTableColumn3, new TypeColumn(fileSystemExpansionProvider).getColumn());
            try {
                if (((String)ExplorerPrefs.LastFolderSortColumn.get()).equals("status")) {
                    ExplorerPrefs.LastFolderSortColumn.unset(SettingLevel.USER);
                    ExplorerPrefs.LastFolderSortDescending.unset(SettingLevel.USER);
                }
                if (((String)ExplorerPrefs.LastFolderGroupColumn.get()).equals("status")) {
                    ExplorerPrefs.LastFolderGroupColumn.unset(SettingLevel.USER);
                }
            }
            catch (SettingException settingException) {
                settingException.printStackTrace();
            }
            explorerTableConfigurationSerializer = new ExplorerTableConfigurationSerializer(ExplorerPrefs.LastFolderGroupColumn, ExplorerPrefs.LastFolderGroupMode, ExplorerPrefs.LastFolderSortColumn, ExplorerPrefs.LastFolderSortDescending, ExplorerPrefs.LastFolderVisibleColumns, ExplorerPrefs.LastFolderColumnOrder, ExplorerPrefs.LastFolderColumnSizes, ExplorerPrefs.LastFolderOpenGroups, ExplorerPrefs.LastFolderClosedGroups);
        }
        for (GroupingTableColumn groupingTableColumn4 : list) {
            if (groupingTableColumn4.equals((Object)groupingTableColumn)) continue;
            vector.add(new GroupingTablePair(groupingTableColumn, groupingTableColumn4));
        }
        GroupingTableConfiguration groupingTableConfiguration = new GroupingTableConfiguration(list, groupingTableColumn2, Arrays.asList(new DescriptionAttribute(fileSystemExpansionProvider)), vector, (TableConfigurationSerializer)explorerTableConfigurationSerializer, 2);
        groupingTableConfiguration.addExpansionProvider((ExpansionProvider)fileSystemExpansionProvider);
        groupingTableConfiguration.setFixedColumnSize(groupingTableColumn, 40);
        groupingTableConfiguration.setColumnSizeIfNotFixed(groupingTableColumn3, 40);
        groupingTableConfiguration.setPreSorter((Comparator)new DirectoryVsFileSeparator());
        groupingTableConfiguration.addAffordance((Affordance)new LocationAffordance(!bl));
        groupingTableConfiguration.setAverageWidthEstimate("name", Integer.valueOf(200));
        groupingTableConfiguration.setAverageWidthEstimate("modified", Integer.valueOf(120));
        groupingTableConfiguration.setAverageWidthEstimate("type", Integer.valueOf(120));
        groupingTableConfiguration.setAverageWidthEstimate("size", Integer.valueOf(56));
        groupingTableConfiguration.setAverageWidthEstimate("location", Integer.valueOf(270));
        groupingTableConfiguration.setAverageWidthEstimate("description", Integer.valueOf(270));
        return groupingTableConfiguration;
    }

    private static FileTable buildTable(NavigationContext navigationContext, WorkMonitor workMonitor, GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FindFiles.invoke();
            }
        };
        FileTable fileTable = new FileTable(navigationContext, workMonitor, runnable, groupingTableConfiguration);
        ListColorUtils.setupForList((JTable)fileTable);
        fileTable.setShowVerticalLines(true);
        FileTransferHandler fileTransferHandler = new FileTransferHandler(navigationContext);
        fileTable.addSendHandler((SendHandler)fileTransferHandler);
        fileTable.addReceiveHandler((ReceiveHandler)fileTransferHandler);
        fileTable.addReceiveHandler((ReceiveHandler)new VariableTransferHandler(navigationContext));
        fileTable.setName("DocumentTable");
        fileTable.getAccessibleContext().setAccessibleName(ExplorerResources.getString((String)"title"));
        return fileTable;
    }

    private static ActionManager buildActionManager(FileTable fileTable) {
        ExtensionRegistry extensionRegistry = ExplorerExtensionRegistry.getInstance();
        for (ActionProvider actionProvider : extensionRegistry.getActionProviders()) {
            if (!(actionProvider instanceof DiffActionProvider)) continue;
            ((DiffActionProvider)actionProvider).installKeyBindings((JComponent)fileTable, 0);
        }
        ActionManager actionManager = new ActionManager("Explorer", (ActionInputSource)fileTable, extensionRegistry.getActionProviders(), new Object[0]);
        fileTable.setActionManager(actionManager);
        return actionManager;
    }

    private static MJScrollPane buildTableScroller(FileTable fileTable) {
        if (PlatformInfo.isWindowsClassicAppearance()) {
            return new MJScrollPane((Component)fileTable);
        }
        MJScrollPane mJScrollPane = new MJScrollPane((Component)fileTable){

            public void setBorder(Border border) {
                super.setBorder(null);
            }
        };
        mJScrollPane.setBorder(null);
        mJScrollPane.setViewportBorder(null);
        if (PlatformInfo.isMacintosh()) {
            Component component = new JTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, 0);
            ((JComponent)component).setOpaque(false);
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
            mJPanel.add(component, (Object)"Center");
            mJScrollPane.setCorner("UPPER_RIGHT_CORNER", (Component)mJPanel);
        }
        return mJScrollPane;
    }

    private static WorkMonitor buildWorkMonitor(final Component component) {
        final WorkMonitor workMonitor = new WorkMonitor();
        workMonitor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (workMonitor.shouldUseWaitCursor()) {
                    component.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    component.setCursor(Cursor.getDefaultCursor());
                }
                component.repaint();
            }
        });
        return workMonitor;
    }

    private AddressBar buildAddressBar(final NavigationContext navigationContext, WorkMonitor workMonitor) {
        NavigationHistory navigationHistory = new NavigationHistory(navigationContext, ExplorerPrefs.History, ExplorerPrefs.HistorySize);
        final AddressBar addressBar = new AddressBar(navigationContext, navigationHistory, workMonitor, Arrays.asList(AddressBarMode.values()), new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                jPopupMenu.addSeparator();
                jPopupMenu.add((Action)new MJAbstractAction(ExplorerResources.getString((String)"csh.addressbar")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MLHelpServices.cshDisplayTopic((Object)((Object)Explorer.getInstance()), (String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env_csh"), (String)"matlab_env_filebrowser_navigation");
                    }
                });
                jPopupMenu.addSeparator();
                jPopupMenu.add(Explorer.this.getMoveToolbarAction());
                jPopupMenu.add((Action)new MJAbstractAction(ExplorerResources.getString((String)"toolbar.popup.customize")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MLDesktop.getInstance().showToolBarCustomizationPanel(Explorer.this.fToolbar.getCustomizationPanelKey());
                    }
                });
            }
        });
        addressBar.addStateChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!addressBar.getMode().equals((Object)AddressBarMode.SEARCH_MODE) && navigationContext.isSearching()) {
                    try {
                        navigationContext.endSearch();
                    }
                    catch (InvalidLocationException invalidLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        final RequestFilter requestFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SearchCriteria searchCriteria = null;
                        if (addressBar.getSearchText() != null) {
                            searchCriteria = new SearchCriteria(addressBar.getSearchText());
                        }
                        Explorer.this.setSearchCriteria(searchCriteria);
                    }
                });
            }
        }, 500);
        requestFilter.setName("CDB Search Request Filter");
        addressBar.addSearchTextListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                requestFilter.cancelPendingRequests();
                requestFilter.request();
            }
        });
        addressBar.getComponent().setName("AddressBar");
        addressBar.getComponent().getAccessibleContext().setAccessibleName(ExplorerResources.getString((String)"title"));
        return addressBar;
    }

    private static ExplorerActionButton buildActionButton(final FileTable fileTable, final ActionManager actionManager) {
        ExplorerActionButton explorerActionButton = new ExplorerActionButton(fileTable, new ExplorerActionButton.Customizer(){

            public void customize(JComponent jComponent, JPopupMenu jPopupMenu, MJMenu mJMenu) {
                jPopupMenu.removeAll();
                new ActionMenuBuilder(jPopupMenu).populateMenu(fileTable, actionManager, mJMenu);
            }
        });
        explorerActionButton.getComponent().setName("ActionButton");
        return explorerActionButton;
    }

    public Object getLazyProperty(DTProperty dTProperty) {
        if (dTProperty.equals((Object)DTProperty.CONTEXT_MENU)) {
            MJMenu mJMenu = new MJMenu();
            MJMenu mJMenu2 = new MJMenu(ExplorerResources.getString((String)"tooltip.newfile"));
            mJMenu2.setName("menu.newfile");
            List list = MenuUtils.getNewFileOptions((FileTable)this.fTable);
            for (Action action : list) {
                mJMenu2.add(action);
            }
            new ActionMenuBuilder((JMenu)mJMenu).populateMenu(this.fTable, this.fActionManager, mJMenu2);
            return mJMenu;
        }
        return null;
    }

    private static FileSystemExpansionProvider getFileSystemExpansionProvider(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        for (ExpansionProvider expansionProvider : groupingTableConfiguration.getExpansionProviders()) {
            if (!(expansionProvider instanceof FileSystemExpansionProvider)) continue;
            return (FileSystemExpansionProvider)expansionProvider;
        }
        return null;
    }

    public DetailViewer getDetailViewer() {
        return this.fDetailViewer;
    }

    private void setupFocus() {
        FocusTraversalPolicyBuilder focusTraversalPolicyBuilder;
        this.setFocusCycleRoot(true);
        if (SwingUtilities.isDescendingFrom(this.fAddressBar.getComponent(), (Component)((Object)this))) {
            focusTraversalPolicyBuilder = new FocusTraversalPolicyBuilder((Component)this.fTable, (Component)this.fAddressBar.getComponent());
            focusTraversalPolicyBuilder.addNextStep((Component)this.fDetailViewer.getButton());
            focusTraversalPolicyBuilder.addNextStep((Component)this.fDetailViewer.getComponent());
            focusTraversalPolicyBuilder.addNextStep((Component)this.fAddressBar.getComponent());
        } else {
            focusTraversalPolicyBuilder = new FocusTraversalPolicyBuilder((Component)this.fTable, (Component)this.fDetailViewer.getComponent());
            focusTraversalPolicyBuilder.addNextStep((Component)this.fDetailViewer.getButton());
            focusTraversalPolicyBuilder.addNextStep((Component)this.fDetailViewer.getComponent());
        }
        this.setFocusTraversalPolicy(focusTraversalPolicyBuilder.getPolicy());
    }

    private void cdOnDocumentContextNavigation() {
        this.fContext.addNavigationListener(new NavigationListener(){

            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                FileLocation fileLocation3 = Explorer.this.fSuppressCdReaction;
                if (fileLocation3 != null && fileLocation3.equals((Object)fileLocation2)) {
                    return;
                }
                File file = new File(fileLocation2.toString());
                if (MatlabPath.getCWD() == null || !file.equals(new File(MatlabPath.getCWD()))) {
                    MatlabPath.setCWD((String)file.getAbsolutePath(), (CompletionObserver)new MatlabCdOperationObserver(Explorer.this.fContext));
                }
            }

            public void searchStarted(SearchCriteria searchCriteria) {
            }

            public void searchEnded() {
            }
        });
    }

    private void navigateDocumentContextOnCd() {
        MatlabPath.addActionListener((ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!actionEvent.getActionCommand().equals("CWD_CHANGE")) {
                    return;
                }
                if (MatlabPath.getCWD() != null && !MatlabPath.getCWD().isEmpty()) {
                    File file = new File(MatlabPath.getCWD());
                    try {
                        FileLocation fileLocation = new FileLocation(file);
                        if (file.exists()) {
                            if (Explorer.this.fCurrentConfiguration.getGroupMode() != null && Explorer.this.fCurrentConfiguration.getGroupColumn().getKey().equals("status")) {
                                Explorer.this.fCurrentConfiguration.setGroupMode(null, null);
                            }
                            Explorer.this.fSuppressCdReaction = fileLocation;
                            Explorer.this.fContext.setLocation(fileLocation);
                            sSourceControlManager.checkForSourceControl(file);
                        }
                    }
                    catch (InvalidLocationException invalidLocationException) {
                        Explorer.this.fSuppressCdReaction = null;
                    }
                }
            }
        });
    }

    private void clearSearchBoxOnSearchEnd() {
        this.fContext.addNavigationListener(new NavigationListener(){

            public void searchStarted(SearchCriteria searchCriteria) {
            }

            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                Explorer.this.fAddressBar.setMode(Explorer.this.fAddressBar.getDefaultMode());
            }

            public void searchEnded() {
                if (Explorer.this.fAddressBar.getMode().equals((Object)AddressBarMode.SEARCH_MODE)) {
                    Explorer.this.fAddressBar.setMode(Explorer.this.fAddressBar.getDefaultMode());
                }
            }
        });
    }

    private void switchTableConfigurationOnSearchOrEnd() {
        this.fContext.addNavigationListener(new NavigationListener(){

            public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
                this.searchEnded();
            }

            public void searchStarted(SearchCriteria searchCriteria) {
                if (!Explorer.this.fCurrentConfiguration.equals(Explorer.this.fSearchConfiguration)) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Explorer.this.fNonSearchConfiguration = Explorer.this.fTable.getConfiguration().switchConfiguration(Explorer.this.fSearchConfiguration);
                            Explorer.this.fTable.updateWidthEstimateScaleFactor();
                            Explorer.this.fCurrentConfiguration = Explorer.this.fSearchConfiguration;
                        }
                    });
                }
            }

            public void searchEnded() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!Explorer.this.fCurrentConfiguration.equals(Explorer.this.fNonSearchConfiguration)) {
                            Explorer.this.fSearchConfiguration = Explorer.this.fTable.getConfiguration().switchConfiguration(Explorer.this.fNonSearchConfiguration);
                            Explorer.this.fTable.updateWidthEstimateScaleFactor();
                            Explorer.this.fCurrentConfiguration = Explorer.this.fNonSearchConfiguration;
                        }
                    }
                });
            }
        });
    }

    private static void stopFileSystemMonitoringOnShutdown() {
        MLDesktop.getInstance().addMatlabThreadCloser(new DTWindowCloser(){

            public boolean canClose() {
                RealFileSystem.stopPassiveMonitoring();
                MLFileSystemUtils.releaseAllMatlabAccessibleEntries();
                return true;
            }

            public void close() {
            }
        });
    }

    ExplorerActionButton getActionButton() {
        return this.fExplorerActionButton;
    }

    public void requestFocus() {
        this.fTable.requestFocus();
    }

    public boolean requestFocusInWindow() {
        this.fTable.requestFocus();
        return true;
    }

    public void clearSearch() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Explorer.this.fContext.endSearch();
                }
                catch (InvalidLocationException invalidLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public static synchronized Explorer getInstance() {
        if (sInstance == null) {
            sInstance = new Explorer();
        }
        return sInstance;
    }

    public static void invoke() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MLDesktop.getInstance().addClient((Component)((Object)Explorer.getInstance()), Explorer.NAME);
            }
        });
    }

    public JToolBar borrowToolbar() {
        this.remove(this.fToolbar.getComponent());
        this.fMoveToolbarAction.updateLabel(true);
        this.setupFocus();
        this.revalidate();
        this.repaint();
        return this.fToolbar.getComponent();
    }

    public void returnToolbar() {
        this.add(this.fToolbar.getComponent(), "North");
        this.fMoveToolbarAction.updateLabel(false);
        this.setupFocus();
        this.revalidate();
        this.repaint();
    }

    public NavigationContext getContext() {
        return this.fContext;
    }

    public WorkMonitor getWorkMonitor() {
        return this.fWorkMonitor;
    }

    public void doLayout() {
        super.doLayout();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Explorer.this.fSplitPane.initialize();
            }
        });
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        boolean bl = MJUtilities.isHighContrast();
        if (sIsHighContrast != bl) {
            sIsHighContrast = bl;
            ToolbarUtils.fixLook(this.fToolbar.getComponent());
        }
    }

    public AddressBar getAddressBar() {
        return this.fAddressBar;
    }

    public void setSearchCriteria(SearchCriteria searchCriteria) {
        try {
            if (searchCriteria == null) {
                this.fContext.endSearch();
            } else {
                this.fContext.search(searchCriteria, (Predicate)new Predicate<FileSystemEntry>(){

                    public boolean accept(FileSystemEntry fileSystemEntry) {
                        return true;
                    }
                });
            }
        }
        catch (InvalidLocationException invalidLocationException) {
            throw new IllegalStateException(invalidLocationException);
        }
    }

    public FileTable getTable() {
        return this.fTable;
    }

    Action getMoveToolbarAction() {
        if (this.fMoveToolbarAction == null) {
            this.fMoveToolbarAction = new MoveToolbarAction();
        }
        return this.fMoveToolbarAction;
    }

    static {
        I18N_NAME = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop").getString("title.CurrentDirectory");
    }

    private static class MoveToolbarAction
    extends MJAbstractAction {
        MoveToolbarAction() {
            super("");
            this.updateLabel(MLDesktop.getInstance().isCurrentFolderBarBelowToolstrip());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = MLDesktop.getInstance().isCurrentFolderBarBelowToolstrip();
            MLDesktop.getInstance().setCurrentFolderBarBelowToolstrip(!bl);
        }

        private void updateLabel(boolean bl) {
            this.setName(ExplorerResources.getString((String)(bl ? "toolbar.popup.moveBackIn" : "toolbar.popup.moveBelowToolstrip")));
        }
    }

    private static class DirectoryVsFileSeparator
    implements Comparator<FileSystemEntry> {
        private DirectoryVsFileSeparator() {
        }

        @Override
        public int compare(FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2) {
            fileSystemEntry = VirtualFileSystem.getUnderlyingEntryIfMountPoint((FileSystemEntry)fileSystemEntry);
            fileSystemEntry2 = VirtualFileSystem.getUnderlyingEntryIfMountPoint((FileSystemEntry)fileSystemEntry2);
            if (fileSystemEntry.isFolder() ^ fileSystemEntry2.isFolder()) {
                return fileSystemEntry.isFolder() ? -1 : 1;
            }
            return 0;
        }
    }

    private class PathAffordanceAdapter {
        private PathAffordance iMainAffordance;
        private PathAffordance iSearchAffordance;

        PathAffordanceAdapter() {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (((Boolean)ExplorerPrefs.PathAffordanceEnabled.get()).booleanValue() && PathAffordanceAdapter.this.iMainAffordance == null) {
                            PathAffordanceAdapter.this.iMainAffordance = new PathAffordance((PathModel)MatlabPathModel.getInstance(), Explorer.getFileSystemExpansionProvider((GroupingTableConfiguration<FileSystemEntry>)Explorer.this.fNonSearchConfiguration));
                            PathAffordanceAdapter.this.iSearchAffordance = new PathAffordance((PathModel)MatlabPathModel.getInstance(), Explorer.getFileSystemExpansionProvider((GroupingTableConfiguration<FileSystemEntry>)Explorer.this.fSearchConfiguration));
                            Explorer.this.fNonSearchConfiguration.addAffordance((Affordance)PathAffordanceAdapter.this.iMainAffordance);
                            Explorer.this.fSearchConfiguration.addAffordance((Affordance)PathAffordanceAdapter.this.iSearchAffordance);
                            if (Explorer.this.fContext.isSearching()) {
                                Explorer.this.fTable.getConfiguration().addAffordance((Affordance)PathAffordanceAdapter.this.iSearchAffordance);
                            } else {
                                Explorer.this.fTable.getConfiguration().addAffordance((Affordance)PathAffordanceAdapter.this.iMainAffordance);
                            }
                        } else if (!((Boolean)ExplorerPrefs.PathAffordanceEnabled.get()).booleanValue() && PathAffordanceAdapter.this.iMainAffordance != null) {
                            Explorer.this.fNonSearchConfiguration.removeAffordance((Affordance)PathAffordanceAdapter.this.iMainAffordance);
                            Explorer.this.fSearchConfiguration.removeAffordance((Affordance)PathAffordanceAdapter.this.iSearchAffordance);
                            Explorer.this.fTable.getConfiguration().removeAffordance((Affordance)PathAffordanceAdapter.this.iMainAffordance);
                            Explorer.this.fTable.getConfiguration().removeAffordance((Affordance)PathAffordanceAdapter.this.iSearchAffordance);
                            PathAffordanceAdapter.this.iMainAffordance.dispose();
                            PathAffordanceAdapter.this.iSearchAffordance.dispose();
                            PathAffordanceAdapter.this.iMainAffordance = null;
                            PathAffordanceAdapter.this.iSearchAffordance = null;
                        }
                    }
                    catch (SettingException settingException) {
                        throw new RuntimeException(settingException);
                    }
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
            try {
                ExplorerPrefs.PathAffordanceEnabled.addListener((SettingListener)new SettingAdapter(){

                    public void settingChanged(SettingChangeEvent settingChangeEvent) {
                        MJUtilities.runOnEventDispatchThread((Runnable)runnable);
                    }
                });
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
    }

    private static class ActionMenuBuilder {
        private JPopupMenu iPopupMenu;
        private JMenu iMenu;

        ActionMenuBuilder(JPopupMenu jPopupMenu) {
            this.iPopupMenu = jPopupMenu;
        }

        ActionMenuBuilder(JMenu jMenu) {
            this.iMenu = jMenu;
        }

        void add(JMenuItem jMenuItem) {
            if (this.iPopupMenu != null) {
                this.iPopupMenu.add(jMenuItem);
            } else if (this.iMenu != null) {
                this.iMenu.add(jMenuItem);
            }
        }

        void add(Action action) {
            if (this.iPopupMenu != null) {
                this.iPopupMenu.add(action);
            } else if (this.iMenu != null) {
                this.iMenu.add(action);
            }
        }

        void addSeparator() {
            if (this.iPopupMenu != null) {
                this.iPopupMenu.addSeparator();
            } else if (this.iMenu != null) {
                this.iMenu.addSeparator();
            }
        }

        void populateMenu(FileTable fileTable, ActionManager actionManager, MJMenu mJMenu) {
            Action action2;
            this.add((JMenuItem)new MJMenuItem((Action)actionManager.getAction(CoreActionID.NEW_FOLDER)));
            if (mJMenu != null) {
                this.add((JMenuItem)mJMenu);
            }
            this.addSeparator();
            MJMenu mJMenu2 = new MJMenu(actionManager.getMenuSection(CoreMenuSectionID.REPORTS).getName());
            for (Action action2 : actionManager.getActions(CoreMenuSectionID.REPORTS)) {
                mJMenu2.add(action2);
            }
            mJMenu2.setName("menu.reports");
            this.add((JMenuItem)mJMenu2);
            this.add(MLDesktop.getInstance().getLaunchComparisonToolAction());
            this.add((Action)actionManager.getAction(CoreActionID.FIND_FILES));
            this.addSeparator();
            ColumnActions columnActions = fileTable.getColumnActions();
            action2 = columnActions.createGroupingMenu();
            MJMenu mJMenu3 = columnActions.createSortingMenu();
            MJMenu mJMenu4 = columnActions.createShowMenu();
            this.add((JMenuItem)mJMenu4);
            this.add((JMenuItem)mJMenu3);
            this.add((JMenuItem)((Object)action2));
        }
    }
}

