/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.find;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mde.find.FindFiles;
import com.mathworks.mde.find.FindFilesPrefs;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.table.AccessibleTextProvider;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.mwswing.table.SortedTable;
import com.mathworks.mwswing.table.SortedTableHeaderRenderer;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.SyntaxTextLabel;
import com.mathworks.widgets.TokenizerFactory;
import com.mathworks.widgets.WorkMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;

public class FindResultsPanel
extends MJPanel {
    private static final int FILENAME_COLUMN = 0;
    private static final int PATH_COLUMN = 1;
    private static final int LINE_NUM_COLUMN = 2;
    private static final int OPEN = 0;
    private static final int OPEN_AS_TEXT = 1;
    private static final int OPEN_OUTSIDE_MATLAB = 2;
    private static final int HGAP = 4;
    private static ResourceBundle sResourceBundle;
    private final MyTable fResultsTable;
    private CustomModel fCustomModel;
    private MJLabel fResults;
    private MJPanel fDirPanel;
    private TableColumn fFileTableColumn;
    private TableColumn fPathTableColumn;
    private TableColumn fLineNoColumn;
    private TableColumn fResultColumn;
    private MJSpinner fDirectories;
    private SpinnerListModel fSpinnerModel;
    private MJScrollPane fScrollpane;
    private EntryRenderer fEntryRenderer;
    private MyCodeRenderer fCodeRenderer;
    private Matlab fMatlab;
    private MJPopupMenu fPopupMenu;
    private CopyAction fCopyAction;
    private JMenuItem fCopyMenuItem;
    private JMenuItem fOpenMenuItem;
    private MJCheckBoxMenuItem fShowFullPathMenuItem;
    private SortDecorator fSorter;
    private WorkMonitor fWorkMonitor;
    private int fMaxLineLength = 400;
    private String[] fColumnHeaders = new String[]{FindFiles.sRes.getString("header.Filename"), FindFiles.sRes.getString("header.Filename"), FindFiles.sRes.getString("header.Line"), FindFiles.sRes.getString("header.Text")};
    private int[] fColumnWidths = new int[3];
    private List fCachedToAdd = new ArrayList();
    private UpdateThread fUpdateThread;
    private boolean fIsTesting = false;
    private final String DIR_LABEL_NAME = "FoldersSearchedLabel";

    public FindResultsPanel(boolean bl) {
        Object object;
        sResourceBundle = ResourceBundle.getBundle("com.mathworks.mde.find.resources.RES_FindFiles");
        this.fMatlab = new Matlab();
        this.fWorkMonitor = new WorkMonitor();
        this.fWorkMonitor.registerComponentForWaitCursor((Component)((Object)this));
        this.setLayout(new BorderLayout());
        Object[][] objectArray = new String[][]{{"", "", "", ""}};
        this.fCustomModel = new CustomModel(objectArray, this.fColumnHeaders);
        this.fResultsTable = new MyTable(this.fCustomModel);
        this.fSorter = new SortDecorator(this.fCustomModel);
        JTableHeader jTableHeader = this.fResultsTable.getTableHeader();
        jTableHeader.setDefaultRenderer((TableCellRenderer)new SortedTableHeaderRenderer(jTableHeader.getDefaultRenderer()));
        this.fResultsTable.setModel(this.fSorter);
        this.fResultsTable.setName("ResultsTable");
        this.fResultsTable.getAccessibleContext().setAccessibleName(sResourceBundle.getString("acc.SearchResults"));
        ListColorUtils.setupForList((JTable)((Object)this.fResultsTable));
        this.fResultsTable.addMouseListener(new ResultsMouseAdapter());
        this.fResultsTable.setBackground(FindFiles.getBackgroundColor());
        this.fResultsTable.setForeground(FindFiles.getTextColor());
        this.fEntryRenderer = new EntryRenderer();
        this.fResultsTable.setDefaultRenderer(Object.class, this.fEntryRenderer);
        this.fCodeRenderer = new MyCodeRenderer(0);
        this.fResultsTable.getColumnModel().getColumn(3).setCellRenderer(this.fCodeRenderer);
        this.fFileTableColumn = this.fResultsTable.getColumnModel().getColumn(0);
        this.fPathTableColumn = this.fResultsTable.getColumnModel().getColumn(1);
        this.fResultsTable.removeColumn(this.fPathTableColumn);
        this.fResultsTable.setCellViewerEnabled(true);
        this.fResultsTable.addKeyListener(new MyKeyListener());
        this.fResultsTable.setAccessibleTextProvider(this.createAccessibleTextProvider());
        JTableHeader jTableHeader2 = this.fResultsTable.getTableHeader();
        jTableHeader2.addMouseListener(new HeaderMouseAdapter());
        this.fScrollpane = new MJScrollPane((Component)((Object)this.fResultsTable));
        this.fScrollpane.getViewport().setBackground(FindFiles.getBackgroundColor());
        this.fScrollpane.setName("ResultsScrollPane");
        this.add((Component)this.fScrollpane, "Center");
        if (bl) {
            object = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(2, 1));
            mJPanel.setName("StatusPanel");
            Object[] objectArray2 = new Object[]{""};
            String string = sResourceBundle.getString("msg.SearchingString");
            this.fResults = new MJLabel(MessageFormat.format(string, objectArray2));
            this.fResults.setName("ResultsLabel");
            this.fCopyAction = new CopyAction();
            this.createPopupMenu();
            this.fResultsTable.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
            this.fResultsTable.getInputMap().put(KeyStroke.getKeyStroke(155, 2), "copy");
            this.fResultsTable.getInputMap().put(KeyStroke.getKeyStroke(87, 8), "copy");
            this.fResultsTable.getActionMap().put("copy", this.fCopyAction);
            this.fResultsTable.getInputMap().put(KeyStroke.getKeyStroke(87, 2), "closetab");
            this.fResultsTable.getActionMap().put("closetab", (Action)FindFiles.getRemoveTabAction());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.fDirPanel = new MJPanel((LayoutManager)object);
            MJLabel mJLabel = new MJLabel(sResourceBundle.getString("label.Directoriessearched"));
            mJLabel.setName("FoldersSearchedLabel");
            this.fSpinnerModel = new SpinnerListModel();
            this.fDirectories = new MJSpinner((SpinnerModel)this.fSpinnerModel);
            MySpinnerEditor mySpinnerEditor = new MySpinnerEditor((JSpinner)this.fDirectories);
            this.fDirectories.setEditor((JComponent)mySpinnerEditor);
            this.fDirectories.setFont(this.fResults.getFont());
            mySpinnerEditor.getTextField().setEditable(false);
            mySpinnerEditor.getAccessibleContext().setAccessibleName(sResourceBundle.getString("label.Directoriessearched"));
            this.fDirectories.setName("DirsSearchedList");
            ((GridBagLayout)object).setConstraints((Component)mJLabel, gridBagConstraints);
            this.fDirPanel.add((Component)mJLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ((GridBagLayout)object).setConstraints((Component)this.fDirectories, gridBagConstraints);
            ((GridBagLayout)object).setConstraints((Component)this.fResults, gridBagConstraints);
            this.fDirPanel.add((Component)this.fDirectories);
            this.fDirPanel.setVisible(false);
            mJPanel.add((Component)this.fResults);
            mJPanel.add((Component)this.fDirPanel);
            this.add((Component)mJPanel, "South");
            this.fUpdateThread = new UpdateThread();
            this.fUpdateThread.start();
        }
        this.fResultsTable.setAutoResizeMode(0);
        this.fScrollpane.setHorizontalScrollBarPolicy(30);
        if (FindFiles.isShowingFullPathnames()) {
            this.showFullPathnames(true);
        }
        this.fLineNoColumn = this.fResultsTable.getColumnModel().getColumn(1);
        this.fResultColumn = this.fResultsTable.getColumnModel().getColumn(2);
        object = new StringTokenizer(FindFilesPrefs.getColumnSize(), ";");
        int n = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            this.fColumnWidths[n++] = new Integer(((StringTokenizer)object).nextToken().trim());
        }
        this.fFileTableColumn.setPreferredWidth(this.fColumnWidths[0] == -1 ? 150 : this.fColumnWidths[0]);
        this.fPathTableColumn.setPreferredWidth(this.fColumnWidths[0] == -1 ? this.fFileTableColumn.getPreferredWidth() : this.fColumnWidths[0]);
        if (this.fColumnWidths[2] == -1) {
            this.fLineNoColumn.sizeWidthToFit();
        } else {
            this.fLineNoColumn.setPreferredWidth(this.fColumnWidths[1]);
        }
        this.fResultColumn.setPreferredWidth(this.fColumnWidths[2] == -1 ? 350 : this.fColumnWidths[2]);
        this.fResultsTable.setFont(FindFiles.getTextFont());
        this.setTableRowHeight(FindFiles.getTextFont());
        this.fResultsTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FindResultsPanel.this.saveColumnSize();
            }
        });
    }

    private AccessibleTextProvider createAccessibleTextProvider() {
        return new AccessibleTextProvider(){

            public String getAccessibleText(int n, int n2) {
                String string = FindResultsPanel.this.fCustomModel.getValueAt(n, 0) + " on line " + FindResultsPanel.this.fCustomModel.getValueAt(n, 2);
                String string2 = (String)FindResultsPanel.this.fCustomModel.getValueAt(n, 3);
                if (string2 != null && !string2.isEmpty()) {
                    string = string + " containing text " + string2;
                }
                return string;
            }
        };
    }

    private void saveColumnSize() {
        if (FindFilesPrefs.isShowFullPath()) {
            FindFilesPrefs.setColumnSize(String.valueOf(this.fPathTableColumn.getWidth()) + "; " + this.fLineNoColumn.getWidth() + "; " + this.fResultColumn.getWidth());
        } else {
            FindFilesPrefs.setColumnSize(String.valueOf(this.fFileTableColumn.getWidth()) + "; " + this.fLineNoColumn.getWidth() + "; " + this.fResultColumn.getWidth());
        }
    }

    private void createPopupMenu() {
        this.fPopupMenu = new MJPopupMenu();
        this.fOpenMenuItem = this.fPopupMenu.add((Action)new OpenAction(sResourceBundle.getString("popup.Open"), 0));
        this.fOpenMenuItem = this.fPopupMenu.add((Action)new OpenAction(sResourceBundle.getString("popup.OpenAsText"), 1));
        if (!PlatformInfo.isXWindows()) {
            this.fOpenMenuItem = this.fPopupMenu.add((Action)new OpenAction(sResourceBundle.getString("popup.OpenOutside"), 2));
        }
        this.fCopyMenuItem = this.fPopupMenu.add((Action)this.fCopyAction);
        this.fPopupMenu.addSeparator();
        this.fShowFullPathMenuItem = new MJCheckBoxMenuItem(sResourceBundle.getString("popup.ShowFullPathnames"));
        this.fShowFullPathMenuItem.addActionListener((ActionListener)new ShowPathAction());
        this.fShowFullPathMenuItem.setState(FindFiles.isShowingFullPathnames());
        this.fPopupMenu.add((JMenuItem)this.fShowFullPathMenuItem);
    }

    void interruptUpdateThread() {
        this.fUpdateThread.interrupt();
    }

    void addResult(String[] stringArray, boolean bl) {
        if (bl) {
            this.showFullPathnames(true);
        }
        this.fCustomModel.addRowToCache(stringArray);
    }

    public void setBackgroundColor(Color color) {
        this.fResultsTable.setBackground(color);
        this.fScrollpane.getViewport().setBackground(color);
    }

    public void setForegroundColor(Color color) {
        this.fResultsTable.setForeground(color);
    }

    void setTableRowHeight(Font font) {
        this.fResultsTable.setFont(font);
        Graphics graphics = this.fResultsTable.getGraphics();
        if (graphics != null) {
            int n = graphics.getFontMetrics().getHeight() + 1;
            if (n != this.fResultsTable.getRowHeight()) {
                this.fResultsTable.setRowHeight(n);
            }
            graphics.dispose();
        }
    }

    void showFullPathnames(boolean bl) {
        if (bl) {
            this.fPathTableColumn.setPreferredWidth(FindFilesPrefs.getFirstColumnSize());
            this.fResultsTable.addColumn(this.fPathTableColumn);
            this.fResultsTable.removeColumn(this.fFileTableColumn);
            if (this.fSorter.getSortedColumn() == 0) {
                this.fSorter.sort(1, this.fSorter.getSortDirection());
            }
        } else {
            this.fFileTableColumn.setPreferredWidth(FindFilesPrefs.getFirstColumnSize());
            this.fResultsTable.addColumn(this.fFileTableColumn);
            this.fResultsTable.removeColumn(this.fPathTableColumn);
            if (this.fSorter.getSortedColumn() == 1) {
                this.fSorter.sort(0, this.fSorter.getSortDirection());
            }
        }
        this.fResultsTable.getColumnModel().moveColumn(this.fResultsTable.getColumnModel().getColumnCount() - 1, 0);
        if (this.fShowFullPathMenuItem != null) {
            this.fShowFullPathMenuItem.setState(bl);
        }
    }

    MJLabel getResultsLabel() {
        return this.fResults;
    }

    void setSpinnerList(List list) {
        if (list != null && !list.isEmpty()) {
            this.fSpinnerModel.setList(list);
        }
    }

    MJPanel getDirPanel() {
        return this.fDirPanel;
    }

    private boolean isShowingNoResultsMsg() {
        String string = (String)this.fSorter.getValueAt(0, 0);
        return string.equals(sResourceBundle.getString("msg.NoResults"));
    }

    private void openSelectedFiles(int n) {
        int[] nArray = this.fResultsTable.getSelectedRows();
        ArrayList<Status> arrayList = new ArrayList<Status>();
        for (int n2 : nArray) {
            Object[] objectArray;
            boolean bl;
            Integer n3;
            String string = (String)this.fSorter.getValueAt(n2, 1);
            String string2 = this.fSorter.getValueAt(n2, 2).toString();
            if (string2 == null || string2.isEmpty()) {
                n3 = 1;
                bl = false;
            } else {
                n3 = new Integer(string2);
                bl = true;
            }
            File file = new File(string);
            if (!file.exists() || !file.isFile() || this.fMatlab == null) continue;
            Status status = new Status("", true);
            arrayList.add(status);
            if (n == 1) {
                objectArray = MLEditorServices.getEditorApplication().openEditor(new File(string));
                this.openFileIfNotNull(n3, bl, (Editor)objectArray);
                status.markCompleted();
                continue;
            }
            if (n == 0) {
                objectArray = "uiopen('" + StringUtils.quoteSingleQuotes((String)string) + "',1)";
                this.fMatlab.evalConsoleOutput((String)objectArray, (CompletionObserver)new StatusObserver(status));
                continue;
            }
            if (n != 2) continue;
            if (PlatformInfo.isWindows()) {
                objectArray = "winopen('" + StringUtils.quoteSingleQuotes((String)string) + "')";
                this.fMatlab.eval((String)objectArray, (CompletionObserver)new EvalPCSysOpenObserver(status));
                continue;
            }
            if (!PlatformInfo.isMacintosh()) continue;
            objectArray = new String[]{"open '" + string + "'"};
            this.fMatlab.feval("unix", objectArray, 2, (CompletionObserver)new FevalMacSysOpenObserver(status));
        }
        Status status = new Status(arrayList);
        final WorkMonitor.Task task = this.fWorkMonitor.startTask(status.getLabel(), status.isHeavy());
        status.addCompletionOrCancellationRunnable(new Runnable(){

            @Override
            public void run() {
                task.finished();
            }
        });
    }

    public void openFileIfNotNull(Integer n, boolean bl, Editor editor) {
        if (editor != null) {
            editor.bringToFront();
            editor.goToLine(n.intValue(), bl);
        }
    }

    void setSelectedIndexes(int[] nArray) {
        int[] nArray2 = this.fResultsTable.getSelectedRows();
        if (Arrays.equals(nArray2, nArray)) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1 || nArray[i] >= this.fResultsTable.getRowCount()) continue;
            if (i == 0) {
                this.fResultsTable.setRowSelectionInterval(nArray[0], nArray[0]);
            } else {
                this.fResultsTable.addRowSelectionInterval(nArray[i], nArray[i]);
            }
            this.fResultsTable.scrollRectToVisible(this.fResultsTable.getCellRect(nArray[0], 0, false));
        }
    }

    private void enableDisableMenuItems() {
        this.fOpenMenuItem.setEnabled(!this.isShowingNoResultsMsg() && this.fResultsTable.getSelectedRowCount() > 0);
        this.fCopyMenuItem.setEnabled(this.fResultsTable.getSelectedRowCount() > 0);
    }

    private int alertUser(Object object, int n, int n2) {
        return MJOptionPane.showConfirmDialog((Component)this.getParent(), (Object)object, (String)sResourceBundle.getString("title.FindFiles"), (int)n, (int)n2);
    }

    JTable getTable() {
        return this.fResultsTable;
    }

    JSpinner getSpinner() {
        return this.fDirectories;
    }

    private class UpdateThread
    extends Thread {
        private Runnable iPublishRunnable;
        private boolean iDone;

        UpdateThread() {
            this.iPublishRunnable = new Runnable(){

                @Override
                public void run() {
                    UpdateThread.this.publishChangesOnEventDispatchingThread();
                }
            };
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && !this.iDone) {
                try {
                    UpdateThread.sleep(200L);
                    this.publishChanges();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.iDone) {
                this.publishChanges();
            }
        }

        @Override
        public void interrupt() {
            this.iDone = true;
            super.interrupt();
        }

        private void publishChanges() {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            while (eventQueue.peekEvent() != null && !FindResultsPanel.this.fIsTesting) {
                try {
                    UpdateThread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateThread.this.iPublishRunnable.run();
                    FindResultsPanel.this.saveColumnSize();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void publishChangesOnEventDispatchingThread() {
            int n = FindResultsPanel.this.fCustomModel.getRowCount();
            if (FindResultsPanel.this.fCachedToAdd != null) {
                FindResultsPanel.this.fCustomModel.addCachedRows();
                FindResultsPanel.this.fCustomModel.fireTableRowsInserted(n, FindResultsPanel.this.fCustomModel.getRowCount() - 1);
                if (this.iDone) {
                    List list = FindResultsPanel.this.fCachedToAdd;
                    synchronized (list) {
                        FindResultsPanel.this.fCachedToAdd = null;
                    }
                }
            }
        }
    }

    private class MyTable
    extends MJTable
    implements SortedTable {
        MyTable(TableModel tableModel) {
            super(tableModel);
            this.setRowHeight(18);
            this.setRightSelectionEnabled(true);
        }

        public int getSortColumn() {
            return FindResultsPanel.this.fSorter.getSortedColumn();
        }

        public int getSortDirection() {
            if (FindResultsPanel.this.fSorter.getSortedColumn() == -1) {
                return 0;
            }
            if (FindResultsPanel.this.fSorter.getSortDirection()) {
                return 0;
            }
            return 1;
        }

        public void copy() {
            int[] nArray = this.getSelectedRows();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < this.getColumnModel().getColumnCount(); ++j) {
                    stringBuilder.append(this.getValueAt(nArray[i], j));
                    if (j == this.getColumnModel().getColumnCount() - 1) continue;
                    stringBuilder.append("\t");
                }
                if (i == nArray.length - 1) continue;
                stringBuilder.append("\n");
            }
            if (nArray.length > 0 && PlatformInfo.isXWindows()) {
                MJClipboard.getMJClipboard().setXSelectionContents(stringBuilder.toString());
            }
            MJClipboard.getMJClipboard().setContents(stringBuilder.toString(), null);
        }
    }

    private static class MySpinnerEditor
    extends JSpinner.ListEditor {
        MySpinnerEditor(JSpinner jSpinner) {
            super(jSpinner);
        }

        @Override
        public JFormattedTextField getTextField() {
            JFormattedTextField jFormattedTextField = super.getTextField();
            jFormattedTextField.setBorder(null);
            jFormattedTextField.getAccessibleContext().setAccessibleName(sResourceBundle.getString("label.Directoriessearched"));
            return jFormattedTextField;
        }
    }

    private class CustomModel
    extends DefaultTableModel {
        private final List iCachedToAddLocking;

        CustomModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
            super.removeRow(0);
            this.iCachedToAddLocking = FindResultsPanel.this.fCachedToAdd;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRowToCache(Object[] objectArray) {
            List list = this.iCachedToAddLocking;
            synchronized (list) {
                this.iCachedToAddLocking.add(CustomModel.convertToVector(objectArray));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCachedRows() {
            List list = this.iCachedToAddLocking;
            synchronized (list) {
                if (this.dataVector.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (FindResultsPanel.this.fResultsTable.getRowCount() > 0 && FindResultsPanel.this.fResultsTable.getSelectedRow() == -1) {
                                FindResultsPanel.this.fResultsTable.getSelectionModel().addSelectionInterval(0, 0);
                            }
                        }
                    });
                }
                this.dataVector.addAll(this.iCachedToAddLocking);
                this.iCachedToAddLocking.clear();
            }
        }
    }

    private class SortDecorator
    implements TableModel,
    TableModelListener {
        private CustomModel realModel;
        private int[] indexes;
        private boolean iSortDirection = true;
        private int iSortedColumn = -1;

        SortDecorator(CustomModel customModel) {
            if (customModel == null) {
                throw new IllegalArgumentException("null models are not allowed");
            }
            this.realModel = customModel;
            this.realModel.addTableModelListener(this);
            this.allocate();
        }

        public boolean getSortDirection() {
            return this.iSortDirection;
        }

        public int getSortedColumn() {
            return this.iSortedColumn;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.realModel.getRowCount() > this.indexes.length) {
                this.allocate();
            }
            return this.realModel.getValueAt(this.indexes[n], n2);
        }

        public int getRealIndexForRow(int n) {
            return this.indexes[n];
        }

        public int getRowForIndex(int n) {
            for (int i = 0; i < this.indexes.length; ++i) {
                if (this.indexes[i] != n) continue;
                return i;
            }
            return 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.realModel.setValueAt(object, this.indexes[n], n2);
            if (this.realModel.getRowCount() > this.indexes.length) {
                this.allocate();
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.allocate();
        }

        public void sort(final int n, boolean bl) {
            int n2;
            this.iSortedColumn = n;
            this.iSortDirection = bl;
            Integer[] integerArray = new Integer[this.indexes.length];
            for (n2 = 0; n2 < this.indexes.length; ++n2) {
                integerArray[n2] = this.indexes[n2];
            }
            Arrays.sort(integerArray, new Comparator<Integer>(){

                @Override
                public int compare(Integer n3, Integer n2) {
                    return -SortDecorator.this.compare(n3, n2, n);
                }
            });
            for (n2 = 0; n2 < this.indexes.length; ++n2) {
                if (bl) {
                    this.indexes[n2] = integerArray[n2];
                    continue;
                }
                this.indexes[this.indexes.length - n2 - 1] = integerArray[n2];
            }
        }

        public void swap(int n, int n2) {
            int n3 = this.indexes[n];
            this.indexes[n] = this.indexes[n2];
            this.indexes[n2] = n3;
        }

        public int compare(int n, int n2, int n3) {
            Object object = this.realModel.getValueAt(n, n3);
            Object object2 = this.realModel.getValueAt(n2, n3);
            int n4 = n3 != 2 ? this.compareStrings(object.toString(), object2.toString()) : this.compareLineNumbers(this.realModel.getValueAt(n, 2), this.realModel.getValueAt(n2, 2));
            if (n4 == 0 && n3 != 0 && n3 != 1) {
                int n5 = 0;
                if (FindFiles.isShowingFullPathnames()) {
                    n5 = 1;
                }
                Object object3 = this.realModel.getValueAt(n, n5);
                Object object4 = this.realModel.getValueAt(n2, n5);
                n4 = this.compareStrings(object3.toString(), object4.toString());
            } else if (n4 == 0) {
                n4 = this.compareLineNumbers(this.realModel.getValueAt(n, 2), this.realModel.getValueAt(n2, 2));
            }
            return n4;
        }

        private int compareStrings(String string, String string2) {
            return string2.trim().toLowerCase().compareTo(string.trim().toLowerCase());
        }

        private int compareLineNumbers(Object object, Object object2) {
            if (((String)object).isEmpty() || ((String)object2).isEmpty()) {
                return ((CharSequence)object).length() < ((CharSequence)object2).length() ? -1 : (((CharSequence)object).length() == ((CharSequence)object2).length() ? 0 : 1);
            }
            Integer n = new Integer((String)object);
            Integer n2 = new Integer((String)object2);
            return n2.compareTo(n);
        }

        private void allocate() {
            if (this.indexes == null || this.indexes.length != this.getRowCount()) {
                this.indexes = new int[this.getRowCount()];
                for (int i = 0; i < this.indexes.length; ++i) {
                    this.indexes[i] = i;
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.realModel.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.realModel.getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            return this.realModel.getColumnName(n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.realModel.getColumnClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.realModel.isCellEditable(n, n2);
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.realModel.addTableModelListener(tableModelListener);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.realModel.removeTableModelListener(tableModelListener);
        }

        public void addRow(Object[] objectArray) {
            this.realModel.addRow(objectArray);
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                FindResultsPanel.this.openSelectedFiles(1);
            }
            keyEvent.consume();
        }
    }

    private class ShowPathAction
    extends AbstractAction {
        ShowPathAction() {
            super(sResourceBundle.getString("popup.ShowFullPathnames"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindFiles.MyCheckbox myCheckbox = FindFiles.getPathnamesCheckbox();
            boolean bl = myCheckbox.isSelected();
            FindResultsPanel.this.showFullPathnames(!bl);
            myCheckbox.setSelected(!bl);
            myCheckbox.fireStateChanged();
        }
    }

    private class CopyAction
    extends AbstractAction {
        CopyAction() {
            super(sResourceBundle.getString("popup.Copy"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindResultsPanel.this.fResultsTable.copy();
        }
    }

    private class EvalPCSysOpenObserver
    extends StatusObserver {
        EvalPCSysOpenObserver(Status status) {
            super(status);
        }

        @Override
        protected void processResult(final int n, Object object) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Matlab.getExecutionStatus((int)n) == 2 || Matlab.getExecutionStatus((int)n) == 1) {
                        FindResultsPanel.this.alertUser(sResourceBundle.getString("error.SysOpenFailed"), -1, 0);
                    }
                }
            });
        }
    }

    private class FevalMacSysOpenObserver
    extends StatusObserver {
        FevalMacSysOpenObserver(Status status) {
            super(status);
        }

        @Override
        protected void processResult(int n, final Object object) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = (Object[])object;
                    double[] dArray = (double[])objectArray[0];
                    if (dArray[0] != 0.0) {
                        FindResultsPanel.this.alertUser(sResourceBundle.getString("error.SysOpenFailed"), -1, 0);
                    }
                }
            });
        }
    }

    private static class StatusObserver
    implements CompletionObserver {
        private final Status iStatus;

        StatusObserver(Status status) {
            this.iStatus = status;
        }

        public final void completed(int n, Object object) {
            this.processResult(n, object);
            this.iStatus.markCompleted();
        }

        protected void processResult(int n, Object object) {
        }
    }

    private class OpenAction
    extends AbstractAction {
        private int iOpenType;

        OpenAction(String string, int n) {
            super(string);
            this.iOpenType = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindResultsPanel.this.openSelectedFiles(this.iOpenType);
        }
    }

    private class ResultsMouseAdapter
    extends MouseAdapter {
        private ResultsMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                FindResultsPanel.this.openSelectedFiles(1);
            } else if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        void showPopup(MouseEvent mouseEvent) {
            Object object;
            FindResultsPanel.this.enableDisableMenuItems();
            if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
                FindResultsPanel.this.fPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class MyCodeRenderer
    extends SyntaxTextLabel
    implements TableCellRenderer {
        private static final String JAVA = "java";
        private static final String C = "c";
        private static final String CPP = "cpp";
        private static final String XML = "xml";
        private static final String HTML = "html";

        MyCodeRenderer(int n) {
            super(n);
            this.setOpaque(true);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.setFont(FindFiles.getTextFont());
            this.setText((String)object, false);
            Color color = ListColorUtils.getListAlternatingBackgroundColor((JTable)jTable, (int)n, (boolean)bl, (boolean)jTable.hasFocus());
            Color color2 = ListColorUtils.getListForegroundColor((JTable)jTable, (boolean)bl, (boolean)jTable.hasFocus());
            this.setBackground(color);
            this.setForeground(color2);
            this.setOpaque(true);
            this.setSelected(bl);
            if (bl) {
                this.setTokenizer(TokenizerFactory.getPlainTokenizer());
            } else {
                String string = (String)FindResultsPanel.this.fCustomModel.getValueAt(n, 0);
                if (MLFileUtils.isMatlabCodeFile((String)string)) {
                    this.setTokenizer(TokenizerFactory.getMTokenizer());
                } else {
                    String string2 = FilenameUtils.getExtension((String)string);
                    if (JAVA.equalsIgnoreCase(string2)) {
                        this.setTokenizer(TokenizerFactory.getJavaTokenizer());
                    } else if (C.equalsIgnoreCase(string2) || CPP.equalsIgnoreCase(string2)) {
                        this.setTokenizer(TokenizerFactory.getCTokenizer());
                    } else if (HTML.equalsIgnoreCase(string2) || XML.equalsIgnoreCase(string2)) {
                        this.setTokenizer(TokenizerFactory.getXMLTokenizer());
                    } else {
                        this.setTokenizer(TokenizerFactory.getPlainTokenizer());
                    }
                }
            }
            int n3 = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
            if (n3 > FindResultsPanel.this.fMaxLineLength) {
                FindResultsPanel.this.fMaxLineLength = n3;
                if (SwingUtilities.isEventDispatchThread()) {
                    FindResultsPanel.this.fResultsTable.getColumnModel().getColumn(2).setPreferredWidth(FindResultsPanel.this.fMaxLineLength);
                } else {
                    SwingUtilities.invokeLater(new SetTextColumnWidth(FindResultsPanel.this.fMaxLineLength));
                }
            }
            return this;
        }
    }

    private static class EntryRenderer
    extends MJLabel
    implements TableCellRenderer {
        EntryRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(FindFiles.getTextFont());
            this.setText((String)object);
            Color color = ListColorUtils.getListAlternatingBackgroundColor((JTable)jTable, (int)n, (boolean)bl, (boolean)jTable.hasFocus());
            Color color2 = ListColorUtils.getListForegroundColor((JTable)jTable, (boolean)bl, (boolean)jTable.hasFocus());
            this.setBackground(color);
            this.setForeground(color2);
            this.setOpaque(true);
            this.setIcon(null);
            return this;
        }
    }

    private class SetSelectionOnEventThread
    implements Runnable {
        private int[] fIds;

        SetSelectionOnEventThread(int[] nArray) {
            this.setIds(nArray);
        }

        @Override
        public void run() {
            FindResultsPanel.this.setSelectedIndexes(this.getIds());
        }

        public int[] getIds() {
            return this.fIds;
        }

        public void setIds(int[] nArray) {
            this.fIds = nArray;
        }
    }

    private class HeaderMouseAdapter
    extends MouseAdapter {
        private int iLastSortByClick = -1;

        HeaderMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int[] nArray = FindResultsPanel.this.fResultsTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = FindResultsPanel.this.fSorter.getRealIndexForRow(nArray[i]);
            }
            TableColumnModel tableColumnModel = FindResultsPanel.this.fResultsTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = FindResultsPanel.this.fResultsTable.convertColumnIndexToModel(n);
            if (n2 != -1) {
                if (n2 != this.iLastSortByClick) {
                    FindResultsPanel.this.fSorter.sort(n2, true);
                } else {
                    FindResultsPanel.this.fSorter.sort(n2, !FindResultsPanel.this.fSorter.getSortDirection());
                }
                this.iLastSortByClick = n2;
                int[] nArray2 = new int[nArray.length];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = FindResultsPanel.this.fSorter.getRowForIndex(nArray[i]);
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    FindResultsPanel.this.setSelectedIndexes(nArray2);
                } else {
                    SwingUtilities.invokeLater(new SetSelectionOnEventThread(nArray2));
                }
            }
        }
    }

    private class SetTextColumnWidth
    implements Runnable {
        private int fWidth;

        SetTextColumnWidth(int n) {
            this.setWidth(n);
        }

        @Override
        public void run() {
            FindResultsPanel.this.fResultsTable.getColumnModel().getColumn(2).setPreferredWidth(this.getWidth());
            FindResultsPanel.this.fResultsTable.getColumnModel().getColumn(2).setPreferredWidth(FindResultsPanel.this.fResultsTable.getColumnModel().getColumn(2).getPreferredWidth());
        }

        public int getWidth() {
            return this.fWidth;
        }

        public void setWidth(int n) {
            this.fWidth = n;
        }
    }
}

