/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.KeyStroke;

class ProductScopePanel
extends MJPanel {
    private MJLabel fProductLabel;
    private static final String resStr = "com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser";
    private static final String key = "ProductScopePanel.";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser");
    private static final Color TEXT_FORGROUND = new Color(97, 109, 126);
    private static final Color DEFAULT_SCOPE_BUTTON_BACKGROUND = new Color(177, 193, 211);
    private MJPanel fBorderOnHoverPanel;
    private static ResourceBundle sPrefRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private PrefListener fProdFilterPrefListener;

    public ProductScopePanel() {
        super((LayoutManager)new BorderLayout());
        Color color;
        this.setName("ProductScopePanel");
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProductScopePanel.this.openDialog();
            }
        };
        this.fProductLabel = new MJLabel("", 0);
        this.fProductLabel.setName("ProductScopePanel:fProductLabel");
        this.fProductLabel.setTipWhenTruncatedEnabled(false);
        if (MJUtilities.isHighContrast()) {
            this.fProductLabel.setForeground(Color.white);
            color = Color.black;
        } else {
            this.fProductLabel.setForeground(TEXT_FORGROUND);
            color = FunctionBrowser.DEFAULT_BACKGROUND_COLOR;
        }
        this.setBackground(color);
        this.fProductLabel.setBackground(color);
        this.updateProductLabel();
        this.fBorderOnHoverPanel = new MJPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                int n = this.getWidth();
                int n2 = this.getHeight();
                Dimension dimension = new Dimension(n2, n2);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(DEFAULT_SCOPE_BUTTON_BACKGROUND);
                graphics2D.fillRoundRect(1, 1, n - 1, n2 - 1, dimension.width, dimension.height);
            }
        };
        this.fBorderOnHoverPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fBorderOnHoverPanel, 0));
        this.fBorderOnHoverPanel.setBackground(color);
        this.fBorderOnHoverPanel.add((Component)this.fProductLabel);
        this.fBorderOnHoverPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        this.fProductLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BoxLayout((Container)mJPanel, 0));
        mJPanel.setBackground(color);
        mJPanel.add(Box.createHorizontalGlue());
        mJPanel.add((Component)this.fBorderOnHoverPanel);
        mJPanel.addMouseListener((MouseListener)mouseAdapter);
        mJPanel.add(Box.createHorizontalGlue());
        this.add((Component)mJPanel, "Center");
        this.fProdFilterPrefListener = new ProductFilterPrefListener();
        HelpPrefs.addPrefsListeners((PrefListener)this.fProdFilterPrefListener, (String[])new String[]{"HelpDocCenterFilterEnabled", "HelpSelectedInstalledProducts"});
        this.fProductLabel.addMouseListener((MouseListener)mouseAdapter);
        this.fProductLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ProductScopePanel.this.reverseProductLabelColor();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ProductScopePanel.this.unreverseProductLabelColor();
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "ProductScopePanel:Enter");
        this.getActionMap().put("ProductScopePanel:Enter", (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProductScopePanel.this.openDialog();
            }
        });
        this.fProductLabel.setToolTipText(resources.getString("ProductScopePanel.ScopeLabelTooltip"));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ProductScopePanel.this.reverseProductLabelColor();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ProductScopePanel.this.unreverseProductLabelColor();
            }
        });
    }

    private void reverseProductLabelColor() {
        this.fProductLabel.setForeground(Color.white);
        this.fProductLabel.revalidate();
        this.fProductLabel.repaint();
    }

    private void unreverseProductLabelColor() {
        this.fProductLabel.setForeground(TEXT_FORGROUND);
        this.fProductLabel.revalidate();
        this.fProductLabel.repaint();
    }

    private void openDialog() {
        this.setCursor(new Cursor(3));
        MLPrefsDialogServices.showPrefsDialog((String)sPrefRes.getString("area.help"));
        this.setCursor(new Cursor(0));
    }

    private void updateProductLabel() {
        String string = this.getProductLabelText();
        this.fProductLabel.setText(string);
        this.fProductLabel.setFont(this.fProductLabel.getFont().deriveFont(1));
        this.fProductLabel.setMinimumSize(new Dimension(0, this.fProductLabel.getMinimumSize().height));
        this.fProductLabel.revalidate();
        this.fProductLabel.repaint();
    }

    private String getProductLabelText() {
        boolean bl = HelpPrefs.isDocCenterProductFilterEnabled();
        ProductFilterStatus productFilterStatus = ProductScopePanel.isLocalDocProductAllSelected();
        if (!bl || productFilterStatus == ProductFilterStatus.ALL_SELECTED) {
            return this.getAllProductsText();
        }
        if (productFilterStatus == ProductFilterStatus.NON_SELECTED) {
            return this.getNoProductsText();
        }
        List list = FunctionReferenceUtils.getToplevelProductFunctionData();
        StringBuilder stringBuilder = new StringBuilder();
        for (FunctionReferenceUtils.FunctionProductData functionProductData : list) {
            if (!functionProductData.isSelected()) continue;
            stringBuilder.append(functionProductData.getProductName()).append(", ");
        }
        Object object = stringBuilder.toString();
        if (((String)object).length() > 2 && ((String)object).substring(((String)object).length() - 2).equals(", ")) {
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        return object;
    }

    static ProductFilterStatus isLocalDocProductAllSelected() {
        int n = 0;
        List list = FunctionReferenceUtils.getToplevelProductFunctionData();
        for (FunctionReferenceUtils.FunctionProductData functionProductData : list) {
            if (!functionProductData.isSelected()) continue;
            ++n;
        }
        if (list.size() == n) {
            return ProductFilterStatus.ALL_SELECTED;
        }
        if (n == 0) {
            return ProductFilterStatus.NON_SELECTED;
        }
        return ProductFilterStatus.PARTIAL_SELECTED;
    }

    private String getAllProductsText() {
        return resources.getString("ProductScopePanel.AllProducts");
    }

    private String getNoProductsText() {
        return resources.getString("ProductScopePanel.EmptyText");
    }

    void cleanup() {
        Prefs.removeListener((PrefListener)this.fProdFilterPrefListener);
    }

    static String[] getSelectedProductShortNames() {
        return ProductScopePanel.getInstalledProductShortNames(true);
    }

    static String[] getInstalledProductShortNames(boolean bl) {
        List list = FunctionReferenceUtils.getInstalledProductShortNames((boolean)bl);
        return list.toArray(new String[list.size()]);
    }

    private class ProductFilterPrefListener
    implements PrefListener {
        private ProductFilterPrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (FunctionBrowser.isInstanceShowing()) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProductScopePanel.this.updateProductLabel();
                        FunctionBrowser.update();
                    }
                });
            } else {
                FunctionBrowser.setProductFilterDirty(true);
            }
        }
    }

    public static enum ProductFilterStatus {
        ALL_SELECTED,
        NON_SELECTED,
        PARTIAL_SELECTED;

    }
}

