/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.ContentsTree;
import com.mathworks.mde.help.ContentsTreeUICallback;
import com.mathworks.mde.help.HelpNavigator;
import com.mathworks.mde.help.HelpNavigatorAction;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.help.ContentsData;
import com.mathworks.mlwidgets.help.ContentsDataEvent;
import com.mathworks.mlwidgets.help.ContentsDataListener;
import com.mathworks.mlwidgets.help.DemoInfoItem;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.HelpPanelSyncEvent;
import com.mathworks.mlwidgets.help.HelpSyncListener;
import com.mathworks.mlwidgets.help.HelpSynchronizer;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeUtils;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.PopupListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RectangularShape;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class Contents
extends MJPanel {
    private ContentsTree fTree;
    private MJScrollPane fScrolledTree;
    private ContentsUICallback fContentsUICallback;
    private ContentsHelpSyncListener fContentsHelpSyncListener;
    private HelpSynchronizer fHelpSynchronizer;
    private boolean fSyncToTag = false;

    public static void main(String[] stringArray) {
        Contents contents = new Contents();
        HelpUtils.placeComponentInFrame(contents);
    }

    Contents() {
        this.setLayout(new BorderLayout());
        this.setName("Help Contents");
        this.fContentsHelpSyncListener = new ContentsHelpSyncListener();
        this.fContentsUICallback = new ContentsUICallback();
    }

    private void initializeTree() {
        this.fTree = new ContentsTree(this.fContentsUICallback);
        this.fContentsUICallback.setTree(this.fTree);
        this.fTree.setHelpSynchronizer(this.fHelpSynchronizer);
        this.setFont(HelpNavigator.getNavigatorFont());
        this.setBackground(HelpNavigator.getBackgroundColor());
        this.setForeground(HelpNavigator.getTextColor());
        this.fTree.setName("Help Contents Tree");
        this.fTree.getAccessibleContext().setAccessibleName("Help table of contents");
        this.fTree.setRootVisible(false);
        this.fTree.setShowsRootHandles(ContentsData.isPopulated());
        this.fTree.setCellViewerEnabled(true);
        this.fTree.setMinimumRowHeight(18);
        this.fTree.getSelectionModel().setSelectionMode(1);
        ContentsRenderer contentsRenderer = new ContentsRenderer();
        this.fTree.setCellRenderer(contentsRenderer);
        this.fTree.addListeners();
        this.fTree.addMouseListener((MouseListener)((Object)new ContentsPopupListener()));
        this.fTree.addMouseListener(new ContentsMouseListener());
        this.fScrolledTree = new MJScrollPane((Component)((Object)this.fTree));
        SwingUtilities.invokeLater(new AddTreeToPanelThread());
    }

    void init() {
        if (this.fTree == null) {
            this.initializeTree();
        }
    }

    public void reset() {
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fTree != null) {
            this.fTree.setFont(font);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fTree != null) {
            this.fTree.setBackground(color);
            this.fTree.repaint();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fTree != null) {
            this.fTree.setForeground(color);
            this.fTree.repaint();
        }
    }

    void scrollToSelectedTreeNode() {
        if (this.fTree != null && this.fTree.getSelectionPath() != null && this.fScrolledTree != null) {
            HelpUtils.scrollToNode(this.fTree, this.fTree.getSelectionPath(), this.fScrolledTree.getViewport().getHeight());
        }
    }

    MJScrollPane getScrolledTree() {
        return this.fScrolledTree;
    }

    void setHelpSynchronizer(HelpSynchronizer helpSynchronizer) {
        assert (helpSynchronizer != null) : "setHelpSynchronizer must be called with non-null HelpSynchronizer.";
        this.fHelpSynchronizer = helpSynchronizer;
    }

    private void addHelpSyncListenerToHelpSynchronizer() {
        assert (this.fHelpSynchronizer != null) : "fHelpSynchronizer is null, cannot add HelpSyncListener.";
        assert (this.fContentsHelpSyncListener != null) : "fContentsHelpSyncListener is null, cannot add to HelpSynchronizer.";
        this.fHelpSynchronizer.addHelpSyncListener((HelpSyncListener)this.fContentsHelpSyncListener, true);
    }

    private void removeHelpSyncListenerFromHelpSynchronizer() {
        assert (this.fHelpSynchronizer != null) : "fHelpSynchronizer is null, cannot remove HelpSyncListener.";
        assert (this.fContentsHelpSyncListener != null) : "fContentsHelpSyncListener is null, cannot remove from HelpSynchronizer.";
        this.fHelpSynchronizer.removeHelpSyncListener((HelpSyncListener)this.fContentsHelpSyncListener);
    }

    void selectDemoItem(final DemoTreeItem demoTreeItem) {
        ContentsDataListener contentsDataListener = new ContentsDataListener(){

            public void contentsChanged(ContentsDataEvent contentsDataEvent) {
                if (contentsDataEvent.getType() == ContentsDataEvent.EventType.CONTENTS_POPULATED) {
                    ContentsData.loadProductNodeInfo((String)DemoInfoUtils.getDemoProductFullName((DemoInfoItem)demoTreeItem));
                    Contents.this.doSelectHelpTreeItem((HelpTreeItem)demoTreeItem);
                    ContentsData.removeContentsDataListener((ContentsDataListener)this);
                }
            }
        };
        ContentsData.addContentsDataListener((ContentsDataListener)contentsDataListener, (boolean)true);
    }

    private void doSelectHelpTreeItem(final HelpTreeItem helpTreeItem) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Contents.this.fHelpSynchronizer.syncToTreeNode(helpTreeItem.getTreeNode());
                Contents.this.fTree.showHelpTreeItemInBrowser(helpTreeItem);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public boolean requestFocusInWindow() {
        if (this.fTree != null) {
            return this.fTree.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private void setLoggingEnabled(boolean bl) {
        assert (this.fTree != null) : "ContentsTree is null. Cannot set LoggingEnabled.";
        this.fTree.setLoggingEnabled(bl);
    }

    void updateGlobalActions() {
        HelpNavigatorAction.COLLAPSE_ALL.updateUnderlyingAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Contents.this.fContentsUICallback.collapseTree();
            }

            @Override
            public boolean isEnabled() {
                TreeModel treeModel = Contents.this.fTree.getModel();
                return super.isEnabled() && Contents.this.fTree.getRowCount() > treeModel.getChildCount(treeModel.getRoot());
            }
        });
        HelpNavigatorAction.EXPAND_ALL.updateUnderlyingAction(null);
    }

    private class ContentsPopupListener
    extends PopupListener {
        private ContentsPopupListener() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            MJPopupMenu mJPopupMenu;
            TreeNode treeNode;
            HelpTreeItem helpTreeItem;
            Object object;
            TreePath treePath = Contents.this.fTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (treePath == null && n == 0 && n2 == 0) {
                treePath = Contents.this.fTree.getSelectionPath();
                object = Contents.this.fTree.getPathBounds(treePath);
                if (object != null) {
                    n = (int)Math.round(((RectangularShape)object).getCenterX());
                    n2 = (int)Math.round(((RectangularShape)object).getCenterY());
                }
            }
            if (treePath != null && (object = treePath.getLastPathComponent()) != null && object instanceof TreeNode && (helpTreeItem = HelpTreeUtils.getItemForTreeNode((TreeNode)(treeNode = (TreeNode)object))) != null && (mJPopupMenu = this.buildPopupMenuForItem(helpTreeItem)) != null) {
                mJPopupMenu.show((Component)((Object)Contents.this.fTree), n, n2);
            }
        }

        private MJPopupMenu buildPopupMenuForItem(HelpTreeItem helpTreeItem) {
            DemoTreeItem demoTreeItem;
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            MJMenuItem mJMenuItem = new MJMenuItem((Action)HelpNavigatorAction.COLLAPSE_ALL.getAction());
            mJMenuItem.setName("HelpCollapseAllMenuItem");
            mJPopupMenu.add((JMenuItem)mJMenuItem);
            if (Matlab.isMatlabAvailable()) {
                mJPopupMenu.addSeparator();
                demoTreeItem = new MJMenuItem((Action)new AbstractAction(HelpUtils.getLocalizedString((String)"action.RefreshDemos")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DemosData.reload();
                    }
                });
                demoTreeItem.setName("HelpRefreshDemosMenuItem");
                mJPopupMenu.add((JMenuItem)demoTreeItem);
            }
            if (helpTreeItem instanceof DemoTreeItem) {
                demoTreeItem = (DemoTreeItem)helpTreeItem;
                MJMenuItem mJMenuItem2 = new MJMenuItem((Action)new AbstractAction(HelpUtils.getLocalizedString((String)"action.EditSource")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MLEditorServices.getEditorApplication().openEditor(new File(demoTreeItem.getXmlFilename()));
                            }
                        });
                    }
                });
                mJMenuItem2.setName("HelpEditDemosMenuItem");
                mJPopupMenu.add((JMenuItem)mJMenuItem2);
            }
            return mJPopupMenu;
        }
    }

    private class ContentsMouseListener
    extends MouseAdapter {
        private HelpTreeItem iShowIfNotPopup;

        private ContentsMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.iShowIfNotPopup = null;
            if (!mouseEvent.isPopupTrigger()) {
                int n = Contents.this.fTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (Contents.this.fTree.isRowSelected(n) && Contents.this.fSyncToTag) {
                    this.iShowIfNotPopup = (HelpTreeItem)Contents.this.fTree.getSelectionPath().getLastPathComponent();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() && this.iShowIfNotPopup != null) {
                Contents.this.fTree.showHelpTreeItemInBrowser(this.iShowIfNotPopup);
            }
            this.iShowIfNotPopup = null;
        }
    }

    private class ContentsUICallback
    extends ContentsTreeUICallback {
        private ContentsUICallback() {
        }

        @Override
        public void updateAfterTreeCleared() {
            this.getTree().setShowsRootHandles(false);
            Contents.this.removeHelpSyncListenerFromHelpSynchronizer();
        }

        @Override
        public void updateAfterTreePopulated() {
            this.getTree().setShowsRootHandles(true);
            Contents.this.addHelpSyncListenerToHelpSynchronizer();
        }

        @Override
        public void updateAfterTreeSelectionChanged(TreePath treePath) {
            if (Contents.this.isShowing()) {
                Contents.this.scrollToSelectedTreeNode();
            }
        }

        @Override
        public void updateForSelectFirstProduct() {
            if (Contents.this.getScrolledTree() != null) {
                Contents.this.getScrolledTree().getVerticalScrollBar().setValue(0);
            }
        }

        public void syncToHelpPanelSyncEvent(HelpPanelSyncEvent helpPanelSyncEvent) {
            if (helpPanelSyncEvent == null) {
                return;
            }
            Contents.this.fSyncToTag = helpPanelSyncEvent.isSynchToTag();
            if (helpPanelSyncEvent.isContentsItem()) {
                this.getTree().syncTocToItem(helpPanelSyncEvent.getHelpTreeItem());
            } else if (helpPanelSyncEvent.isOtherItem()) {
                this.getTree().clearSelection();
                this.getTree().setCurrentItem(null);
            } else if (helpPanelSyncEvent.isHelpOpened()) {
                if (this.getTree() != null) {
                    this.collapseTree();
                }
            } else if (helpPanelSyncEvent.isHelpOpenedSelectFirstProduct()) {
                if (this.getTree() != null) {
                    this.collapseTree();
                    this.getTree().selectFirstProduct();
                }
            } else if (helpPanelSyncEvent.isSelectFirstProduct()) {
                if (this.getTree() != null) {
                    this.getTree().selectFirstProduct();
                }
            } else if (helpPanelSyncEvent.isResetTOC() && this.getTree() != null) {
                this.getTree().clearSelection();
                this.getTree().setCurrentItem(null);
            }
        }
    }

    private static class ContentsRenderer
    extends DefaultTreeCellRenderer {
        private ContentsRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            HelpTreeItem helpTreeItem = HelpTreeUtils.getItemForTreeNode((TreeNode)((TreeNode)object));
            if (helpTreeItem != null) {
                String string = helpTreeItem.getLabel();
                Icon icon = helpTreeItem.getIcon();
                this.setText(string);
                this.setIcon(icon);
                this.setToolTipText(null);
                this.setOpaque(!bl);
                if (!bl) {
                    this.setForeground(HelpNavigator.getTextColor());
                    this.setBackground(HelpNavigator.getBackgroundColor());
                }
            }
            return this;
        }
    }

    private class ContentsHelpSyncListener
    implements HelpSyncListener {
        private ContentsHelpSyncListener() {
        }

        public void syncToHelpPanelSyncEvent(HelpPanelSyncEvent helpPanelSyncEvent) {
            Contents.this.fContentsUICallback.syncToHelpPanelSyncEvent(helpPanelSyncEvent);
        }
    }

    private class AddTreeToPanelThread
    implements Runnable {
        private AddTreeToPanelThread() {
        }

        @Override
        public void run() {
            Contents.this.add((Component)Contents.this.fScrolledTree, "Center");
            Contents.this.validate();
        }
    }
}

