/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.mde.help.ContentsTreeUICallbackProvider;
import com.mathworks.mde.help.DemoPageBuilder;
import com.mathworks.mde.help.DemoUtils;
import com.mathworks.mde.help.HelpBrowser;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlwidgets.help.ClassicHelpDataAccessor;
import com.mathworks.mlwidgets.help.ContentsData;
import com.mathworks.mlwidgets.help.ContentsDataEvent;
import com.mathworks.mlwidgets.help.ContentsDataListener;
import com.mathworks.mlwidgets.help.ContentsItem;
import com.mathworks.mlwidgets.help.DemoInfoItem;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpSynchronizer;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeItemVisitor;
import com.mathworks.mlwidgets.help.HelpTreeUtils;
import com.mathworks.mlwidgets.help.ProductHelpTreeItem;
import com.mathworks.mlwidgets.help.ReferenceItem;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.TreeUtils;
import java.awt.Component;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ContentsTree
extends MJTree {
    private DefaultTreeModel fModel;
    private ContentsTreeListener fTreeListener;
    private HelpSynchronizer fHelpSynchronizer;
    private ContentsTreeUICallbackProvider fUICallback;
    private HelpTreeItem fCurrentItem = null;
    private boolean fCollapsing = false;
    private boolean fLoggingEnabled = false;

    public ContentsTree(ContentsTreeUICallbackProvider contentsTreeUICallbackProvider) {
        assert (contentsTreeUICallbackProvider != null) : "ContentsTree must be instantiated with non-null ContentsTreeUICallbackProvider.";
        this.fUICallback = contentsTreeUICallbackProvider;
        this.fModel = new ContentsTreeModel(ContentsData.getRootNode());
        this.setModel(this.fModel);
    }

    public void addListeners() {
        this.fTreeListener = new ContentsTreeListener();
        this.addTreeSelectionListener(this.fTreeListener);
        this.addTreeExpansionListener(this.fTreeListener);
        ContentsData.addContentsDataListener((ContentsDataListener)new ContentsTreeDataListener(), (boolean)true);
    }

    public void setCollapsing(boolean bl) {
        this.fCollapsing = bl;
    }

    private void setSyncPath(TreePath treePath) {
        this.fTreeListener.setSyncPath(treePath);
    }

    private void afterCleared() {
        this.fUICallback.updateAfterTreeCleared();
        this.clearSelection();
        this.setCurrentItem(null);
        this.reload();
    }

    private void afterPopulated() {
        this.reload();
        this.fUICallback.updateAfterTreePopulated();
    }

    private void handleAddedNodes(ContentsDataEvent contentsDataEvent) {
        this.fModel.nodesWereInserted(contentsDataEvent.getModifiedParent(), contentsDataEvent.getModifiedIndicies());
    }

    private void handleRemovedNodes(ContentsDataEvent contentsDataEvent) {
        boolean bl = false;
        TreePath treePath = this.getSelectionPath();
        for (HelpTreeItem helpTreeItem : contentsDataEvent.getModifiedChildren()) {
            TreePath treePath2 = TreeUtils.nodeToPath((TreeNode)helpTreeItem.getTreeNode());
            if (!treePath2.isDescendant(treePath)) continue;
            bl = true;
        }
        this.fModel.nodesWereRemoved(contentsDataEvent.getModifiedParent(), contentsDataEvent.getModifiedIndicies(), contentsDataEvent.getModifiedChildren());
        if (bl) {
            this.setSelectionPath(new TreePath(this.fModel.getRoot()));
        }
    }

    private void afterSelectionChanged(TreePath treePath) {
        this.fUICallback.updateAfterTreeSelectionChanged(treePath);
    }

    private void reload() {
        this.fModel.reload();
    }

    public void setHelpSynchronizer(HelpSynchronizer helpSynchronizer) {
        this.fHelpSynchronizer = helpSynchronizer;
    }

    public void setCurrentItem(HelpTreeItem helpTreeItem) {
        this.fCurrentItem = helpTreeItem;
    }

    public void setLoggingEnabled(boolean bl) {
        this.fLoggingEnabled = bl;
    }

    private void helpSynchronizerSyncToTreeNode(TreeNode treeNode) {
        if (this.fHelpSynchronizer != null && treeNode != null) {
            this.fHelpSynchronizer.syncToTreeNode(treeNode);
        }
    }

    void syncTocToItem(HelpTreeItem helpTreeItem) {
        if (helpTreeItem != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.syncTocToItemMethod(helpTreeItem);
            } else {
                SwingUtilities.invokeLater(new SyncTocToItemThread(helpTreeItem));
            }
        }
    }

    private void syncTocToItemMethod(HelpTreeItem helpTreeItem) {
        if (this.fCurrentItem == null || !this.fCurrentItem.equals(helpTreeItem)) {
            TreePath treePath;
            if (this.fLoggingEnabled) {
                System.out.println("In SyncTocToItemThread.run(), sync to item.");
            }
            if (TreeUtils.pathExists((TreeModel)this.fModel, (TreePath)(treePath = TreeUtils.nodeToPath((TreeNode)helpTreeItem.getTreeNode()))) && !HelpUtils.isSelectedPath(this, treePath)) {
                try {
                    this.setSyncPath(treePath);
                    this.setSelectionPath(treePath);
                    this.afterSelectionChanged(treePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.fCurrentItem = helpTreeItem;
    }

    public void selectFirstProduct() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.selectFirstProductMethod();
        } else {
            SwingUtilities.invokeLater(new SelectFirstProductThread());
        }
    }

    private void selectFirstProductMethod() {
        if (ContentsData.isPopulated()) {
            if (this.fLoggingEnabled) {
                System.out.println("In selectFirstProductMethod(), ContentsData is populated.");
            }
            this.fUICallback.updateForSelectFirstProduct();
            HelpTreeItem helpTreeItem = ContentsData.getFirstProductOrDemo();
            if (helpTreeItem != null) {
                TreePath treePath = TreeUtils.nodeToPath((TreeNode)helpTreeItem.getTreeNode());
                if (HelpUtils.isSelectedPath(this, treePath)) {
                    this.showHelpTreeItemInBrowser(helpTreeItem);
                } else if (TreeUtils.pathExists((TreeModel)this.fModel, (TreePath)treePath)) {
                    this.setSelectionPath(treePath);
                } else {
                    this.selectFirstRow();
                }
            } else {
                this.selectFirstRow();
            }
        } else if (this.fLoggingEnabled) {
            System.out.println("In selectFirstProductMethod(), ContentsData isn't populated.");
        }
    }

    private void selectFirstRow() {
        if (this.isRowSelected(0)) {
            TreePath treePath = this.getPathForRow(0);
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            HelpTreeItem helpTreeItem = HelpTreeUtils.getItemForTreeNode((TreeNode)treeNode);
            this.showHelpTreeItemInBrowser(helpTreeItem);
        } else {
            this.setSelectionRow(0);
        }
    }

    void showHelpTreeItemInBrowser(HelpTreeItem helpTreeItem) {
        helpTreeItem.accept((HelpTreeItemVisitor)new ShowHelpTreeItemVisitor());
    }

    private void showContentsItemInBrowser(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (string == null || string.length() == 0 || string2.startsWith("http:")) {
            HelpBrowser.setCurrentLocation(string2, false);
        } else if (ContentsTree.isAnchorOnCurrentPage(string, string2)) {
            HelpBrowser.showHelpPageForFullProductName(string, string2, false);
        } else if (string2.startsWith("file:")) {
            int n;
            boolean bl = false;
            int n2 = 5;
            HelpInfoItem[] helpInfoItemArray = ClassicHelpDataAccessor.getInstalledProductHelpInfo();
            String string3 = HelpInfo.getProductShortName((String)string);
            while (!bl && n2 < string2.length() && (n = string2.indexOf(47, n2)) >= 0) {
                String string4;
                if (n > 0 && !(string4 = string2.substring(n2, n)).equals("..")) {
                    for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
                        if (!helpInfoItem.getShortName().equals(string4)) continue;
                        string3 = string4;
                        string2 = string2.substring(n + 1);
                        bl = true;
                        break;
                    }
                }
                n2 = n + 1;
            }
            HelpBrowser.showHelpPage(string3, string2, false);
            if (!bl && this.fLoggingEnabled) {
                System.out.println("In showContentsItemInBrowser(ContentsItem), file not found.");
            }
        } else {
            HelpBrowser.showHelpPageForFullProductName(string, string2, false);
        }
    }

    private static boolean isAnchorOnCurrentPage(String string, String string2) {
        String string3 = HelpBrowser.getCurrentLocation();
        if (string3 != null) {
            String string4 = HelpInfo.getPrefixForProductName((String)string) + string2;
            string4 = HTMLUtils.getFilenameFromURL((String)string4);
            return string3.startsWith(string4);
        }
        return false;
    }

    private class ShowHelpTreeItemVisitor
    implements HelpTreeItemVisitor {
        private ShowHelpTreeItemVisitor() {
        }

        public void visit(ProductHelpTreeItem productHelpTreeItem) {
            ContentsTree.this.showContentsItemInBrowser(productHelpTreeItem.getProduct(), productHelpTreeItem.getFilename());
        }

        public void visit(ContentsItem contentsItem) {
            ContentsTree.this.showContentsItemInBrowser(contentsItem.getProduct(), contentsItem.getFilename());
        }

        public void visit(DemoTreeItem demoTreeItem) {
            boolean bl = false;
            if (demoTreeItem.isLeaf()) {
                bl = DemoUtils.displayDemo((DemoInfoItem)demoTreeItem, demoTreeItem.getCallback(), (Component)((Object)ContentsTree.this));
            }
            if (!bl) {
                String string = demoTreeItem.getFilename();
                String string2 = demoTreeItem.getXmlFilename();
                if (this.isNotEmpty(string)) {
                    HelpBrowser.setCurrentLocation(string, false);
                } else if (this.isNotEmpty(string2)) {
                    String string3 = DemoPageBuilder.createIndexFromXml(demoTreeItem);
                    if (string3 != null) {
                        HelpBrowser.setHtmlText(string3);
                    }
                } else {
                    HelpBrowser.setHtmlText(demoTreeItem.getTextDescription());
                }
                if (HelpTreeUtils.isValidTreeNode((TreeNode)demoTreeItem.getTreeNode())) {
                    HelpBrowser.setCurrentDemoId(DemoInfoUtils.getIdentifierForTreeNode((DemoTreeItem)demoTreeItem));
                }
            }
        }

        public void visit(ReferenceItem referenceItem) {
            ContentsTree.this.showContentsItemInBrowser(referenceItem.getProduct(), referenceItem.getFilename());
        }

        private boolean isEmptyOrNull(String string) {
            return string == null || string.length() == 0;
        }

        private boolean isNotEmpty(String string) {
            return !this.isEmptyOrNull(string);
        }
    }

    private class SelectFirstProductThread
    implements Runnable {
        private SelectFirstProductThread() {
        }

        @Override
        public void run() {
            ContentsTree.this.selectFirstProductMethod();
        }
    }

    private class SyncTocToItemThread
    implements Runnable {
        private HelpTreeItem fItem;

        private SyncTocToItemThread(HelpTreeItem helpTreeItem) {
            this.fItem = helpTreeItem;
        }

        @Override
        public void run() {
            ContentsTree.this.syncTocToItemMethod(this.fItem);
        }
    }

    private class ContentsTreeDataListener
    implements ContentsDataListener {
        private ContentsTreeDataListener() {
        }

        public void contentsChanged(ContentsDataEvent contentsDataEvent) {
            switch (contentsDataEvent.getType()) {
                case CONTENTS_POPULATED: {
                    ContentsTree.this.afterPopulated();
                    break;
                }
                case CONTENTS_CLEARED: {
                    ContentsTree.this.afterCleared();
                    break;
                }
                case NODES_ADDED: {
                    ContentsTree.this.handleAddedNodes(contentsDataEvent);
                    break;
                }
                case NODES_REMOVED: {
                    ContentsTree.this.handleRemovedNodes(contentsDataEvent);
                }
            }
        }
    }

    private class ContentsTreeListener
    implements TreeSelectionListener,
    TreeExpansionListener {
        private TreePath iSyncPath;
        private HelpTreeItem iExpandingForSync;

        private ContentsTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (ContentsTree.this.fCollapsing) {
                return;
            }
            TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
            if (treePath == null) {
                return;
            }
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (this.iSyncPath == null || !this.iSyncPath.equals(treePath)) {
                ContentsTree.this.helpSynchronizerSyncToTreeNode(treeNode);
                HelpTreeItem helpTreeItem = HelpTreeUtils.getItemForTreeNode((TreeNode)treeNode);
                if (helpTreeItem != null) {
                    ContentsTree.this.showHelpTreeItemInBrowser(helpTreeItem);
                }
                this.iSyncPath = null;
            } else if (this.iSyncPath.equals(treePath)) {
                TreePath treePath2 = treeNode.isLeaf() ? treePath.getParentPath() : treePath;
                this.iExpandingForSync = ContentsTree.this.isExpanded(treePath2) ? null : HelpTreeUtils.getItemForTreeNode((TreeNode)((TreeNode)treePath2.getLastPathComponent()));
                this.iSyncPath = null;
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreeNode treeNode;
            HelpTreeItem helpTreeItem;
            TreePath treePath = treeExpansionEvent.getPath();
            if (this.iSyncPath == null && this.iExpandingForSync == null) {
                ContentsTree.this.setSelectionPath(treePath);
            } else if (this.iExpandingForSync != null && (helpTreeItem = HelpTreeUtils.getItemForTreeNode((TreeNode)(treeNode = (TreeNode)treePath.getLastPathComponent()))).equals(this.iExpandingForSync)) {
                this.iExpandingForSync = null;
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            TreePath treePath2 = ContentsTree.this.getSelectionPath();
            if (treePath2 == null || !treePath.isDescendant(treePath2)) {
                ContentsTree.this.setSelectionPath(treePath);
            }
        }

        private void setSyncPath(TreePath treePath) {
            this.iSyncPath = treePath;
        }
    }

    private static class ContentsTreeModel
    extends DefaultTreeModel {
        private static final ContentsItem LOADING_ITEM = ContentsItem.getDummyItem((TreeNode)ContentsData.getRootNode(), (String)HelpUtils.getLocalizedString((String)"contents.loading"), null);

        private ContentsTreeModel(TreeNode treeNode) {
            super(treeNode);
        }

        @Override
        public Object getChild(Object object, int n) {
            TreeNode treeNode = (TreeNode)object;
            if (treeNode.equals(ContentsData.getRootNode()) && !ContentsData.isPopulated()) {
                return LOADING_ITEM;
            }
            return super.getChild(object, n);
        }

        @Override
        public int getChildCount(Object object) {
            TreeNode treeNode = (TreeNode)object;
            if (treeNode.equals(ContentsData.getRootNode()) && !ContentsData.isPopulated()) {
                return 1;
            }
            return super.getChildCount(object);
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            TreeNode treeNode = (TreeNode)object;
            if (treeNode.equals(ContentsData.getRootNode()) && !ContentsData.isPopulated()) {
                if (object2.equals(LOADING_ITEM)) {
                    return 0;
                }
                return -1;
            }
            return super.getIndexOfChild(object, object2);
        }
    }
}

