/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.help.helpui.DocConfig;
import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.SearchExpressionFilter;
import com.mathworks.helpsearch.product.DocCenterItemResolver;
import com.mathworks.helpsearch.product.DocSetItemResolver;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductFilter;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.SearchEngineSuggestionProvider;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.suggestion.FullSuggestionRequest;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchField;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.util.Disposable;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.SearchTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class DocCenterBrowserSearchBox
implements ComponentBuilder {
    private static final int SUGGESTION_POPUP_WIDTH = 450;
    private static final int MAX_PER_GROUP = 5;
    private final JComponent fComponent;
    private final SearchTextField fSearchTextField;
    private PopupList fPopupList;

    public DocCenterBrowserSearchBox() {
        String string = HelpUtils.getLocalizedString((String)"doccenter.web.search");
        this.fSearchTextField = new SearchTextField(string);
        Font font = this.fSearchTextField.getComponent().getFont();
        FontMetrics fontMetrics = this.fSearchTextField.getComponent().getFontMetrics(font);
        this.fSearchTextField.addSearchTextFieldListener((SearchTextField.Listener)new SearchActionListener());
        this.fSearchTextField.getComponent().setName("SearchField");
        this.fSearchTextField.enableFocusRelinquishing();
        int n = DocCenterBrowserSearchBox.computePanelWidth(string, fontMetrics);
        this.fComponent = new SearchPanel(n);
        this.fComponent.putClientProperty("mwjavaguitest.instance", this);
        this.fComponent.setName("SearchComponent");
        this.fComponent.setLayout(new BorderLayout());
        this.fComponent.setOpaque(false);
        this.fPopupList = new PopupList(new DefaultListModel()){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.fPopupList.setName("SuggestionPopupList");
        this.fPopupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                ListItem listItem = listActionEvent.getListItem();
                Action action = (Action)listItem.getAttributes().getAttribute(TSFactory.ACTION_ATTRIBUTE);
                if (action != null) {
                    DocCenterBrowserSearchBox.this.hideSuggestionPopup();
                    action.actionPerformed((ActionEvent)listActionEvent);
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DocCenterBrowserSearchBox.this.isSuggestionPopupVisible()) {
                    DocCenterBrowserSearchBox.this.updateModel(DocCenterBrowserSearchBox.this.fSearchTextField.getSearchText());
                } else {
                    DocCenterBrowserSearchBox.this.fPopupList.requestFocus();
                    DocCenterBrowserSearchBox.this.fPopupList.setSelectedIndex(1);
                    DocCenterBrowserSearchBox.this.fPopupList.repaint();
                }
            }
        };
        String string2 = "DOWN";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        this.fSearchTextField.getComponent().getInputMap().put(keyStroke, "none");
        this.fComponent.getInputMap(1).put(keyStroke, string2);
        this.fComponent.getActionMap().put(string2, abstractAction);
        this.fComponent.setLayout(new BorderLayout());
        this.fComponent.add((Component)this.fSearchTextField.getComponent(), "Center");
        this.fComponent.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    private static int computePanelWidth(String string, FontMetrics fontMetrics) {
        int n = 0;
        if (string != null && fontMetrics != null) {
            n = SwingUtilities.computeStringWidth(fontMetrics, string) + 32;
        }
        int n2 = 198;
        return Math.max(n2, n);
    }

    protected static DocConfig getDocConfig() {
        return DocCenterDocConfig.getInstance();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public static DocumentationSuggestionProvider getSuggestionProvider() throws IOException {
        DocConfig docConfig = DocCenterBrowserSearchBox.getDocConfig();
        SearchConfig searchConfig = docConfig.getSearchConfig();
        DocumentationSet documentationSet = docConfig.getDocumentationSet();
        SearchEngine searchEngine = DocSearchEngineFactory.createSearchEngine((SearchConfig)searchConfig, (DocumentationSet)documentationSet);
        ProductFilter productFilter = docConfig.getProductFilter();
        DocCenterItemResolver docCenterItemResolver = new DocCenterItemResolver(documentationSet);
        return new SearchEngineSuggestionProvider(searchEngine, (SearchField)DocumentationSearchField.BODY, (DocSetItemResolver)docCenterItemResolver, (SearchExpressionFilter)productFilter);
    }

    public static Collection<InformationType> getTypesToSuggest() {
        return EnumSet.of(InformationType.FUNCTIONS, InformationType.SYSTEM_OBJECTS);
    }

    public void updateModel(final String string) {
        try {
            DefaultListModel defaultListModel;
            if (string.length() > 1) {
                FullSuggestionRequest fullSuggestionRequest = new FullSuggestionRequest(DocCenterBrowserSearchBox.getSuggestionProvider(), DocCenterBrowserSearchBox.getTypesToSuggest(), string, 5);
                defaultListModel = fullSuggestionRequest.getModel();
            } else {
                defaultListModel = new DefaultListModel();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DocCenterBrowserSearchBox.this.fSearchTextField.getSearchText().equals(string)) {
                        DocCenterBrowserSearchBox.this.fPopupList.setModel((ListModel)defaultListModel);
                        if (defaultListModel.isEmpty()) {
                            DocCenterBrowserSearchBox.this.hideSuggestionPopup();
                        } else {
                            DocCenterBrowserSearchBox.this.showSuggestionPopup();
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void hideSuggestionPopup() {
        if (!this.isSuggestionPopupVisible()) {
            Disposable disposable = (Disposable)this.fComponent.getClientProperty("PopupComponent");
            disposable.dispose();
            this.fSearchTextField.requestFocus();
            this.fComponent.putClientProperty("PopupComponent", null);
        }
    }

    private void showSuggestionPopup() {
        this.fPopupList.setFocusable(false);
        this.resetSuggestionPopupSize();
        if (this.isSuggestionPopupVisible()) {
            Overlay overlay = ToolstripSections.showPopup((JComponent)this.fComponent, (JComponent)this.fPopupList);
            this.fComponent.putClientProperty("PopupComponent", overlay);
        } else {
            OverlayManager overlayManager = OverlayManagers.get((Component)this.fPopupList);
            overlayManager.packOverlay((Component)this.fPopupList);
        }
        this.fPopupList.setFocusable(true);
    }

    public boolean isSuggestionPopupVisible() {
        Overlay overlay = (Overlay)this.fComponent.getClientProperty("PopupComponent");
        return overlay == null;
    }

    private void resetSuggestionPopupSize() {
        this.fPopupList.setPreferredSize(null);
        Dimension dimension = this.fPopupList.getPreferredSize();
        dimension.width = 450;
        this.fPopupList.setPreferredSize(dimension);
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.getText())) {
            this.fSearchTextField.setSearchText(string);
        }
    }

    public String getText() {
        return this.fSearchTextField.getSearchText();
    }

    private class SearchPanel
    extends MJPanel {
        private final int iPreferredWidth;

        private SearchPanel(int n) {
            this.iPreferredWidth = n;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = DocCenterBrowserSearchBox.this.fSearchTextField.getComponent().getPreferredSize();
            return new Dimension(this.iPreferredWidth, (int)dimension.getHeight());
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public boolean requestFocusInWindow() {
            DocCenterBrowserSearchBox.this.fSearchTextField.requestFocus();
            return true;
        }

        public boolean isFocusOwner() {
            return true;
        }
    }

    private class SearchActionListener
    implements SearchTextField.Listener {
        private SearchActionListener() {
        }

        public void search(String string) {
            if (string != null && !string.isEmpty()) {
                String string2 = DocCenterUtils.buildDocCenterSearchUrl((String)string);
                DocCenterBrowserSearchBox.this.hideSuggestionPopup();
                MLHelpServices.setCurrentLocation((String)string2);
            }
        }

        public void searchTextChanged(final String string) {
            new Thread("DocCenterBrowserSearchBox"){

                @Override
                public void run() {
                    DocCenterBrowserSearchBox.this.updateModel(string);
                }
            }.start();
        }

        public void searchCleared() {
        }
    }
}

