/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.controller;

import com.mathworks.mde.licensing.borrowing.controller.BorrowController;
import com.mathworks.mde.licensing.borrowing.model.BorrowManager;
import com.mathworks.mde.licensing.borrowing.model.EventDispatchThreadCallback;
import com.mathworks.mde.licensing.borrowing.model.Feature;
import com.mathworks.mde.licensing.borrowing.view.AutoBorrowStatusLabel;
import com.mathworks.mde.licensing.borrowing.view.AutoBorrowView;
import com.mathworks.mde.licensing.borrowing.view.BorrowView;
import com.mathworks.mde.licensing.borrowing.view.FailedFeature;
import com.mathworks.mde.licensing.borrowing.view.MainView;
import com.mathworks.mde.licensing.borrowing.view.ReturnView;
import com.mathworks.mde.licensing.borrowing.view.SelectedOption;
import com.mathworks.mde.licensing.borrowing.view.StatusView;
import com.mathworks.mde.licensing.borrowing.view.ViewFactory;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class BorrowControllerImpl
implements BorrowController {
    private final ViewFactory fViewFactory;
    private BorrowManager fBorrowMgr;
    private final MainView fMainView;
    private final AutoBorrowStatusLabel fStatusLabel;
    private AutoBorrowView fAutoBorrowView;
    private BorrowView fBorrowView;
    private ReturnView fReturnView;
    private StatusView fStatusView;
    private Collection<Feature> flexFeatureList;
    private ResourceBundle fResBundle;
    private SelectedOption fOptionInView;

    public BorrowControllerImpl(ViewFactory viewFactory, BorrowManager borrowManager) {
        this.fBorrowMgr = borrowManager;
        this.fViewFactory = viewFactory;
        this.fResBundle = ResourceBundle.getBundle("com.mathworks.mde.licensing.borrowing.resources.RES_Borrow");
        this.fMainView = this.fViewFactory.createMainView(this, this.fResBundle);
        this.fStatusLabel = this.fViewFactory.createAutoBorrowStatusLabel(this.fResBundle);
    }

    @Override
    public Collection<Feature> getFlexFeatures() {
        if (this.flexFeatureList == null) {
            this.flexFeatureList = this.fBorrowMgr.getFeatureList();
        }
        return new ArrayList<Feature>(this.flexFeatureList);
    }

    @Override
    public void setAutoBorrowSelected() {
        this.fOptionInView = SelectedOption.AUTO_BORROW;
        if (this.fAutoBorrowView == null) {
            this.fAutoBorrowView = this.fViewFactory.createAutoBorrowView(this, this.fResBundle);
        }
        this.fMainView.createSubPanel(this.fAutoBorrowView);
    }

    @Override
    public void setBorrowProductSelected() {
        this.fOptionInView = SelectedOption.BY_PRODUCT;
        if (this.fBorrowView == null) {
            this.fBorrowView = this.fViewFactory.createBorrowView(this, this.fResBundle);
        }
        this.fMainView.createSubPanel(this.fBorrowView);
    }

    @Override
    public void setReturnProductSelected() {
        this.fOptionInView = SelectedOption.RETURN_PRODUCT;
        if (this.fReturnView == null) {
            this.fReturnView = this.fViewFactory.createReturnView(this, this.fResBundle);
        }
        if (this.fBorrowMgr.isEarlyReturnAllowed()) {
            this.fMainView.createSubPanel(this.fReturnView);
        } else {
            this.fMainView.showMessageDialog(this.fResBundle.getString("return.samesession.info"), this.fResBundle.getString("return.samesession.title"));
            this.fMainView.showInitialView();
        }
    }

    @Override
    public void setStatusViewSelection() {
        if (this.fStatusView == null) {
            this.fStatusView = this.fViewFactory.createStatusView(this, this.fResBundle);
        }
        this.fMainView.createSubPanel(this.fStatusView);
    }

    @Override
    public void borrowableFeatureSelected(boolean bl) {
        if (bl) {
            this.fBorrowView.enableBorrowButton();
        } else {
            Collection<Feature> collection = this.fBorrowView.getSelectedFeatures();
            if (collection.isEmpty()) {
                this.fBorrowView.disableBorrowButton();
            } else {
                this.fBorrowView.enableBorrowButton();
            }
        }
    }

    @Override
    public void returnFeatureSelected(boolean bl) {
        if (bl) {
            this.fReturnView.enableReturnButton();
        } else {
            Collection<Feature> collection = this.fReturnView.getSelectedFeatures();
            if (collection.isEmpty()) {
                this.fReturnView.disableReturnButton();
            } else {
                this.fReturnView.enableReturnButton();
            }
        }
    }

    @Override
    public void updateRadioButtonStatus() {
        this.fMainView.disableReturnRadioButton();
        this.fMainView.disableAutoBorrowRadioButton();
        this.fMainView.disableBorrowFeatureRadioButton();
        for (Feature feature : this.flexFeatureList) {
            if (!feature.isBorrowed()) continue;
            this.fMainView.enableReturnRadioButton();
            break;
        }
        for (Feature feature : this.flexFeatureList) {
            if (!feature.canBorrow()) continue;
            this.fMainView.enableAutoBorrowRadioButton();
            this.fMainView.enableBorrowFeatureRadioButton();
            break;
        }
    }

    @Override
    public void performBorrowAction() {
        this.fMainView.disableAutoBorrowRadioButton();
        Collection<Feature> collection = this.fBorrowView.getSelectedFeatures();
        int n = this.fBorrowView.getNumDaysSelected();
        if (n <= 0) {
            this.fBorrowView.disableBorrowButton();
            this.fMainView.showMessageDialog(this.fResBundle.getString("date.error"), this.fResBundle.getString("date.error.title"));
            this.fMainView.showInitialView();
        } else {
            final ArrayList<FailedFeature> arrayList = new ArrayList<FailedFeature>();
            this.fBorrowMgr.borrowFeatures(n, collection, arrayList, new EventDispatchThreadCallback(){

                @Override
                public void runOnAWTEventDispatchThread(Object object) {
                    BorrowControllerImpl.this.flexFeatureList = BorrowControllerImpl.this.fBorrowMgr.getFeatureList();
                    BorrowControllerImpl.this.updateRadioButtonStatus();
                    BorrowControllerImpl.this.fMainView.enableAutoBorrowRadioButton();
                    if (arrayList.isEmpty()) {
                        BorrowControllerImpl.this.fMainView.showMessageDialog(BorrowControllerImpl.this.fResBundle.getString("borrow.success.msg"), BorrowControllerImpl.this.fResBundle.getString("borrow.status.title"));
                    } else {
                        BorrowControllerImpl.this.showErrorDialog(arrayList);
                    }
                    BorrowControllerImpl.this.fMainView.showInitialView();
                }
            });
        }
    }

    @Override
    public void performReturnAction() {
        final ArrayList<FailedFeature> arrayList = new ArrayList<FailedFeature>();
        Collection<Feature> collection = this.fReturnView.getSelectedFeatures();
        this.fBorrowMgr.returnFeatures(collection, arrayList, new EventDispatchThreadCallback(){

            @Override
            public void runOnAWTEventDispatchThread(Object object) {
                BorrowControllerImpl.this.flexFeatureList = BorrowControllerImpl.this.fBorrowMgr.getFeatureList();
                BorrowControllerImpl.this.updateRadioButtonStatus();
                if (arrayList.isEmpty()) {
                    BorrowControllerImpl.this.fMainView.showMessageDialog(BorrowControllerImpl.this.fResBundle.getString("return.success.msg"), BorrowControllerImpl.this.fResBundle.getString("return.status.title"));
                } else {
                    BorrowControllerImpl.this.showErrorDialog(arrayList);
                }
                BorrowControllerImpl.this.fMainView.showInitialView();
            }
        });
    }

    @Override
    public void turnBorrowModeOn() {
        this.fMainView.disableBorrowFeatureRadioButton();
        this.fMainView.disableReturnRadioButton();
        this.fAutoBorrowView.disableOnButton();
        this.fAutoBorrowView.enableOffButton();
        this.fAutoBorrowView.showInfoPanel();
        this.fAutoBorrowView.disableDaysSpinner();
        int n = this.fAutoBorrowView.getNumDaysSelected();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Feature feature : this.flexFeatureList) {
            if (!feature.isLicenseInUse() || !feature.isFeatureBorrowDisabled()) continue;
            arrayList.add(feature.getProductName());
        }
        if (arrayList.isEmpty()) {
            if (n <= 0) {
                this.fMainView.showMessageDialog(this.fResBundle.getString("date.error"), this.fResBundle.getString("date.error.title"));
                this.fMainView.showInitialView();
            } else {
                final ArrayList arrayList2 = new ArrayList();
                this.fBorrowMgr.turnAutoBorrowOn(n, arrayList2, new EventDispatchThreadCallback(){

                    @Override
                    public void runOnAWTEventDispatchThread(Object object) {
                        if (!arrayList2.isEmpty()) {
                            BorrowControllerImpl.this.showErrorDialog(arrayList2);
                            BorrowControllerImpl.this.updateAutoBorrowView();
                        } else {
                            BorrowControllerImpl.this.fStatusLabel.setAutoModeOn();
                        }
                    }
                });
            }
        } else {
            this.showBorrowDisabledErrorDialog(arrayList);
            this.updateAutoBorrowView();
        }
    }

    private void updateAutoBorrowView() {
        this.fAutoBorrowView.enableOnButton();
        this.fAutoBorrowView.disableOffButton();
        this.fAutoBorrowView.hideInfoPanel();
        this.fAutoBorrowView.enableDaysSpinner();
        this.fMainView.enableBorrowFeatureRadioButton();
        this.fMainView.showInitialView();
    }

    @Override
    public void turnBorrowModeOff() {
        this.fAutoBorrowView.enableOnButton();
        this.fAutoBorrowView.disableOffButton();
        this.fAutoBorrowView.enableDaysSpinner();
        this.fAutoBorrowView.hideInfoPanel();
        this.fBorrowMgr.turnAutoBorrowOff(new EventDispatchThreadCallback(){

            @Override
            public void runOnAWTEventDispatchThread(Object object) {
                BorrowControllerImpl.this.flexFeatureList = BorrowControllerImpl.this.fBorrowMgr.getFeatureList();
                BorrowControllerImpl.this.fMainView.enableBorrowFeatureRadioButton();
                BorrowControllerImpl.this.updateRadioButtonStatus();
                BorrowControllerImpl.this.fMainView.showMessageDialog(BorrowControllerImpl.this.fResBundle.getString("autoborrow.off.msg"), BorrowControllerImpl.this.fResBundle.getString("borrow.status.title"));
                BorrowControllerImpl.this.fMainView.showInitialView();
                BorrowControllerImpl.this.fStatusLabel.setAutoModeOff();
            }
        });
    }

    @Override
    public void refreshStatus() {
        this.fBorrowMgr.fetchBorrowData(new EventDispatchThreadCallback(){

            @Override
            public void runOnAWTEventDispatchThread(Object object) {
                BorrowControllerImpl.this.fStatusView.refreshData();
            }
        });
    }

    private void showErrorDialog(Collection<FailedFeature> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.fOptionInView.getTitle();
        stringBuffer.append(this.fOptionInView.getMessage());
        String string2 = this.fResBundle.getString("error.record");
        MessageFormat messageFormat = new MessageFormat(string2);
        for (FailedFeature failedFeature : collection) {
            Object[] objectArray = new Object[]{failedFeature.getFeatureName(), failedFeature.getErrorNumber(), failedFeature.getErrorMsg()};
            stringBuffer.append(messageFormat.format(objectArray));
        }
        stringBuffer.append(this.fResBundle.getString("error.contact.info"));
        this.fMainView.showMessageDialog(stringBuffer.toString(), string);
    }

    private void showBorrowDisabledErrorDialog(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.fOptionInView.getTitle();
        stringBuilder.append(this.fOptionInView.getMessage());
        String string2 = this.fResBundle.getString("borrowdisabled.error.record");
        MessageFormat messageFormat = new MessageFormat(string2);
        for (String string3 : collection) {
            Object[] objectArray = new Object[]{string3};
            stringBuilder.append(messageFormat.format(objectArray));
        }
        stringBuilder.append(this.fResBundle.getString("borrowdisabled.error.line1"));
        stringBuilder.append(this.fResBundle.getString("borrowdisabled.error.line2"));
        stringBuilder.append(this.fResBundle.getString("error.contact.info"));
        this.fMainView.showMessageDialog(stringBuilder.toString(), string);
    }

    @Override
    public void showUI() {
        this.fBorrowMgr.fetchBorrowData(new EventDispatchThreadCallback(){

            @Override
            public void runOnAWTEventDispatchThread(Object object) {
                BorrowControllerImpl.this.flexFeatureList = BorrowControllerImpl.this.fBorrowMgr.getFeatureList();
                if (BorrowControllerImpl.this.flexFeatureList.isEmpty()) {
                    BorrowControllerImpl.this.fMainView.showMessageDialog(BorrowControllerImpl.this.fResBundle.getString("error.connection.message"), BorrowControllerImpl.this.fResBundle.getString("error.connection.title"));
                } else {
                    boolean bl = BorrowControllerImpl.this.fBorrowMgr.getAutoBorrowMode();
                    if (bl) {
                        BorrowControllerImpl.this.fMainView.showAutoModeOnView();
                    } else {
                        BorrowControllerImpl.this.fMainView.showInitialView();
                    }
                }
            }
        });
    }

    @Override
    public void closeUI() {
        this.fMainView.closeDialog();
    }

    @Override
    public void showHelp() {
        String string = HelpUtils.getMapfileName((String)"matlab", (String)"env_csh");
        MLHelpServices.cshDisplayTopic((String)string, (String)"borrow_gui_help");
    }

    @Override
    public void setStatusPanel(JPanel jPanel) {
        this.fStatusLabel.setStatusPanel(jPanel);
    }
}

