/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.workspace;

import com.mathworks.mde.workspace.MultiDimArrayDim;
import com.mathworks.mde.workspace.MultiDimArrayDimConverter;
import com.mathworks.mde.workspace.WorkspaceBrowserResources;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.workspace.WorkspacePrefs;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingConverter;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingPath;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public class WorkspaceBrowserPrefsPanel
extends MJPanel {
    private static WorkspaceBrowserPrefsPanel sPrefsPanel = null;
    private SpinnerNumberModel fMaxElementsSpinnerModel;
    private MJRadioButton fUseNaNsButton;
    private static SaveVariablesToScriptUIElements fSaveVarsUI;
    private static final int STAT_NUMEL_MIN = 0;
    private static final int STAT_NUMEL_MAX = 20000000;
    private static final int STAT_NUMEL_STEP = 10000;
    private static SettingPath saveVariablesSettingPath;
    private static Setting<Double> maximumArraySizeSetting;
    private static Setting<Double> maximumNestingLevelSetting;
    private static Setting<Boolean> multiDimArrayFormat2DPagesSetting;
    private static Setting<MultiDimArrayDim> multiDimArrayDims;
    private static Setting<Double> MaximumCharsPerLineSetting;
    private static MultiDimArrayDimConverter fConverter;

    private static SettingPath getSaveVariablesSettingPath() throws SettingException {
        if (saveVariablesSettingPath == null) {
            saveVariablesSettingPath = new SettingPath(new SettingPath(MvmContext.get()), new String[]{"matlab", "desktop", "workspace", "savevariablestoscript"});
        }
        return saveVariablesSettingPath;
    }

    private static Setting<Double> getMaximumArraySizeSetting() throws SettingException {
        if (maximumArraySizeSetting == null) {
            saveVariablesSettingPath = WorkspaceBrowserPrefsPanel.getSaveVariablesSettingPath();
            maximumArraySizeSetting = WorkspaceBrowserPrefsPanel.createDoubleSetting(saveVariablesSettingPath, "MaximumArraySize");
        }
        return maximumArraySizeSetting;
    }

    private static Setting<Double> getMaximumNestingLevelSetting() throws SettingException {
        if (maximumNestingLevelSetting == null) {
            saveVariablesSettingPath = WorkspaceBrowserPrefsPanel.getSaveVariablesSettingPath();
            maximumNestingLevelSetting = WorkspaceBrowserPrefsPanel.createDoubleSetting(saveVariablesSettingPath, "MaximumNestingLevel");
        }
        return maximumNestingLevelSetting;
    }

    private static Setting<Boolean> getMultiDimArrayFormat2DPagesSetting() throws SettingException {
        if (multiDimArrayFormat2DPagesSetting == null) {
            saveVariablesSettingPath = WorkspaceBrowserPrefsPanel.getSaveVariablesSettingPath();
            multiDimArrayFormat2DPagesSetting = WorkspaceBrowserPrefsPanel.createBooleanSetting(saveVariablesSettingPath, "Using2Dslice");
        }
        return multiDimArrayFormat2DPagesSetting;
    }

    private static Setting<MultiDimArrayDim> getMultiDimArrayDimensions() throws SettingException {
        if (multiDimArrayDims == null) {
            saveVariablesSettingPath = WorkspaceBrowserPrefsPanel.getSaveVariablesSettingPath();
            fConverter = new MultiDimArrayDimConverter();
            multiDimArrayDims = new Setting(saveVariablesSettingPath, (SettingConverter)fConverter, "ArrayDimensionsFor2Dslice");
        }
        return multiDimArrayDims;
    }

    private static Setting<Double> getMaximumCharsPerLineSettingSetting() throws SettingException {
        if (MaximumCharsPerLineSetting == null) {
            saveVariablesSettingPath = WorkspaceBrowserPrefsPanel.getSaveVariablesSettingPath();
            MaximumCharsPerLineSetting = WorkspaceBrowserPrefsPanel.createDoubleSetting(saveVariablesSettingPath, "MaximumTextWidth");
        }
        return MaximumCharsPerLineSetting;
    }

    private static Setting<Double> createDoubleSetting(SettingPath settingPath, String string) throws SettingException {
        return new Setting(settingPath, Double.class, string);
    }

    private static Setting<Boolean> createBooleanSetting(SettingPath settingPath, String string) throws SettingException {
        return new Setting(settingPath, Boolean.class, string);
    }

    private WorkspaceBrowserPrefsPanel() {
        Object object;
        As2DPagesRadioButtonListener as2DPagesRadioButtonListener;
        int n = 5;
        int n2 = 6;
        this.setLayout((LayoutManager)new MGridLayout(0, 1, n2, n, 131072));
        fSaveVarsUI = new SaveVariablesToScriptUIElements();
        MJPanel mJPanel = null;
        try {
            mJPanel = WorkspaceBrowserPrefsPanel.createSaveVariablesPanel();
            as2DPagesRadioButtonListener = new As2DPagesRadioButtonListener();
            object = new RowVectorRadioButtonListener();
            WorkspaceBrowserPrefsPanel.fSaveVarsUI.fAs2DPagesButton.addActionListener((ActionListener)as2DPagesRadioButtonListener);
            WorkspaceBrowserPrefsPanel.fSaveVarsUI.fRowVectorButton.addActionListener((ActionListener)object);
            this.add((Component)mJPanel);
        }
        catch (SettingException settingException) {
            object = WorkspaceBrowserResources.getResource("prefs.ErrorMessage", settingException.getLocalizedMessage());
            JOptionPane.showOptionDialog(null, object, WorkspaceBrowserResources.getResource("prefs.ErrorTitle"), -1, 0, null, null, null);
        }
        as2DPagesRadioButtonListener = WorkspaceBrowserPrefsPanel.createStatisticsPanel();
        object = WorkspacePrefs.getStatCalculationsNumelLimit();
        Integer n3 = 0;
        Integer n4 = 20000000;
        Integer n5 = 10000;
        this.fMaxElementsSpinnerModel = new SpinnerNumberModel((Number)object, n3, n4, n5);
        MJSpinner mJSpinner = WorkspaceBrowserPrefsPanel.createMaxElementsSpinner(this.fMaxElementsSpinnerModel);
        MJLabel mJLabel = new MJLabel(WorkspaceBrowserResources.getResource("prefs.upperLimitSpinner"));
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.add((Component)mJSpinner);
        mJPanel2.add((Component)mJLabel);
        MJLabel mJLabel2 = WorkspaceBrowserPrefsPanel.createNaNLabel(n, n2);
        ButtonGroup buttonGroup = new ButtonGroup();
        MJRadioButton mJRadioButton = WorkspaceBrowserPrefsPanel.createUseNaNsButton(n, n2, buttonGroup);
        MJRadioButton mJRadioButton2 = WorkspaceBrowserPrefsPanel.createIgnoreNaNsButton(n, n2, buttonGroup);
        as2DPagesRadioButtonListener.add((Component)mJPanel2);
        as2DPagesRadioButtonListener.add((Component)mJLabel2);
        as2DPagesRadioButtonListener.add((Component)mJRadioButton);
        as2DPagesRadioButtonListener.add((Component)mJRadioButton2);
        this.add((Component)((Object)as2DPagesRadioButtonListener));
        this.fUseNaNsButton = mJRadioButton;
    }

    private static MJSpinner createMaxElementsSpinner(SpinnerModel spinnerModel) {
        MJSpinner mJSpinner = new MJSpinner(spinnerModel);
        mJSpinner.setName("SessionSizeSpinner");
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor((JSpinner)mJSpinner);
        JFormattedTextField jFormattedTextField = numberEditor.getTextField();
        jFormattedTextField.setBackground(SystemColor.window);
        jFormattedTextField.setForeground(SystemColor.windowText);
        jFormattedTextField.setBorder(null);
        mJSpinner.setEditor((JComponent)numberEditor);
        numberEditor.getTextField().setEditable(false);
        return mJSpinner;
    }

    private static MJRadioButton createIgnoreNaNsButton(int n, int n2, ButtonGroup buttonGroup) {
        MJRadioButton mJRadioButton = new MJRadioButton(WorkspaceBrowserResources.getResource("prefs.ignoreNaNsRadio"), !WorkspacePrefs.getUseNaNsForStatCalculations());
        mJRadioButton.setName("DontUseNaNsButton");
        mJRadioButton.setBorder(BorderFactory.createEmptyBorder(n, n2 * 4, n, n2));
        buttonGroup.add((AbstractButton)mJRadioButton);
        return mJRadioButton;
    }

    private static MJRadioButton createUseNaNsButton(int n, int n2, ButtonGroup buttonGroup) {
        MJRadioButton mJRadioButton = new MJRadioButton(WorkspaceBrowserResources.getResource("prefs.useNaNsForCalcRadio"), WorkspacePrefs.getUseNaNsForStatCalculations());
        mJRadioButton.setName("UseNaNsButton");
        mJRadioButton.setBorder(BorderFactory.createEmptyBorder(n, n2 * 4, n, n2));
        buttonGroup.add((AbstractButton)mJRadioButton);
        return mJRadioButton;
    }

    private static MJLabel createNaNLabel(int n, int n2) {
        MJLabel mJLabel = new MJLabel(WorkspaceBrowserResources.getResource("prefs.NaNLabel"));
        mJLabel.setBorder(BorderFactory.createEmptyBorder(n, n2, n, n2));
        return mJLabel;
    }

    private static MJPanel createStatisticsPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 1, 3, 0, 196608, (Object)new Float(0.0), null));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(WorkspaceBrowserResources.getResource("prefs.StatLabel")));
        mJPanel.setName("WorkspaceStatisticalCalculations");
        return mJPanel;
    }

    private static MJPanel createSaveVariablesPanel() throws SettingException {
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 1, 3, 10, 131072));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(WorkspaceBrowserResources.getResource("prefs.SaveVariablesLabel")));
        mJPanel.setName("WorkspaceSaveVariables");
        MJPanel mJPanel2 = WorkspaceBrowserPrefsPanel.createMaximumThresholdPanel();
        MJPanel mJPanel3 = WorkspaceBrowserPrefsPanel.createMultiDimensionalArrayPanel();
        MJPanel mJPanel4 = WorkspaceBrowserPrefsPanel.createFileFormattingPanel();
        mJPanel.add((Component)mJPanel2);
        mJPanel.add((Component)mJPanel3);
        mJPanel.add((Component)mJPanel4);
        return mJPanel;
    }

    private static MJPanel createMaximumThresholdPanel() throws SettingException {
        int n = 0;
        Setting<Double> setting = WorkspaceBrowserPrefsPanel.getMaximumArraySizeSetting();
        n = ((Double)setting.get()).intValue();
        int n2 = 0;
        Setting<Double> setting2 = WorkspaceBrowserPrefsPanel.getMaximumNestingLevelSetting();
        n2 = ((Double)setting2.get()).intValue();
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 2, 10, 3, 131072, (Object)0, null));
        MJTextField mJTextField = WorkspaceBrowserPrefsPanel.createTextField("MaximumArraySizeFieldTextField", 20, Integer.toString(n));
        MJLabel mJLabel = new MJLabel(WorkspaceBrowserResources.getResource("prefs.MaximumArraySizeLabel"));
        mJTextField.setAlignmentX(1.0f);
        mJPanel.add((Component)mJLabel);
        mJPanel.add((Component)mJTextField);
        MJTextField mJTextField2 = WorkspaceBrowserPrefsPanel.createTextField("MaximumNestingLevelFieldTextField", 20, Integer.toString(n2));
        MJLabel mJLabel2 = new MJLabel(WorkspaceBrowserResources.getResource("prefs.MaximumNestingLevelLabel"));
        mJTextField2.setAlignmentX(1.0f);
        mJPanel.add((Component)mJLabel2);
        mJPanel.add((Component)mJTextField2);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new MGridLayout(3, 1, 4, 6, 131072, (Object)0, null));
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(WorkspaceBrowserResources.getResource("prefs.ArrayThresholdValuesLabel")));
        String string = WorkspaceBrowserResources.getResource("prefs.Info");
        mJPanel2.add((Component)new MJMultilineLabel(string, true));
        mJPanel2.add((Component)mJPanel);
        WorkspaceBrowserPrefsPanel.fSaveVarsUI.fMaximumArraySizeField = mJTextField;
        WorkspaceBrowserPrefsPanel.fSaveVarsUI.fMaximumNestedLevelField = mJTextField2;
        return mJPanel2;
    }

    public static MJPanel createMultiDimensionalArrayPanel() throws SettingException {
        boolean bl = false;
        boolean bl2 = false;
        Setting<Boolean> setting = WorkspaceBrowserPrefsPanel.getMultiDimArrayFormat2DPagesSetting();
        bl2 = (Boolean)setting.get();
        Setting<MultiDimArrayDim> setting2 = WorkspaceBrowserPrefsPanel.getMultiDimArrayDimensions();
        MultiDimArrayDim multiDimArrayDim = (MultiDimArrayDim)setting2.get();
        int n = multiDimArrayDim.getLow().intValue();
        int n2 = multiDimArrayDim.getHigh().intValue();
        ButtonGroup buttonGroup = new ButtonGroup();
        MJRadioButton mJRadioButton = WorkspaceBrowserPrefsPanel.createRowVectorRadioButton(5, 6, buttonGroup);
        MJRadioButton mJRadioButton2 = WorkspaceBrowserPrefsPanel.create2DPagesRadioButton(5, 6, buttonGroup);
        mJRadioButton.setSelected(!bl2);
        mJRadioButton2.setSelected(bl2);
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 3, 4, 3, 196608, (Object)0, null));
        MJTextField mJTextField = WorkspaceBrowserPrefsPanel.createTextField("MultiDimArrayLowFieldTextField", 5, Integer.toString(n));
        MJTextField mJTextField2 = WorkspaceBrowserPrefsPanel.createTextField("MultiDimArrayHighFieldTextField", 5, Integer.toString(n2));
        MJLabel mJLabel = new MJLabel(WorkspaceBrowserResources.getResource("prefs.MultiDimensionalArrayEditLabel"));
        mJTextField.setAlignmentX(1.0f);
        mJTextField2.setAlignmentX(1.0f);
        mJTextField.setEnabled(bl2);
        mJTextField2.setEnabled(bl2);
        mJPanel.add((Component)mJLabel);
        mJPanel.add((Component)mJTextField);
        mJPanel.add((Component)mJTextField2);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new MGridLayout(3, 1, 4, 6, 131072, (Object)0, null));
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(WorkspaceBrowserResources.getResource("prefs.MultiDimensionalArrayFormattingLabel")));
        mJPanel2.add((Component)mJRadioButton);
        mJPanel2.add((Component)mJRadioButton2);
        mJPanel2.add((Component)mJPanel);
        WorkspaceBrowserPrefsPanel.fSaveVarsUI.fRowVectorButton = mJRadioButton;
        WorkspaceBrowserPrefsPanel.fSaveVarsUI.fAs2DPagesButton = mJRadioButton2;
        WorkspaceBrowserPrefsPanel.fSaveVarsUI.fArrayDimLowField = mJTextField;
        WorkspaceBrowserPrefsPanel.fSaveVarsUI.fArrayDimHighField = mJTextField2;
        return mJPanel2;
    }

    public static MJPanel createFileFormattingPanel() throws SettingException {
        int n = 0;
        Setting<Double> setting = WorkspaceBrowserPrefsPanel.getMaximumCharsPerLineSettingSetting();
        n = ((Double)setting.get()).intValue();
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 2, 4, 3, 131072, (Object)0, null));
        MJTextField mJTextField = WorkspaceBrowserPrefsPanel.createTextField("FileFormatFieldTextField", 20, Integer.toString(n));
        MJLabel mJLabel = new MJLabel(WorkspaceBrowserResources.getResource("prefs.MaximumCharactersLabel"));
        mJPanel.add((Component)mJLabel);
        mJPanel.add((Component)mJTextField);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new MGridLayout(1, 1, 4, 6, 131072, (Object)0, null));
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(WorkspaceBrowserResources.getResource("prefs.FileFormattingLabel")));
        mJPanel2.add((Component)mJPanel);
        WorkspaceBrowserPrefsPanel.fSaveVarsUI.fMaxCharPerLineField = mJTextField;
        return mJPanel2;
    }

    private static MJTextField createTextField(String string, int n, String string2) {
        MJTextField mJTextField = new MJTextField();
        mJTextField.setName(string);
        mJTextField.setColumns(n);
        mJTextField.setText(string2);
        return mJTextField;
    }

    private static MJRadioButton createRowVectorRadioButton(int n, int n2, ButtonGroup buttonGroup) {
        MJRadioButton mJRadioButton = new MJRadioButton(WorkspaceBrowserResources.getResource("prefs.asRowVector"));
        mJRadioButton.setName("UseRowVectorButton");
        buttonGroup.add((AbstractButton)mJRadioButton);
        return mJRadioButton;
    }

    private static MJRadioButton create2DPagesRadioButton(int n, int n2, ButtonGroup buttonGroup) {
        MJRadioButton mJRadioButton = new MJRadioButton(WorkspaceBrowserResources.getResource("prefs.as2DPagesRadio"));
        mJRadioButton.setName("Use2DButton");
        buttonGroup.add((AbstractButton)mJRadioButton);
        return mJRadioButton;
    }

    private static MJLabel createMaxSizeThresholdLabel(int n, int n2) {
        MJLabel mJLabel = new MJLabel(WorkspaceBrowserResources.getResource("prefs.MessageForThresholdValues"));
        mJLabel.setBorder(BorderFactory.createEmptyBorder(n, n2, n, n2));
        return mJLabel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
            sPrefsPanel.commitSaveVariablesToScriptPreferences();
        }
    }

    private void saveOptions() {
        boolean bl = this.fUseNaNsButton.isSelected();
        WorkspacePrefs.setUseNaNsForStatCalculations((boolean)bl);
        WorkspacePrefs.setStatCalculationsNumelLimit((int)this.fMaxElementsSpinnerModel.getNumber().intValue());
    }

    private void commitSaveVariablesToScriptPreferences() {
        String string = WorkspaceBrowserPrefsPanel.fSaveVarsUI.fMaximumArraySizeField.getText();
        double d = 0.0;
        String string2 = WorkspaceBrowserPrefsPanel.fSaveVarsUI.fMaximumNestedLevelField.getText();
        double d2 = 0.0;
        boolean bl = WorkspaceBrowserPrefsPanel.fSaveVarsUI.fRowVectorButton.isSelected();
        boolean bl2 = WorkspaceBrowserPrefsPanel.fSaveVarsUI.fAs2DPagesButton.isSelected();
        assert (bl != bl2);
        String string3 = WorkspaceBrowserPrefsPanel.fSaveVarsUI.fArrayDimLowField.getText();
        double d3 = 0.0;
        String string4 = WorkspaceBrowserPrefsPanel.fSaveVarsUI.fArrayDimHighField.getText();
        double d4 = 0.0;
        String string5 = WorkspaceBrowserPrefsPanel.fSaveVarsUI.fMaxCharPerLineField.getText();
        double d5 = 0.0;
        try {
            d = Double.parseDouble(string);
            d2 = Double.parseDouble(string2);
            d3 = Double.parseDouble(string3);
            d4 = Double.parseDouble(string4);
            d5 = Double.parseDouble(string5);
            Setting<Double> setting = WorkspaceBrowserPrefsPanel.getMaximumArraySizeSetting();
            setting.set((Object)d);
            Setting<Double> setting2 = WorkspaceBrowserPrefsPanel.getMaximumNestingLevelSetting();
            setting2.set((Object)d2);
            Setting<Boolean> setting3 = WorkspaceBrowserPrefsPanel.getMultiDimArrayFormat2DPagesSetting();
            setting3.set((Object)bl2);
            Setting<MultiDimArrayDim> setting4 = WorkspaceBrowserPrefsPanel.getMultiDimArrayDimensions();
            MultiDimArrayDim multiDimArrayDim = new MultiDimArrayDim(d3, d4);
            setting4.set((Object)multiDimArrayDim);
            Setting<Double> setting5 = WorkspaceBrowserPrefsPanel.getMaximumCharsPerLineSettingSetting();
            setting5.set((Object)d5);
        }
        catch (SettingException settingException) {
            String string6 = WorkspaceBrowserResources.getResource("prefs.ErrorMessage", settingException.getLocalizedMessage());
            JOptionPane.showOptionDialog(null, string6, WorkspaceBrowserResources.getResource("prefs.ErrorTitle"), -1, 0, null, null, null);
        }
        catch (NumberFormatException numberFormatException) {
            String string7 = WorkspaceBrowserResources.getResource("prefs.SaveVarsInvalidDataTypeForPref");
            JOptionPane.showOptionDialog(null, string7, WorkspaceBrowserResources.getResource("prefs.ErrorTitle"), -1, 0, null, null, null);
        }
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new WorkspaceBrowserPrefsPanel();
        sPrefsPanel.setName(WorkspaceBrowserResources.getResource("prefs.panelTitle"));
        return sPrefsPanel;
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_workspace_prefs"};
    }

    static {
        saveVariablesSettingPath = null;
        maximumArraySizeSetting = null;
        maximumNestingLevelSetting = null;
        multiDimArrayFormat2DPagesSetting = null;
        multiDimArrayDims = null;
        MaximumCharsPerLineSetting = null;
        fConverter = null;
    }

    private class RowVectorRadioButtonListener
    implements ActionListener {
        private RowVectorRadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJRadioButton mJRadioButton = (MJRadioButton)actionEvent.getSource();
            if (mJRadioButton.isSelected()) {
                fSaveVarsUI.fArrayDimLowField.setEnabled(false);
                fSaveVarsUI.fArrayDimHighField.setEnabled(false);
            }
        }
    }

    private class As2DPagesRadioButtonListener
    implements ActionListener {
        private As2DPagesRadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJRadioButton mJRadioButton = (MJRadioButton)actionEvent.getSource();
            if (mJRadioButton.isSelected()) {
                fSaveVarsUI.fArrayDimLowField.setEnabled(true);
                fSaveVarsUI.fArrayDimHighField.setEnabled(true);
            }
        }
    }

    private class SaveVariablesToScriptUIElements {
        public MJTextField fMaximumArraySizeField;
        public MJTextField fMaximumNestedLevelField;
        public MJRadioButton fRowVectorButton;
        public MJRadioButton fAs2DPagesButton;
        public MJTextField fArrayDimLowField;
        public MJTextField fArrayDimHighField;
        public MJTextField fMaxCharPerLineField;

        private SaveVariablesToScriptUIElements() {
        }
    }
}

