/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.FormSubmitData;
import ice.pilots.html4.FormTypeElement;
import ice.storm.DynEnv;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLInputElement;

public class DInputElement
extends FormTypeElement
implements HTMLInputElement {
    private final String[] OEAB = new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button"};
    public static final int DEFAULT_MAX_LENGTH = 10000;
    public static final int DEFAULT_SIZE = 20;
    private int append = 9;
    private int appendData;
    private int appendFileData;
    private boolean blur = false;
    private boolean bug = false;
    private String cancel;

    protected DInputElement(DDocument dDocument, int n) {
        super(dDocument, n);
    }

    void setAttributes(int[] nArray, String[] stringArray, int n) {
        super.setAttributes(nArray, stringArray, n);
        String string = this.getAttribute(19);
        if (string != null) {
            this.setAttribute(19, string.toUpperCase());
            this.blur = true;
        }
        this.bug = this.blur;
        this.setDefaultValue(this.getValue());
        this.updateType();
    }

    protected void onDAttrValueChange(DAttr dAttr) {
        if (dAttr.nameId == 111) {
            this.updateType();
        }
        super.onDAttrValueChange(dAttr);
    }

    void updateType() {
        int n = 0;
        String string = this.getAttribute(111);
        if (string != null) {
            int n2 = 0;
            while (n2 != this.OEAB.length) {
                if (string.equalsIgnoreCase(this.OEAB[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        this.append = n;
        this.setDAttr(111, this.OEAB[this.append], false);
        if (this.append != 8) {
            this.removeDAttr(119, true);
            this.removeDAttr(45, true);
        }
    }

    public void dispatchChange() {
        if (this.doc == null) {
            return;
        }
        DOMEvent dOMEvent = this.doc.createDOMEvent(18);
        dOMEvent.target = this;
        this.doc.processEvent(dOMEvent);
    }

    public boolean dispatchEvent(Event event) {
        DOMUIEvent dOMUIEvent;
        if (event instanceof DOMUIEvent && (dOMUIEvent = (DOMUIEvent)event).getTypeId() == 1) {
            this.OEAB(dOMUIEvent);
            return dOMUIEvent.isDefaultCancelled();
        }
        return super.dispatchEvent(event);
    }

    private void OEAB(DOMUIEvent dOMUIEvent) {
        if (this.getDisabled()) {
            return;
        }
        boolean[] blArray = new boolean[1];
        boolean bl = false;
        DInputElement dInputElement = null;
        if (this.append == 2) {
            bl = this.getChecked();
            this.append(!bl, false);
        } else if (this.append == 3 && (dInputElement = this.getSelectedRadio()) != this) {
            this.append(true, false);
        }
        if (dOMUIEvent.getAction() == null) {
            dOMUIEvent.setAction(new EventListener(this, blArray){
                private final boolean[] val$runDefault;
                private final DInputElement this$0;
                {
                    this.this$0 = dInputElement;
                    this.val$runDefault = blArray;
                }

                public void handleEvent(Event event) {
                    this.val$runDefault[0] = true;
                }
            });
            super.dispatchEvent(dOMUIEvent);
        }
        if (!blArray[0]) {
            if (this.append == 2) {
                this.append(bl, false);
            } else if (this.append == 3) {
                if (dInputElement == null) {
                    this.append(false, false);
                } else if (dInputElement != this) {
                    dInputElement.append(true, false);
                }
            }
        } else {
            this.appendData = dOMUIEvent.posX;
            this.appendFileData = dOMUIEvent.posY;
            if (this.append == 2 || this.append == 3) {
                this.dispatchChange();
            } else {
                DFormElement dFormElement = this.getDForm();
                if (dFormElement != null) {
                    if (this.append == 4 || this.append == 8) {
                        if (this.append != 4 || !dOMUIEvent.cancel) {
                            dFormElement.submitWithEvent(this);
                        }
                    } else if (this.append == 5) {
                        dFormElement.reset();
                    }
                }
            }
        }
    }

    DInputElement getSelectedRadio() {
        String string = this.getNameForServer();
        DFormElement dFormElement = this.getDForm();
        if (dFormElement != null && string != null) {
            HTMLCollection hTMLCollection = dFormElement.getElements();
            int n = 0;
            Node node = hTMLCollection.item(n);
            while (node != null) {
                if (node instanceof DInputElement) {
                    String string2;
                    DInputElement dInputElement = (DInputElement)node;
                    if (dInputElement.append == 3 && (string2 = dInputElement.getNameForServer()) != null && string2.equals(string) && dInputElement.blur) {
                        return dInputElement;
                    }
                }
                node = hTMLCollection.item(++n);
            }
        }
        return null;
    }

    public String getDefaultValue() {
        return this.cancel;
    }

    public void setDefaultValue(String string) {
        this.cancel = string;
    }

    public boolean getDefaultChecked() {
        return this.bug;
    }

    public void setDefaultChecked(boolean bl) {
        this.bug = bl;
    }

    public String getAccept() {
        return null;
    }

    public void setAccept(String string) {
    }

    public String getAccessKey() {
        return this.getAttribute(4);
    }

    public void setAccessKey(String string) {
        this.setAttribute(4, string);
    }

    public String getAlt() {
        return this.getAttribute(8);
    }

    public void setAlt(String string) {
        this.setAttribute(8, string);
    }

    public boolean getChecked() {
        return this.blur;
    }

    public void setChecked(boolean bl) {
        this.append(bl, true);
    }

    private void append(boolean bl, boolean bl2) {
        if (bl == this.blur) {
            return;
        }
        if (this.append == 2) {
            this.blur = bl;
        } else if (this.append == 3) {
            if (bl) {
                String string = this.getNameForServer();
                DFormElement dFormElement = this.getDForm();
                if (dFormElement != null && string != null) {
                    HTMLCollection hTMLCollection = dFormElement.getElements();
                    int n = 0;
                    Node node = hTMLCollection.item(n++);
                    while (node != null) {
                        String string2;
                        DInputElement dInputElement;
                        if (node instanceof DInputElement && node != this && (dInputElement = (DInputElement)node).getType().equalsIgnoreCase("radio") && (string2 = dInputElement.getNameForServer()) != null && string2.equals(string)) {
                            dInputElement.setChecked(false);
                        }
                        node = hTMLCollection.item(n++);
                    }
                }
            }
            this.blur = bl;
        }
        this.setAttribute(19, bl ? "checked" : null);
        if ((this.append == 2 || this.append == 3 && bl) && bl2) {
            this.dispatchChange();
        }
    }

    public boolean getDisabled() {
        return this.getAttribute(38) != null;
    }

    public void setDisabled(boolean bl) {
        this.setAttribute(38, bl ? "disabled" : null);
    }

    public int getMaxLength() {
        int n = 10000;
        String string = this.getAttribute(59);
        if (string != null) {
            n = CSSUtil.parseInt(string, n);
        }
        return n;
    }

    public void setMaxLength(int n) {
        this.setAttribute(59, Integer.toString(n));
    }

    public boolean getReadOnly() {
        return this.getAttribute(89) != null;
    }

    public void setReadOnly(boolean bl) {
        this.setAttribute(89, bl ? "readonly" : null);
    }

    public String getSize() {
        return this.getAttribute(100);
    }

    public void setSize(String string) {
        this.setAttribute(100, string);
    }

    public String getSrc() {
        return this.getAttribute(102);
    }

    public void setSrc(String string) {
        this.setAttribute(102, string);
    }

    public int getTabIndex() {
        return -1;
    }

    public void setTabIndex(int n) {
    }

    public String getType() {
        return this.OEAB[this.append];
    }

    public void setType(String string) {
    }

    public String getUseMap() {
        return null;
    }

    public void setUseMap(String string) {
    }

    public String getValue() {
        String string = this.getAttribute(114);
        if (string == null && (this.append == 0 || this.append == 1 || this.append == 7)) {
            string = "";
        }
        return string;
    }

    public void setValue(String string) {
        this.setAttribute(114, string);
    }

    public void dispatchSelection(int n, int n2) {
        if (this.append != 0) {
            Debug.bug();
        }
        DOMEvent dOMEvent = this.doc.createDOMEvent(17);
        dOMEvent.target = this;
        this.doc.processEvent(dOMEvent);
    }

    public void blur() {
        this.doc.getDomView().processBlurCall(this);
    }

    public void focus() {
        this.doc.getDomView().processFocusCall(this);
    }

    public void select() {
        this.doc.getDomView().processSelectCall(this);
    }

    public void click() {
        if (this.getDisabled()) {
            return;
        }
        this.doc.getDomView().processClickCall(this);
    }

    public String getAlign() {
        return null;
    }

    public void setAlign(String string) {
    }

    void recordData(FormSubmitData formSubmitData, Object object) {
        switch (this.append) {
            case 5: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                if (this.getDisabled() || !this.blur) break;
                String string = this.getValue();
                if (string == null) {
                    string = "on";
                }
                formSubmitData.appendData(this.getNameForServer(), string);
                break;
            }
            case 6: {
                if (this.getDisabled()) break;
                formSubmitData.appendFileData(this.getNameForServer(), this.fixValue(this.getValue()));
                break;
            }
            case 7: {
                formSubmitData.appendData(this.getNameForServer(), this.getValue());
                break;
            }
            case 8: {
                if (this.getDisabled() || object != this) break;
                String string = this.getNameForServer();
                string = string == null ? "" : string + ".";
                formSubmitData.appendData(string + "x", "" + this.appendData);
                formSubmitData.appendData(string + "y", "" + this.appendFileData);
                break;
            }
            case 0: 
            case 1: {
                if (this.getDisabled()) break;
                formSubmitData.appendData(this.getNameForServer(), this.getValue());
                break;
            }
            case 4: {
                if (this.getDisabled() || object != this) break;
                formSubmitData.appendData(this.getNameForServer(), this.getValue());
                break;
            }
        }
    }

    void reset() {
        if (this.append == 2 || this.append == 3) {
            this.setChecked(this.getDefaultChecked());
        } else {
            this.setValue(this.getDefaultValue());
        }
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DInputElement.bug(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.appendData(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DInputElement.bug(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.appendFileData(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DInputElement.bug(string);
        if (n < 0) {
            return this.blur(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object appendData(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return this.getAccept();
            }
            case 2: {
                return this.getAccessKey();
            }
            case 3: {
                return this.getAlign();
            }
            case 4: {
                return this.getAlt();
            }
            case 5: {
                return dynEnv.wrapBoolean(this.getChecked());
            }
            case 6: {
                return this.getDefaultValue();
            }
            case 7: {
                return dynEnv.wrapBoolean(this.getDefaultChecked());
            }
            case 8: {
                return dynEnv.wrapBoolean(this.getDisabled());
            }
            case 9: {
                return this.getDForm();
            }
            case 10: {
                return dynEnv.wrapInt(this.getMaxLength());
            }
            case 11: {
                return dynEnv.wrapBoolean(this.getReadOnly());
            }
            case 12: {
                return this.getSize();
            }
            case 13: {
                return this.getSrc();
            }
            case 14: {
                return dynEnv.wrapInt(this.getTabIndex());
            }
            case 15: {
                return this.getType();
            }
            case 16: {
                return this.getUseMap();
            }
            case 17: {
                return this.getValue();
            }
        }
        return null;
    }

    private int appendFileData(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                this.setAccept(dynEnv.toStr(object));
                return 1;
            }
            case 2: {
                this.setAccessKey(dynEnv.toStr(object));
                return 1;
            }
            case 3: {
                this.setAlign(dynEnv.toStr(object));
                return 1;
            }
            case 4: {
                this.setAlt(dynEnv.toStr(object));
                return 1;
            }
            case 5: {
                this.setChecked(dynEnv.toBoolean(object));
                return 1;
            }
            case 6: {
                this.setDefaultValue(dynEnv.toStr(object));
                return 1;
            }
            case 7: {
                this.setDefaultChecked(dynEnv.toBoolean(object));
                return 1;
            }
            case 8: {
                this.setDisabled(dynEnv.toBoolean(object));
                return 1;
            }
            case 9: {
                break;
            }
            case 10: {
                this.setMaxLength(dynEnv.toInt(object));
                return 1;
            }
            case 11: {
                this.setReadOnly(dynEnv.toBoolean(object));
                return 1;
            }
            case 12: {
                this.setSize(dynEnv.toStr(object));
                return 1;
            }
            case 13: {
                this.setSrc(dynEnv.toStr(object));
                return 1;
            }
            case 14: {
                this.setTabIndex(dynEnv.toInt(object));
                return 1;
            }
            case 15: {
                this.setType(dynEnv.toStr(object));
                return 1;
            }
            case 16: {
                this.setUseMap(dynEnv.toStr(object));
                return 1;
            }
            case 17: {
                this.setValue(dynEnv.toStr(object));
                return 1;
            }
        }
        return 2;
    }

    private Object blur(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                this.blur();
                break;
            }
            case -2: {
                this.focus();
                break;
            }
            case -3: {
                this.select();
                break;
            }
            case -4: {
                this.click();
                break;
            }
            case -5: {
                DFormElement dFormElement = this.getDForm();
                if (dFormElement == null) break;
                dFormElement.submit();
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int bug(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(0);
                if (c == 'a') {
                    string2 = "alt";
                    n = 4;
                    break;
                }
                if (c != 's') break;
                string2 = "src";
                n = 13;
                break;
            }
            case 4: {
                switch (string.charAt(0)) {
                    case 'b': {
                        string2 = "blur";
                        n = -1;
                        break block0;
                    }
                    case 'f': {
                        string2 = "form";
                        n = 9;
                        break block0;
                    }
                    case 's': {
                        string2 = "size";
                        n = 12;
                        break block0;
                    }
                    case 't': {
                        string2 = "type";
                        n = 15;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "align";
                        n = 3;
                        break block0;
                    }
                    case 'c': {
                        string2 = "click";
                        n = -4;
                        break block0;
                    }
                    case 'f': {
                        string2 = "focus";
                        n = -2;
                        break block0;
                    }
                    case 'v': {
                        string2 = "value";
                        n = 17;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                char c = string.charAt(1);
                if (c == 'c') {
                    string2 = "accept";
                    n = 1;
                    break;
                }
                if (c == 'e') {
                    string2 = "select";
                    n = -3;
                    break;
                }
                if (c == 's') {
                    string2 = "useMap";
                    n = 16;
                    break;
                }
                if (c != 'u') break;
                string2 = "submit";
                n = -5;
                break;
            }
            case 7: {
                string2 = "checked";
                n = 5;
                break;
            }
            case 8: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "disabled";
                    n = 8;
                    break;
                }
                if (c == 'r') {
                    string2 = "readOnly";
                    n = 11;
                    break;
                }
                if (c != 't') break;
                string2 = "tabIndex";
                n = 14;
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'a') {
                    string2 = "accessKey";
                    n = 2;
                    break;
                }
                if (c != 'm') break;
                string2 = "maxLength";
                n = 10;
                break;
            }
            case 12: {
                string2 = "defaultValue";
                n = 6;
                break;
            }
            case 14: {
                string2 = "defaultChecked";
                n = 7;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

