/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.mathworks.mwswing.MJComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class AxisProxy
extends MJComponent {
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;
    private String fTag = "";
    private FontMetrics fFontMet = null;

    public AxisProxy() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 50);
    }

    public void paint(Graphics graphics) {
        this.drawAxis(graphics);
    }

    public void update(Graphics graphics) {
        this.drawAxis(graphics);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fFontMet = null;
    }

    public void setTag(String string) {
        this.fTag = string == null ? "" : string;
    }

    private void checkFontInfo() {
        if (this.fFontMet == null) {
            this.fFontMet = this.getFontMetrics(this.getFont());
        }
    }

    private void drawAxis(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, dimension.width, dimension.height);
        graphics.drawLine(0, dimension.height, dimension.width, 0);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        this.checkFontInfo();
        graphics.drawString(this.fTag, dimension.width / 2 - this.fFontMet.stringWidth(this.fTag) / 2, dimension.height / 3);
    }
}

