/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PanelProxy
extends JPanel {
    private TitledBorder fTitledBorder;
    private int fTitlePosition = 0;
    private static final int EMPTY_BORDER = 0;
    private static final int ETCHED_IN_BORDER = 1;
    private static final int ETCHED_OUT_BORDER = 2;
    private static final int BEVELED_IN_BORDER = 3;
    private static final int BEVELED_OUT_BORDER = 4;
    private static final int LINE_BORDER = 5;
    private static final int LEFT_TOP_TITLE = 0;
    private static final int CENTER_TOP_TITLE = 1;
    private static final int RIGHT_TOP_TITLE = 2;
    private static final int LEFT_BOTTOM_TITLE = 3;
    private static final int CENTER_BOTTOM_TITLE = 4;
    private static final int RIGHT_BOTTOM_TITLE = 5;

    public void setTitle(String string) {
        this.setName(string);
        if (this.fTitledBorder != null) {
            this.fTitledBorder.setTitle(string);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.fTitledBorder != null) {
            this.fTitledBorder.setTitleFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fTitledBorder != null) {
            this.fTitledBorder.setTitleColor(color);
        }
    }

    public void setTitlePosition(int n) {
        this.fTitlePosition = n;
        if (this.fTitledBorder != null) {
            int n2 = 1;
            int n3 = 2;
            switch (this.fTitlePosition) {
                case 0: {
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n3 = 5;
                    break;
                }
                case 4: {
                    n2 = 2;
                    n3 = 5;
                    break;
                }
                case 5: {
                    n2 = 3;
                    n3 = 5;
                }
            }
            if (this.fTitledBorder != null) {
                this.fTitledBorder.setTitlePosition(n3);
                this.fTitledBorder.setTitleJustification(n2);
            }
        }
    }

    public void setBorder(int n, int n2, Color color, Color color2) {
        Border border = null;
        switch (n) {
            case 0: {
                border = BorderFactory.createEmptyBorder();
                break;
            }
            case 1: 
            case 2: {
                int n3 = n == 1 ? 1 : 0;
                border = BorderFactory.createEtchedBorder(n3, color, color2);
                break;
            }
            case 3: 
            case 4: {
                int n4 = n == 3 ? 1 : 0;
                border = BorderFactory.createBevelBorder(n4, color, color2);
                break;
            }
            case 5: {
                border = BorderFactory.createLineBorder(color, n2);
            }
        }
        if (this.fTitledBorder == null) {
            this.fTitledBorder = BorderFactory.createTitledBorder(border);
        } else {
            this.fTitledBorder.setBorder(border);
        }
        this.fTitledBorder.setTitle(this.getName());
        this.fTitledBorder.setTitleFont(this.getFont());
        this.fTitledBorder.setTitleColor(this.getForeground());
        this.setTitlePosition(this.fTitlePosition);
        this.setBorder(this.fTitledBorder);
    }
}

