/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AxisCanvas;
import com.mathworks.hg.peer.AxisCanvasBase;
import com.mathworks.hg.peer.AxisComponent;
import com.mathworks.hg.peer.AxisPanel;
import com.mathworks.hg.peer.AxisPanelBase;
import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.FigureComponentNotification;
import com.mathworks.hg.peer.FigureComponentProxyWithMouse;
import com.mathworks.hg.peer.FigurePaintNotification;
import com.mathworks.hg.peer.FigureWindowNotification;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

public class FigureAxisComponentProxy
extends FigureComponentProxyWithMouse {
    private AxisComponent fAxis;
    private Image fBackingStore;
    private boolean fOffscreenRenderingMode = false;
    private GraphicsConfiguration fGraphicsConfiguration;
    private boolean fLightweight;
    private boolean fUnitTest;

    public FigureAxisComponentProxy(boolean bl, boolean bl2) {
        this.fLightweight = bl;
        this.fUnitTest = bl2;
    }

    private void construct(int n) {
        this.setFigureComponent(null);
        assert (this.fAxis == null);
        assert (this.fFigureComponent == null);
        if (this.fLightweight) {
            this.fAxis = this.fUnitTest ? new AxisPanelBase(){

                @Override
                public void paintCallback(Graphics graphics) {
                    FigureAxisComponentProxy.this.doPaint(graphics);
                }
            } : new AxisPanel(){

                @Override
                public void paintCallback(Graphics graphics) {
                    FigureAxisComponentProxy.this.doPaint(graphics);
                }
            };
        } else {
            this.fGraphicsConfiguration = FigureAxisComponentProxy.chooseGraphicsConfigurationByVisual(n);
            if (this.fUnitTest) {
                try {
                    this.fAxis = new AxisCanvasBase(this.fGraphicsConfiguration);
                }
                catch (Throwable throwable) {
                    this.fAxis = new AxisCanvasBase();
                }
            } else {
                try {
                    this.fAxis = new _AxisCanvas(this.fGraphicsConfiguration);
                }
                catch (Throwable throwable) {
                    this.fAxis = new _AxisCanvas();
                }
            }
        }
        this.setFigureComponent((FigureComponent)((Object)this.fAxis));
        this.fComponent.setName("fAxisComponentProxy");
        this.fNotificationHandler.handleNotification(new FigureComponentNotification(1, this.getComponent(), this.isLightweight()));
    }

    @Override
    public void setFigureComponent(FigureComponent figureComponent) {
        if (figureComponent == null) {
            this.fAxis = null;
        }
        super.setFigureComponent(figureComponent);
    }

    public void setVisual(int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must construct axis on the EDT");
        }
        if (!this.fLightweight || this.getComponent() == null) {
            this.construct(n);
        }
    }

    public void setBackingStore(Image image) {
        this.fBackingStore = image;
    }

    @Override
    public boolean isLightweight() {
        return this.fLightweight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaint(Graphics graphics) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fNotificationHandler.handleNotification(new FigureWindowNotification(1));
        }
        if (this.fOffscreenRenderingMode) {
            if (graphics != null && this.fBackingStore != null) {
                Image image = this.fBackingStore;
                synchronized (image) {
                    graphics.drawImage(this.fBackingStore, 0, 0, null, null);
                }
            }
        } else {
            this.fNotificationHandler.handleNotification(new FigureWindowNotification(2));
            this.fNotificationHandler.handleNotification(new FigurePaintNotification(this.getComponent(), graphics));
        }
    }

    public Graphics getUIJGraphics() {
        if (this.fAxis == null) {
            return null;
        }
        return this.fAxis.getUIJGraphics();
    }

    public long getNativeWindowHandle() {
        if (this.fAxis == null) {
            return 0L;
        }
        return this.fAxis.getNativeWindowHandle();
    }

    public void paintCallback(Graphics graphics) {
        if (this.fAxis == null) {
            return;
        }
        this.fAxis.paintCallback(graphics);
    }

    public void setNativeWindowHandle(long l) {
        this.fAxis.setNativeWindowHandle(l);
    }

    public static GraphicsConfiguration chooseGraphicsConfigurationByVisual(int n) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
        if (graphicsConfigurationArray.length > 0 && PlatformInfo.isXWindows()) {
            Object[] objectArray = new Class[]{};
            Class<?> clazz = graphicsConfigurationArray[0].getClass();
            Method method = null;
            try {
                method = clazz.getMethod("getVisual", (Class<?>[])objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            if (method != null) {
                for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                    try {
                        int n2 = (Integer)method.invoke((Object)graphicsConfigurationArray[i], objectArray);
                        if (n2 == n) {
                            return graphicsConfigurationArray[i];
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public void setOffscreenRendering(boolean bl) {
        this.fOffscreenRenderingMode = bl;
    }

    private class _AxisCanvas
    extends AxisCanvas
    implements FigureComponent {
        public _AxisCanvas() {
        }

        public _AxisCanvas(GraphicsConfiguration graphicsConfiguration) {
            super(graphicsConfiguration);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (PlatformInfo.isWindows()) {
                FigureAxisComponentProxy.this.fNotificationHandler.handleNotification(new FigureWindowNotification(1));
            }
        }

        @Override
        public void paintCallback(Graphics graphics) {
            if (this.getNativeWindowHandle() == -1L) {
                return;
            }
            if (this.getNativeWindowHandle() == 0L) {
                return;
            }
            FigureAxisComponentProxy.this.doPaint(graphics);
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public boolean isComponentLightweight() {
            return false;
        }
    }
}

