/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.util.PlatformInfo;
import java.awt.Insets;
import java.awt.Window;

public class FigureInsetsUtilities {
    private static Insets sRealInsets = null;
    private static Insets sRealInsetsNonRes = null;
    private static Insets sDefaultInsets = new Insets(0, 0, 0, 0);

    private static void setupDefaultMargins() {
        sDefaultInsets = new Insets(30, 4, 4, 4);
        if (PlatformInfo.isWindows2000() || PlatformInfo.isWindowsXP() && !PlatformInfo.useWindowsXPAppearance()) {
            FigureInsetsUtilities.sDefaultInsets.top = 23;
        } else if (PlatformInfo.isUnix()) {
            FigureInsetsUtilities.sDefaultInsets.top = 23;
        } else if (PlatformInfo.isMacintosh()) {
            sDefaultInsets = new Insets(22, 0, 22, 0);
        }
    }

    public static Insets getCachedResizableFrameInsets() {
        Insets insets = null;
        if (sRealInsets == null) {
            sRealInsets = MJFrame.getCachedInsets((boolean)true);
        }
        if (sRealInsets != null) {
            insets = (Insets)sRealInsets.clone();
        }
        return insets;
    }

    static Insets getCachedNonResizableFrameInsets() {
        Insets insets = null;
        if (sRealInsetsNonRes == null) {
            sRealInsetsNonRes = MJFrame.getCachedInsets((boolean)false);
        }
        if (sRealInsetsNonRes != null) {
            insets = (Insets)sRealInsetsNonRes.clone();
        }
        return insets;
    }

    static void updateCachedNonResizableFrameInsets(Insets insets) {
        sRealInsetsNonRes = insets;
    }

    static void updateCachedResizableFrameInsets(Insets insets) {
        sRealInsets = insets;
    }

    static Insets validateInsets(Insets insets, boolean bl) {
        Insets insets2;
        if (insets != null) {
            assert (MJFrame.areInsetsPositive((Insets)insets));
            if (PlatformInfo.isWindows() && insets.top == 0 && insets.bottom == 0 && insets.left == 0 && insets.right == 0) {
                insets = null;
            }
        }
        if (insets == null) {
            insets2 = (Insets)sDefaultInsets.clone();
            if (PlatformInfo.isWindows() && !bl) {
                --insets2.top;
                --insets2.bottom;
                --insets2.left;
                --insets2.right;
            }
        } else {
            insets2 = (Insets)insets.clone();
        }
        return insets2;
    }

    static Insets getInsetsForInvisibleResizableWindow() {
        Insets insets = FigureInsetsUtilities.getCachedResizableFrameInsets();
        insets = FigureInsetsUtilities.validateInsets(insets, true);
        return insets;
    }

    static Insets getWindowInsets(Window window) {
        Insets insets = window.getInsets();
        if (insets != null && MJFrame.areInsetsPositive((Insets)insets)) {
            return insets;
        }
        return null;
    }

    static {
        FigureInsetsUtilities.setupDefaultMargins();
    }
}

