/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.ActiveXCanvas;
import com.mathworks.hg.peer.BlockOnResizeAndWindowStyleChangeState;
import com.mathworks.hg.peer.BlockedOnPositionState;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureBoundsNotification;
import com.mathworks.hg.peer.FigureClient;
import com.mathworks.hg.peer.FigureHG1Client;
import com.mathworks.hg.peer.FigureHG1Mediator;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.HG1WindowRectHandler;
import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.WindowRectHandler;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class HG1FigurePeer
extends FigurePeer {
    public FigureHG1Client fHG1Client;
    private boolean fUnitTestRequest = false;
    private boolean fUnitTest = false;

    public HG1FigurePeer() throws Throwable {
        super(null, 0, false);
    }

    public HG1FigurePeer(int n, boolean bl) throws Throwable {
        super(n, bl);
    }

    public HG1FigurePeer(Desktop desktop, int n, boolean bl) throws Throwable {
        super(desktop, n, bl);
    }

    protected HG1FigurePeer(Desktop desktop, boolean bl) {
        this.fUnitTestRequest = bl;
        this.unitTestInitializePeer(desktop, 0);
    }

    protected HG1FigurePeer(boolean bl) {
        this.fUnitTestRequest = bl;
        this.unitTestInitializePeer(null, 0);
    }

    private void unitTestInitializePeer(final Desktop desktop, final int n) {
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    HG1FigurePeer.this.doInitializePeer(desktop, n);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected WindowRectHandler createWindowRectHandler() {
        return new HG1WindowRectHandler();
    }

    @Override
    protected FigureClient createFigureClient(Desktop desktop, String string, boolean bl, String string2, int n) {
        if (this.fUnitTestRequest && !FigurePeer.sNativeHGLibLoaded) {
            this.fUnitTest = true;
        }
        this.fHG1Client = new FigureHG1Mediator(desktop, string, bl, string2, this, this.fUnitTest);
        return this.fHG1Client;
    }

    @Override
    public ActiveXCanvas getActiveXCanvasImpl() {
        ActiveXCanvas activeXCanvas = null;
        if (this.getNativeWindowHandle() == 0L) {
            this.createFigureHidden();
        } else {
            activeXCanvas = HeavyweightLightweightContainerFactory.getActiveXContainer(this);
            this.addActiveXControl(activeXCanvas);
        }
        return activeXCanvas;
    }

    @Override
    protected void createHWNDForActiveXImpl(ActiveXCanvas activeXCanvas) {
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.getAxisComponent().addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.getAxisComponent().removeFocusListener(focusListener);
    }

    @Override
    protected void setVisualImpl(int n) {
        DebugUtilities.logMessage(32, "FigurePeer.setVisualImpl " + n, this);
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this method from event dispatch thread";
        this.fHG1Client.setClientVisual(n);
    }

    @Override
    protected void setBackingStore(Image image) {
        this.fHG1Client.setBackingStore(image);
        this.fFigureClient.getFigurePanelContainer().repaint();
    }

    @Override
    public BlockedOnPositionState createBlockedOnPositionState() {
        BlockOnResizeAndWindowStyleChangeState blockOnResizeAndWindowStyleChangeState = new BlockOnResizeAndWindowStyleChangeState(this, this.fFigureClient);
        blockOnResizeAndWindowStyleChangeState.setNotificationSuccessor(this);
        return blockOnResizeAndWindowStyleChangeState;
    }

    @Override
    public void clearWaitForResize(boolean bl, boolean bl2) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        this.fBlockedOnPositionState.clearWaitForResize(bl, bl2);
    }

    @Override
    public void setWaitForResize(boolean bl) {
        this.fBlockedOnPositionState.setWaitForResize(bl);
    }

    @Override
    public boolean getWaitForResize() {
        Rectangle rectangle;
        Rectangle rectangle2;
        boolean bl = this.fBlockedOnPositionState.getWaitForResize();
        if (bl && (rectangle2 = this.fWindowRectHandler.getBounds()).equals(rectangle = this.fWindowRectHandler.getBounds(true))) {
            this.fBlockedOnPositionState.stopWaiting();
        }
        return bl;
    }

    @Override
    public boolean getWaitForWindowStyle() {
        return this.fBlockedOnPositionState.getWaitForWindowStyle();
    }

    @Override
    protected void handleFigureBoundsNotification(FigureBoundsNotification figureBoundsNotification) {
        assert (false) : "HG1FigurePeer::handleFigureBoundsNotification should never be called.";
    }

    @Override
    public void doShowContextMenu(JPopupMenu jPopupMenu, int n, int n2) {
        assert (SwingUtilities.isEventDispatchThread());
        Point point = new Point(n, n2);
        if (this.isWindowDocked()) {
            Rectangle rectangle = this.getDrawableRect();
            point.translate(-rectangle.x, -rectangle.y);
            Rectangle rectangle2 = this.getWindowRect();
            point.translate(rectangle2.x, rectangle2.y);
        }
        this.fWindowRectHandler.moveContainerPointToClientPoint(this.fFigureClient.getLocation(), point);
        this.doShowContextMenuInComponentContainer(jPopupMenu, point.x, point.y);
    }

    @Override
    protected boolean shouldSetWindowResizableBeApplied() {
        return this.isListenersEnabled();
    }

    @Override
    protected Rectangle getDrawableRectHelper(Rectangle rectangle) {
        Point point;
        if (this.fCurrentWindowStyle == FigurePeer.WindowStyle.DOCKED && (point = this.fFigureClient.getContainerLocation()) != null) {
            rectangle.translate(point.x, point.y);
        }
        assert (rectangle != null);
        return rectangle;
    }
}

