/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.event.UicontrolEvent;
import com.mathworks.hg.peer.event.UicontrolUserEvent;
import com.mathworks.hg.peer.types.HGBasicScrollBarUI;
import com.mathworks.hg.print.PrintUtilities;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.mwswing.MJScrollBar;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPeer
extends AbstractUicontrolPeer {
    private static double INF_MAX_STEP = 1000.0;
    private static int PRECISION = 6;
    MLScrollBar fSlider;
    SliderUicontrolActionListener fListener;
    boolean fFireCallback;
    private double[] fHGSteps;
    private double[] fHGValues;
    private double fHGMax;
    private double fHGMin;
    private boolean fInfSlider = false;
    private double fPrecisionFactor;
    private static final int sFirstMethodIndex;
    protected static final int sSetControlSliderStep;
    private static final int sLastMethodIndex;
    private static final String[] sLogMessages;

    public SliderPeer() {
        this.fType = 1;
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = n >= sFirstMethodIndex && n <= sLastMethodIndex ? sLogMessages[n - sFirstMethodIndex] : super.getUserMethodDescription(n);
        return string;
    }

    @Override
    protected void createComponent() {
        this.fSlider = new MLScrollBar();
        this.fComponent = this.fSlider;
        this.fHGValues = new double[1];
        this.fHGSteps = new double[2];
        this.fHGSteps[0] = 0.01;
        this.fHGSteps[1] = 0.1;
        this.fHGValues[0] = 0.0;
        this.updateSlider();
    }

    @Override
    protected void doSetPosition(double d, double d2, double d3, double d4) {
        int n = 0;
        double d5 = 15.0;
        if (d3 > d4) {
            if (PlatformInfo.isMacintosh()) {
                d2 -= d4 - d5;
                d4 = d5;
            }
        } else {
            if (PlatformInfo.isMacintosh()) {
                d += d3 - d5;
                d3 = d5;
            }
            n = 1;
        }
        super.doSetPosition(d, d2, d3, d4);
        if (this.fSlider.getOrientation() != n) {
            this.removeUicontrolActionListeners();
            this.fSlider.setOrientation(n);
            this.addUicontrolActionListeners();
            this.updateSlider();
        }
    }

    @Override
    protected void addUicontrolActionListeners() {
        if (this.fListener == null) {
            this.fListener = new SliderUicontrolActionListener();
            this.fSlider.getModel().addChangeListener(this.fListener);
            this.fSlider.addMouseListener(this.fListener);
        }
    }

    @Override
    protected void removeUicontrolActionListeners() {
        if (this.fListener != null) {
            this.fSlider.getModel().removeChangeListener(this.fListener);
            this.fSlider.removeMouseListener(this.fListener);
            this.fListener = null;
        }
    }

    @Override
    protected boolean doPreSetValue(double[] dArray, double d, double d2) {
        this.addLogMessage(11);
        return true;
    }

    @Override
    protected void doSetValue(double[] dArray, double d, double d2) {
        if (d - d2 > 0.0 && dArray != null && dArray.length > 0) {
            this.fHGValues[0] = dArray[0];
            this.fHGMax = d;
            this.fHGMin = d2;
            this.updateSlider();
        }
    }

    private void updateSlider() {
        this.removeUicontrolActionListeners();
        double d = this.getSliderLength();
        double d2 = this.fInfSlider ? INF_MAX_STEP * d : this.fHGSteps[1] * d;
        double d3 = -d2;
        double d4 = d;
        double d5 = this.fHGSteps[0] == 0.0 ? 0.0 : 1.0;
        double d6 = (this.fHGValues[0] - this.fHGMin) * d / (this.fHGMax - this.fHGMin) - d2;
        if (1 == this.fSlider.getOrientation()) {
            d6 = (this.fHGValues[0] - this.fHGMin) * d / (this.fHGMax - this.fHGMin);
            d6 = this.convertValue(d6) - d2;
        }
        double d7 = this.fPrecisionFactor;
        this.updatePrecisionFactor();
        d6 *= this.fPrecisionFactor;
        this.fSlider.setMinimum((int)(d3 *= this.fPrecisionFactor));
        this.fSlider.setMaximum((int)Math.ceil(d4 *= this.fPrecisionFactor));
        this.fSlider.setUnitIncrement(this.fInfSlider ? 0 : (int)(d5 *= this.fPrecisionFactor));
        this.fSlider.setBlockIncrement(this.fInfSlider ? 0 : (int)(d2 *= this.fPrecisionFactor));
        if (d7 != this.fPrecisionFactor) {
            this.fSlider.setVisibleAmount((int)d2);
        }
        this.setSliderValue(d6);
        this.fSlider.setVisibleAmount((int)d2);
        this.addUicontrolActionListeners();
    }

    private void updatePrecisionFactor() {
        if (this.fHGSteps[0] == 0.0) {
            this.fPrecisionFactor = 1.0;
            return;
        }
        int n = (int)Math.log10(this.fHGSteps[0]);
        this.fPrecisionFactor = n < -PRECISION ? 1.0 : Math.pow(10.0, PRECISION + n);
    }

    private void setSliderValue(double d) {
        if (d == this.fHGMax) {
            this.fSlider.setValue((int)Math.ceil(d));
        } else {
            this.fSlider.setValue((int)Math.round(d));
        }
    }

    @Override
    protected double[] doGetValue() {
        double d;
        double d2 = this.fSlider.getValue() + this.fSlider.getVisibleAmount();
        if (1 == this.fSlider.getOrientation()) {
            d2 = this.getSliderLength() * this.fPrecisionFactor - d2;
        }
        this.fHGValues[0] = (d = (this.fHGMax - this.fHGMin) * this.fHGSteps[0] * d2 / this.fPrecisionFactor + this.fHGMin) > this.fHGMax ? this.fHGMax : (d < this.fHGMin ? this.fHGMin : d);
        return this.fHGValues;
    }

    public final void setControlSliderStep(final double[] dArray) {
        if (this.doPreSetSliderStep(dArray)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetControlSliderStep){

                @Override
                public void run() {
                    SliderPeer.this.doSetSliderStep(dArray);
                }
            });
        }
    }

    @Override
    protected boolean doPreSetSliderStep(double[] dArray) {
        this.addLogMessage(sSetControlSliderStep);
        return true;
    }

    @Override
    protected void doSetSliderStep(double[] dArray) {
        if (dArray != null && dArray.length == 2) {
            this.fHGSteps[0] = dArray[0];
            this.fHGSteps[1] = dArray[1] > INF_MAX_STEP ? Double.POSITIVE_INFINITY : dArray[1];
            this.fInfSlider = Double.isInfinite(this.fHGSteps[1]);
            this.updateSlider();
        }
    }

    @Override
    protected void doSetInactive() {
        super.doSetInactive();
        if (this.fEnable == 1) {
            this.doSetSliderStep(this.fHGSteps);
        } else {
            this.fSlider.setUnitIncrement(0);
        }
    }

    @Override
    public void addLogMessage(int n) {
        if (DebugUtilities.isDebugOptions() && n <= this.getUserLastMethodID()) {
            if (n < sFirstMethodIndex) {
                super.addLogMessage(n);
            } else {
                DebugUtilities.logMessage(32, this.getClass().getName() + "." + this.getUserMethodDescription(n), this);
            }
        }
    }

    private double convertValue(double d) {
        return this.getSliderLength() - d;
    }

    private double getSliderLength() {
        double d = Math.pow(10.0, PRECISION);
        return this.fHGSteps[0] == 0.0 || this.fHGSteps[0] < 1.0 / d ? d : 1.0 / this.fHGSteps[0];
    }

    static {
        sLastMethodIndex = sSetControlSliderStep = (sFirstMethodIndex = AbstractUicontrolPeer.getLastMethodIndex() + 1);
        sLogMessages = new String[]{"setControlSliderStep"};
    }

    private class MLScrollBar
    extends MJScrollBar {
        public MLScrollBar() {
            super(0, 0, 10000, 0, 110000);
            this.setRequestFocusEnabled(true);
        }

        public boolean isFocusable() {
            return true;
        }

        public void print(Graphics graphics) {
            if (PlatformInfo.isLinux() && graphics.toString().contains("MWPSGraphics2D")) {
                PrintUtilities.drawComponentAsImageToGraphics((JComponent)((Object)this), graphics);
            } else {
                super.print(graphics);
            }
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (SliderPeer.this.fInfSlider && aWTEvent.getID() == 506) {
                return;
            }
            if (SliderPeer.this.fEnable == 1) {
                if (SliderPeer.this.fListener != null && SliderPeer.this.fListener.getIgnoreAdjusting() && aWTEvent.getID() == 506) {
                    SliderPeer.this.fListener.setIgnoreAdjusting(false);
                    return;
                }
                super.processEvent(aWTEvent);
            } else {
                SliderPeer.this.doProcessEvent(aWTEvent);
            }
        }

        public void updateUI() {
            String string = UIManager.getLookAndFeel().getClass().getName();
            if (string.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                this.setUI(new HGBasicScrollBarUI());
            } else if (PlatformInfo.isMacintosh()) {
                this.setUI(new HGBasicScrollBarUI());
            } else {
                super.updateUI();
            }
        }
    }

    private class SliderUicontrolActionListener
    extends MouseAdapter
    implements ChangeListener {
        private boolean ignoreAdjusting = false;

        private SliderUicontrolActionListener() {
        }

        public boolean getIgnoreAdjusting() {
            return this.ignoreAdjusting;
        }

        public void setIgnoreAdjusting(boolean bl) {
            this.ignoreAdjusting = bl;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.setIgnoreAdjusting(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.setIgnoreAdjusting(false);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            EventObject eventObject;
            boolean bl = SliderPeer.this.fSlider.getValueIsAdjusting();
            double d = SliderPeer.this.fHGValues[0];
            SliderPeer.this.doGetValue();
            double[] dArray = SliderPeer.this.getControlValue();
            assert (dArray != null);
            if (d != dArray[0]) {
                eventObject = new UicontrolUserEvent(SliderPeer.this, changeEvent.getSource());
                SliderPeer.this.fireUicontrolUserAction((UicontrolUserEvent)eventObject);
            }
            if (!bl || this.ignoreAdjusting) {
                eventObject = new UicontrolEvent(SliderPeer.this, changeEvent.getSource());
                SliderPeer.this.fireUicontrolAction((UicontrolEvent)eventObject);
            }
            SliderPeer.this.refreshUicontrol();
        }
    }
}

