/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureChild;
import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.jmi.Matlab;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.SwingUtilities;

class UIPanel {
    private Container fPanel = HeavyweightLightweightContainerFactory.getUIComponentContainer();
    private Component fComponent;
    private double fUIContainer;
    private ComponentListener fListener;

    UIPanel(UIComponentParent uIComponentParent, Component component, FigureChild figureChild) {
        this.fComponent = component;
        this.fUIContainer = 0.0;
        this.addListeners();
    }

    void addListeners() {
        if (this.fListener != null) {
            this.removeListeners();
        } else {
            this.fListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    UIPanel.this.updatePosition();
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    UIPanel.this.updateVisible();
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    UIPanel.this.updateVisible();
                }
            };
        }
        this.fComponent.addComponentListener(this.fListener);
    }

    void removeListeners() {
        this.fComponent.removeComponentListener(this.fListener);
    }

    void addTo(Container container) {
        this.fPanel.add(this.fComponent);
        this.fPanel.setVisible(this.fComponent.isVisible());
        container.add(this.fPanel, null, 0);
    }

    void removeFrom(Container container) {
        this.removeListeners();
        this.fListener = null;
        UIPanel.removeFrom(container, this.fPanel, this.fComponent);
    }

    static void removeFrom(Container container, Container container2, Component component) {
        container2.remove(component);
        if (container2.getParent() != container) {
            return;
        }
        container.remove(container2);
        container.invalidate();
        Container container3 = container.getParent();
        if (container3 != null) {
            container3.validate();
        }
    }

    void updatePosition() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UIPanel.this.fPanel.getParent() != null) {
                    UIPanel.this.fPanel.validate();
                }
            }
        });
    }

    void updateVisible() {
        if (this.fPanel.getParent() != null) {
            if (this.fUIContainer != 0.0) {
                Matlab.whenMatlabReady((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String string = UIPanel.this.fComponent.isVisible() ? "on" : "off";
                            Matlab.mtFeval((String)"set", (Object[])new Object[]{UIPanel.this.fUIContainer, "Visible", string}, (int)0);
                        }
                        catch (Exception exception) {
                            throw new Error(exception);
                        }
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIPanel.this.fPanel.setVisible(UIPanel.this.fComponent.isVisible());
                }
            });
        }
    }

    public void setUIContainer(double d) {
        this.fUIContainer = d;
    }
}

