/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.HGColor;
import com.mathworks.util.CategoricalVariable;
import com.mathworks.util.StyledColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class HGStyledColor
extends HGColor {
    protected String fStyleName;
    protected final List<String> fAllowedStyles;
    protected boolean fIsColor;

    public HGStyledColor(double d, double d2, double d3, double d4, List<String> list) {
        super(d, d2, d3, d4);
        this.fStyleName = null;
        this.fIsColor = true;
        this.fAllowedStyles = new ArrayList<String>(list);
    }

    public HGStyledColor(double d, double d2, double d3, List<String> list) {
        this(d, d2, d3, 1.0, list);
    }

    private double[] getComponents() {
        return new double[]{this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()};
    }

    public HGStyledColor(String string, List<String> list) {
        super(0.0, 0.0, 0.0);
        if (list == null) {
            throw new IllegalArgumentException("Argument allowedStyles must not be null.");
        }
        assert (list.contains(string)) : "styleName is not an allowed style: " + string;
        this.fStyleName = string;
        this.fIsColor = false;
        this.fAllowedStyles = new ArrayList<String>(list);
    }

    private static HGStyledColor newInstance(double d, double d2, double d3, double d4, String[] stringArray) {
        assert (stringArray != null) : "Argument allowedStyles must not be null";
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        Collections.addAll(arrayList, stringArray);
        return new HGStyledColor(d, d2, d3, d4, arrayList);
    }

    private static HGStyledColor newInstance(String string, String[] stringArray) {
        assert (string != null) : "Argument style must not be null";
        assert (stringArray != null) : "Argument allowedStyles must not be null";
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        Collections.addAll(arrayList, stringArray);
        return new HGStyledColor(string, arrayList);
    }

    public CategoricalVariable<Integer> getStyleCategory() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 0; i < this.fAllowedStyles.size(); ++i) {
            hashMap.put(i, this.fAllowedStyles.get(i));
        }
        hashMap.put(-1, "");
        CategoricalVariable categoricalVariable = new CategoricalVariable(hashMap, null);
        if (this.fStyleName == null) {
            categoricalVariable.setValue((Object)-1);
        } else {
            categoricalVariable.setValue(categoricalVariable.findValueByLabel(this.fStyleName));
        }
        return categoricalVariable;
    }

    public void setStyleCategory(CategoricalVariable<Integer> categoricalVariable) {
        assert (this.fAllowedStyles != null);
        for (String string : this.fAllowedStyles) {
            assert (categoricalVariable.getCategories().values().contains(string));
        }
        this.fStyleName = categoricalVariable.getLabel();
        this.fIsColor = this.fStyleName == null || "".equals(this.fStyleName);
    }

    public List<String> getAllowedStyles() {
        return Collections.unmodifiableList(this.fAllowedStyles);
    }

    public String getFullStyleName(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        for (String string2 : this.fAllowedStyles) {
            if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
            return string2;
        }
        return null;
    }

    public boolean isStyleAllowed(String string) {
        return this.getFullStyleName(string) != null;
    }

    public double[] getMatlabRGB() {
        return new double[]{this.getRed() / 255.0, this.getGreen() / 255.0, this.getBlue() / 255.0};
    }

    public boolean isStyle() {
        return !this.fIsColor;
    }

    public boolean isColor() {
        return this.fIsColor;
    }

    public String getStyleName() {
        return this.fStyleName;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HGStyledColor)) {
            return false;
        }
        if (this.fIsColor != ((HGStyledColor)object).isColor()) {
            return false;
        }
        if (this.fStyleName == null && ((HGStyledColor)object).getStyleName() != null) {
            return false;
        }
        if (this.fStyleName != null && ((HGStyledColor)object).getStyleName() == null) {
            return false;
        }
        if (this.fStyleName != null && !this.fStyleName.equals(((HGStyledColor)object).getStyleName())) {
            return false;
        }
        if (this.fAllowedStyles == null && ((HGStyledColor)object).getAllowedStyles() != null) {
            return false;
        }
        if (this.fAllowedStyles != null && ((HGStyledColor)object).getAllowedStyles() == null) {
            return false;
        }
        if (this.fAllowedStyles != null && !this.fAllowedStyles.equals(((HGStyledColor)object).getAllowedStyles())) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(super.hashCode()).append(this.fAllowedStyles).toHashCode();
    }

    public static HGStyledColor valueOf(StyledColor styledColor) {
        if (styledColor == null) {
            return null;
        }
        if (styledColor.isStyle()) {
            return new HGStyledColor(styledColor.getStyleName(), styledColor.getAllowedStyles());
        }
        return new HGStyledColor((double)styledColor.getRed() / 255.0, (double)styledColor.getGreen() / 255.0, (double)styledColor.getBlue() / 255.0, (double)styledColor.getAlpha() / 255.0, styledColor.getAllowedStyles());
    }

    public StyledColor colorValue() {
        if (this.isColor()) {
            return new StyledColor(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha(), this.getAllowedStyles());
        }
        return new StyledColor(this.getStyleName(), this.getAllowedStyles());
    }
}

