/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.linestyleeditor;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.StyleModel;
import com.mathworks.hg.types.LineSpec;
import com.mathworks.hg.types.LineStyleSpecifier;
import com.mathworks.hg.types.MarkerSpecifier;
import com.mathworks.hg.types.Resources;
import com.mathworks.util.DebugUtils;
import java.awt.Color;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;

final class LineStyleTableModel
extends AbstractTableModel
implements StyleModel {
    private final List<LineSpec> lineStyles;
    private final Color BACKGROUND1 = UIManager.getColor("Table.background");
    private final Color BACKGROUND2 = new Color(253, 253, 244);
    private final CellStyle cellStyle = new CellStyle();

    LineStyleTableModel(List<LineSpec> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument lineStyles must not be null");
        }
        this.lineStyles = list;
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int n) {
        return Columns.values()[n].toString();
    }

    @Override
    public int getRowCount() {
        return this.lineStyles.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        assert (n >= 0 && n < Columns.values().length) : "Column index=" + n;
        Columns columns = Columns.values()[n];
        switch (columns) {
            case LINE: {
                return LineStyleSpecifier.class;
            }
            case MARKER: {
                return MarkerSpecifier.class;
            }
        }
        throw new AssertionError((Object)("Column class unknown: " + n));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        assert (this.lineStyles != null && n >= 0 && n < this.lineStyles.size()) : "Row index=" + n;
        assert (n2 >= 0 && n2 < Columns.values().length) : "Column index=" + n2;
        Columns columns = Columns.values()[n2];
        LineSpec lineSpec = this.lineStyles.get(n);
        assert (lineSpec != null);
        switch (columns) {
            case LINE: {
                return lineSpec.getLineStyleSpecifier();
            }
            case MARKER: {
                return lineSpec.getMarkerSpecifier();
            }
        }
        assert (DebugUtils.warning((String)("Unknown value for column: " + (Object)((Object)columns))));
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        assert (this.lineStyles != null && n >= 0 && n < this.lineStyles.size()) : "Row index=" + n;
        assert (n2 >= 0 && n2 < Columns.values().length) : "Column index=" + n2;
        Columns columns = Columns.values()[n2];
        LineSpec lineSpec = this.lineStyles.get(n);
        assert (lineSpec != null);
        switch (columns) {
            case LINE: {
                LineStyleSpecifier lineStyleSpecifier = (LineStyleSpecifier)((Object)object);
                this.lineStyles.set(n, new LineSpec(lineStyleSpecifier, lineSpec.getMarkerSpecifier()));
                break;
            }
            case MARKER: {
                MarkerSpecifier markerSpecifier = (MarkerSpecifier)((Object)object);
                this.lineStyles.set(n, new LineSpec(lineSpec.getLineStyleSpecifier(), markerSpecifier));
                break;
            }
            default: {
                assert (DebugUtils.warning((String)("Invalid column: " + (Object)((Object)columns))));
                break;
            }
        }
    }

    public CellStyle getCellStyleAt(int n, int n2) {
        if (n % 2 == 0) {
            this.cellStyle.setBackground(this.BACKGROUND1);
        } else {
            this.cellStyle.setBackground(this.BACKGROUND2);
        }
        return this.cellStyle;
    }

    public boolean isCellStyleOn() {
        return true;
    }

    static final class Columns
    extends Enum<Columns> {
        public static final /* enum */ Columns LINE = new Columns(Resources.getBundle().getString("linestyletable.column.line"));
        public static final /* enum */ Columns MARKER = new Columns(Resources.getBundle().getString("linestyletable.column.marker"));
        private final String name;
        private static final /* synthetic */ Columns[] $VALUES;

        public static Columns[] values() {
            return (Columns[])$VALUES.clone();
        }

        public static Columns valueOf(String string) {
            return Enum.valueOf(Columns.class, string);
        }

        private Columns(String string2) {
            assert (string2 != null);
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        static {
            $VALUES = new Columns[]{LINE, MARKER};
        }
    }
}

