/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.hg.types.table.TablePropertyModel;
import com.mathworks.hg.types.table.panel.PropertyPanelEnum;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public abstract class AbstractEditorPanel
extends MJPanel {
    public static final ResourceBundle EDITOR_RESOURCES = ResourceBundle.getBundle("com.mathworks.hg.types.table.resources.RES_TableEditor");
    PropertyPanelEnum panelType;
    TablePropertyModel propertyModel;

    public AbstractEditorPanel(PropertyPanelEnum propertyPanelEnum, TablePropertyModel tablePropertyModel) {
        this.panelType = propertyPanelEnum;
        this.propertyModel = tablePropertyModel;
        this.buildPanel(propertyPanelEnum.getLongDescription());
        this.initializePanel();
    }

    public PropertyPanelEnum getEditorPanelType() {
        return this.panelType;
    }

    private void buildPanel(String string) {
        JPanel jPanel = this.buildTitlePanel(string);
        JPanel jPanel2 = this.buildEditorPanel();
        FormLayout formLayout = new FormLayout("fill:p:g(1.0)", "p, fill:p:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)((Object)this));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(1, 2));
    }

    JPanel buildTitlePanel(String string) {
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.setFont(mJLabel.getFont().deriveFont(1));
        mJLabel.setBorder(Borders.createEmptyBorder((String)"0dlu, 4dlu, 0dlu, 4dlu"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(3));
        mJPanel.add((Component)mJLabel);
        mJPanel.setOpaque(true);
        mJPanel.setBackground(ColorUtils.getDarkenedHeadingBackground((JComponent)mJPanel));
        mJPanel.setForeground(ColorUtils.getDarkenedHeadingForeground((JComponent)mJPanel));
        return mJPanel;
    }

    String getResourceString(String string) {
        try {
            return EDITOR_RESOURCES.getString(string);
        }
        catch (Exception exception) {
            System.out.println("Resource " + string + " is missing from the table editor resource file.");
            return "";
        }
    }

    boolean getBooleanValue(String string) {
        boolean bl = false;
        Object object = this.propertyModel.getProperty(string);
        if (object != null) {
            if (object instanceof String) {
                bl = "on".equals(object);
            } else if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
        }
        return bl;
    }

    void setBooleanValue(String string, Object object) {
        if (this.propertyModel.hasProperty(string) && object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            Object object2 = this.propertyModel.getProperty(string);
            if (object2 instanceof String) {
                this.propertyModel.putProperty(string, bl != false ? "on" : "off");
            } else if (object2 instanceof Boolean) {
                this.propertyModel.putProperty(string, bl);
            }
        }
    }

    List<Color> getColorValues(String string, String string2) {
        double[] dArray;
        int n;
        ArrayList<Color> arrayList = new ArrayList<Color>();
        Object object = this.propertyModel.getProperty(string);
        if (object != null && (n = (dArray = (double[])object).length) > 0 && n % 3 == 0) {
            int n2 = 0;
            while (n2 * 3 < n) {
                float f = Double.valueOf(dArray[n2]).floatValue();
                float f2 = Double.valueOf(dArray[n2 + n / 3]).floatValue();
                float f3 = Double.valueOf(dArray[n2 + n / 3 * 2]).floatValue();
                arrayList.add(new Color(f, f2, f3));
                ++n2;
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(UIManager.getColor(string2));
        }
        return arrayList;
    }

    void setColorValue(String string, List<Color> list) {
        if (this.propertyModel.hasProperty(string) && list != null) {
            double[] dArray = new double[list.size() * 3];
            for (int i = 0; i < list.size(); ++i) {
                dArray[i] = (double)list.get(i).getRed() / 255.0;
                dArray[i + list.size()] = (double)list.get(i).getGreen() / 255.0;
                dArray[i + 2 * list.size()] = (double)list.get(i).getBlue() / 255.0;
            }
            this.propertyModel.putProperty(string, dArray);
        }
    }

    void setMetadataValue(String string, Object object) {
        Object[] objectArray = this.propertyModel.getProperty("PropertyMetaData");
        if (objectArray != null && objectArray instanceof Object[]) {
            Object[] objectArray2 = objectArray;
            String[] stringArray = (String[])objectArray2[0];
            Object[] objectArray3 = (Object[])objectArray2[1];
            String[] stringArray2 = new String[stringArray.length + 1];
            Object[] objectArray4 = new Object[objectArray3.length + 1];
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
                objectArray4[i] = objectArray3[i];
                if (!stringArray[i].equals(string)) continue;
                objectArray3[i] = object;
                bl = true;
                break;
            }
            if (!bl) {
                stringArray2[i] = string;
                objectArray4[i] = object;
                objectArray = new Object[]{stringArray2, objectArray4};
            }
        }
        this.propertyModel.putProperty("PropertyMetaData", objectArray);
    }

    Object getMetadataValue(String string) {
        Object object = null;
        Object object2 = this.propertyModel.getProperty("PropertyMetaData");
        if (object2 != null && object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            String[] stringArray = (String[])objectArray[0];
            Object[] objectArray2 = (Object[])objectArray[1];
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                object = objectArray2[i];
                break;
            }
        }
        return object;
    }

    public void update() {
        this.initializePanel();
    }

    protected abstract JPanel buildEditorPanel();

    protected abstract void initializePanel();

    public abstract boolean validatePanel();

    public abstract void cleanup();

    public abstract void commit();
}

