/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.jogamp.nativewindow.awt.AWTPrintLifecycle;
import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.HGOutputFlags;
import com.mathworks.hg.util.GraphicsDeviceUtilities;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelperProcessingException;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

public abstract class OutputHelper {
    protected MPrintJob fPrintJob;
    protected AWTPrintLifecycle.Context fPrintContext = null;

    public OutputHelper(MPrintJob mPrintJob) {
        this.fPrintJob = mPrintJob;
    }

    public abstract void open(FigurePanelContainer var1) throws OutputHelperProcessingException;

    public void beginPage() throws OutputHelperProcessingException {
    }

    public abstract void generateOutput(FigurePanelContainer var1) throws OutputHelperProcessingException;

    public void endPage() throws OutputHelperProcessingException {
    }

    public abstract void close() throws OutputHelperProcessingException;

    public boolean supportsGettingCDataFromBufferedImage() {
        return false;
    }

    public BufferedImage getBufferedImage() throws OutputHelperProcessingException {
        return null;
    }

    public boolean supportsMultiplePages() {
        return false;
    }

    public boolean supportsGettingDataForClipboard() {
        return false;
    }

    public ByteArrayOutputStream getDataForClipboard() throws OutputHelperProcessingException {
        return null;
    }

    public void release() throws OutputHelperProcessingException {
    }

    public void validateContainerState(Container container) throws OutputHelperProcessingException {
        assert (this.fPrintJob.getDesired_Height() != 0);
        assert (this.fPrintJob.getDesired_Width() != 0);
        if (!GraphicsEnvironment.isHeadless() && !container.isDisplayable()) {
            throw new OutputHelperProcessingException("Target container is not displayable. Perhaps the figure was not made visible?");
        }
    }

    public void validateContainerSize(Container container) {
        assert (EventQueue.isDispatchThread());
        if (container.getWidth() != this.fPrintJob.getDesired_Width() || container.getHeight() != this.fPrintJob.getDesired_Height()) {
            container.setSize(this.fPrintJob.getDesired_Width(), this.fPrintJob.getDesired_Height());
            container.validate();
        }
    }

    public HGOutputFlags setFlagsFromPrintjob(MPrintJob mPrintJob) {
        HGOutputFlags hGOutputFlags = new HGOutputFlags();
        hGOutputFlags.setClearBackground(!mPrintJob.getTransparent());
        hGOutputFlags.setPrintUI(mPrintJob.isShowUI());
        hGOutputFlags.setDebugMode(mPrintJob.isDebugMode());
        hGOutputFlags.setCalledFromMATLAB(true);
        return hGOutputFlags;
    }

    protected void prePrint(Container container) {
        double d = this.fPrintJob.getScaledDPI();
        double d2 = 1.0;
        if (d > 0.0) {
            d2 = (double)GraphicsDeviceUtilities.getDefaultScreenResolution() / d;
        }
        int n = 0;
        this.fPrintContext = AWTPrintLifecycle.Context.setupPrint((Container)container, (double)d2, (double)d2, (int)n, (int)-1, (int)-1);
    }

    protected void postPrint() {
        this.fPrintContext.releasePrint();
        this.fPrintContext = null;
    }
}

