/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.util.Vector;
import javax.swing.JComponent;

public class UIFocusTraversalPolicy
extends DefaultFocusTraversalPolicy {
    private Vector<Component> collectChildren(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("focusCycleRoot can't be null");
        }
        Vector<Component> vector = new Vector<Component>();
        this.collect(vector, container);
        return vector;
    }

    protected boolean isComponentScreenStateOkForFocusTransfer(Component component) {
        return false != component.isShowing() && false != component.isEnabled();
    }

    @Override
    protected boolean accept(Component component) {
        if (!super.accept(component)) {
            return false;
        }
        if (!this.isComponentScreenStateOkForFocusTransfer(component)) {
            return false;
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Object object = jComponent.getClientProperty("TabCycleParticipant");
            if (object == null) {
                return false;
            }
            return (Boolean)object;
        }
        return false;
    }

    private void collect(Vector<Component> vector, Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(n - i - 1);
            if (this.accept(component)) {
                vector.addElement(component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.collect(vector, (Container)component);
        }
    }

    @Override
    public Component getFirstComponent(Container container) {
        Vector<Component> vector = this.collectChildren(container);
        if (vector.isEmpty()) {
            return null;
        }
        return vector.firstElement();
    }

    @Override
    public Component getLastComponent(Container container) {
        Vector<Component> vector = this.collectChildren(container);
        if (vector.isEmpty()) {
            return null;
        }
        return vector.lastElement();
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        Component component2;
        Vector<Component> vector = this.collectChildren(container);
        int n = vector.indexOf(component);
        Component component3 = component2 = n + 1 >= vector.size() ? null : vector.elementAt(n + 1);
        if (component2 == null) {
            if (!vector.isEmpty()) {
                return vector.firstElement();
            }
            return null;
        }
        return component2;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        Component component2;
        Vector<Component> vector = this.collectChildren(container);
        int n = vector.indexOf(component);
        Component component3 = component2 = n - 1 < 0 ? null : vector.elementAt(n - 1);
        if (component2 == null) {
            if (!vector.isEmpty()) {
                return vector.lastElement();
            }
            return null;
        }
        return component2;
    }
}

