/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.alignmenttool;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.matlab.guide.alignmenttool.AlignmentType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class AlignmentPanel
extends MJPanel
implements ActionListener {
    public static final ResourceBundle ALIGN_RESOURCES = ResourceBundle.getBundle("com.mathworks.toolbox.matlab.guide.alignmenttool.resources.RES_Alignment");
    public static final ResourceBundle NOTRANS_ALIGN_RESOURCES = ResourceBundle.getBundle("com.mathworks.toolbox.matlab.guide.alignmenttool.resources.RES_Alignment_notranslation");
    private static final int DEFAULT_DISTANCE = 20;
    public static final int OFF = 0;
    public static final int LEFT_ALIGNMENT = 1;
    public static final int CENTER_ALIGNMENT = 2;
    public static final int RIGHT_ALIGNMENT = 3;
    public static final int TOP_ALIGNMENT = 4;
    public static final int BOTTOM_ALIGNMENT = 5;
    static final int DISTRIBUTIONS = 6;
    public static final int INSIDE_DISTRIBUTION = 7;
    public static final int LEFT_DISTRIBUTION = 8;
    public static final int CENTER_DISTRIBUTION = 9;
    public static final int RIGHT_DISTRIBUTION = 10;
    public static final int TOP_DISTRIBUTION = 11;
    public static final int BOTTOM_DISTRIBUTION = 12;
    protected MJButton fApplyButton;
    protected MJButton fOkButton;
    protected MJButton fCancelButton;
    protected List<AlignmentButton> fVertButtons;
    protected List<AlignmentButton> fHorzButtons;
    protected MJCheckBox fVertUseFixedDist;
    protected MJCheckBox fHorzUseFixedDist;
    protected MJTextField fVertFixedDistValue;
    protected MJTextField fHorzFixedDistValue;
    protected MJLabel fVertPixelLabel;
    protected MJLabel fHorzPixelLabel;
    protected int fVertDistance = 20;
    protected int fHorzDistance = 20;

    public AlignmentPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(0, 1, 0, 8));
        mJPanel.add((Component)this.createVerticalAlignmentPanel());
        mJPanel.add((Component)this.createHorizontalAlignmentPanel());
        this.fOkButton = new MJButton(ALIGN_RESOURCES.getString("button.ok"));
        this.fOkButton.setName(NOTRANS_ALIGN_RESOURCES.getString("button.ok"));
        this.fOkButton.addActionListener((ActionListener)this);
        this.fApplyButton = new MJButton(ALIGN_RESOURCES.getString("button.apply"));
        this.fApplyButton.setName(NOTRANS_ALIGN_RESOURCES.getString("button.apply"));
        this.fApplyButton.addActionListener((ActionListener)this);
        this.fCancelButton = new MJButton(ALIGN_RESOURCES.getString("button.cancel"));
        this.fCancelButton.setName(NOTRANS_ALIGN_RESOURCES.getString("button.cancel"));
        this.fCancelButton.addActionListener((ActionListener)this);
        JPanel jPanel = ButtonBarFactory.buildOKCancelApplyBar((JButton)this.fOkButton, (JButton)this.fCancelButton, (JButton)this.fApplyButton);
        jPanel.setBorder(Borders.createEmptyBorder((String)"4dlu, 0dlu, 0dlu, 0dlu"));
        this.setLayout(new BorderLayout());
        this.add(jPanel, "South");
        this.add((Component)mJPanel, "Center");
        this.fOkButton.requestFocus();
    }

    private MJPanel createVerticalAlignmentPanel() {
        Object object;
        Object object22;
        MJPanel mJPanel = new MJPanel[]{AlignmentType.ALIGN_VERT_OFF, AlignmentType.ALIGN_TOP, AlignmentType.ALIGN_MIDDLE, AlignmentType.ALIGN_BOTTOM};
        MJPanel mJPanel2 = new MJPanel[]{AlignmentType.DIST_VERT_INSIDE, AlignmentType.DIST_TOP, AlignmentType.DIST_MIDDLE, AlignmentType.DIST_BOTTOM};
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel3.setBorder((Border)BorderFactory.createTitledBorder(ALIGN_RESOURCES.getString("groupbox.vertical")));
        mJPanel3.setName(NOTRANS_ALIGN_RESOURCES.getString("groupbox.vertical"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fVertButtons = new ArrayList<AlignmentButton>();
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridLayout(1, 0, 0, 0));
        mJPanel4.setName(NOTRANS_ALIGN_RESOURCES.getString("panel.vertaligngrid"));
        for (AlignmentType alignmentType : mJPanel) {
            object22 = new AlignmentButton(alignmentType, true);
            mJPanel4.add((Component)object22);
            buttonGroup.add((AbstractButton)object22);
            this.fVertButtons.add((AlignmentButton)((Object)object22));
        }
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new GridLayout(1, 0, 0, 0));
        mJPanel5.setName(NOTRANS_ALIGN_RESOURCES.getString("panel.vertdistgrid"));
        for (Object object22 : mJPanel2) {
            object = new AlignmentButton((AlignmentType)((Object)object22), true);
            mJPanel5.add((Component)object);
            buttonGroup.add((AbstractButton)object);
            this.fVertButtons.add((AlignmentButton)((Object)object));
        }
        MJPanel mJPanel6 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel6.setName(NOTRANS_ALIGN_RESOURCES.getString("panel.vertalignment"));
        MJLabel mJLabel = new MJLabel(ALIGN_RESOURCES.getString("label.align"));
        mJPanel6.add((Component)mJLabel, (Object)"West");
        mJPanel6.add(Box.createHorizontalStrut(4), (Object)"Center");
        mJPanel6.add((Component)mJPanel4, (Object)"East");
        MJPanel mJPanel7 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel7.setName(NOTRANS_ALIGN_RESOURCES.getString("panel.vertdistribution"));
        object22 = new MJLabel(ALIGN_RESOURCES.getString("label.distribute"));
        mJPanel7.add((Component)object22, (Object)"West");
        mJPanel7.add(Box.createHorizontalStrut(4), (Object)"Center");
        mJPanel7.add((Component)mJPanel5, (Object)"East");
        object = ALIGN_RESOURCES.getString("checkbox.setspacing");
        this.fVertUseFixedDist = new MJCheckBox((String)object + " ");
        this.fVertUseFixedDist.setName(NOTRANS_ALIGN_RESOURCES.getString("checkbox.vertspacing"));
        this.fVertUseFixedDist.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AlignmentPanel.this.doVertDistEnableStates();
            }
        });
        this.fVertUseFixedDist.setSelected(false);
        this.fVertFixedDistValue = new MJTextField(Integer.toString(this.fVertDistance), 6);
        this.fVertFixedDistValue.setName(NOTRANS_ALIGN_RESOURCES.getString("textfield.vertspacing"));
        this.fVertFixedDistValue.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    int n;
                    AlignmentPanel.this.fVertDistance = n = Integer.parseInt(AlignmentPanel.this.fVertFixedDistValue.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    int n = AlignmentPanel.this.fVertDistance;
                    AlignmentPanel.this.fVertFixedDistValue.setText(Integer.toString(n));
                }
            }
        });
        String string = ALIGN_RESOURCES.getString("label.pixels");
        this.fVertPixelLabel = new MJLabel(" " + string);
        MJPanel mJPanel8 = new MJPanel((LayoutManager)new FlowLayout(0, 0, 5));
        mJPanel8.add((Component)this.fVertUseFixedDist);
        mJPanel8.add((Component)this.fVertFixedDistValue);
        mJPanel8.add((Component)this.fVertPixelLabel);
        MJPanel mJPanel9 = new MJPanel((LayoutManager)new GridLayout(0, 1, 0, 0));
        mJPanel9.add((Component)mJPanel6);
        mJPanel9.add((Component)mJPanel7);
        MJPanel mJPanel10 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel10.add((Component)mJPanel9, (Object)"Center");
        mJPanel10.add((Component)mJPanel8, (Object)"South");
        this.fVertButtons.get(0).setSelected(true);
        this.doVertDistEnableStates();
        mJPanel3.add((Component)mJPanel10, (Object)"Center");
        return mJPanel3;
    }

    private MJPanel createHorizontalAlignmentPanel() {
        Object object;
        Object object22;
        MJPanel mJPanel = new MJPanel[]{AlignmentType.ALIGN_HORZ_OFF, AlignmentType.ALIGN_LEFT, AlignmentType.ALIGN_CENTER, AlignmentType.ALIGN_RIGHT};
        MJPanel mJPanel2 = new MJPanel[]{AlignmentType.DIST_HORZ_INSIDE, AlignmentType.DIST_LEFT, AlignmentType.DIST_CENTER, AlignmentType.DIST_RIGHT};
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel3.setBorder((Border)BorderFactory.createTitledBorder(ALIGN_RESOURCES.getString("groupbox.horizontal")));
        mJPanel3.setName(NOTRANS_ALIGN_RESOURCES.getString("groupbox.horizontal"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fHorzButtons = new ArrayList<AlignmentButton>();
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridLayout(1, 0, 0, 0));
        mJPanel4.setName(NOTRANS_ALIGN_RESOURCES.getString("panel.horzaligngrid"));
        for (AlignmentType alignmentType : mJPanel) {
            object22 = new AlignmentButton(alignmentType, false);
            mJPanel4.add((Component)object22);
            buttonGroup.add((AbstractButton)object22);
            this.fHorzButtons.add((AlignmentButton)((Object)object22));
        }
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new GridLayout(1, 0, 0, 0));
        mJPanel5.setName(NOTRANS_ALIGN_RESOURCES.getString("panel.horzdistgrid"));
        for (Object object22 : mJPanel2) {
            object = new AlignmentButton((AlignmentType)((Object)object22), false);
            mJPanel5.add((Component)object);
            buttonGroup.add((AbstractButton)object);
            this.fHorzButtons.add((AlignmentButton)((Object)object));
        }
        MJPanel mJPanel6 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel6.setName(NOTRANS_ALIGN_RESOURCES.getString("panel.horzalignment"));
        MJLabel mJLabel = new MJLabel(ALIGN_RESOURCES.getString("label.align"));
        mJPanel6.add((Component)mJLabel, (Object)"West");
        mJPanel6.add(Box.createHorizontalStrut(4), (Object)"Center");
        mJPanel6.add((Component)mJPanel4, (Object)"East");
        MJPanel mJPanel7 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel7.setName(NOTRANS_ALIGN_RESOURCES.getString("panel.horzdistribution"));
        object22 = new MJLabel(ALIGN_RESOURCES.getString("label.distribute"));
        mJPanel7.add((Component)object22, (Object)"West");
        mJPanel7.add(Box.createHorizontalStrut(4), (Object)"Center");
        mJPanel7.add((Component)mJPanel5, (Object)"East");
        object = ALIGN_RESOURCES.getString("checkbox.setspacing");
        this.fHorzUseFixedDist = new MJCheckBox((String)object + " ");
        this.fHorzUseFixedDist.setName(NOTRANS_ALIGN_RESOURCES.getString("checkbox.horzspacing"));
        this.fHorzUseFixedDist.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AlignmentPanel.this.doHorzDistEnableStates();
            }
        });
        this.fHorzUseFixedDist.setSelected(false);
        this.fHorzFixedDistValue = new MJTextField(Integer.toString(this.fHorzDistance), 6);
        this.fHorzFixedDistValue.setName(NOTRANS_ALIGN_RESOURCES.getString("textfield.horzspacing"));
        this.fHorzFixedDistValue.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    int n;
                    AlignmentPanel.this.fHorzDistance = n = Integer.parseInt(AlignmentPanel.this.fHorzFixedDistValue.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    int n = AlignmentPanel.this.fHorzDistance;
                    AlignmentPanel.this.fHorzFixedDistValue.setText(Integer.toString(n));
                }
            }
        });
        String string = ALIGN_RESOURCES.getString("label.pixels");
        this.fHorzPixelLabel = new MJLabel(" " + string);
        MJPanel mJPanel8 = new MJPanel((LayoutManager)new FlowLayout(0, 0, 5));
        mJPanel8.add((Component)this.fHorzUseFixedDist);
        mJPanel8.add((Component)this.fHorzFixedDistValue);
        mJPanel8.add((Component)this.fHorzPixelLabel);
        MJPanel mJPanel9 = new MJPanel((LayoutManager)new GridLayout(0, 1, 0, 0));
        mJPanel9.add((Component)mJPanel6);
        mJPanel9.add((Component)mJPanel7);
        MJPanel mJPanel10 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel10.add((Component)mJPanel9, (Object)"Center");
        mJPanel10.add((Component)mJPanel8, (Object)"South");
        this.fHorzButtons.get(0).setSelected(true);
        this.doHorzDistEnableStates();
        mJPanel3.add((Component)mJPanel10, (Object)"Center");
        return mJPanel3;
    }

    public abstract void doAlign(int var1, int var2, int var3, int var4);

    protected void doOk() {
        this.doApply();
        this.doCancel();
    }

    protected void doApply() {
        int n = this.getVerticalCommandID();
        int n2 = this.getHorizontalCommandID();
        int n3 = this.vDistOn() ? this.getVertFixedDistValue() : -1;
        int n4 = this.hDistOn() ? this.getHorzFixedDistValue() : -1;
        this.doAlign(n, n3, n2, n4);
    }

    protected void doCancel() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window != null) {
            this.fOkButton.requestFocus();
            window.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.fApplyButton)) {
            this.doApply();
        } else if (actionEvent.getSource().equals(this.fCancelButton)) {
            this.doCancel();
        } else if (actionEvent.getSource().equals(this.fOkButton)) {
            this.doOk();
        }
    }

    public Insets getInsets() {
        return new Insets(8, 8, 8, 8);
    }

    protected boolean vDistOn() {
        return this.getUseVertFixedDistValue();
    }

    protected boolean hDistOn() {
        return this.getUseHorzFixedDistValue();
    }

    protected int getVerticalCommandID() {
        int n = -1;
        for (AlignmentButton alignmentButton : this.fVertButtons) {
            if (!alignmentButton.isSelected()) continue;
            n = alignmentButton.getCommandID();
        }
        return n;
    }

    protected int getHorizontalCommandID() {
        int n = -1;
        for (AlignmentButton alignmentButton : this.fHorzButtons) {
            if (!alignmentButton.isSelected()) continue;
            n = alignmentButton.getCommandID();
        }
        return n;
    }

    protected boolean getUseVertFixedDistValue() {
        return this.fVertUseFixedDist.isSelected();
    }

    protected boolean getUseHorzFixedDistValue() {
        return this.fHorzUseFixedDist.isSelected();
    }

    protected int getVertFixedDistValue() {
        return Integer.parseInt(this.fVertFixedDistValue.getText());
    }

    protected int getHorzFixedDistValue() {
        return Integer.parseInt(this.fHorzFixedDistValue.getText());
    }

    protected void doVertDistEnableStates() {
        if (this.getVerticalCommandID() > 6) {
            this.setVertDistEnabled(true);
        } else {
            this.setVertDistEnabled(false);
        }
    }

    protected void doHorzDistEnableStates() {
        if (this.getHorizontalCommandID() > 6) {
            this.setHorzDistEnabled(true);
        } else {
            this.setHorzDistEnabled(false);
        }
    }

    private void setVertDistEnabled(boolean bl) {
        this.fVertUseFixedDist.setEnabled(bl);
        this.fVertFixedDistValue.setEnabled(bl && this.fVertUseFixedDist.isSelected());
        if (this.fVertFixedDistValue.isEnabled()) {
            this.fVertFixedDistValue.requestFocus();
            this.fVertFixedDistValue.selectAll();
        } else {
            this.fVertFixedDistValue.transferFocus();
        }
        if (this.fVertPixelLabel != null) {
            this.fVertPixelLabel.setEnabled(bl);
            this.fVertPixelLabel.repaint();
        }
    }

    private void setHorzDistEnabled(boolean bl) {
        this.fHorzUseFixedDist.setEnabled(bl);
        this.fHorzFixedDistValue.setEnabled(bl && this.fHorzUseFixedDist.isSelected());
        if (this.fHorzFixedDistValue.isEnabled()) {
            this.fHorzFixedDistValue.requestFocus();
            this.fHorzFixedDistValue.selectAll();
        } else {
            this.fHorzFixedDistValue.transferFocus();
        }
        if (this.fHorzPixelLabel != null) {
            this.fHorzPixelLabel.setEnabled(bl);
            this.fHorzPixelLabel.repaint();
        }
    }

    private class AlignmentButton
    extends MJToggleButton {
        private int fCommandID;
        private boolean fIsVertical;

        AlignmentButton(AlignmentType alignmentType, boolean bl) {
            super(alignmentType.getIcon());
            this.setName(alignmentType.getName());
            this.fCommandID = alignmentType.getCommandID();
            this.fIsVertical = bl;
            int n = this.getMargin().top;
            this.setMargin(new Insets(n, n, n, n));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AlignmentButton.this.fIsVertical) {
                        AlignmentPanel.this.doVertDistEnableStates();
                    } else {
                        AlignmentPanel.this.doHorzDistEnableStates();
                    }
                }
            });
        }

        public int getCommandID() {
            return this.fCommandID;
        }

        public boolean isVertical() {
            return this.fIsVertical;
        }
    }
}

