/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.mathworks.common.icons.ControlIcon;
import com.mathworks.common.icons.IconContainer;
import com.mathworks.hg.types.GUIDEViewProvider;
import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollBar;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.matlab.guide.HGControl;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.LayoutStackingArea;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.StackingPanel;
import com.mathworks.toolbox.matlab.guide.palette.AxisProxy;
import com.mathworks.toolbox.matlab.guide.palette.ButtonProxy;
import com.mathworks.toolbox.matlab.guide.palette.DefaultProxy;
import com.mathworks.toolbox.matlab.guide.palette.EditProxy;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.MObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.MObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.PanelProxy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.MutableComboBoxModel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;

public class GObjectProxy
extends MObjectProxy
implements LayoutStackingArea {
    public static final int STYLE_PUSHBUTTON = 0;
    public static final int STYLE_SLIDER = 1;
    public static final int STYLE_RADIOBUTTON = 2;
    public static final int STYLE_CHECKBOX = 3;
    public static final int STYLE_EDIT = 4;
    public static final int STYLE_TEXT = 5;
    public static final int STYLE_FRAME = 6;
    public static final int STYLE_POPUPMENU = 7;
    public static final int STYLE_LISTBOX = 8;
    public static final int STYLE_TOGGLEBUTTON = 9;
    public static final int STYLE_TABLE = 10;
    public static final int STYLE_AXES = 11;
    public static final int STYLE_CONTAINER = 12;
    public static final int STYLE_PANEL = 13;
    public static final int STYLE_BUTTONGROUP = 14;
    public static final int STYLE_NUMBER = 15;
    static final String[] CONTROL_STYLE_NAMES = new String[]{"pushbutton", "slider", "radiobutton", "checkbox", "edit", "text", "frame", "popupmenu", "listbox", "togglebutton", "table", "axes", "container", "panel", "buttongroup"};
    static final IconContainer[] CONTROL_ICONS = new IconContainer[]{ControlIcon.PUSHBUTTON, ControlIcon.SCROLLBAR, ControlIcon.RADIOBUTTON, ControlIcon.CHECKBOX, ControlIcon.TEXTEDIT, ControlIcon.LABEL, ControlIcon.PANEL, ControlIcon.COMBOBOX, ControlIcon.LISTBOX, ControlIcon.TOGGLEBUTTON, ControlIcon.TABLE, ControlIcon.AXES, ControlIcon.PANEL, ControlIcon.PANEL, ControlIcon.BUTTONGROUP};
    static final int[] CONTROL_STYLES = new int[15];
    static final String[] CONTROL_STRINGARRAY = new String[15];
    static final String[] CONTROL_TESTNAMES = new String[15];
    private static final int ALIGN_LEFT = -1;
    private static final int ALIGN_CENTER = 0;
    private static final int ALIGN_RIGHT = 1;
    private int fAlign;
    private String[] fStringArray;
    private boolean fAutoAdjustSizeFirstTime = false;
    private StackingPanel fStackingPanel;
    private boolean fComponentViewPassedIn = false;
    private static final Dimension sMinimumSize;
    private Dimension fHGMinimumSize = null;

    public GObjectProxy(Object object, String[] stringArray, double[] dArray, Component component) {
        int n = GObjectProxy.getStyleFromMATLAB(object);
        this.fStringArray = stringArray != null ? stringArray : new String[0];
        this.fParentHeight = (int)dArray[0];
        boolean bl = this.fComponentViewPassedIn = component != null;
        this.init(n == 11 ? 2 : (n >= 12 ? 3 : 1), n, object, component);
    }

    GObjectProxy(int n) {
        this.fAlign = 0;
        this.fStringArray = new String[]{CONTROL_STRINGARRAY[n]};
        this.init(n == 11 ? 2 : (n >= 12 ? 3 : 1), n);
    }

    public static IconContainer[] getControlStyleIcons() {
        return CONTROL_ICONS;
    }

    public static int getStyleFromMATLAB(Object object) {
        int n = -1;
        if (object instanceof UDDObject) {
            UDDObject uDDObject = (UDDObject)object;
            String string = uDDObject.getClassName();
            if (HGControl.UICONTROL.getClassName().equalsIgnoreCase(string)) {
                Object object2 = HGControl.getPropertyValueForCompatibility(uDDObject, "Style");
                if (object2 != null && object2 instanceof Integer) {
                    n = (Integer)object2;
                }
            } else if (HGControl.TABLE.getClassName().equalsIgnoreCase(string)) {
                n = 10;
            } else if (HGControl.CONTAINER.getClassName().equalsIgnoreCase(string)) {
                n = 12;
            } else if (HGControl.PANEL.getClassName().equalsIgnoreCase(string)) {
                n = 13;
            } else if (HGControl.BUTTONGROUP.getClassName().equalsIgnoreCase(string)) {
                n = 14;
            } else if (LayoutLooper.isAxes(uDDObject)) {
                n = 11;
            } else if (LayoutLooper.isContainer(uDDObject)) {
                n = 12;
            }
        }
        return n;
    }

    @Override
    public Object[] getProxyData() {
        return this.getStringArray();
    }

    private String[] getStringArray() {
        return this.fStringArray;
    }

    @Override
    public String getStyleString() {
        return CONTROL_STYLE_NAMES[this.getStyle()];
    }

    @Override
    void setWrapper(MObjectWrapper mObjectWrapper) {
        this.fWrapper = mObjectWrapper;
        if (this.fWrapper != null) {
            this.fAutoAdjustSizeFirstTime = true;
        }
    }

    @Override
    protected Component buildComponent() {
        Object object;
        switch (this.fStyle) {
            case 0: 
            case 9: {
                object = new ButtonProxy(GObjectProxy.extractString(this.fStringArray));
                break;
            }
            case 1: {
                object = new ProxyScrollbar();
                break;
            }
            case 2: {
                object = new MJRadioButton(GObjectProxy.extractString(this.fStringArray));
                break;
            }
            case 3: {
                object = new MJCheckBox(GObjectProxy.extractString(this.fStringArray));
                break;
            }
            case 4: {
                EditProxy editProxy = new EditProxy(GObjectProxy.extractMultilineString(this.fStringArray));
                editProxy.setAlignment(0);
                object = editProxy;
                break;
            }
            case 5: {
                MJLabel mJLabel = new MJLabel(GObjectProxy.extractMultilineString(this.fStringArray));
                mJLabel.setVerticalAlignment(1);
                mJLabel.setHorizontalAlignment(0);
                object = mJLabel;
                break;
            }
            case 6: {
                object = new PanelProxy();
                break;
            }
            case 7: {
                MJComboBox mJComboBox = new MJComboBox();
                mJComboBox.setEditable(false);
                if (this.fStringArray != null && this.fStringArray.length > 0) {
                    ((MutableComboBoxModel)mJComboBox.getModel()).addElement(this.fStringArray[0]);
                }
                object = mJComboBox;
                break;
            }
            case 8: {
                MJList mJList = new MJList((Object[])this.fStringArray);
                mJList.setPreferredSize(new Dimension(150, 150));
                MJScrollPane mJScrollPane = new MJScrollPane((Component)mJList);
                mJScrollPane.setVerticalScrollBarPolicy(22);
                object = mJScrollPane;
                break;
            }
            case 11: {
                object = new AxisProxy();
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                object = new PanelProxy();
                break;
            }
            default: {
                object = new DefaultProxy(this, true);
            }
        }
        if (this.fStyle >= 0 && this.fStyle < CONTROL_STYLE_NAMES.length) {
            ((Component)object).setName(CONTROL_STYLE_NAMES[this.fStyle]);
        }
        return object;
    }

    @Override
    protected void updateProxyImage(UDDObject uDDObject) {
        if (sRenderingMethod == 1) {
            this.updateComponentView(uDDObject);
            if (this.getComponentView() != null) {
                this.fComponentImage = null;
                Image image = HGUtils.getComponentImage((Object)this.fComponentView);
                if (image != null && image instanceof Image) {
                    this.fComponentImage = image;
                }
            }
        }
    }

    @Override
    protected void updateProxyComponent(UDDObject uDDObject) {
        if (sRenderingMethod == 2) {
            this.updateComponentView(uDDObject);
        }
    }

    private void updateComponentView(UDDObject uDDObject) {
        try {
            if (this.hasComponentView()) {
                if (this.getComponentView() == null) {
                    Matlab.mtFeval((String)"drawnow", null, (int)0);
                    Object object = Matlab.mtFeval((String)"getGUIDEView", (Object[])new Object[]{uDDObject}, (int)1);
                    JComponent jComponent = null;
                    if (object instanceof GUIDEViewProvider) {
                        jComponent = ((GUIDEViewProvider)object).getGUIDEView();
                    }
                    this.fComponentView = jComponent;
                    this.fComponentViewPassedIn = false;
                } else if (!this.fComponentViewPassedIn || SwingUtilities.getWindowAncestor(this) != null && SwingUtilities.getWindowAncestor(this).isVisible()) {
                    this.fComponentViewPassedIn = false;
                    Matlab.mtFeval((String)"drawnow", null, (int)0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean canUseDefaultProxy() {
        return this.fStyle <= 10;
    }

    @Override
    public void updateProxy(Object object) {
        if (object instanceof UDDObject) {
            UDDObject uDDObject = (UDDObject)object;
            super.updateProxy(uDDObject);
            switch (this.fType) {
                case 2: {
                    this.updateAxes(uDDObject);
                    break;
                }
                case 1: {
                    if (this.getStyle() == 10) break;
                    this.updateUIControl(uDDObject);
                    break;
                }
                case 3: {
                    if (this.fStyle == 12) {
                        this.updateUIContainer(uDDObject);
                    } else {
                        this.updateUIPanel(uDDObject);
                    }
                    MObjectWrapper mObjectWrapper = this.getWrapper();
                    if (mObjectWrapper == null || !mObjectWrapper.isEnclosure()) break;
                    Enumeration enumeration = mObjectWrapper.baseWrappers();
                    while (enumeration.hasMoreElements()) {
                        mObjectWrapper = (MObjectWrapper)enumeration.nextElement();
                        if (mObjectWrapper == null || mObjectWrapper.getBean() == null) continue;
                        ((MObjectProxy)mObjectWrapper.getControl()).updateProxy(mObjectWrapper.getBean());
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected void updateComponentPositionAWT(HGRectangle hGRectangle) {
        super.updateComponentPositionAWT(hGRectangle);
        Rectangle rectangle = this.getBounds();
        if (this.fStyle == 8 && this.fComponent instanceof MJScrollPane) {
            MJScrollPane mJScrollPane = (MJScrollPane)this.fComponent;
            if (rectangle.height <= 22) {
                mJScrollPane.setHorizontalScrollBarPolicy(31);
            } else {
                mJScrollPane.setHorizontalScrollBarPolicy(30);
            }
            LayoutArea.forceLayout(this);
        }
    }

    private void updateFont(UDDObject uDDObject) {
        Object object;
        Object object2 = HGControl.getPropertyValueForCompatibility(uDDObject, "FontName");
        String string = "SansSerif";
        if (object2 != null && object2 instanceof String) {
            string = (String)object2;
        }
        Object object3 = HGControl.getPropertyValueForCompatibility(uDDObject, "FontAngle");
        int n = 0;
        if (object3 != null && object3 instanceof Integer) {
            n = (Integer)object3;
        }
        int n2 = 1;
        try {
            object = (String)Matlab.mtFeval((String)"get", (Object[])new Object[]{uDDObject, "FontWeight"}, (int)1);
            String[] stringArray = new String[]{"light", "normal", "demi", "bold"};
            int n3 = Arrays.asList(stringArray).indexOf(object);
            if (n3 != -1) {
                n2 = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = HGControl.getPropertyValueForCompatibility(uDDObject, "FontUnits");
        int n4 = 4;
        if (object != null && object instanceof Integer) {
            n4 = (Integer)object;
        }
        if (n4 != 4) {
            HGControl.setPropertyValueForCompatibility(uDDObject, "FontUnits", new Integer(4));
        }
        Object object4 = HGControl.getPropertyValueForCompatibility(uDDObject, "FontSize");
        int n5 = 10;
        if (object4 != null && object4 instanceof Double) {
            n5 = Math.round(((Double)object4).floatValue());
        }
        if (n4 != 4) {
            HGControl.setPropertyValueForCompatibility(uDDObject, "FontUnits", new Integer(n4));
        }
        int n6 = (n > 0 ? 2 : 0) + (n2 > 1 ? 1 : 0);
        Font font = new Font(string, n6, n5);
        boolean bl = false;
        if (this.fAutoAdjustSizeFirstTime) {
            this.fAutoAdjustSizeFirstTime = false;
            bl = true;
        }
        this.updateComponentFont(font, bl);
    }

    private void updateComponentFont(final Font font, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateComponentFontAWT(font, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GObjectProxy.this.updateComponentFontAWT(font, bl);
                }
            });
        }
    }

    private void updateComponentFontAWT(Font font, boolean bl) {
        this.fComponent.setFont(font);
        if (this.fStyle != 8 && this.fStyle != 1) {
            Dimension dimension = this.fComponent.getPreferredSize();
            dimension.width = (int)((double)dimension.width * 1.05);
            this.fHGMinimumSize = dimension;
        }
        if (bl && this.fComponent.getSize().equals(this.fComponent.getPreferredSize())) {
            this.setSize(this.fComponent.getPreferredSize());
            this.fComponent.invalidate();
            this.validate();
            ((GObjectWrapper)this.fWrapper).updatePosition();
        }
    }

    private void updateAxes(UDDObject uDDObject) {
        this.updateAxesImage(uDDObject);
        this.updatePosition(uDDObject);
        this.updateFont(uDDObject);
    }

    private void updateAxesImage(UDDObject uDDObject) {
        Color color = null;
        String[] stringArray = this.fStringArray;
        Object object = HGControl.getStringProperty(uDDObject, "Tag");
        if (object instanceof String) {
            stringArray = new String[]{object};
        } else if (object instanceof String[]) {
            stringArray = (String[])object;
        }
        this.fStringArray = stringArray;
        object = HGControl.getPropertyValueForCompatibility(uDDObject, "Color");
        if (object != null && object instanceof HGColor) {
            color = HGColor.getColor((HGColor)((HGColor)object));
        }
        this.updateAxesComponentImage(color);
    }

    private void updateAxesComponentImage(final Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateAxesComponentImageAWT(color);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GObjectProxy.this.updateAxesComponentImageAWT(color);
                }
            });
        }
    }

    private void updateAxesComponentImageAWT(Color color) {
        ((AxisProxy)((Object)this.fComponent)).setTag(this.fStringArray[0]);
        if (color != null) {
            this.fComponent.setBackground(color);
        }
    }

    private void updateUIPanel(UDDObject uDDObject) {
        this.updateUIPanelAppearance(uDDObject);
        this.updatePosition(uDDObject);
        this.updateFont(uDDObject);
    }

    private void updateUIPanelAppearance(UDDObject uDDObject) {
        String[] stringArray = this.fStringArray;
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        int n = 0;
        int n2 = 0;
        Object object = HGControl.getPropertyValueForCompatibility(uDDObject, "Title");
        if (object instanceof String) {
            stringArray = new String[]{(String)object};
        } else if (object instanceof String[]) {
            stringArray = (String[])object;
        }
        this.fStringArray = stringArray;
        object = HGControl.getPropertyValueForCompatibility(uDDObject, "TitlePosition");
        if (object != null && object instanceof Integer) {
            this.fAlign = (Integer)object;
        }
        if ((object = HGControl.getPropertyValueForCompatibility(uDDObject, "BorderType")) != null && object instanceof Integer) {
            n = (Integer)object;
        }
        if ((object = HGControl.getPropertyValueForCompatibility(uDDObject, "BorderWidth")) != null && object instanceof Integer) {
            n2 = (Integer)object;
        }
        if ((object = HGControl.getPropertyValueForCompatibility(uDDObject, "BackgroundColor")) != null && object instanceof HGColor) {
            color = HGColor.getColor((HGColor)((HGColor)object));
        }
        if ((object = HGControl.getPropertyValueForCompatibility(uDDObject, "ForegroundColor")) != null && object instanceof HGColor) {
            color2 = HGColor.getColor((HGColor)((HGColor)object));
        }
        if ((object = HGControl.getPropertyValueForCompatibility(uDDObject, "HighlightColor")) != null && object instanceof HGColor) {
            color3 = HGColor.getColor((HGColor)((HGColor)object));
        }
        if ((object = HGControl.getPropertyValueForCompatibility(uDDObject, "ShadowColor")) != null && object instanceof HGColor) {
            color4 = HGColor.getColor((HGColor)((HGColor)object));
        }
        this.updatePanelAppearance(n, n2, color, color2, color3, color4);
    }

    private void updatePanelAppearance(final int n, final int n2, final Color color, final Color color2, final Color color3, final Color color4) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updatePanelAppearanceAWT(n, n2, color, color2, color3, color4);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GObjectProxy.this.updatePanelAppearanceAWT(n, n2, color, color2, color3, color4);
                }
            });
        }
    }

    private void updatePanelAppearanceAWT(int n, int n2, Color color, Color color2, Color color3, Color color4) {
        PanelProxy panelProxy = (PanelProxy)this.fComponent;
        panelProxy.setTitle(GObjectProxy.extractMultilineString(this.fStringArray));
        panelProxy.setTitlePosition(this.fAlign);
        panelProxy.setBorder(n, n2, color3, color4);
        panelProxy.setBackground(color);
        panelProxy.setForeground(color2);
    }

    private void updateUIContainer(UDDObject uDDObject) {
        this.updateUIContainerAppearance(uDDObject);
        this.updatePosition(uDDObject);
    }

    private void updateUIContainerAppearance(UDDObject uDDObject) {
        Object object = HGControl.getPropertyValueForCompatibility(uDDObject, "BackgroundColor");
        Color color = null;
        if (object != null && object instanceof HGColor) {
            color = HGColor.getColor((HGColor)((HGColor)object));
        }
        this.updateContainerAppearance(color);
    }

    private void updateContainerAppearance(final Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateContainerAppearanceAWT(color);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GObjectProxy.this.updateContainerAppearanceAWT(color);
                }
            });
        }
    }

    private void updateContainerAppearanceAWT(Color color) {
        this.fComponent.setBackground(color);
    }

    private void updateUIControl(UDDObject uDDObject) {
        Object object = HGControl.getPropertyValueForCompatibility(uDDObject, "Style");
        int n = this.fStyle;
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        if (n != this.fStyle) {
            this.fStyle = n;
            this.init(this.fType, this.fStyle, uDDObject, null);
            LayoutArea.forceLayout(this);
        } else {
            this.updateAppearance(uDDObject);
            this.updatePosition(uDDObject);
            this.updateFont(uDDObject);
        }
    }

    private void updateAppearance(UDDObject uDDObject) {
        int n = this.fStyle;
        String[] stringArray = this.fStringArray;
        int n2 = 0;
        boolean bl = false;
        Color color = null;
        Color color2 = null;
        Object object = HGControl.getPropertyValueForCompatibility(uDDObject, "String");
        if (object instanceof String) {
            stringArray = new String[]{(String)object};
        } else if (object instanceof String[]) {
            stringArray = (String[])object;
        }
        object = HGControl.getPropertyValueForCompatibility(uDDObject, "HorizontalAlignment");
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object - 1;
        }
        double d = (Double)HGControl.getPropertyValueForCompatibility(uDDObject, "Min");
        double[] dArray = (double[])HGControl.getPropertyValueForCompatibility(uDDObject, "Value");
        if (dArray != null && dArray.length != 0) {
            boolean bl2 = bl = dArray[0] != d;
        }
        if ((object = HGControl.getPropertyValueForCompatibility(uDDObject, "BackgroundColor")) != null && object instanceof HGColor) {
            color = HGColor.getColor((HGColor)((HGColor)object));
        }
        if ((object = HGControl.getPropertyValueForCompatibility(uDDObject, "ForegroundColor")) != null && object instanceof HGColor) {
            color2 = HGColor.getColor((HGColor)((HGColor)object));
        }
        this.fAlign = n2;
        this.fStringArray = stringArray;
        this.updateComponentAppearance(bl, color, color2);
    }

    private void updateComponentAppearance(final boolean bl, final Color color, final Color color2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateComponentAppearanceAWT(bl, color, color2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GObjectProxy.this.updateComponentAppearanceAWT(bl, color, color2);
                }
            });
        }
    }

    private void updateComponentAppearanceAWT(boolean bl, Color color, Color color2) {
        switch (this.fStyle) {
            case 0: 
            case 9: {
                ButtonProxy buttonProxy = (ButtonProxy)((Object)this.fComponent);
                int n = 0;
                buttonProxy.setText(GObjectProxy.extractString(this.fStringArray));
                buttonProxy.setHorizontalAlignment(n);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ((MJRadioButton)this.fComponent).setText(GObjectProxy.extractString(this.fStringArray));
                break;
            }
            case 3: {
                ((MJCheckBox)this.fComponent).setText(GObjectProxy.extractString(this.fStringArray));
                break;
            }
            case 4: {
                EditProxy editProxy = (EditProxy)((Object)this.fComponent);
                int n = 0;
                switch (this.fAlign) {
                    case -1: {
                        n = 2;
                        break;
                    }
                    case 1: {
                        n = 4;
                    }
                }
                editProxy.setText(GObjectProxy.extractMultilineString(this.fStringArray));
                editProxy.setAlignment(n);
                break;
            }
            case 5: {
                MJLabel mJLabel = (MJLabel)this.fComponent;
                int n = 0;
                switch (this.fAlign) {
                    case -1: {
                        n = 2;
                        break;
                    }
                    case 1: {
                        n = 4;
                        break;
                    }
                }
                mJLabel.setText(GObjectProxy.extractMultilineString(this.fStringArray));
                mJLabel.setHorizontalAlignment(n);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                MJComboBox mJComboBox = (MJComboBox)this.fComponent;
                mJComboBox.removeAll();
                for (String string : this.fStringArray) {
                    mJComboBox.addItem((Object)string);
                }
                break;
            }
            case 8: {
                MJList mJList = (MJList)((MJScrollPane)this.fComponent).getViewport().getView();
                mJList.setListData((Object[])this.fStringArray);
                if (this.fStringArray == null || this.fStringArray.length <= 0) break;
                mJList.setSelectedIndex(0);
                break;
            }
            case 11: {
                break;
            }
        }
        switch (this.fStyle) {
            case 3: {
                ((MJCheckBox)this.fComponent).setSelected(bl);
                break;
            }
            case 2: {
                ((MJRadioButton)this.fComponent).setSelected(bl);
                break;
            }
            case 9: {
                ((ButtonProxy)((Object)this.fComponent)).setSelected(bl);
            }
        }
        if (color != null) {
            this.fComponent.setBackground(color);
        }
        if (color2 != null) {
            this.fComponent.setForeground(color2);
        }
    }

    private static String extractString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return "";
        }
        return stringArray[0];
    }

    private static String extractMultilineString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string = stringArray[0] != null ? stringArray[0] : "";
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            string = string + '\n' + stringArray[i];
        }
        return string;
    }

    @Override
    public void addToLayer(LOControlWrapper lOControlWrapper, int n) {
        if (this.fStackingPanel == null) {
            this.fStackingPanel = new StackingPanel();
            this.fStackingPanel.setBackground(this.fComponent.getBackground());
            this.fStackingPanel.setOpaque(false);
            this.setLayout(new OverlayLayout(this));
            this.add((Component)this.fStackingPanel, "Stacking Area");
            this.add(this.fComponent, "Component Area");
            this.validate();
        }
        this.fStackingPanel.addToLayer(lOControlWrapper, n);
    }

    @Override
    public void removeFromLayer(LOControlWrapper lOControlWrapper) {
        if (this.fStackingPanel != null) {
            this.fStackingPanel.removeFromLayer(lOControlWrapper);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.fType == 3 && this.getParent() == null) {
            return sMinimumSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.fHGMinimumSize != null) {
            return this.fHGMinimumSize;
        }
        return super.getMinimumSize();
    }

    public boolean isTabable() {
        int n = this.getStyle();
        return n != 5 && n != 6 && n != 11 && n != 13 && n != 12 && n != 14;
    }

    public static boolean hasCallback(int n) {
        return n != 5 && n != 6 && n != 11;
    }

    static boolean isPaletteEntry(int n) {
        return n != 6 && n != 12 && (n != 10 || sShowTable);
    }

    private boolean hasComponentView() {
        int n = this.getStyle();
        return n != 11 && n != 13 && n != 12 && n != 14;
    }

    static {
        for (int i = 0; i < 15; ++i) {
            GObjectProxy.CONTROL_STYLES[i] = i;
            GObjectProxy.CONTROL_STRINGARRAY[i] = ResourceManager.getString("uicontrol." + CONTROL_STYLE_NAMES[i]);
            GObjectProxy.CONTROL_TESTNAMES[i] = ResourceManager.getUntranslatedString("palette." + CONTROL_STYLE_NAMES[i]);
        }
        sMinimumSize = new Dimension(150, 150);
    }

    private static class ProxyScrollbar
    extends MJScrollBar {
        private ProxyScrollbar() {
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (n3 > n4) {
                this.setOrientation(0);
                this.setValue(this.getMinimum());
            } else {
                this.setOrientation(1);
                this.setValue(this.getMaximum());
            }
        }
    }
}

