/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class LayoutWrapperOwner
implements LOWrapperOwner {
    public static final int AXES_CONTAINER_LAYER = 0;
    public static final int UICONTROL_LAYER = 1;
    public static final int ACTIVEX_LAYER = 2;
    public static final int CONTROL_LAYER = 3;
    private static final int NUM_LAYERS = 4;
    private Vector[] fControlList;

    public LayoutWrapperOwner(boolean bl) {
        if (bl) {
            this.fControlList = new Vector[LayoutWrapperOwner.getNumberOfLayers()];
            for (int i = 0; i < LayoutWrapperOwner.getNumberOfLayers(); ++i) {
                this.fControlList[i] = new LayerVector();
            }
        }
    }

    @Override
    public void addWrapper(LOControlWrapper lOControlWrapper, int n, boolean bl) {
        Cloneable cloneable;
        if (n == -2) {
            cloneable = lOControlWrapper.getBaseLocation();
            LOControlWrapper lOControlWrapper2 = this.findParent(lOControlWrapper);
            if (lOControlWrapper2 != null) {
                lOControlWrapper2.translateFromBaseCoordinates((Point)cloneable);
                lOControlWrapper.getControl().setLocation((Point)cloneable);
                if (lOControlWrapper.getParent() != null) {
                    lOControlWrapper.getParent().removeWrapper(lOControlWrapper, false);
                }
                lOControlWrapper.setParent(lOControlWrapper2);
                lOControlWrapper2.addWrapper(lOControlWrapper, -1, bl);
                return;
            }
            n = -1;
        }
        cloneable = this.getLayer(lOControlWrapper);
        if (n == -1) {
            n = ((Vector)cloneable).size();
        }
        ((Vector)cloneable).insertElementAt(lOControlWrapper, n);
    }

    public static int getLayerIndexOfWrapper(LOControlWrapper lOControlWrapper) {
        int n = 3;
        switch (lOControlWrapper.getControlType()) {
            case 2: {
                n = 0;
                break;
            }
            case 1: 
            case 3: {
                n = 1;
                break;
            }
            case 6: {
                n = 2;
            }
        }
        return n;
    }

    @Override
    public void removeWrapper(LOControlWrapper lOControlWrapper, boolean bl) {
        this.getLayer(lOControlWrapper).removeElement(lOControlWrapper);
        lOControlWrapper.setParent(null);
    }

    @Override
    public int getIndexOfWrapper(LOControlWrapper lOControlWrapper) {
        return this.getLayer(lOControlWrapper).indexOf(lOControlWrapper);
    }

    @Override
    public LOControlWrapper findWrapper(Object object) {
        LOControlWrapper lOControlWrapper;
        LOControlWrapper lOControlWrapper2 = null;
        Enumeration enumeration = this.baseWrappers();
        while (enumeration.hasMoreElements() && (lOControlWrapper2 = (lOControlWrapper = (LOControlWrapper)enumeration.nextElement()).findWrapper(object)) == null) {
        }
        return lOControlWrapper2;
    }

    Vector[] getLayers() {
        return this.fControlList;
    }

    Vector getLayer(LOControlWrapper lOControlWrapper) {
        return this.getLayer(LayoutWrapperOwner.getLayerIndexOfWrapper(lOControlWrapper));
    }

    public Vector getLayer(int n) {
        Vector vector = null;
        Vector[] vectorArray = this.getLayers();
        if (vectorArray != null && n >= 0 && n < LayoutWrapperOwner.getNumberOfLayers()) {
            vector = vectorArray[n];
        }
        return vector;
    }

    public static int getNumberOfLayers() {
        return 4;
    }

    LOControlWrapper findParent(LOControlWrapper lOControlWrapper) {
        Point point = lOControlWrapper.getBaseLocation();
        LOControlWrapper lOControlWrapper2 = this.findContainer(point);
        if (lOControlWrapper2 != null && lOControlWrapper.isEnclosable()) {
            Dimension dimension = lOControlWrapper.getControl().getSize();
            Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            point.translate(rectangle.width, rectangle.height);
            Point point2 = lOControlWrapper2.getBaseLocation();
            Dimension dimension2 = lOControlWrapper2.getControl().getSize();
            point2.translate(dimension2.width, dimension2.height);
            if (point.x <= point2.x && point.y <= point2.y) {
                return lOControlWrapper2;
            }
        }
        return null;
    }

    public LOControlWrapper findContainer(Point point) {
        LOControlWrapper lOControlWrapper = null;
        for (int i = 0; i < LayoutWrapperOwner.getNumberOfLayers(); ++i) {
            Vector vector = this.getLayer(i);
            for (int j = vector.size() - 1; j >= 0; --j) {
                LOControlWrapper lOControlWrapper2 = (LOControlWrapper)vector.elementAt(j);
                if (!lOControlWrapper2.isEnclosure() || !lOControlWrapper2.ptInControlRect(point)) continue;
                LOControlWrapper lOControlWrapper3 = lOControlWrapper2.findContainer(point);
                if (lOControlWrapper3 != null) {
                    lOControlWrapper = lOControlWrapper3;
                    break;
                }
                lOControlWrapper = lOControlWrapper2;
                break;
            }
            if (lOControlWrapper != null) break;
        }
        return lOControlWrapper;
    }

    public LOControlWrapper findControl(Point point) {
        if (point != null) {
            for (int i = LayoutWrapperOwner.getNumberOfLayers() - 1; i >= 0; --i) {
                LOControlWrapper lOControlWrapper = this.findControlInLayer(this.getLayer(i), point);
                if (lOControlWrapper == null) continue;
                return lOControlWrapper;
            }
        }
        return null;
    }

    private LOControlWrapper findControlInLayer(Vector vector, Point point) {
        if (vector != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                LOControlWrapper lOControlWrapper;
                LOControlWrapper lOControlWrapper2 = (LOControlWrapper)vector.elementAt(i);
                if (!lOControlWrapper2.ptInControlRect(point)) continue;
                if (lOControlWrapper2.isEnclosure() && (lOControlWrapper = lOControlWrapper2.findControl(point)) != null) {
                    return lOControlWrapper;
                }
                return lOControlWrapper2;
            }
        }
        return null;
    }

    public Enumeration baseLayers() {
        return new BaseLayerEnumerator(this.getLayers());
    }

    public Enumeration baseWrappers() {
        return new WrapperEnumerator(this.baseLayers());
    }

    public Enumeration layers() {
        return new LayerEnumerator(this.getLayers());
    }

    public Enumeration wrappers() {
        return new WrapperEnumerator(this.layers());
    }

    public Enumeration layersReversed() {
        return new LayerEnumerator(this.getLayers(), 1);
    }

    public Enumeration wrappersReversed() {
        return new WrapperEnumerator(this.layersReversed(), 1);
    }

    static interface BidirectionEnumeration
    extends Enumeration {
        public static final int DIRECTION_FORWARD = 0;
        public static final int DIRECTION_BACKWARD = 1;

        public int getDirection();
    }

    private class LayerVector
    extends Vector {
        private LayerVector() {
        }

        public Enumeration reversedElements() {
            return new Enumeration(){
                int count;
                {
                    this.count = LayerVector.this.elementCount - 1;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.count >= 0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object nextElement() {
                    LayerVector layerVector = LayerVector.this;
                    synchronized (layerVector) {
                        if (this.count >= 0) {
                            return LayerVector.this.elementData[this.count--];
                        }
                    }
                    throw new NoSuchElementException("Vector Enumeration");
                }
            };
        }
    }

    private class LayerEnumerator
    implements BidirectionEnumeration {
        private Vector[] fLayer;
        private int[] fIndex;
        private int fLayerIndex;
        private Enumeration fSublayersEnum;
        private boolean fSelfReturned;
        private boolean fTimeToReturnSelf;
        private int fDirection = 0;

        LayerEnumerator(Vector[] vectorArray) {
            this(vectorArray, 0);
        }

        LayerEnumerator(Vector[] vectorArray, int n) {
            this.fIndex = new int[vectorArray.length];
            this.fLayer = vectorArray;
            for (int i = 0; i < this.fIndex.length; ++i) {
                this.fIndex[i] = 0;
            }
            this.fLayerIndex = 0;
            this.fSublayersEnum = null;
            this.fDirection = n;
            this.fSelfReturned = false;
            this.fTimeToReturnSelf = this.fDirection == 0;
        }

        public Object nextElement() {
            if (this.fTimeToReturnSelf && !this.fSelfReturned) {
                this.fSelfReturned = true;
                return this.fLayer[this.getCurrentLayerIndex()];
            }
            if (this.fSublayersEnum != null) {
                return this.fSublayersEnum.nextElement();
            }
            throw new NoSuchElementException("LayerEnumerator");
        }

        @Override
        public boolean hasMoreElements() {
            if (this.fTimeToReturnSelf && !this.fSelfReturned) {
                return true;
            }
            if (this.fSublayersEnum != null) {
                boolean bl = this.fSublayersEnum.hasMoreElements();
                if (!bl) {
                    this.fSublayersEnum = null;
                    bl = this.hasMoreElements();
                }
                return bl;
            }
            Vector[] vectorArray = this.findSublayer();
            if (vectorArray != null) {
                this.fSublayersEnum = new LayerEnumerator(vectorArray, this.fDirection);
                return this.hasMoreElements();
            }
            if (!this.fSelfReturned) {
                this.fTimeToReturnSelf = true;
                return this.hasMoreElements();
            }
            if (this.fLayerIndex < this.fLayer.length - 1) {
                ++this.fLayerIndex;
                this.fSelfReturned = false;
                this.fSublayersEnum = null;
                return this.hasMoreElements();
            }
            return false;
        }

        private Vector[] findSublayer() {
            int n;
            Vector[] vectorArray = null;
            int n2 = this.getCurrentLayerIndex();
            Vector vector = this.fLayer[n2];
            for (int i = n = this.fIndex[n2]; i < vector.size(); ++i) {
                vectorArray = this.getWrapperOfCurrentLayerAtIndex(i).getLayers();
                if (vectorArray == null) continue;
                this.fIndex[n2] = i + 1;
                break;
            }
            return vectorArray;
        }

        private int getCurrentLayerIndex() {
            int n = this.fLayerIndex;
            if (this.fDirection == 1) {
                n = this.fLayer.length - 1 - this.fLayerIndex;
            }
            return n;
        }

        private LOControlWrapper getWrapperOfCurrentLayerAtIndex(int n) {
            Vector vector = this.fLayer[this.getCurrentLayerIndex()];
            int n2 = n;
            if (this.fDirection == 1) {
                n2 = vector.size() - 1 - n;
            }
            return (LOControlWrapper)vector.elementAt(n2);
        }

        @Override
        public int getDirection() {
            return this.fDirection;
        }
    }

    private class BaseLayerEnumerator
    implements BidirectionEnumeration {
        Vector[] fLayers;
        int fIndex = 0;
        int fDirection = 0;

        BaseLayerEnumerator(Vector[] vectorArray) {
            this(vectorArray, 0);
        }

        BaseLayerEnumerator(Vector[] vectorArray, int n) {
            this.fDirection = n;
            if (this.fDirection == 1) {
                this.fLayers = new Vector[vectorArray.length];
                for (int i = 0; i < vectorArray.length; ++i) {
                    this.fLayers[vectorArray.length - 1 - i] = vectorArray[i];
                }
            } else {
                this.fLayers = vectorArray;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.fLayers != null && this.fIndex < this.fLayers.length;
        }

        public Object nextElement() {
            if (this.fIndex < this.fLayers.length) {
                return this.fLayers[this.fIndex++];
            }
            throw new NoSuchElementException("BaseLayerEnumerator");
        }

        @Override
        public int getDirection() {
            return this.fDirection;
        }
    }

    private class WrapperEnumerator
    implements BidirectionEnumeration {
        Enumeration fLayers = null;
        Enumeration fWrappers = null;
        int fDirection = 0;

        WrapperEnumerator(Enumeration enumeration) {
            this(enumeration, 0);
        }

        WrapperEnumerator(Enumeration enumeration, int n) {
            this.fLayers = enumeration;
            this.fDirection = n;
            this.advance();
        }

        private void advance() {
            while ((this.fWrappers == null || !this.fWrappers.hasMoreElements()) && this.fLayers.hasMoreElements()) {
                LayerVector layerVector = (LayerVector)this.fLayers.nextElement();
                if (this.fDirection == 1) {
                    this.fWrappers = layerVector.reversedElements();
                    continue;
                }
                this.fWrappers = layerVector.elements();
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.fWrappers != null && this.fWrappers.hasMoreElements();
        }

        public Object nextElement() {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)this.fWrappers.nextElement();
            this.advance();
            return lOControlWrapper;
        }

        @Override
        public int getDirection() {
            return this.fDirection;
        }
    }
}

