/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.util.Locale;

public class BooleanConverter
implements ObjectConverter {
    public String toString(Object object, ConverterContext converterContext) {
        if (Boolean.FALSE.equals(object)) {
            return this.getFalse();
        }
        if (Boolean.TRUE.equals(object)) {
            return this.getTrue();
        }
        return this.getNull();
    }

    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public Object fromString(String string, ConverterContext converterContext) {
        if (string.equalsIgnoreCase(this.getTrue())) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase(this.getFalse())) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    protected String getTrue() {
        String string = Resource.getResourceBundle(Locale.getDefault()).getString("Boolean.true");
        return string != null ? string.trim() : string;
    }

    protected String getFalse() {
        String string = Resource.getResourceBundle(Locale.getDefault()).getString("Boolean.false");
        return string != null ? string.trim() : string;
    }

    protected String getNull() {
        return "";
    }
}

