/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.provider;

import com.mathworks.storage.provider.FileMetadata;
import com.mathworks.storage.provider.FolderListEntry;
import com.mathworks.storage.provider.FolderMetadata;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public final class Folder {
    private final Map<String, FileMetadata> fFiles;
    private final Map<String, FolderMetadata> fFolders;
    private final FolderMetadata fMetaData;

    public Folder(String string, Date date, boolean bl) {
        this(new FolderMetadata(string, date, bl));
    }

    public Folder(FolderMetadata folderMetadata) {
        this.fMetaData = folderMetadata;
        this.fFiles = new HashMap<String, FileMetadata>();
        this.fFolders = new HashMap<String, FolderMetadata>();
    }

    public FolderMetadata getMetaData() {
        return this.fMetaData;
    }

    public void addFile(FileMetadata fileMetadata) {
        this.fFiles.put(fileMetadata.getName(), fileMetadata);
    }

    public FileMetadata removeFile(String string) {
        return this.fFiles.remove(string);
    }

    public void addFolder(FolderMetadata folderMetadata) {
        this.fFolders.put(folderMetadata.getName(), folderMetadata);
    }

    public FolderMetadata removeFolder(String string) {
        return this.fFolders.remove(string);
    }

    public boolean isEmpty() {
        return this.fFiles.isEmpty() && this.fFolders.isEmpty();
    }

    public Set<FileMetadata> getFiles() {
        HashSet<FileMetadata> hashSet = new HashSet<FileMetadata>();
        hashSet.addAll(this.fFiles.values());
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<FolderMetadata> getFolders() {
        HashSet<FolderMetadata> hashSet = new HashSet<FolderMetadata>();
        hashSet.addAll(this.fFolders.values());
        return Collections.unmodifiableSet(hashSet);
    }

    public boolean hasFolder(String string) {
        return CollectionUtils.exists(this.getFolders(), (Predicate)new NamePredicate(string));
    }

    public boolean hasFile(String string) {
        return CollectionUtils.exists(this.getFiles(), (Predicate)new NamePredicate(string));
    }

    public FolderMetadata getFolder(String string) {
        return (FolderMetadata)CollectionUtils.find(this.getFolders(), (Predicate)new NamePredicate(string));
    }

    public FileMetadata getFile(String string) {
        return (FileMetadata)CollectionUtils.find(this.getFiles(), (Predicate)new NamePredicate(string));
    }

    public Set<FolderListEntry> listEntries() {
        Set<FolderMetadata> set = this.getFolders();
        Set<FileMetadata> set2 = this.getFiles();
        HashSet<FolderListEntry> hashSet = new HashSet<FolderListEntry>(set.size() + set2.size());
        hashSet.addAll(set2);
        hashSet.addAll(set);
        return hashSet;
    }

    private static class NamePredicate
    implements Predicate {
        private final String fNameToFind;

        private NamePredicate(String string) {
            this.fNameToFind = string;
        }

        public boolean evaluate(Object object) {
            if (object instanceof FolderMetadata) {
                FolderMetadata folderMetadata = (FolderMetadata)object;
                return this.fNameToFind.equals(folderMetadata.getName());
            }
            if (object instanceof FileMetadata) {
                FileMetadata fileMetadata = (FileMetadata)object;
                return this.fNameToFind.equals(fileMetadata.getName());
            }
            return false;
        }
    }
}

