/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import com.mathworks.hadoop.MWArrayWritable;
import com.mathworks.hadoop.MWWritableOutput;
import com.mathworks.hadoop.MxArrayWritable;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class MWMapObject
implements Serializable {
    private MapData mdata = null;
    private Object mcontext = null;

    public MWMapObject(Mapper.Context context, String[] cachedFiles, long fileSize) {
        boolean isMLArrayOutput = context.getMapOutputValueClass().equals(MxArrayWritable.class);
        this.mdata = new MapData(context, fileSize);
        this.mcontext = isMLArrayOutput ? new MapContext(context, cachedFiles) : new MapContext2(context, cachedFiles);
    }

    public MapData getData() {
        return this.mdata;
    }

    public Object getContext() {
        return this.mcontext;
    }

    class MapContext2
    implements Serializable {
        private Mapper.Context context = null;
        private MWWritableOutput vadapter = null;
        private MWWritableOutput kadapter = null;
        private MWArrayWritable mwArray = null;
        private boolean firstTime = true;
        private boolean isTextValue = false;
        private String[] cachedFiles = null;

        MapContext2(Mapper.Context context, String[] cachedFiles) {
            this.context = context;
            this.cachedFiles = cachedFiles;
            this.kadapter = new MWWritableOutput(context.getMapOutputKeyClass());
            if (!context.getMapOutputValueClass().equals(MWArrayWritable.class)) {
                if (context.getMapOutputValueClass().equals(Text.class)) {
                    this.isTextValue = true;
                }
                this.vadapter = new MWWritableOutput(context.getMapOutputValueClass());
            } else {
                this.mwArray = new MWArrayWritable();
            }
        }

        public Mapper.Context getContext() {
            return this.context;
        }

        public String get(String prop) {
            return this.context.getConfiguration().get(prop);
        }

        public String[] getCachedFiles() {
            return this.cachedFiles;
        }

        public boolean isMatlabKey() {
            return false;
        }

        public boolean isMatlabValue() {
            return false;
        }

        public void add(Object keys, Object values) throws IOException, InterruptedException {
            if (keys == null) {
                return;
            }
            if (!keys.getClass().isArray()) {
                if (values == null && this.isTextValue) {
                    this.write(keys, new Text(""));
                } else {
                    this.write(keys, values);
                }
            } else if (values.getClass().isArray()) {
                this.addMultiple((Object[])keys, (Object[])values);
            } else {
                throw new IOException("Values must be an array when the reducer outputs multiple keys");
            }
        }

        public void addMultiple(Object[] keys, Object[] values) throws IOException, InterruptedException {
            if (keys == null) {
                return;
            }
            if (keys.length != values.length) {
                throw new IOException("The number of keys and values must match when they are both cell arrays");
            }
            for (int Index = 0; Index < values.length; ++Index) {
                if (values[Index] == null && this.isTextValue) {
                    this.write(keys[Index], new Text(""));
                    continue;
                }
                this.write(keys[Index], values[Index]);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void write(Object key, Object value) throws IOException, InterruptedException {
            if (this.firstTime) {
                this.kadapter.setWritable(key instanceof Writable);
                if (this.vadapter != null) {
                    this.vadapter.setWritable(value instanceof Writable);
                }
                this.firstTime = false;
            }
            this.kadapter.setInstance(key);
            Writable theKey = this.kadapter.getInstance();
            if (this.vadapter != null) {
                this.vadapter.setInstance(value);
                this.context.write((Object)theKey, (Object)this.vadapter.getInstance());
                return;
            } else if (!value.getClass().isArray()) {
                if (!value.getClass().equals(MWArrayWritable.class)) throw new IOException("The values are not an array as expected");
                this.context.write((Object)theKey, (Object)((MWArrayWritable)value));
                return;
            } else {
                this.mwArray.set(value);
                this.context.write((Object)theKey, (Object)this.mwArray);
            }
        }
    }

    class MapContext
    implements Serializable {
        private Mapper.Context context = null;
        private boolean firstTime = true;
        private MWWritableOutput kadapter = null;
        private String[] cachedFiles = null;
        private boolean bMatlabKey = false;

        MapContext(Mapper.Context context, String[] cachedFiles) {
            this.context = context;
            this.kadapter = new MWWritableOutput(context.getMapOutputKeyClass());
            this.cachedFiles = cachedFiles;
            this.bMatlabKey = context.getMapOutputKeyClass().equals(MxArrayWritable.class);
        }

        public Mapper.Context getContext() {
            return this.context;
        }

        public String get(String prop) {
            return this.context.getConfiguration().get(prop);
        }

        public String[] getCachedFiles() {
            return this.cachedFiles;
        }

        public boolean isMatlabKey() {
            return this.bMatlabKey;
        }

        public boolean isMatlabValue() {
            return true;
        }

        public void add(Object keys, byte[] values) throws IOException, InterruptedException {
            if (keys == null) {
                return;
            }
            if (this.bMatlabKey) {
                this.context.write((Object)new MxArrayWritable((byte[])keys), (Object)new MxArrayWritable(values));
            } else {
                this.write(keys, new MxArrayWritable(values));
            }
        }

        public void addMultiple(Object[] keys, Object[] values) throws IOException, InterruptedException {
            if (keys == null) {
                return;
            }
            if (keys.length != values.length) {
                throw new IOException("The numer of keys and values must match when they are both arrays.");
            }
            for (int index = 0; index < keys.length; ++index) {
                if (this.bMatlabKey) {
                    this.context.write((Object)new MxArrayWritable((byte[])keys[index]), (Object)new MxArrayWritable((byte[])values[index]));
                    continue;
                }
                this.write(keys[index], new MxArrayWritable((byte[])values[index]));
            }
        }

        private void write(Object key, MxArrayWritable value) throws IOException, InterruptedException {
            if (this.firstTime) {
                this.kadapter.setWritable(key instanceof Writable);
                this.firstTime = false;
            }
            this.kadapter.setInstance(key);
            this.context.write((Object)this.kadapter.getInstance(), (Object)value);
        }
    }

    class MapData
    implements Serializable {
        private Mapper.Context context = null;
        private long fileSize;

        MapData(Mapper.Context context, long fileSize) {
            this.context = context;
            this.fileSize = fileSize;
        }

        public Mapper.Context getContext() {
            return this.context;
        }

        public boolean hasData() throws IOException, InterruptedException {
            return this.context.nextKeyValue();
        }

        public Object getKey() throws IOException, InterruptedException {
            return this.context.getCurrentKey();
        }

        public Object getData() throws IOException, InterruptedException {
            return this.context.getCurrentValue();
        }

        public String get(String prop) {
            return this.context.getConfiguration().get(prop);
        }

        public long getFileSize() {
            return this.fileSize;
        }
    }
}

