/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.osgi;

import java.io.File;
import java.net.MalformedURLException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public class OSGiUtils {
    private static final String LOG_PREFIX = "[OSGi] ";
    private static boolean sDebugging = false;

    private OSGiUtils() {
    }

    public static void setDebugging(boolean bl) {
        sDebugging = bl;
        OSGiUtils.log("Enabled debugging messages.");
    }

    public static void log(String string) {
        if (sDebugging) {
            System.out.println(LOG_PREFIX + Thread.currentThread().getId() + " " + string);
        }
    }

    public static String toReferenceUrl(File file) throws MalformedURLException {
        if (file == null) {
            throw new IllegalArgumentException("'file' cannot be null");
        }
        return "reference:" + file.toURL().toString();
    }

    public static StartLevel getStartLevelService(BundleContext bundleContext) {
        ServiceReference serviceReference = bundleContext.getServiceReference(StartLevel.class.getName());
        assert (serviceReference != null) : "Failed to find StartLevel service";
        return (StartLevel)bundleContext.getService(serviceReference);
    }
}

