/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class WeakEventListenerList
extends EventListenerList {
    private int listenerSize;

    @Override
    public synchronized Object[] getListenerList() {
        int n = 0;
        Object[] objectArray = new Object[this.listenerSize];
        for (int i = 1; i < this.listenerSize; i += 2) {
            Object t = ((WeakReference)this.listenerList[i]).get();
            if (t != null) {
                objectArray[n++] = this.listenerList[i - 1];
                objectArray[n++] = t;
                continue;
            }
            System.arraycopy(this.listenerList, i + 1, this.listenerList, i - 1, this.listenerSize - i - 1);
            this.listenerSize -= 2;
            i -= 2;
        }
        if (objectArray.length != n) {
            Object[] objectArray2 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            objectArray = objectArray2;
        }
        return objectArray;
    }

    public synchronized EventListener[] getListeners(Class clazz) {
        int n = 0;
        EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, this.listenerSize);
        for (int i = 0; i < this.listenerSize; ++i) {
            if (this.listenerList[i++] != clazz) continue;
            EventListener eventListener = (EventListener)((WeakReference)this.listenerList[i]).get();
            if (eventListener != null) {
                eventListenerArray[n++] = eventListener;
                continue;
            }
            System.arraycopy(this.listenerList, i + 1, this.listenerList, i - 1, this.listenerSize - i - 1);
            this.listenerSize -= 2;
            i -= 2;
        }
        if (eventListenerArray.length != n) {
            EventListener[] eventListenerArray2 = (EventListener[])Array.newInstance(clazz, n);
            System.arraycopy(eventListenerArray, 0, eventListenerArray2, 0, n);
            eventListenerArray = eventListenerArray2;
        }
        return eventListenerArray;
    }

    public synchronized void add(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        if (this.listenerSize == 0) {
            this.listenerList = new Object[]{clazz, new WeakReference<EventListener>(eventListener)};
            this.listenerSize = 2;
        } else {
            if (this.listenerSize == this.listenerList.length) {
                Object[] objectArray = new Object[this.listenerSize * 2];
                System.arraycopy(this.listenerList, 0, objectArray, 0, this.listenerSize);
                this.listenerList = objectArray;
            }
            this.listenerList[this.listenerSize++] = clazz;
            this.listenerList[this.listenerSize++] = new WeakReference<EventListener>(eventListener);
        }
    }

    public synchronized void remove(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        int n = -1;
        for (int i = this.listenerSize - 2; i >= 0; i -= 2) {
            if (this.listenerList[i] != clazz || eventListener != ((WeakReference)this.listenerList[i + 1]).get()) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            System.arraycopy(this.listenerList, n + 2, this.listenerList, n, this.listenerSize - n - 2);
            this.listenerSize -= 2;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.listenerSize; i += 2) {
            Class clazz = (Class)this.listenerList[i];
            EventListener eventListener = (EventListener)((WeakReference)this.listenerList[i + 1]).get();
            if (eventListener == null || !(eventListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(clazz.getName());
            objectOutputStream.writeObject(eventListener);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            EventListener eventListener = (EventListener)objectInputStream.readObject();
            this.add((Class)Class.forName((String)object), eventListener);
        }
    }

    @Override
    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("WeakEventListenerList: ");
        stringBuffer.append(this.listenerSize / 2);
        stringBuffer.append(" listeners:\n");
        for (int i = 0; i < this.listenerSize; i += 2) {
            stringBuffer.append(" type " + ((Class)this.listenerList[i]).getName());
            stringBuffer.append(" listener " + ((WeakReference)this.listenerList[i + 1]).get());
        }
        return stringBuffer.toString();
    }
}

