/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;

public class ExtSyntaxSupport
extends SyntaxSupport {
    public static final int COMPLETION_POPUP = 0;
    public static final int COMPLETION_CANCEL = 1;
    public static final int COMPLETION_REFRESH = 2;
    public static final int COMPLETION_POST_REFRESH = 3;
    public static final int COMPLETION_HIDE = 4;
    private static final TokenID[] EMPTY_TOKEN_ID_ARRAY = new TokenID[0];
    private DocumentListener docL;
    private HashMap localVarMaps = new HashMap();
    private HashMap globalVarMaps = new HashMap();

    public ExtSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
        this.docL = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ExtSyntaxSupport.this.documentModified(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ExtSyntaxSupport.this.documentModified(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.getDocument().addDocumentListener(this.docL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenItem getTokenChain(int n, int n2) throws BadLocationException {
        if (n < 0) {
            throw new IllegalArgumentException("startOffset=" + n + " < 0");
        }
        if (n > n2) {
            throw new IllegalArgumentException("startOffset=" + n + " > endOffset=" + n2);
        }
        TokenItem tokenItem = null;
        BaseDocument baseDocument = this.getDocument();
        baseDocument.readLock();
        try {
            int n3 = baseDocument.getLength();
            n2 = Math.min(n2, n3);
            if (n < n3) {
                TokenItemTP tokenItemTP = new TokenItemTP();
                tokenItemTP.targetOffset = n2;
                this.tokenizeText(tokenItemTP, n, n2, false);
                tokenItem = tokenItemTP.getTokenChain();
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return tokenItem;
    }

    protected void documentModified(DocumentEvent documentEvent) {
        this.localVarMaps.clear();
        this.globalVarMaps.clear();
    }

    protected BracketFinder getMatchingBracketFinder(char c) {
        BracketFinder bracketFinder = new BracketFinder(c);
        if (bracketFinder.moveCount == 0) {
            bracketFinder = null;
        }
        return bracketFinder;
    }

    public int[] findMatchingBlock(int n, boolean bl) throws BadLocationException {
        int[] nArray;
        char c = this.getDocument().getChars(n, 1)[0];
        int n2 = -1;
        final BracketFinder bracketFinder = this.getMatchingBracketFinder(c);
        if (bracketFinder != null) {
            Object object;
            if (!bl) {
                object = this.getTokenID(n);
                TokenID[] tokenIDArray = this.getBracketSkipTokens();
                for (int i = tokenIDArray.length - 1; i >= 0; --i) {
                    if (object != tokenIDArray[i]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                n2 = bracketFinder.isForward() ? this.getDocument().find(bracketFinder, n, -1) : this.getDocument().find(bracketFinder, n + 1, 0);
            } else {
                object = new TextBatchProcessor(){

                    @Override
                    public int processTextBatch(BaseDocument baseDocument, int n, int n2, boolean bl) {
                        try {
                            int[] nArray = ExtSyntaxSupport.this.getTokenBlocks(n, n2, ExtSyntaxSupport.this.getBracketSkipTokens());
                            return ExtSyntaxSupport.this.findOutsideBlocks(bracketFinder, n, n2, nArray);
                        }
                        catch (BadLocationException badLocationException) {
                            return -1;
                        }
                    }
                };
                n2 = bracketFinder.isForward() ? this.getDocument().processText((TextBatchProcessor)object, n, -1) : this.getDocument().processText((TextBatchProcessor)object, n + 1, 0);
            }
        }
        if (n2 != -1) {
            int[] nArray2 = new int[2];
            nArray2[0] = n2;
            nArray = nArray2;
            nArray2[1] = n2 + 1;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public TokenID[] getBracketSkipTokens() {
        return EMPTY_TOKEN_ID_ARRAY;
    }

    public TokenID getTokenID(int n) throws BadLocationException {
        FirstTokenTP firstTokenTP = new FirstTokenTP();
        this.tokenizeText(firstTokenTP, n, this.getDocument().getLength(), true);
        return firstTokenTP.getTokenID();
    }

    public int[] getFunctionBlock(int[] nArray) throws BadLocationException {
        int n;
        if (nArray != null && (n = Utilities.getFirstNonWhiteFwd(this.getDocument(), nArray[1])) >= 0 && this.getDocument().getChars(n, 1)[0] == '(') {
            return new int[]{nArray[0], n + 1};
        }
        return null;
    }

    public int[] getFunctionBlock(int n) throws BadLocationException {
        return this.getFunctionBlock(Utilities.getIdentifierBlock(this.getDocument(), n));
    }

    public boolean isWhitespaceToken(TokenID tokenID, char[] cArray, int n, int n2) {
        return Analyzer.isWhitespace(cArray, n, n2);
    }

    public boolean isCommentOrWhitespace(int n, int n2) throws BadLocationException {
        CommentOrWhitespaceTP commentOrWhitespaceTP = new CommentOrWhitespaceTP(this.getCommentTokens());
        this.tokenizeText(commentOrWhitespaceTP, n, n2, true);
        return !commentOrWhitespaceTP.nonEmpty;
    }

    public int getRowLastValidChar(int n) throws BadLocationException {
        return Utilities.getRowLastNonWhite(this.getDocument(), n);
    }

    public boolean isRowValid(int n) throws BadLocationException {
        return Utilities.isRowWhite(this.getDocument(), n);
    }

    public TokenID[] getCommentTokens() {
        return EMPTY_TOKEN_ID_ARRAY;
    }

    public int[] getCommentBlocks(int n, int n2) throws BadLocationException {
        return this.getTokenBlocks(n, n2, this.getCommentTokens());
    }

    public Object findType(String string, int n) {
        Object var3_3 = null;
        Map map = this.getLocalVariableMap(n);
        if (map != null) {
            var3_3 = map.get(string);
        }
        if (var3_3 == null && (map = this.getGlobalVariableMap(n)) != null) {
            var3_3 = map.get(string);
        }
        return var3_3;
    }

    public Map getLocalVariableMap(int n) {
        Integer n2 = new Integer(n);
        Map map = (Map)this.localVarMaps.get(n2);
        if (map == null) {
            map = this.buildLocalVariableMap(n);
            this.localVarMaps.put(n2, map);
        }
        return map;
    }

    protected Map buildLocalVariableMap(int n) {
        int n2 = this.getMethodStartPosition(n);
        if (n2 >= 0 && n2 < n) {
            VariableMapTokenProcessor variableMapTokenProcessor = this.createVariableMapTokenProcessor(n2, n);
            try {
                this.tokenizeText(variableMapTokenProcessor, n2, n, true);
                return variableMapTokenProcessor.getVariableMap();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public Map getGlobalVariableMap(int n) {
        Integer n2 = new Integer(n);
        Map map = (Map)this.globalVarMaps.get(n2);
        if (map == null) {
            map = this.buildGlobalVariableMap(n);
            this.globalVarMaps.put(n2, map);
        }
        return map;
    }

    protected Map buildGlobalVariableMap(int n) {
        int n2 = this.getDocument().getLength();
        VariableMapTokenProcessor variableMapTokenProcessor = this.createVariableMapTokenProcessor(0, n2);
        if (variableMapTokenProcessor != null) {
            try {
                this.tokenizeText(variableMapTokenProcessor, 0, n2, true);
                return variableMapTokenProcessor.getVariableMap();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected int getMethodStartPosition(int n) {
        return 0;
    }

    public int findDeclarationPosition(String string, int n) {
        int n2 = this.findLocalDeclarationPosition(string, n);
        if (n2 < 0) {
            n2 = this.findGlobalDeclarationPosition(string, n);
        }
        return n2;
    }

    public int findLocalDeclarationPosition(String string, int n) {
        int n2 = this.getMethodStartPosition(n);
        if (n2 >= 0 && n2 < n) {
            return this.findDeclarationPositionImpl(string, n2, n);
        }
        return -1;
    }

    public int findGlobalDeclarationPosition(String string, int n) {
        return this.findDeclarationPositionImpl(string, 0, this.getDocument().getLength());
    }

    private int findDeclarationPositionImpl(String string, int n, int n2) {
        DeclarationTokenProcessor declarationTokenProcessor = this.createDeclarationTokenProcessor(string, n, n2);
        if (declarationTokenProcessor != null) {
            try {
                this.tokenizeText(declarationTokenProcessor, n, n2, true);
                return declarationTokenProcessor.getDeclarationPosition();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DeclarationTokenProcessor createDeclarationTokenProcessor(String string, int n, int n2) {
        return null;
    }

    protected VariableMapTokenProcessor createVariableMapTokenProcessor(int n, int n2) {
        return null;
    }

    public int checkCompletion(JTextComponent jTextComponent, String string, boolean bl) {
        return bl ? 4 : 1;
    }

    protected class FirstTokenTP
    implements TokenProcessor {
        private TokenID tokenID;

        public TokenID getTokenID() {
            return this.tokenID;
        }

        @Override
        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            this.tokenID = tokenID;
            return false;
        }

        @Override
        public int eot(int n) {
            return 0;
        }

        @Override
        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
        }
    }

    class CommentOrWhitespaceTP
    implements TokenProcessor {
        private char[] buffer;
        private TokenID[] commentTokens;
        boolean nonEmpty;

        CommentOrWhitespaceTP(TokenID[] tokenIDArray) {
            this.commentTokens = tokenIDArray;
        }

        @Override
        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            boolean bl;
            for (bl = false; bl < this.commentTokens.length; bl += 1) {
                if (tokenID != this.commentTokens[bl]) continue;
                return true;
            }
            bl = ExtSyntaxSupport.this.isWhitespaceToken(tokenID, this.buffer, n, n2);
            if (bl) {
                this.nonEmpty = true;
            }
            return bl;
        }

        @Override
        public int eot(int n) {
            return 0;
        }

        @Override
        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.buffer = cArray;
        }
    }

    final class TokenItemTP
    implements TokenProcessor {
        private Item firstItem;
        private Item lastItem;
        private int fwdBatchLineCnt;
        private int bwdBatchLineCnt;
        private char[] buffer;
        private int bufferStartPos;
        int targetOffset;

        TokenItemTP() {
            this.fwdBatchLineCnt = this.bwdBatchLineCnt = ((Integer)ExtSyntaxSupport.this.getDocument().getProperty("line-batch-size")).intValue();
        }

        public TokenItem getTokenChain() {
            return this.firstItem;
        }

        @Override
        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            if (this.bufferStartPos + n >= this.targetOffset) {
                return false;
            }
            this.lastItem = new Item(tokenID, tokenContextPath, this.bufferStartPos + n, new String(this.buffer, n, n2), this.lastItem);
            if (this.firstItem == null) {
                this.firstItem = this.lastItem;
            }
            return true;
        }

        @Override
        public int eot(int n) {
            return (Integer)ExtSyntaxSupport.this.getDocument().getProperty("mark-distance");
        }

        @Override
        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.buffer = cArray;
            this.bufferStartPos = n3 - n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Item getNextChunk(Item item) {
            int n;
            int n2;
            BaseDocument baseDocument = ExtSyntaxSupport.this.getDocument();
            int n3 = item.getOffset() + item.getImage().length();
            if (n3 == (n2 = baseDocument.getLength())) {
                return null;
            }
            try {
                n = Utilities.getRowStart(baseDocument, n3, this.fwdBatchLineCnt);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            if (n == -1) {
                n = n2;
            }
            this.fwdBatchLineCnt *= 2;
            Item item2 = null;
            Item item3 = this.firstItem;
            Item item4 = this.lastItem;
            try {
                this.firstItem = null;
                this.lastItem = null;
                this.targetOffset = n;
                ExtSyntaxSupport.this.tokenizeText(this, n3, n, false);
                item2 = this.firstItem;
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (this.firstItem != null) {
                    item4.next = this.firstItem;
                    this.firstItem.previous = item4;
                }
                this.firstItem = item3;
                if (this.lastItem == null) {
                    this.lastItem = item4;
                }
            }
            return item2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Item getPreviousChunk(Item item) {
            int n;
            BaseDocument baseDocument = ExtSyntaxSupport.this.getDocument();
            int n2 = item.getOffset();
            if (n2 == 0) {
                return null;
            }
            try {
                n = Utilities.getRowStart(baseDocument, n2, -this.bwdBatchLineCnt);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            if (n == -1) {
                n = 0;
            }
            this.bwdBatchLineCnt *= 2;
            Item item2 = null;
            Item item3 = this.firstItem;
            Item item4 = this.lastItem;
            try {
                this.firstItem = null;
                this.lastItem = null;
                this.targetOffset = n2;
                ExtSyntaxSupport.this.tokenizeText(this, n, n2, false);
                item2 = this.lastItem;
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (this.lastItem != null) {
                    item3.previous = this.lastItem;
                    this.lastItem.next = item3;
                }
                this.lastItem = item4;
                if (this.firstItem == null) {
                    this.firstItem = item3;
                }
            }
            return item2;
        }

        final class Item
        extends TokenItem.AbstractItem {
            Item previous;
            TokenItem next;

            Item(TokenID tokenID, TokenContextPath tokenContextPath, int n, String string, Item item) {
                super(tokenID, tokenContextPath, n, string);
                if (item != null) {
                    this.previous = item;
                    item.next = this;
                }
            }

            @Override
            public TokenItem getNext() {
                if (this.next == null) {
                    this.next = TokenItemTP.this.getNextChunk(this);
                }
                return this.next;
            }

            @Override
            public TokenItem getPrevious() {
                if (this.previous == null) {
                    this.previous = TokenItemTP.this.getPreviousChunk(this);
                }
                return this.previous;
            }
        }
    }

    public class BracketFinder
    extends FinderFactory.GenericFinder {
        protected char bracketChar;
        protected char matchChar;
        private int depth;
        protected int moveCount;

        public BracketFinder(char c) {
            this.bracketChar = c;
            this.updateStatus();
            this.forward = this.moveCount > 0;
        }

        protected boolean updateStatus() {
            boolean bl = true;
            switch (this.bracketChar) {
                case '(': {
                    this.matchChar = (char)41;
                    this.moveCount = 1;
                    break;
                }
                case ')': {
                    this.matchChar = (char)40;
                    this.moveCount = -1;
                    break;
                }
                case '{': {
                    this.matchChar = (char)125;
                    this.moveCount = 1;
                    break;
                }
                case '}': {
                    this.matchChar = (char)123;
                    this.moveCount = -1;
                    break;
                }
                case '[': {
                    this.matchChar = (char)93;
                    this.moveCount = 1;
                    break;
                }
                case ']': {
                    this.matchChar = (char)91;
                    this.moveCount = -1;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        protected int scan(char c, boolean bl) {
            if (c == this.bracketChar) {
                ++this.depth;
            } else if (c == this.matchChar && --this.depth == 0) {
                this.found = true;
                return 0;
            }
            return this.moveCount;
        }
    }

    public static interface VariableMapTokenProcessor
    extends TokenProcessor {
        public Map getVariableMap();
    }

    public static interface DeclarationTokenProcessor
    extends TokenProcessor {
        public int getDeclarationPosition();
    }
}

