/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.netbeans.lib.editor.util.AbstractCharSequence;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.PriorityDocumentListenerList;

public final class DocumentUtilities {
    private static final Object TYPING_MODIFICATION_DOCUMENT_PROPERTY = new Object();
    public static final Element MODIFICATION_TEXT_ELEMENT = ModificationTextElement.INSTANCE;

    private DocumentUtilities() {
    }

    public static void addDocumentListener(Document document, DocumentListener documentListener, DocumentListenerPriority documentListenerPriority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)document.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.add(documentListener, documentListenerPriority.getPriority());
        } else {
            document.addDocumentListener(documentListener);
        }
    }

    public static void removeDocumentListener(Document document, DocumentListener documentListener, DocumentListenerPriority documentListenerPriority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)document.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.remove(documentListener, documentListenerPriority.getPriority());
        } else {
            document.removeDocumentListener(documentListener);
        }
    }

    public static DocumentListener initPriorityListening(Document document) {
        if (document.getProperty(PriorityDocumentListenerList.class) != null) {
            throw new IllegalStateException("PriorityDocumentListenerList already initialized for doc=" + document);
        }
        PriorityDocumentListenerList priorityDocumentListenerList = new PriorityDocumentListenerList();
        document.putProperty(PriorityDocumentListenerList.class, priorityDocumentListenerList);
        return priorityDocumentListenerList;
    }

    public static void setTypingModification(Document document, boolean bl) {
        document.putProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY, bl);
    }

    public static boolean isTypingModification(DocumentEvent documentEvent) {
        Boolean bl = (Boolean)documentEvent.getDocument().getProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY);
        return bl != null ? bl : false;
    }

    public static boolean isTypingModification(Document document) {
        Boolean bl = (Boolean)document.getProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY);
        return bl != null ? bl : false;
    }

    public static CharSequence getText(Document document) {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            charSequence = new DocumentCharSequence(document);
            document.putProperty(CharSequence.class, charSequence);
        }
        return charSequence;
    }

    public static CharSequence getText(Document document, int n, int n2) throws BadLocationException {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            charSequence = new DocumentCharSequence(document);
            document.putProperty(CharSequence.class, charSequence);
        }
        try {
            return charSequence.subSequence(n, n + n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n3 = n;
            if (n >= 0 && n + n2 > charSequence.length()) {
                n3 = n2;
            }
            throw new BadLocationException(indexOutOfBoundsException.getMessage(), n3);
        }
    }

    public static String getModificationText(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(MODIFICATION_TEXT_ELEMENT);
        return elementChange != null ? elementChange.toString() : null;
    }

    private static final class ModificationTextElement
    implements Element {
        static final ModificationTextElement INSTANCE = new ModificationTextElement();

        private ModificationTextElement() {
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return 0;
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public int getElementIndex(int n) {
            return -1;
        }

        @Override
        public Element getElement(int n) {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Element getParentElement() {
            return null;
        }

        @Override
        public String getName() {
            return "Helper element for modification text providing";
        }

        @Override
        public Document getDocument() {
            return null;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static final class DocumentCharSequence
    extends AbstractCharSequence.StringLike {
        private final Segment segment = new Segment();
        private final Document doc;

        DocumentCharSequence(Document document) {
            this.doc = document;
        }

        @Override
        public int length() {
            return this.doc.getLength();
        }

        @Override
        public synchronized char charAt(int n) {
            try {
                this.doc.getText(n, 1, this.segment);
            }
            catch (BadLocationException badLocationException) {
                throw new IndexOutOfBoundsException(badLocationException.getMessage() + " at offset=" + badLocationException.offsetRequested());
            }
            return this.segment.array[this.segment.offset];
        }
    }
}

