/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.config.Config;
import com.sun.jini.logging.Levels;
import com.sun.jini.norm.NormServerBaseImpl;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.util.logging.Level;
import net.jini.activation.ActivationExporter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

class ActivatableNormServerImpl
extends NormServerBaseImpl {
    private ActivationID activationID;
    private ActivationSystem activationSystem;

    public void destroy() throws RemoteException {
        try {
            this.activationSystem.unregisterObject(this.activationID);
            logger.log(Level.FINEST, "Unregistered object with activation system");
        }
        catch (ActivationException activationException) {
            logger.log(Levels.HANDLED, "Unable to unregister object with activation system", activationException);
        }
        super.destroy();
    }

    void postDestroy() {
        try {
            net.jini.activation.ActivationGroup.inactive((ActivationID)this.activationID, (Exporter)this.exporter);
            logger.log(Level.FINEST, "Inactivated object with activation system");
        }
        catch (RemoteException remoteException) {
            logger.log(Levels.HANDLED, "Unable to inactivate object with activation system", remoteException);
        }
        catch (ActivationException activationException) {
            logger.log(Levels.HANDLED, "Unable to inactivate object with activation system", activationException);
        }
    }

    ActivatableNormServerImpl(ActivationID activationID, MarshalledObject marshalledObject) throws Exception {
        super(true);
        String[] stringArray = null;
        try {
            if (activationID == null) {
                throw new NullPointerException("activationID is null");
            }
            stringArray = (String[])marshalledObject.get();
        }
        catch (Throwable throwable) {
            ActivatableNormServerImpl.initFailed(throwable);
        }
        this.activationID = activationID;
        this.init(stringArray, null);
    }

    void initAsSubject(Configuration configuration) throws Exception {
        ProxyPreparer proxyPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.norm", "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.activationSystem = (ActivationSystem)proxyPreparer.prepareProxy((Object)ActivationGroup.getSystem());
        ProxyPreparer proxyPreparer2 = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.norm", "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.activationID = (ActivationID)proxyPreparer2.prepareProxy((Object)this.activationID);
        super.initAsSubject(configuration);
    }

    Exporter getExporter(Configuration configuration) throws ConfigurationException {
        Exporter exporter = (Exporter)Config.getNonNullEntry(configuration, "com.sun.jini.norm", "serverExporter", Exporter.class, new ActivationExporter(this.activationID, (Exporter)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory())), this.activationID);
        return exporter;
    }
}

