/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.norm.ClientLeaseWrapper;
import com.sun.jini.norm.NormServerBaseImpl;
import com.sun.jini.norm.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.lease.DesiredExpirationListener;
import net.jini.lease.LeaseRenewalEvent;

class LRMEventListener
extends Thread
implements DesiredExpirationListener {
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private final NormServerBaseImpl server;
    private final Queue queue = new Queue();
    static final LeaseDeniedException EXPIRED_SET_EXCEPTION = new LeaseDeniedException("Set Expired");

    LRMEventListener(NormServerBaseImpl normServerBaseImpl) {
        super("LRM Event Listener");
        this.setDaemon(true);
        this.server = normServerBaseImpl;
    }

    public void notify(LeaseRenewalEvent leaseRenewalEvent) {
        if (leaseRenewalEvent.getException() == EXPIRED_SET_EXCEPTION) {
            return;
        }
        Lease lease = leaseRenewalEvent.getLease();
        if (lease instanceof ClientLeaseWrapper) {
            ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)lease;
            this.queue.enqueue(new Discriminator(clientLeaseWrapper, true));
        }
    }

    public void expirationReached(LeaseRenewalEvent leaseRenewalEvent) {
        Lease lease = leaseRenewalEvent.getLease();
        if (lease instanceof ClientLeaseWrapper) {
            ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)lease;
            this.queue.enqueue(new Discriminator(clientLeaseWrapper, false));
        }
    }

    public void run() {
        while (!this.isInterrupted()) {
            try {
                Discriminator discriminator = (Discriminator)this.queue.dequeue();
                if (discriminator.isFailure) {
                    this.server.renewalFailure(discriminator.clw);
                    continue;
                }
                this.server.desiredExpirationReached(discriminator.clw);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.INFO, "Exception in LRMEventListener Notifier while processing an event from the LRM -- attempting to continue", runtimeException);
            }
            catch (Error error) {
                logger.log(Level.INFO, "Exception in LRMEventListener Notifier while processing an event from the LRM -- attempting to continue", error);
            }
        }
    }

    private static class Discriminator {
        private final boolean isFailure;
        private final ClientLeaseWrapper clw;

        private Discriminator(ClientLeaseWrapper clientLeaseWrapper, boolean bl) {
            this.isFailure = bl;
            this.clw = clientLeaseWrapper;
        }
    }
}

