/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.debug.Debug;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.FormInputText;
import ice.pilots.html4.awt.FormTextArea;
import ice.pilots.html4.awt.Movable;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.awt.AWTEventListenerCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class DocPanel
extends Panel
implements AWTEventListenerCallback {
    private static final boolean FALSE = Defs.sysProperty((String)"os.name").startsWith("Mac OS");
    private DocView OEAB;
    int sx = 0;
    int sy = 0;
    int nsx = 0;
    int nsy = 0;
    private Image TRUE = null;
    boolean reflow_req = false;
    private boolean TYPE = false;
    private boolean _panePanel = false;
    private int abs;
    private int add;
    private int append;
    private int canScroll = -1;
    private int checkIfVisible = -1;
    private int copyArea = -1;
    private int createImage = -1;
    private int currentTimeMillis = 0;
    private int dispose = 1;
    private boolean docClearSelection = false;
    private long docContainsFixedBoxes = 0L;
    private boolean docLayout;
    private Object docPaint;
    boolean preventOptimisedPaintOnce = false;

    DocPanel(DocView docView) {
        this.OEAB = docView;
        this.enableEvents(60L);
        this.setLayout(null);
        this.abs = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollHeight", (int)14);
        this.add = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollTimeout", (int)100);
        this.docClearSelection = Defs.sysPropertyBoolean((String)"ice.pilots.html4.awt.reclaimFocus");
        String string = Defs.sysProperty((String)"ice.pilots.html4.selectButton");
        if (!docView.enableTextSelection) {
            string = "none";
        }
        this.currentTimeMillis = ComponentFactory.parseButton(string, this.currentTimeMillis);
        string = Defs.sysProperty((String)"ice.pilots.html4.scrollButton");
        this.dispose = ComponentFactory.parseButton(string, this.dispose);
        if (JavaVersion.isV14orGreater()) {
            this.checkIfVisible();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Component add(Component component) {
        component.setVisible(false);
        if (!FALSE) {
            super.add(component);
            return component;
        }
        if (component instanceof FormInputText || component instanceof FormTextArea) {
            try {
                Class<?> clazz = component.getClass();
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = clazz.getMethod("enableInputMethods", classArray);
                Object[] objectArray = new Object[]{Boolean.TRUE};
                Object[] objectArray2 = new Object[]{Boolean.FALSE};
                method.invoke((Object)component, objectArray2);
                super.add(component);
                method.invoke((Object)component, objectArray);
            }
            catch (Exception exception) {
                Debug.ex((Throwable)exception);
            }
        } else {
            super.add(component);
        }
        return component;
    }

    public void removeNotify() {
        if (this.TRUE != null) {
            this.TRUE.flush();
            this.TRUE = null;
        }
        super.removeNotify();
    }

    private void FALSE() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this._panePanel) {
                return;
            }
            this._panePanel = true;
            int n = this.getComponentCount();
            try {
                int n2 = 0;
                while (n2 < n) {
                    Component component = this.getComponent(n2);
                    if (component.isVisible()) {
                        component.setVisible(false);
                    }
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    void showChildren() {
        FocusManager focusManager;
        long l = System.currentTimeMillis();
        if (l - this.docContainsFixedBoxes < this.OEAB.repaintTimeout) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this._panePanel) {
                return;
            }
            this._panePanel = false;
            int n = this.getComponentCount();
            try {
                int n2 = 0;
                while (n2 < n) {
                    Movable movable;
                    ObjectBox objectBox;
                    Component component = this.getComponent(n2);
                    if (component instanceof Movable && (objectBox = (movable = (Movable)((Object)component)).getBox()) != null) {
                        Point point = new Point(0, 0);
                        objectBox.findAbsolutePosition(point);
                        movable.syncDom(point.x - this.sx, point.y - this.sy, objectBox.checkIfVisible());
                    }
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
        if (this.docClearSelection && !(focusManager = this.OEAB.getPilot().getView().getFocusManager()).requestFocus()) {
            this.requestFocus();
        }
        this.docLayout = true;
    }

    public void doLayout() {
        int n;
        int n2;
        block19: {
            if (this.OEAB.isPilotDisposed()) {
                return;
            }
            Dimension dimension = this.getSize();
            n2 = dimension.width;
            n = dimension.height;
            if (this.TRUE != null && (this.TRUE.getWidth(null) != n2 || this.TRUE.getHeight(null) != n)) {
                this.TRUE.flush();
                this.TRUE = null;
            }
            try {
                this.OEAB.docLayout(n2, n);
            }
            catch (Exception exception) {
                if (Debug.ex) {
                    Debug.ex((Throwable)exception);
                }
                if (!Debug.trace) break block19;
                Debug.trace((String)("Layout exception: " + exception));
            }
        }
        Scrollbar scrollbar = this.OEAB.vbar;
        Scrollbar scrollbar2 = this.OEAB.hbar;
        if (scrollbar != null && this.isVisible()) {
            int n3 = scrollbar.getValue();
            int n4 = n;
            int n5 = this.OEAB.getDocHeight();
            if (n4 > n5) {
                n4 = n5;
            }
            if (n3 + n4 > n5) {
                this.sy = this.nsy = (n3 = n5 - n4);
            }
            scrollbar.setValues(n3, n4, 0, n5);
            scrollbar.setBlockIncrement(n4);
            scrollbar.setUnitIncrement(20);
            int n6 = scrollbar2.getValue();
            int n7 = this.OEAB.getDocWidth();
            int n8 = n2;
            if (n8 > n7) {
                n8 = n7;
            }
            if (n6 + n8 > n7) {
                this.sx = this.nsx = (n6 = n7 - n8);
            }
            scrollbar2.setValues(n6, n8, 0, n7);
            scrollbar2.setBlockIncrement(n8);
            scrollbar2.setUnitIncrement(20);
            boolean bl = false;
            if (n5 <= n4) {
                if (scrollbar.isVisible() && this.OEAB.validateTreeNesting <= 1) {
                    scrollbar.setVisible(false);
                    bl = true;
                }
            } else if (!scrollbar.isVisible()) {
                scrollbar.setVisible(true);
                bl = true;
            }
            if (n7 <= n8) {
                if (scrollbar2.isVisible() && this.OEAB.validateTreeNesting <= 1) {
                    scrollbar2.setVisible(false);
                    bl = true;
                }
            } else if (!scrollbar2.isVisible()) {
                scrollbar2.setVisible(true);
                bl = true;
            }
            if (bl) {
                this.OEAB._panePanel.validateTree();
                return;
            }
        }
        this.OEAB.docPostLayout();
        this.sx = this.nsx;
        this.sy = this.nsy;
        this._panePanel = true;
        this.docContainsFixedBoxes = 0L;
        this.showChildren();
    }

    void scroll(int n, int n2) {
        if (this.OEAB.canScroll(n, n2)) {
            this.nsx = n;
            this.nsy = n2;
            this.FALSE();
            this.repaint();
            this.docContainsFixedBoxes = System.currentTimeMillis();
            this.OEAB.postShowChildren(this);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            if (Debug.trace) {
                Debug.trace((String)("Error: negative dimension: w=" + n3 + " h=" + n4));
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2;
        if (this.OEAB.isPilotDisposed()) {
            return;
        }
        if (!this.OEAB.doesAutoRepaint()) {
            return;
        }
        if (graphics == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Dimension dimension = this.getSize();
        if (rectangle != null) {
            if (rectangle.x >= dimension.width) {
                return;
            }
            if (rectangle.y >= dimension.height) {
                return;
            }
            if (rectangle.x + rectangle.width < 0) {
                return;
            }
            if (rectangle.y + rectangle.height < 0) {
                return;
            }
        }
        if (this.TRUE == null) {
            try {
                this.TRUE = this.createImage(dimension.width, dimension.height);
            }
            catch (Exception exception) {
                return;
            }
        }
        if ((graphics2 = this.TRUE.getGraphics()) == null) {
            if (this.TRUE != null) {
                this.TRUE.flush();
            }
            this.TRUE = null;
            return;
        }
        if (this.preventOptimisedPaintOnce || this.OEAB.docContainsFixedBoxes() || this.nsx != this.sx && this.nsy != this.sy) {
            this.sx = this.nsx;
            this.sy = this.nsy;
        } else if (rectangle == null || rectangle.width == dimension.width && rectangle.height == dimension.height) {
            if (this.nsy < this.sy) {
                if (this.sy - this.nsy < dimension.height) {
                    graphics.copyArea(0, 0, dimension.width, dimension.height - (this.sy - this.nsy), 0, this.sy - this.nsy);
                    graphics.setClip(0, 0, dimension.width, this.sy - this.nsy);
                }
            } else if (this.nsy > this.sy) {
                if (this.nsy - this.sy < dimension.height) {
                    graphics.copyArea(0, this.nsy - this.sy, dimension.width, dimension.height - (this.nsy - this.sy), 0, this.sy - this.nsy);
                    graphics.setClip(0, dimension.height - (this.nsy - this.sy), dimension.width, this.nsy - this.sy);
                }
            } else if (this.nsx < this.sx) {
                if (this.sx - this.nsx < dimension.width) {
                    graphics.copyArea(0, 0, dimension.width - (this.sx - this.nsx), dimension.height, this.sx - this.nsx, 0);
                    graphics.setClip(0, 0, this.sx - this.nsx, dimension.height);
                }
            } else if (this.nsx > this.sx && this.nsx - this.sx < dimension.width) {
                graphics.copyArea(this.nsx - this.sx, 0, dimension.width - (this.nsx - this.sx), dimension.height, this.sx - this.nsx, 0);
                graphics.setClip(dimension.width - (this.nsx - this.sx), 0, this.nsx - this.sx, dimension.height);
            }
            rectangle = graphics.getClipBounds();
            this.sy = this.nsy;
            this.sx = this.nsx;
        }
        if (rectangle == null) {
            graphics.setClip(0, 0, dimension.width, dimension.height);
            rectangle = graphics.getClipBounds();
        }
        graphics2.setClip(rectangle);
        this.docLayout = false;
        this.OEAB(graphics2, rectangle);
        if (!this.docLayout) {
            this._panePanel = true;
            this.showChildren();
        }
        graphics2.dispose();
        if (this.TRUE != null) {
            graphics.drawImage(this.TRUE, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
        }
        this.preventOptimisedPaintOnce = false;
    }

    private void OEAB(Graphics graphics, Rectangle rectangle) {
        graphics.translate(-this.sx, -this.sy);
        graphics.setClip(rectangle.x + this.sx, rectangle.y + this.sy, rectangle.width, rectangle.height);
        this.OEAB.docPaint(graphics);
        graphics.translate(this.sx, this.sy);
        this.OEAB.docPaintFixed(graphics);
    }

    private boolean TRUE(int n, InputEvent inputEvent) {
        if (n < 0) {
            return false;
        }
        int n2 = inputEvent.getModifiers();
        if (n == 0 && (n2 == 0 || (n2 & 0x10) != 0)) {
            return true;
        }
        return n == 1 && (n2 & 4) != 0;
    }

    private void TYPE(MouseEvent mouseEvent) {
        this.append = mouseEvent.getY();
        if (this.TRUE(this.dispose, mouseEvent)) {
            if (this.canScroll >= 0) {
                int n = this.canScroll - mouseEvent.getX();
                int n2 = this.checkIfVisible - mouseEvent.getY();
                if (Math.abs(n) > Math.abs(n2)) {
                    n2 = 0;
                } else {
                    n = 0;
                }
                this.OEAB.setScrollPosition(this.sx + n, this.sy + n2);
            }
            this.canScroll = mouseEvent.getX();
            this.checkIfVisible = mouseEvent.getY();
        } else if (this.TRUE(this.currentTimeMillis, mouseEvent)) {
            if (this.copyArea >= 0) {
                int n = 0;
                if (mouseEvent.getY() > this.getSize().height) {
                    n = this.abs;
                } else if (mouseEvent.getY() < 0) {
                    n = -this.abs;
                }
                this._panePanel(n, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.copyArea = mouseEvent.getX();
                this.createImage = mouseEvent.getY();
            }
        }
    }

    private void _panePanel(int n, int n2, int n3) {
        if (n != 0) {
            long l = System.currentTimeMillis();
            if (l - this.docContainsFixedBoxes > (long)this.add) {
                int n4 = this.OEAB.vbar.getMaximum();
                int n5 = this.OEAB.vbar.getVisibleAmount();
                int n6 = this.OEAB.vbar.getValue();
                if (n > 0 && n6 + n5 == n4) {
                    return;
                }
                if (n < 0 && n6 == 0) {
                    return;
                }
                this.OEAB.setScrollPosition(this.sx, this.sy + n);
                this.docContainsFixedBoxes = l;
                this.createImage -= n;
            }
            ScrollTimer scrollTimer = new ScrollTimer(this, n2, n3, n);
            this.OEAB.getPilot().getStorm().runOnEventThreadLater(scrollTimer, this.add + 10);
        }
        this.OEAB.docSetSelection(this.copyArea, this.createImage, n2, n3 + n);
    }

    void verifyScrollTime(ScrollTimer scrollTimer) {
        if (this.copyArea != -1 && scrollTimer.dragY == this.append) {
            this._panePanel(scrollTimer.scr, scrollTimer.selX, scrollTimer.dragY);
        }
    }

    private void abs(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.TRUE(this.currentTimeMillis, mouseEvent)) {
            this.OEAB.docClearSelection();
        }
    }

    private void add(MouseEvent mouseEvent) {
        this.canScroll = -1;
        this.copyArea = -1;
    }

    private void append(MouseEvent mouseEvent) {
        this.canScroll = -1;
    }

    private void canScroll(MouseEvent mouseEvent) {
        if (this.TRUE(this.currentTimeMillis, mouseEvent)) {
            int n = mouseEvent.getClickCount();
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            Html4DocumentAccess html4DocumentAccess = new Html4DocumentAccess(this.OEAB.getPilot());
            switch (n) {
                case 4: {
                    html4DocumentAccess.setSelection(0, n2, n3);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    html4DocumentAccess.setSelection(2, n2, n3);
                }
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.OEAB.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
            switch (aWTEvent.getID()) {
                case 506: {
                    this.TYPE((MouseEvent)aWTEvent);
                    break;
                }
                case 501: {
                    this.abs((MouseEvent)aWTEvent);
                    break;
                }
                case 502: {
                    this.add((MouseEvent)aWTEvent);
                    break;
                }
                case 505: {
                    this.append((MouseEvent)aWTEvent);
                    break;
                }
                case 500: {
                    this.canScroll((MouseEvent)aWTEvent);
                }
            }
        }
    }

    private void checkIfVisible() {
        block4: {
            try {
                String string = "ice.util.awt.jdk12.AWTEventListener";
                Constructor<?> constructor = Class.forName(string).getConstructors()[0];
                Object[] objectArray = new Object[]{this};
                this.docPaint = constructor.newInstance(objectArray);
                if (Debug.trace) {
                    Debug.trace((String)"Custom AWTEventListener constructed.");
                }
            }
            catch (Throwable throwable) {
                if (Debug.trace) {
                    Debug.trace((String)"Problem constructing custom AWTEventListener.");
                }
                if (!Debug.ex) break block4;
                Debug.ex((Throwable)throwable);
            }
        }
    }

    public void receiveEvent(AWTEvent aWTEvent) {
        if (this.equals(aWTEvent.getSource())) {
            this.processEvent(aWTEvent);
        }
    }

    public void dispose() {
        if (this.docPaint != null) {
            this.copyArea();
        }
    }

    private void copyArea() {
        block3: {
            try {
                Method method = this.docPaint.getClass().getDeclaredMethod("dispose", null);
                method.invoke(this.docPaint, null);
                if (Debug.trace) {
                    Debug.trace((String)"Custom AWTEventListener disposed.");
                }
            }
            catch (Throwable throwable) {
                if (!Debug.ex) break block3;
                Debug.ex((Throwable)throwable);
            }
        }
    }

    private static class ScrollTimer
    implements Runnable {
        final DocPanel owner;
        final int dragY;
        final int selX;
        final int scr;

        ScrollTimer(DocPanel docPanel, int n, int n2, int n3) {
            this.owner = docPanel;
            this.dragY = n2;
            this.scr = n3;
            this.selX = n;
        }

        public void run() {
            this.owner.verifyScrollTime(this);
        }
    }
}

