/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ImageConnection;
import ice.storm.UrlMaster;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.ResourceOwner;
import ice.util.alg.Session;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Image;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class ImageCache
implements ResourceOwner {
    private static final Object NO_SYNCHRONIZATION = new Object();
    private static final HashArray OEAB = new HashArray(Defs.NO_SYNCHRONIZATION);
    private static long addElement = 0L;
    private static boolean append = true;
    private static Method bug = null;
    private Session currentThread;
    private int currentTimeMillis = 0;
    protected HashArray uriToEntry;
    protected HashArray imageToEntry;
    protected int timeout = 30;
    static final int NUMBER_OF_LOADER_THREADS = 4;
    private int dieTime = 0;
    private Toolkit disposeResources;
    private boolean doPrivileged;

    protected ImageCache(Session session) {
        this.currentThread = session;
        this.uriToEntry = new HashArray(Defs.NO_SYNCHRONIZATION);
        this.imageToEntry = new HashArray(Defs.NO_SYNCHRONIZATION);
        this.disposeResources = Toolkit.getDefaultToolkit();
    }

    public static ImageCache get(Session session) {
        ImageCache imageCache = (ImageCache)session.getEntry(NO_SYNCHRONIZATION);
        if (imageCache == null) {
            imageCache = ImageCache.set(session, new ImageCache(session));
        }
        return imageCache;
    }

    public static ImageCache set(Session session, ImageCache imageCache) {
        return (ImageCache)session.initEntry(NO_SYNCHRONIZATION, (Object)imageCache);
    }

    public void setReload(boolean bl) {
        this.doPrivileged = bl;
    }

    public Toolkit getAwtToolkit() {
        return this.disposeResources;
    }

    public void setExpire(int n) {
        this.timeout = n;
    }

    public int getExpire() {
        return this.timeout;
    }

    public void dispose() {
        this.disposeResources();
    }

    public void disposeResources() {
        this.flushImages(true);
    }

    public Image getImage(URL uRL) {
        return this.getImage(uRL.toExternalForm());
    }

    public Image getImage(String string) {
        Entry entry;
        URL uRL = null;
        boolean bl = false;
        Image image = null;
        ImageCache imageCache = this;
        synchronized (imageCache) {
            entry = (Entry)this.uriToEntry.get((Object)string);
            if (this.doPrivileged && entry != null && entry.image != null) {
                image = this.OEAB(entry);
                entry = null;
            }
            if (entry == null) {
                entry = new Entry(this, null);
                entry.url = string;
                entry.realUrlObj = UrlMaster.get(this.currentThread).newURL(string);
                if (entry.realUrlObj == null) {
                    Image image2 = null;
                    return image2;
                }
                this.uriToEntry.put((Object)string, (Object)entry);
                ++entry.ref;
                uRL = this.append(entry) ? entry.proxyUrlObj : entry.realUrlObj;
            } else if (entry.image != null) {
                this.NO_SYNCHRONIZATION(entry);
                Image image3 = entry.image;
                return image3;
            }
        }
        if (image != null) {
            image.flush();
        }
        if (uRL != null) {
            if (entry.initializedImage) {
                Debug.bug();
            }
            Image image4 = this.addElement(uRL);
            ImageCache imageCache2 = this;
            synchronized (imageCache2) {
                if (image4 != null) {
                    entry.image = image4;
                    this.imageToEntry.put((Object)entry.image, (Object)entry);
                } else {
                    --entry.ref;
                    this.uriToEntry.remove((Object)entry.url);
                    this.bug(entry);
                }
            }
            Entry entry2 = entry;
            synchronized (entry2) {
                entry.initializedImage = true;
                entry.notifyAll();
            }
        }
        Entry entry3 = entry;
        synchronized (entry3) {
            if (!entry.initializedImage) {
                try {
                    entry.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        ImageCache imageCache3 = this;
        synchronized (imageCache3) {
            if (entry.image != null) {
                this.NO_SYNCHRONIZATION(entry);
            }
        }
        return entry.image;
    }

    private void NO_SYNCHRONIZATION(Entry entry) {
        entry.stopped = false;
        if (entry.flushBeforeReload) {
            entry.flushBeforeReload = false;
            entry.image.flush();
        }
        if (entry.ref == 0) {
            --this.currentTimeMillis;
        }
        ++entry.ref;
    }

    public void stopLoading(Image image) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Entry entry = (Entry)this.imageToEntry.get((Object)image);
            if (entry == null) {
                return;
            }
            ImageConnection imageConnection = entry.ic;
            entry.ic = null;
            if (imageConnection != null) {
                entry.flushBeforeReload = imageConnection.reqToStop();
            } else {
                entry.stopped = true;
            }
        }
    }

    public void release(Image image) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Entry entry = (Entry)this.imageToEntry.get((Object)image);
            if (entry != null) {
                --entry.ref;
                if (entry.ref == 0) {
                    ++this.currentTimeMillis;
                    entry.dieTime = System.currentTimeMillis() + (long)(this.timeout * 1000);
                }
            }
        }
    }

    public void flushImages(boolean bl) {
        Object object;
        if (!bl && this.currentTimeMillis == 0) {
            return;
        }
        Vector<Entry> vector = null;
        ImageCache imageCache = this;
        synchronized (imageCache) {
            long l = System.currentTimeMillis();
            object = this.uriToEntry.newIterator();
            object.start();
            while (!object.done()) {
                Entry entry = (Entry)object.value();
                if (bl || entry.ref == 0 && entry.dieTime <= l) {
                    if (vector == null) {
                        vector = new Vector<Entry>();
                    }
                    vector.addElement(entry);
                }
                object.next();
            }
            if (vector != null) {
                int n = 0;
                int n2 = vector.size();
                while (n != n2) {
                    Entry entry = (Entry)vector.elementAt(n);
                    Image image = this.OEAB(entry);
                    vector.setElementAt((Entry)((Object)image), n);
                    ++n;
                }
            }
        }
        if (vector != null) {
            int n = 0;
            int n3 = vector.size();
            while (n != n3) {
                block14: {
                    object = (Image)vector.elementAt(n);
                    if (object != null) {
                        try {
                            ((Image)object).flush();
                        }
                        catch (NullPointerException nullPointerException) {
                            if (!Debug.ex) break block14;
                            Debug.ex((Throwable)nullPointerException);
                        }
                    }
                }
                ++n;
            }
        }
    }

    private Image OEAB(Entry entry) {
        Image image;
        this.uriToEntry.remove((Object)entry.url);
        this.bug(entry);
        if (entry.ref == 0) {
            --this.currentTimeMillis;
        }
        if ((image = entry.image) != null) {
            this.imageToEntry.remove((Object)image);
            entry.image = null;
        }
        return image;
    }

    public void checkForAnimatedImagesBug() {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            ++this.dieTime;
            if (Debug.trace) {
                Debug.trace((String)("animImageCounter==" + this.dieTime));
            }
            if (this.dieTime >= 4) {
                block9: {
                    try {
                        if (Debug.trace) {
                            Debug.trace((String)"--> Initiating recovery");
                        }
                        URL uRL = this.getClass().getResource("resources/dummyimage.gif");
                        Image image = this.addElement(uRL);
                        this.disposeResources.prepareImage(image, -1, -1, null);
                        image.flush();
                    }
                    catch (Exception exception) {
                        if (!Debug.ex) break block9;
                        Debug.ex((Throwable)exception);
                    }
                }
                if (Debug.trace) {
                    Debug.trace((String)"--> --> Recovery done");
                }
            }
        }
    }

    private Image addElement(URL uRL) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            --this.dieTime;
            if (this.dieTime < 0) {
                this.dieTime = 0;
            }
        }
        return (Image)SecurityKit.doPrivileged((BoxedCode)new BoxedCode(this, uRL){
            private final URL val$url;
            private final ImageCache this$0;
            {
                this.this$0 = imageCache;
                this.val$url = uRL;
            }

            public Object run() {
                return this.this$0.factoryGetImage(this.val$url);
            }
        });
    }

    protected Image factoryGetImage(URL uRL) {
        if (bug != null) {
            Object[] objectArray = new Object[]{uRL};
            try {
                Image image = (Image)bug.invoke(null, objectArray);
                return image;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.disposeResources.getImage(uRL);
    }

    private boolean append(Entry entry) {
        if (append) {
            HashArray hashArray = OEAB;
            synchronized (hashArray) {
                URL uRL;
                String string = "image:" + ++addElement;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    append = true;
                    uRL = null;
                }
                if (uRL != null) {
                    entry.proxyUrlObj = uRL;
                    OEAB.put((Object)uRL, (Object)entry);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private void bug(Entry entry) {
        URL uRL = entry.proxyUrlObj;
        if (uRL != null) {
            HashArray hashArray = OEAB;
            synchronized (hashArray) {
                OEAB.remove((Object)uRL);
            }
        }
    }

    static URL setImageConnection(URL uRL, ImageConnection imageConnection) {
        Entry entry;
        HashArray hashArray = OEAB;
        synchronized (hashArray) {
            entry = (Entry)OEAB.get((Object)uRL);
        }
        if (entry != null) {
            entry.ic = imageConnection;
            if (entry.stopped) {
                entry.flushBeforeReload = true;
                return null;
            }
            return entry.realUrlObj;
        }
        return null;
    }

    static {
        if (Defs.sysPropertyBoolean((String)"ice.storm.use14")) {
            try {
                Class<?> clazz = Class.forName("javax.imageio.ImageIO");
                Class[] classArray = new Class[1];
                URL uRL = new URL("http://dummy.org");
                classArray[0] = uRL.getClass();
                bug = clazz.getMethod("read", classArray);
            }
            catch (Throwable throwable) {
                if (Debug.trace) {
                    Debug.trace((String)"ImageCache: Java 1.4 Imaging subsystem not found.");
                }
                bug = null;
            }
        }
    }

    private class Entry {
        boolean initializedImage;
        Image image;
        String url;
        int ref;
        long dieTime;
        URL proxyUrlObj;
        URL realUrlObj;
        ImageConnection ic;
        volatile boolean flushBeforeReload;
        volatile boolean stopped;
        private final ImageCache this$0;

        private Entry(ImageCache imageCache) {
            this.this$0 = imageCache;
            this.flushBeforeReload = false;
            this.stopped = false;
        }

        Entry(ImageCache imageCache, 1 var2_2) {
            this(imageCache);
        }
    }
}

