/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.ComponentInstaller;
import com.mathworks.install.ComponentSizeAggregator;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductInstaller;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class ProductInstallerImpl
implements ProductInstaller {
    private final ComponentContainer productInstallerComponentContainer;
    private final ComponentInstaller componentInstaller;
    private final InstalledProductData fileList;
    private final InstallStatusObserver installStatusObserver;
    private final long statusFactor;
    private final ProductContainer theProductContainer;
    private InstallStatusObserver[] allObservers;
    private Map<String, InstallableComponent> installedComponents;
    private Map<String, ComponentData> latestComponentsToBeInstalled;

    @Inject
    ProductInstallerImpl(ProductContainer productContainer, ComponentContainer componentContainer, ComponentInstaller componentInstaller, InstalledProductData installedProductData, @Named(value="loggingStatusObserver") InstallStatusObserver installStatusObserver, @Named(value="uninstallStatusFactor") Long l) {
        this.theProductContainer = productContainer;
        this.productInstallerComponentContainer = componentContainer;
        this.componentInstaller = componentInstaller;
        this.fileList = installedProductData;
        this.installStatusObserver = installStatusObserver;
        this.statusFactor = l;
    }

    @Override
    public void installProducts(String string, File file, File file2, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        this.downloadProducts(string, file2, installableProductArray, installFlowControlHandler, componentContainer, installStatusObserverArray);
        for (InstallableProduct installableProduct : installableProductArray) {
            this.installProduct(string, file, file2, installFlowControlHandler, this.allObservers, this.installedComponents, this.latestComponentsToBeInstalled, installableProduct);
            this.fileList.installProductFileData(ProductInstallerImpl.getProductNameAndVersion(installableProduct.getProductData()), file.getAbsolutePath(), installableProduct.getXML());
        }
    }

    @Override
    public void downloadProducts(String string, File file, InstallableProduct[] installableProductArray, final InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, final InstallStatusObserver ... installStatusObserverArray) throws InterruptedException, IOException {
        this.allObservers = ProductInstallerImpl.combineObservers(this.installStatusObserver, installStatusObserverArray);
        this.installedComponents = ProductInstallerImpl.getLatestVersionOfInstalledComponentsByName(componentContainer);
        Set<ComponentData> set = ProductInstallerImpl.getComponentsOfProducts(ProductInstallerImpl.createProductNameSet(installableProductArray), string, this.theProductContainer);
        this.latestComponentsToBeInstalled = ProductInstallerImpl.getLatestVersionOfComponentsByName(set);
        long l = 0L;
        for (InstallableProduct object : installableProductArray) {
            Product product = object.getProductData();
            final String string2 = ProductInstallerImpl.getProductNameAndVersion(product);
            InstallableComponent[] installableComponentArray = this.getComponentsToDownloadForProduct(string, object, this.productInstallerComponentContainer);
            final ComponentSizeAggregator componentSizeAggregator = new ComponentSizeAggregator();
            for (InstallableComponent installableComponent : installableComponentArray) {
                componentSizeAggregator.add(installableComponent);
            }
            l += componentSizeAggregator.getTotalDownloadSize();
            if (componentSizeAggregator.getTotalDownloadSize() > 0L) {
                for (InstallStatusObserver installStatusObserver : this.allObservers) {
                    installStatusObserver.downloadingProduct(string2, componentSizeAggregator.getTotalDownloadSize());
                }
            }
            for (InstallableComponent installableComponent : installableComponentArray) {
                installableComponent.download(file, installFlowControlHandler, new IOObserver(){

                    public boolean updateBytes(long l) throws InterruptedException {
                        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                            installStatusObserver.updateDownloadUnits(string2, l, componentSizeAggregator.getTotalDownloadSize());
                        }
                        return installFlowControlHandler.checkTaskState();
                    }
                }, installStatusObserverArray);
            }
            object.writeOutXML(file);
        }
        if (l > 0L) {
            for (InstallStatusObserver installStatusObserver : this.allObservers) {
                installStatusObserver.finishedDownloading(l);
            }
        }
    }

    private void installProduct(String string, File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver[] installStatusObserverArray, Map<String, InstallableComponent> map, Map<String, ComponentData> map2, InstallableProduct installableProduct) throws InterruptedException, IOException {
        ProductInstallerImpl.updateObserversAndGetProductData(installableProduct, installStatusObserverArray);
        InstallableComponent[] installableComponentArray = this.getComponentsToInstallForProduct(file, installFlowControlHandler, installStatusObserverArray, map, map2, installableProduct, string);
        this.componentInstaller.installComponents(file, file2, installableComponentArray, installFlowControlHandler, installStatusObserverArray);
    }

    private InstallableComponent[] getComponentsToDownloadForProduct(String string, InstallableProduct installableProduct, ComponentContainer componentContainer) throws InterruptedException, IOException {
        ComponentVisitor componentVisitor = new ComponentVisitor(){

            @Override
            public void visit(Collection<InstallableComponent> collection, InstallableComponent installableComponent, String string) {
                if (!ProductInstallerImpl.this.installedComponents.containsKey(string)) {
                    collection.add(installableComponent);
                }
            }
        };
        return this.getInstallableComponents(componentVisitor, installableProduct, string);
    }

    private InstallableComponent[] getComponentsToInstallForProduct(final File file, final InstallFlowControlHandler installFlowControlHandler, final InstallStatusObserver[] installStatusObserverArray, final Map<String, InstallableComponent> map, final Map<String, ComponentData> map2, InstallableProduct installableProduct, String string) throws InterruptedException, IOException {
        ComponentVisitor componentVisitor = new ComponentVisitor(){

            @Override
            public void visit(Collection<InstallableComponent> collection, InstallableComponent installableComponent, String string) throws IOException, InterruptedException {
                if (installableComponent != null) {
                    if (map.containsKey(string)) {
                        InstallableComponent installableComponent2 = (InstallableComponent)map.get(string);
                        if (installableComponent2.getComponentData().isOlderThan((ComponentData)map2.get(string))) {
                            ProductInstallerImpl.this.componentInstaller.uninstallComponents(file, new InstallableComponent[]{installableComponent2}, installFlowControlHandler, installStatusObserverArray);
                            collection.add(installableComponent);
                        }
                    } else {
                        collection.add(installableComponent);
                    }
                }
            }
        };
        return this.getInstallableComponents(componentVisitor, installableProduct, string);
    }

    private InstallableComponent[] getInstallableComponents(ComponentVisitor componentVisitor, InstallableProduct installableProduct, String string) throws IOException, InterruptedException {
        ArrayList<InstallableComponent> arrayList = new ArrayList<InstallableComponent>();
        for (ComponentData componentData : installableProduct.getRequiredComponents(string)) {
            String string2 = componentData.getName();
            if (!this.latestComponentsToBeInstalled.containsKey(string2)) continue;
            InstallableComponent installableComponent = this.productInstallerComponentContainer.getInstallableComponent(this.latestComponentsToBeInstalled.get(string2));
            componentVisitor.visit(arrayList, installableComponent, string2);
        }
        return arrayList.toArray(new InstallableComponent[arrayList.size()]);
    }

    private static Map<String, ComponentData> getLatestVersionOfComponentsByName(Collection<ComponentData> collection) {
        LinkedHashMap<String, ComponentData> linkedHashMap = new LinkedHashMap<String, ComponentData>();
        for (ComponentData componentData : collection) {
            String string = componentData.getName();
            if (linkedHashMap.containsKey(string) && !((ComponentData)linkedHashMap.get(string)).isOlderThan(componentData)) continue;
            linkedHashMap.put(string, componentData);
        }
        return linkedHashMap;
    }

    private static Map<String, InstallableComponent> getLatestVersionOfInstalledComponentsByName(ComponentContainer componentContainer) {
        InstallableComponent[] installableComponentArray;
        LinkedHashMap<String, InstallableComponent> linkedHashMap = new LinkedHashMap<String, InstallableComponent>();
        for (InstallableComponent installableComponent : installableComponentArray = componentContainer.getInstalledComponents()) {
            ComponentData componentData = installableComponent.getComponentData();
            String string = componentData.getName();
            if (linkedHashMap.containsKey(string) && !((InstallableComponent)linkedHashMap.get(string)).getComponentData().isOlderThan(componentData)) continue;
            linkedHashMap.put(installableComponent.getComponentData().getName(), installableComponent);
        }
        return linkedHashMap;
    }

    @Override
    public long getInstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
        ComponentSizeAggregator componentSizeAggregator = new ComponentSizeAggregator();
        this.aggregateComponentsDuringInstall(string, file, installableProductArray, installableProductArray2, productContainer, componentContainer, componentSizeAggregator);
        return componentSizeAggregator.getTotalInstallUnits(this.statusFactor);
    }

    private static InstallStatusObserver[] combineObservers(InstallStatusObserver installStatusObserver, InstallStatusObserver ... installStatusObserverArray) {
        ArrayList<InstallStatusObserver> arrayList = new ArrayList<InstallStatusObserver>(Arrays.asList(installStatusObserverArray));
        arrayList.add(installStatusObserver);
        return arrayList.toArray(new InstallStatusObserver[arrayList.size()]);
    }

    private static Product updateObserversAndGetProductData(InstallableProduct installableProduct, InstallStatusObserver ... installStatusObserverArray) {
        Product product = installableProduct.getProductData();
        String string = ProductInstallerImpl.getProductNameAndVersion(product);
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.addProduct(string);
        }
        return product;
    }

    private static Product updateObserversAndRemoveProductData(InstallableProduct installableProduct, InstallStatusObserver ... installStatusObserverArray) {
        Product product = installableProduct.getProductData();
        String string = ProductInstallerImpl.getProductNameAndVersion(product);
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.removeProduct(string);
        }
        return product;
    }

    private static String getProductNameAndVersion(Product product) {
        return product.getName() + ' ' + product.getVersion();
    }

    @Override
    public void uninstallProducts(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ProductContainer productContainer, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        InstallStatusObserver[] installStatusObserverArray2 = ProductInstallerImpl.combineObservers(this.installStatusObserver, installStatusObserverArray);
        Map<String, InstallableComponent> map = ProductInstallerImpl.getLatestVersionOfInstalledComponentsByName(componentContainer);
        LinkedHashSet<InstallableProduct> linkedHashSet = new LinkedHashSet<InstallableProduct>();
        linkedHashSet.addAll(Arrays.asList(productContainer.getInstallableProducts()));
        for (InstallableProduct installableProduct : installableProductArray) {
            Product product = ProductInstallerImpl.updateObserversAndRemoveProductData(installableProduct, installStatusObserverArray2);
            String string2 = product.getNameVersionReleaseAndReleaseDescription();
            ComponentData[] componentDataArray = ProductInstallerImpl.getNonSharedComponents(string2, string, linkedHashSet, productContainer);
            ArrayList<InstallableComponent> arrayList = new ArrayList<InstallableComponent>();
            for (ComponentData componentData : componentDataArray) {
                String string3 = componentData.getName();
                if (!map.containsKey(string3)) continue;
                arrayList.add(map.remove(string3));
            }
            this.componentInstaller.uninstallComponents(file, arrayList.toArray(new InstallableComponent[arrayList.size()]), installFlowControlHandler, installStatusObserverArray2);
            componentContainer.uninstallComponents(arrayList.toArray(new InstallableComponent[arrayList.size()]));
            InstallableProduct object = productContainer.getInstallableProductByNameVersionReleaseAndReleaseDescription(string2);
            if (object != null) {
                linkedHashSet.remove(object);
            }
            this.fileList.removeProduct(ProductInstallerImpl.getProductNameAndVersion(product), file.getAbsolutePath());
        }
    }

    @Override
    public long getUninstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
        Set<String> set = ProductInstallerImpl.createProductNameSet(installableProductArray);
        Set<ComponentData> set2 = ProductInstallerImpl.getComponentsOfProducts(set, string, productContainer);
        ProductInstallerImpl.removeComponentsAlsoInProductsNotBeingUninstalled(string, set, set2, productContainer);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ComponentData componentData : set2) {
            linkedHashSet.add(componentData.getComponentNameAndVersion());
        }
        return this.fileList.getTotalFileCount(linkedHashSet.toArray(new String[linkedHashSet.size()]), string) * this.statusFactor;
    }

    @Override
    public void calculateSpaceRequired(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
        ProductInstallerImpl.aggregateComponentsDuringUninstall(string, installableProductArray2, productContainer, componentContainer, componentAggregator);
        this.aggregateComponentsDuringInstall(string, file, installableProductArray, installableProductArray2, productContainer, componentContainer, componentAggregator, this.theProductContainer);
    }

    private void aggregateComponentsDuringInstall(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator, ProductContainer productContainer2) {
        LinkedHashSet<ComponentData> linkedHashSet = new LinkedHashSet<ComponentData>();
        for (InstallableComponent object2 : ProductInstallerImpl.getLatestVersionOfInstalledComponentsByName(componentContainer).values()) {
            linkedHashSet.add(object2.getComponentData());
        }
        Set<ComponentData> set = ProductInstallerImpl.getComponentsOfProducts(ProductInstallerImpl.createProductNameSet(installableProductArray), string, productContainer2);
        Map<String, ComponentData> map = ProductInstallerImpl.getLatestVersionOfComponentsByName((Collection<ComponentData>)set);
        Set<ComponentData> set2 = ProductInstallerImpl.getComponentsOfProducts(ProductInstallerImpl.createProductNameSet(installableProductArray2), string, productContainer);
        ProductInstallerImpl.removeComponentsAlsoInProductsNotBeingUninstalled(string, ProductInstallerImpl.createProductNameSet(installableProductArray2), set2, productContainer);
        LinkedHashMap<String, ComponentData> linkedHashMap = new LinkedHashMap<String, ComponentData>();
        for (ComponentData componentData : linkedHashSet) {
            if (set2.contains(componentData)) continue;
            linkedHashMap.put(componentData.getName(), componentData);
        }
        for (ComponentData componentData : map.values()) {
            InstallableComponent installableComponent = this.productInstallerComponentContainer.getInstallableComponent(componentData);
            if (installableComponent == null) continue;
            String string2 = componentData.getName();
            if (linkedHashMap.containsKey(string2)) {
                ComponentData componentData2 = (ComponentData)linkedHashMap.get(string2);
                if (!componentData2.isOlderThan(componentData)) continue;
                String[] stringArray = this.fileList.getNonSharedFiles(componentData2.getName(), file.getAbsolutePath());
                InstallableComponent installableComponent2 = componentContainer.getInstallableComponent(componentData2);
                componentAggregator.add(installableComponent);
                componentAggregator.remove(installableComponent2, stringArray.length);
                continue;
            }
            componentAggregator.add(installableComponent);
        }
    }

    private void aggregateComponentsDuringInstall(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
        this.aggregateComponentsDuringInstall(string, file, installableProductArray, installableProductArray2, productContainer, componentContainer, componentAggregator, this.theProductContainer);
    }

    private static void aggregateComponentsDuringUninstall(String string, InstallableProduct[] installableProductArray, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
        Set<String> set = ProductInstallerImpl.createProductNameSet(installableProductArray);
        Set<ComponentData> set2 = ProductInstallerImpl.getComponentsOfProducts(set, string, productContainer);
        ProductInstallerImpl.removeComponentsAlsoInProductsNotBeingUninstalled(string, set, set2, productContainer);
        for (ComponentData componentData : ProductInstallerImpl.getLatestVersionOfComponentsByName(set2).values()) {
            InstallableComponent installableComponent = componentContainer.getInstallableComponent(componentData);
            if (installableComponent == null) continue;
            componentAggregator.remove(installableComponent, 0L);
        }
    }

    private static Set<String> createProductNameSet(InstallableProduct[] installableProductArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (InstallableProduct installableProduct : installableProductArray) {
            linkedHashSet.add(installableProduct.getProductData().getNameVersionReleaseAndReleaseDescription());
        }
        return linkedHashSet;
    }

    private static void removeComponentsAlsoInProductsNotBeingUninstalled(String string, Collection<String> collection, Collection<ComponentData> collection2, ProductContainer productContainer) {
        for (InstallableProduct installableProduct : productContainer.getInstallableProducts()) {
            Product product = installableProduct.getProductData();
            if (collection.contains(product.getNameVersionReleaseAndReleaseDescription()) && string.equalsIgnoreCase(product.getArchitecture())) continue;
            ProductInstallerImpl.removeSharedComponents(collection2, installableProduct, string);
        }
    }

    private static Set<ComponentData> getComponentsOfProducts(Collection<String> collection, String string, ProductContainer productContainer) {
        LinkedHashSet<ComponentData> linkedHashSet = new LinkedHashSet<ComponentData>();
        for (String string2 : collection) {
            InstallableProduct installableProduct = productContainer.getInstallableProduct(string2, string);
            linkedHashSet.addAll(Arrays.asList(installableProduct.getRequiredComponents(string)));
        }
        return linkedHashSet;
    }

    private static void removeSharedComponents(Collection<ComponentData> collection, InstallableProduct installableProduct, String string) {
        ArrayList<ComponentData> arrayList = new ArrayList<ComponentData>();
        for (ComponentData componentData : collection) {
            if (!componentData.hasPlatform(installableProduct.getProductData().getArchitecture()) || !ProductInstallerImpl.otherProductContainsComponent(installableProduct, componentData, string)) continue;
            arrayList.add(componentData);
        }
        collection.removeAll(arrayList);
    }

    private static boolean otherProductContainsComponent(InstallableProduct installableProduct, ComponentData componentData, String string) {
        for (ComponentData componentData2 : installableProduct.getRequiredComponents(string)) {
            if (!componentData.getName().equalsIgnoreCase(componentData2.getName())) continue;
            return true;
        }
        return false;
    }

    private static ComponentData[] getNonSharedComponents(String string, String string2, Collection<InstallableProduct> collection, ProductContainer productContainer) {
        LinkedHashSet<ComponentData> linkedHashSet = new LinkedHashSet<ComponentData>();
        InstallableProduct installableProduct = productContainer.getInstallableProduct(string, string2);
        linkedHashSet.addAll(Arrays.asList(installableProduct.getRequiredComponents(string2)));
        for (InstallableProduct installableProduct2 : collection) {
            String string3 = installableProduct2.getProductData().getNameVersionReleaseAndReleaseDescription();
            if (string3.equalsIgnoreCase(string) && installableProduct2.getProductData().getArchitecture().equalsIgnoreCase(string2)) continue;
            ProductInstallerImpl.removeSharedComponents(linkedHashSet, installableProduct2, string2);
        }
        return linkedHashSet.toArray(new ComponentData[linkedHashSet.size()]);
    }

    private static interface ComponentVisitor {
        public void visit(Collection<InstallableComponent> var1, InstallableComponent var2, String var3) throws IOException, InterruptedException;
    }
}

