/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetItemType;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;

class InstalledDocSetItem {
    private static final String SHORTNAME_PROP = "shortname";
    private static final String DISPLAYNAME_PROP = "displayname";
    private static final String STATUS_PROP = "status";
    private static final String BASEPRODUCT_SHORTNAME_PROP = "baseshortname";
    private final String shortName;
    private final String displayName;
    private final String helpLoc;
    private final Set<DocDestination> destinations;
    private final String baseProductShortName;
    private final DocSetItemType type;

    private InstalledDocSetItem(String string, String string2, String string3, String string4, String string5) {
        this.helpLoc = string;
        this.displayName = string2;
        this.shortName = string3;
        this.destinations = InstalledDocSetItem.resolveDestinations(string4);
        this.baseProductShortName = string5;
        this.type = this.baseProductShortName == null || this.baseProductShortName.isEmpty() ? DocSetItemType.PRODUCT : DocSetItemType.ADDON;
    }

    static InstalledDocSetItem buildDocSetItem(String string, String string2, String string3, String string4, String string5) {
        return new InstalledDocSetItem(string, string2, string3, string4, string5);
    }

    static InstalledDocSetItem buildDocSetItem(String string, Properties properties) {
        String string2 = properties.getProperty(DISPLAYNAME_PROP);
        String string3 = properties.containsKey(SHORTNAME_PROP) ? properties.getProperty(SHORTNAME_PROP) : string.replaceFirst(".*/", "");
        String string4 = properties.containsKey(STATUS_PROP) ? properties.getProperty(STATUS_PROP) : null;
        String string5 = properties.containsKey(BASEPRODUCT_SHORTNAME_PROP) ? properties.getProperty(BASEPRODUCT_SHORTNAME_PROP) : null;
        return InstalledDocSetItem.buildDocSetItem(string, string2, string3, string4, string5);
    }

    private static Set<DocDestination> resolveDestinations(String string) {
        if (string == null || string.trim().isEmpty()) {
            return EnumSet.allOf(DocDestination.class);
        }
        if (string.equalsIgnoreCase("web_only")) {
            return EnumSet.of(DocDestination.WEB);
        }
        if (string.equalsIgnoreCase("install_only")) {
            return EnumSet.of(DocDestination.INSTALL);
        }
        return EnumSet.noneOf(DocDestination.class);
    }

    String getShortName() {
        return this.shortName;
    }

    String getDisplayName() {
        return this.displayName;
    }

    String getHelpLoc() {
        return this.helpLoc;
    }

    String getBaseProductShortName() {
        return this.baseProductShortName;
    }

    boolean includeProduct(DocDestination docDestination) {
        if (docDestination == DocDestination.INSTALL && this.type == DocSetItemType.ADDON) {
            return false;
        }
        return this.destinations.contains((Object)docDestination);
    }

    DocSetItemType getType() {
        return this.type;
    }
}

