/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetItemComparator;
import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import com.mathworks.instutil.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class InstallerDocSetItemList
implements DocSetItemList {
    static FilenameFilter LOCALIZED_SEARCH_INDEX_FILTER = new LocalizedSearchIndexFilter();
    private final IO io;
    private final Map<DocSetItemType, List<InstalledDocSetItem>> docSetItemMap = new EnumMap<DocSetItemType, List<InstalledDocSetItem>>(DocSetItemType.class);
    private final Collection<String> localeSuffixes = new LinkedHashSet<String>();

    InstallerDocSetItemList(IO iO) {
        this.io = iO;
    }

    @Override
    public synchronized void populate(File file, DocDestination docDestination) throws IOException {
        this.docSetItemMap.clear();
        for (DocSetItemType docSetItemType : DocSetItemType.values()) {
            this.docSetItemMap.put(docSetItemType, new LinkedList());
        }
        this.examineSubDirectories(file, "", docDestination);
        for (List list : this.docSetItemMap.values()) {
            Collections.sort(list, new DocSetItemComparator());
        }
    }

    @Override
    public synchronized Collection<String> getLocaleSuffixes() {
        return Collections.unmodifiableCollection(this.localeSuffixes);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.docSetItemMap.get((Object)DocSetItemType.PRODUCT).isEmpty() && this.docSetItemMap.get((Object)DocSetItemType.ADDON).isEmpty();
    }

    @Override
    public synchronized List<InstalledDocSetItem> getInstalledDocSetItems(Set<DocSetItemType> set) {
        LinkedList linkedList = new LinkedList();
        for (DocSetItemType docSetItemType : set) {
            linkedList.addAll(this.docSetItemMap.get((Object)docSetItemType));
        }
        return Collections.unmodifiableList(linkedList);
    }

    private void examineSubDirectories(File file, String string, DocDestination docDestination) throws IOException {
        File[] fileArray;
        for (File file2 : fileArray = this.io.listFiles(new File(file, string), null)) {
            if (!this.io.isDirectory(file2)) continue;
            String string2 = string;
            if (!string.isEmpty()) {
                string2 = string2 + "/";
            }
            string2 = string2 + file2.getName();
            this.findInstalledDocProducts(file, string2, docDestination);
        }
    }

    private void findInstalledDocProducts(File file, String string, DocDestination docDestination) throws IOException {
        File file2 = new File(new File(file, string), "doccenter.properties");
        if (this.io.isFile(file2)) {
            InstalledDocSetItem installedDocSetItem = InstallerDocSetItemList.getDocSetItemFromFile(file2, string);
            if (installedDocSetItem.includeProduct(docDestination)) {
                this.localeSuffixes.addAll(this.findLocaleSuffixes(new File(file, string)));
                this.docSetItemMap.get((Object)installedDocSetItem.getType()).add(installedDocSetItem);
            }
        } else {
            this.examineSubDirectories(file, string, docDestination);
        }
    }

    private static InstalledDocSetItem getDocSetItemFromFile(File file, String string) throws IOException {
        Properties properties = InstallerDocSetItemList.getPropertiesFromFile(file);
        return InstalledDocSetItem.buildDocSetItem(string, properties);
    }

    private static Properties getPropertiesFromFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Properties properties = InstallerDocSetItemList.getPropertiesFromInputStream(fileInputStream);
            return properties;
        }
    }

    static Properties getPropertiesFromInputStream(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");){
            properties.load(inputStreamReader);
        }
        return properties;
    }

    private Collection<String> findLocaleSuffixes(File file) {
        File[] fileArray = this.io.listFiles(file, LOCALIZED_SEARCH_INDEX_FILTER);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (File file2 : fileArray) {
            linkedList.add(file2.getName().substring("helpsearch_".length()));
        }
        return linkedList;
    }

    private static class LocalizedSearchIndexFilter
    implements FilenameFilter {
        private LocalizedSearchIndexFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("helpsearch_");
        }
    }
}

