/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.archive.Archive;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ArchiveInputStreamProvider;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.XMLInstallationFileParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;

final class DWSInstallationInputFile
implements InstallationInputFile {
    private final File file;
    private final ArchiveFactory archiveFactory;
    private final XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceProvider componentSourceProvider;
    private final ContentOptimizer contentOptimizer;
    private InstallerDownloadInfoContainer installerDownloadInfoContainer;

    DWSInstallationInputFile(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceProvider componentSourceProvider, ContentOptimizer contentOptimizer, InstallerDownloadInfoContainer installerDownloadInfoContainer) {
        this.file = file;
        this.archiveFactory = archiveFactory;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceProvider = componentSourceProvider;
        this.contentOptimizer = contentOptimizer;
        this.installerDownloadInfoContainer = installerDownloadInfoContainer;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse() throws IOException, XMLParseException, JAXBException {
        InputStream inputStream = null;
        try {
            Archive archive = this.archiveFactory.createArchive(this.getFile());
            for (String string : archive.getEntries()) {
                if (this.contentOptimizer.accept(string)) {
                    this.xmlInstallationFileParser.readInDefinition(new ArchiveInputStreamProvider(archive, string), this.componentSourceProvider);
                    continue;
                }
                if (!string.contains("installerdata.xml")) continue;
                inputStream = new ArchiveInputStreamProvider(archive, string).getInputStream();
                this.installerDownloadInfoContainer.readInDefinition(inputStream);
            }
        }
        finally {
            if (inputStream != null) {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }
}

