/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.BrowserQueue;
import com.mathworks.html.HtmlActionStateManager;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.StandardHtmlActionId;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class BasicHtmlActionStateManager
implements HtmlActionStateManager {
    private final HtmlComponent fComponent;

    protected BasicHtmlActionStateManager(HtmlComponent htmlComponent) {
        this.fComponent = htmlComponent;
    }

    @Override
    public void updateActionStates(HtmlActions htmlActions) {
        NavigationStateCallable navigationStateCallable = new NavigationStateCallable();
        NavigationStateListener navigationStateListener = new NavigationStateListener(htmlActions.getBasicActions());
        BrowserQueue.invokeLaterAndNotify(navigationStateCallable, navigationStateListener);
    }

    private class NavigationStateListener
    implements HtmlDataListener<Map<StandardHtmlActionId, Boolean>> {
        private final Map<StandardHtmlActionId, ? extends Action> iActions;

        private NavigationStateListener(Map<StandardHtmlActionId, ? extends Action> map) {
            this.iActions = map;
        }

        @Override
        public void dataRetrieved(final Map<StandardHtmlActionId, Boolean> map) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : map.entrySet()) {
                        Action action = (Action)NavigationStateListener.this.iActions.get(entry.getKey());
                        if (action == null) continue;
                        action.setEnabled((Boolean)entry.getValue());
                    }
                }
            });
        }
    }

    private class NavigationStateCallable
    implements Callable<Map<StandardHtmlActionId, Boolean>> {
        private NavigationStateCallable() {
        }

        @Override
        public Map<StandardHtmlActionId, Boolean> call() throws Exception {
            EnumMap<StandardHtmlActionId, Boolean> enumMap = new EnumMap<StandardHtmlActionId, Boolean>(StandardHtmlActionId.class);
            enumMap.put(StandardHtmlActionId.GO_BACK, BasicHtmlActionStateManager.this.fComponent.canGoBack());
            enumMap.put(StandardHtmlActionId.GO_FORWARD, BasicHtmlActionStateManager.this.fComponent.canGoForward());
            return enumMap;
        }
    }
}

