/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.FindInPageHandler;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.SelectedTextUtils;
import com.mathworks.html.StandardHtmlActionId;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;

public final class BasicHtmlActions
implements HtmlActions {
    public static final String ZOOM_ACTIONS = "ZoomActions";
    public static final String ZOOM_IN_ACTION_ID = "ZoomIn";
    public static final String ZOOM_OUT_ACTION_ID = "ZoomOut";
    private final HtmlComponent fHtmlComponent;
    private final Map<StandardHtmlActionId, Action> fBasicActions = new EnumMap<StandardHtmlActionId, Action>(StandardHtmlActionId.class);
    private final BasicHtmlActionLabels fLabels;
    private final ActionAdapter<? extends Action> fActionAdapter;
    private FindInPageHandler fFindInPageHandler;
    private boolean fPopulated = false;

    public BasicHtmlActions(HtmlComponent htmlComponent, BasicHtmlActionLabels basicHtmlActionLabels) {
        this(htmlComponent, basicHtmlActionLabels, new DefaultActionAdapter());
    }

    public BasicHtmlActions(HtmlComponent htmlComponent, BasicHtmlActionLabels basicHtmlActionLabels, ActionAdapter<? extends Action> actionAdapter) {
        this.fHtmlComponent = htmlComponent;
        this.fLabels = basicHtmlActionLabels;
        this.fActionAdapter = actionAdapter;
    }

    public void setViewSourceHandler(ViewSourceHandler viewSourceHandler) {
        if (viewSourceHandler == null) {
            this.fBasicActions.remove((Object)StandardHtmlActionId.VIEW_SOURCE);
        } else {
            this.addBasicAction(StandardHtmlActionId.VIEW_SOURCE, new ViewSourceAction(viewSourceHandler));
        }
    }

    public void setFindInPageHandler(FindInPageHandler findInPageHandler) {
        this.fFindInPageHandler = findInPageHandler;
        if (findInPageHandler == null) {
            this.fBasicActions.remove((Object)StandardHtmlActionId.FIND);
        } else {
            this.addBasicAction(StandardHtmlActionId.FIND, new FindAction());
        }
    }

    public void setSaveFileSelector(SaveFileSelector saveFileSelector) {
        if (saveFileSelector == null) {
            this.fBasicActions.remove((Object)StandardHtmlActionId.SAVE_AS);
        } else {
            this.addBasicAction(StandardHtmlActionId.SAVE_AS, new SaveAction(saveFileSelector));
        }
    }

    @Override
    public Map<StandardHtmlActionId, ? extends Action> getBasicActions() {
        Map<StandardHtmlActionId, Action> map = this.populateBasicActions();
        if (this.fHtmlComponent.getHomeUrl() != null) {
            EnumMap<StandardHtmlActionId, Action> enumMap = new EnumMap<StandardHtmlActionId, Action>(map);
            this.addActionToMap(enumMap, StandardHtmlActionId.HOME, new HomeAction());
            return Collections.unmodifiableMap(enumMap);
        }
        return Collections.unmodifiableMap(map);
    }

    private synchronized Map<StandardHtmlActionId, Action> populateBasicActions() {
        if (!this.fPopulated) {
            this.addBasicAction(StandardHtmlActionId.GO_BACK, new GoBackAction());
            this.addBasicAction(StandardHtmlActionId.GO_FORWARD, new GoForwardAction());
            this.addBasicAction(StandardHtmlActionId.RELOAD, new ReloadAction());
            this.addBasicAction(StandardHtmlActionId.COPY, new CopyAction());
            if (this.fHtmlComponent.isPrintingSupported()) {
                this.addBasicAction(StandardHtmlActionId.PRINT, new PrintAction());
            }
            this.fPopulated = true;
        }
        return this.fBasicActions;
    }

    @Override
    public void removeNavigationActions() {
        this.populateBasicActions();
        this.fBasicActions.remove((Object)StandardHtmlActionId.GO_BACK);
        this.fBasicActions.remove((Object)StandardHtmlActionId.GO_FORWARD);
        this.fBasicActions.remove((Object)StandardHtmlActionId.RELOAD);
        this.fBasicActions.remove((Object)StandardHtmlActionId.HOME);
    }

    @Override
    public HtmlActionGroups getCustomActionGroups() {
        return this.fHtmlComponent.getBrowserSuppliedActions();
    }

    @Override
    public void dispose() {
    }

    private void addBasicAction(StandardHtmlActionId standardHtmlActionId, Action action) {
        this.addActionToMap(this.fBasicActions, standardHtmlActionId, action);
    }

    private void addActionToMap(Map<StandardHtmlActionId, Action> map, StandardHtmlActionId standardHtmlActionId, Action action) {
        Action action2 = this.fActionAdapter.adaptAction(standardHtmlActionId, action);
        map.put(standardHtmlActionId, action2);
    }

    public static interface SaveFileSelector {
        public File selectFile();
    }

    public static interface ViewSourceHandler {
        public void doViewSource(String var1, String var2);
    }

    private class HomeAction
    extends AbstractAction {
        private HomeAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.HOME));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.setCurrentLocation(BasicHtmlActions.this.fHtmlComponent.getHomeUrl());
        }
    }

    private class SaveAction
    extends AbstractAction {
        private final SaveFileSelector iFileSelector;

        private SaveAction(SaveFileSelector saveFileSelector) {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.SAVE_AS));
            this.iFileSelector = saveFileSelector;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = this.iFileSelector.selectFile();
            if (file != null) {
                new Thread(new SaveRunnable(file)).start();
            }
        }

        private class SaveRunnable
        implements Runnable {
            private File iFile;

            private SaveRunnable(File file) {
                this.iFile = file;
            }

            @Override
            public void run() {
                BasicHtmlActions.this.fHtmlComponent.saveAs(this.iFile);
            }
        }
    }

    private class PrintAction
    extends AbstractAction {
        private PrintAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.PRINT));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.print(new HtmlDataListener<Boolean>(){

                @Override
                public void dataRetrieved(Boolean bl) {
                }
            });
        }
    }

    private class FindAction
    extends AbstractAction {
        private FindAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.FIND));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fFindInPageHandler.openFindInPage();
        }
    }

    private class ViewSourceAction
    extends AbstractAction {
        private final ViewSourceHandler iHandler;

        private ViewSourceAction(ViewSourceHandler viewSourceHandler) {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.VIEW_SOURCE));
            this.iHandler = viewSourceHandler;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = BasicHtmlActions.this.fHtmlComponent.getCurrentLocation();
            String string2 = BasicHtmlActions.this.fHtmlComponent.getHtmlText();
            this.iHandler.doViewSource(string, string2);
        }
    }

    private static class CopyListener
    implements HtmlDataListener<String> {
        private CopyListener() {
        }

        @Override
        public void dataRetrieved(String string) {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(string), null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        private CopyAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.COPY));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectedTextUtils.getSelectedTextForEvent(actionEvent, BasicHtmlActions.this.fHtmlComponent, new CopyListener());
        }
    }

    private class ReloadAction
    extends AbstractAction {
        private ReloadAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.RELOAD));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.reload();
        }
    }

    private class GoForwardAction
    extends AbstractAction {
        private GoForwardAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.GO_FORWARD));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.goForward();
        }
    }

    private class GoBackAction
    extends AbstractAction {
        private GoBackAction() {
            super(BasicHtmlActions.this.fLabels.getLabel(StandardHtmlActionId.GO_BACK));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicHtmlActions.this.fHtmlComponent.goBack();
        }
    }

    private static class DefaultActionAdapter
    implements ActionAdapter<Action> {
        private DefaultActionAdapter() {
        }

        @Override
        public Action adaptAction(StandardHtmlActionId standardHtmlActionId, Action action) {
            return action;
        }
    }

    public static interface ActionAdapter<U extends Action> {
        public U adaptAction(StandardHtmlActionId var1, Action var2);
    }

    public static interface BasicHtmlActionLabels {
        public String getLabel(StandardHtmlActionId var1);
    }
}

