/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.HtmlDataListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class BrowserQueue {
    private static final RunnableQueue QUEUE = RunnableQueue.SINGLETON;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void markItemAsFinished(RunnableQueueItem runnableQueueItem) {
        RunnableQueueItem runnableQueueItem2 = runnableQueueItem;
        synchronized (runnableQueueItem2) {
            runnableQueueItem.setFinished(true);
            runnableQueueItem.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForItem(RunnableQueueItem runnableQueueItem) {
        if (runnableQueueItem != null) {
            try {
                RunnableQueueItem runnableQueueItem2 = runnableQueueItem;
                synchronized (runnableQueueItem2) {
                    while (!runnableQueueItem.isFinished()) {
                        runnableQueueItem.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private BrowserQueue() {
    }

    public static void invokeLater(Runnable runnable) {
        BrowserQueue.QUEUE.addRunnable(runnable);
    }

    public static <T> void invokeLaterAndNotify(Callable<T> callable, HtmlDataListener<T> htmlDataListener) {
        BrowserQueue.invokeLaterAndNotify(callable, htmlDataListener, null);
    }

    public static <T> void invokeLaterAndNotify(Callable<T> callable, HtmlDataListener<T> htmlDataListener, HtmlDataListener<Exception> htmlDataListener2) {
        BrowserQueue.invokeLater(new CallableWrapper(callable, htmlDataListener, htmlDataListener2));
    }

    public static void invokeAndWait(Runnable runnable) {
        if (BrowserQueue.isBrowserThread()) {
            runnable.run();
        } else {
            RunnableQueueItem runnableQueueItem = BrowserQueue.QUEUE.addRunnable(runnable);
            BrowserQueue.waitForItem(runnableQueueItem);
        }
    }

    public static <T> T invokeAndReturn(Callable<T> callable) throws Exception {
        CaptureListener captureListener = new CaptureListener();
        CaptureListener captureListener2 = new CaptureListener();
        CallableWrapper callableWrapper = new CallableWrapper(callable, captureListener, captureListener2);
        BrowserQueue.invokeAndWait(callableWrapper);
        Exception exception = (Exception)captureListener2.getValue();
        if (exception != null) {
            throw exception;
        }
        return (T)captureListener.getValue();
    }

    public static <T> T invokeAndReturnSilently(Callable<T> callable) {
        try {
            return BrowserQueue.invokeAndReturn(callable);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isBrowserThread() {
        return Thread.currentThread().equals(BrowserQueue.QUEUE.getCurrentThread());
    }

    public static synchronized void clearQueue() {
        BrowserQueue.QUEUE.clear();
    }

    public static synchronized void flushQueue() {
        BrowserQueue.QUEUE.flush();
    }

    public static synchronized boolean isActive() {
        return BrowserQueue.QUEUE.getCurrentThread() != null;
    }

    private static class ExecuteRunnable
    implements Runnable {
        private ExecuteRunnable() {
        }

        @Override
        public void run() {
            RunnableQueueItem runnableQueueItem = QUEUE.getCurrentItem();
            while (runnableQueueItem != null) {
                runnableQueueItem = ExecuteRunnable.executeAndGetNext(runnableQueueItem);
            }
        }

        private static RunnableQueueItem executeAndGetNext(RunnableQueueItem runnableQueueItem) {
            try {
                runnableQueueItem.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return QUEUE.completed();
        }
    }

    private static class CallableWrapper<T>
    implements Runnable {
        private final Callable<T> iCallable;
        private final HtmlDataListener<T> iValueListener;
        private final HtmlDataListener<Exception> iExceptionListener;

        private CallableWrapper(Callable<T> callable, HtmlDataListener<T> htmlDataListener, HtmlDataListener<Exception> htmlDataListener2) {
            this.iCallable = callable;
            this.iValueListener = htmlDataListener;
            this.iExceptionListener = htmlDataListener2;
        }

        @Override
        public void run() {
            block3: {
                try {
                    T t = this.iCallable.call();
                    if (this.iValueListener != null) {
                        this.iValueListener.dataRetrieved(t);
                    }
                }
                catch (Exception exception) {
                    if (this.iExceptionListener == null) break block3;
                    this.iExceptionListener.dataRetrieved(exception);
                }
            }
        }
    }

    private static class CaptureListener<T>
    implements HtmlDataListener<T> {
        private T iValue;

        private CaptureListener() {
        }

        @Override
        public void dataRetrieved(T t) {
            this.iValue = t;
        }

        private T getValue() {
            return this.iValue;
        }
    }

    private static class RunnableQueueItem
    implements Runnable {
        private final Runnable iRealRunnable;
        private boolean iFinished = false;

        private RunnableQueueItem(Runnable runnable) {
            this.iRealRunnable = runnable;
        }

        @Override
        public void run() {
            this.iRealRunnable.run();
        }

        private synchronized void setFinished(boolean bl) {
            this.iFinished = bl;
        }

        private synchronized boolean isFinished() {
            return this.iFinished;
        }
    }

    private static enum RunnableQueue {
        SINGLETON;

        private final List<RunnableQueueItem> iRunnables = new LinkedList<RunnableQueueItem>();
        private Thread iCurrentThread;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized RunnableQueueItem addRunnable(Runnable runnable) {
            try {
                RunnableQueueItem runnableQueueItem = new RunnableQueueItem(runnable);
                this.iRunnables.add(runnableQueueItem);
                RunnableQueueItem runnableQueueItem2 = runnableQueueItem;
                return runnableQueueItem2;
            }
            finally {
                if (this.iCurrentThread == null) {
                    this.iCurrentThread = new Thread(new ExecuteRunnable());
                    this.iCurrentThread.setName("Browser Thread");
                    this.iCurrentThread.setDaemon(true);
                    this.iCurrentThread.start();
                }
            }
        }

        private synchronized RunnableQueueItem completed() {
            RunnableQueueItem runnableQueueItem = this.iRunnables.remove(0);
            if (this.iRunnables.isEmpty()) {
                this.iCurrentThread = null;
            }
            BrowserQueue.markItemAsFinished(runnableQueueItem);
            return this.getCurrentItem();
        }

        private synchronized RunnableQueueItem getCurrentItem() {
            return this.iRunnables.isEmpty() ? null : this.iRunnables.get(0);
        }

        private synchronized RunnableQueueItem getLastItem() {
            return this.iRunnables.isEmpty() ? null : this.iRunnables.get(this.iRunnables.size() - 1);
        }

        private synchronized Thread getCurrentThread() {
            return this.iCurrentThread;
        }

        private synchronized RunnableQueueItem clearAllButCurrentItem() {
            RunnableQueueItem runnableQueueItem = this.getCurrentItem();
            this.iRunnables.clear();
            if (runnableQueueItem != null) {
                this.iRunnables.add(runnableQueueItem);
            }
            return runnableQueueItem;
        }

        private void clear() {
            RunnableQueueItem runnableQueueItem = this.clearAllButCurrentItem();
            BrowserQueue.waitForItem(runnableQueueItem);
            if (this.iCurrentThread != null) {
                this.iCurrentThread.interrupt();
            }
        }

        private void flush() {
            RunnableQueueItem runnableQueueItem = this.getLastItem();
            if (runnableQueueItem != null) {
                BrowserQueue.waitForItem(runnableQueueItem);
            }
        }
    }
}

